/*
 * Decompiled with CFR 0.152.
 */
package com.charliemouse.cambozola.accessories;

import com.charliemouse.cambozola.Accessory;
import com.charliemouse.cambozola.ViewerAttributeInterface;
import com.charliemouse.cambozola.profiles.ICameraProfile;
import java.awt.Point;

public class PanAccessory
extends Accessory {
    public String getName() {
        return "Pan View";
    }

    public String getIconLocation() {
        return "pan.gif";
    }

    public String getDescription() {
        return "Pan around the image (must be zoomed in)";
    }

    public boolean isEnabled(ICameraProfile profile, ViewerAttributeInterface vfi) {
        return super.isEnabled(profile, vfi) && (profile.supportsPan() || profile.supportsTilt());
    }

    public void actionPerformed(Point p, ViewerAttributeInterface vfi) {
        int invx = 30 - p.x;
        int center = 15;
        if (Math.abs(center - p.x) < 3 && Math.abs(center - p.y) < 3) {
            return;
        }
        boolean ne_line = p.x > p.y;
        boolean se_line = invx > p.y;
        ICameraProfile profile = vfi.getProfile();
        if (ne_line) {
            if (se_line) {
                profile.tiltUp();
            } else {
                profile.panRight();
            }
        } else if (se_line) {
            profile.panLeft();
        } else {
            profile.tiltDown();
        }
    }
}

