/*
 * Decompiled with CFR 0.152.
 */
package com.charliemouse.cambozola.server;

import com.charliemouse.cambozola.server.ReplicatingConnection;
import com.charliemouse.cambozola.shared.AppID;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;

public class Replicator {
    public static final int DEFAULT_PORT = 3030;
    protected URL m_src;
    protected String m_name;
    protected int m_port;
    protected ServerSocket m_listen_socket;

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Test code - for replicating a stream");
            System.err.println("Usage: <replication source> [<port>]");
            System.exit(0);
        }
        URL source = new URL(args[0]);
        int port = 3030;
        if (args.length > 1) {
            port = Integer.valueOf(args[1]);
        }
        System.out.println("Replicating " + source);
        new Replicator(source, AppID.getAppID().getAppName(), port);
    }

    public Replicator(URL source, String name, int port) {
        this.m_src = source;
        this.m_name = name;
        this.m_port = port;
        try {
            this.m_listen_socket = new ServerSocket(port);
            System.out.println(name + " replicator listening on port " + port);
            while (true) {
                Socket client_socket = this.m_listen_socket.accept();
                ReplicatingConnection.addConnection(this.m_src, this.m_name, client_socket);
            }
        }
        catch (Exception e) {
            System.err.println("Exception occurred: " + e);
            return;
        }
    }
}

