/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common;

import java.util.HashMap;
import java.util.Map;
import org.apache.directory.api.util.Strings;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.core.model.schema.AttributeValueEditorRelation;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SyntaxValueEditorRelation;
import org.apache.directory.studio.ldapbrowser.core.utils.Utils;
import org.eclipse.jface.preference.IPreferenceStore;

public class ValueEditorsPreferences {
    private Map<String, String> attributeValueEditorCache;
    private Map<String, String> syntaxValueEditorCache;

    public Map<String, String> getAttributeValueEditorMap() {
        if (this.attributeValueEditorCache == null) {
            this.attributeValueEditorCache = new HashMap<String, String>();
            AttributeValueEditorRelation[] relations = this.getAttributeValueEditorRelations();
            for (int i = 0; i < relations.length; ++i) {
                if (relations[i].getAttributeNumericOidOrType() == null) continue;
                this.attributeValueEditorCache.put(Strings.toLowerCase((String)relations[i].getAttributeNumericOidOrType()), relations[i].getValueEditorClassName());
            }
        }
        return this.attributeValueEditorCache;
    }

    public AttributeValueEditorRelation[] getAttributeValueEditorRelations() {
        IPreferenceStore store = BrowserCommonActivator.getDefault().getPreferenceStore();
        String s = store.getString("attributeValueProviderRelations");
        s = s.replaceAll("AttributeValueProviderRelation", "AttributeValueEditorRelation");
        s = s.replaceAll("valueProviderClassname", "valueEditorClassName");
        AttributeValueEditorRelation[] aver = (AttributeValueEditorRelation[])Utils.deserialize((String)s);
        return aver;
    }

    public void setAttributeValueEditorRelations(AttributeValueEditorRelation[] attributeValueEditorRelations) {
        ValueEditorsPreferences.store("attributeValueProviderRelations", attributeValueEditorRelations);
        this.attributeValueEditorCache = null;
    }

    public AttributeValueEditorRelation[] getDefaultAttributeValueEditorRelations() {
        IPreferenceStore store = BrowserCommonActivator.getDefault().getPreferenceStore();
        String s = store.getDefaultString("attributeValueProviderRelations");
        s = s.replaceAll("AttributeValueProviderRelation", "AttributeValueEditorRelation");
        s = s.replaceAll("valueProviderClassname", "valueEditorClassName");
        AttributeValueEditorRelation[] aver = (AttributeValueEditorRelation[])Utils.deserialize((String)s);
        return aver;
    }

    public void setDefaultAttributeValueEditorRelations(AttributeValueEditorRelation[] attributeValueEditorRelations) {
        ValueEditorsPreferences.storeDefault("attributeValueProviderRelations", attributeValueEditorRelations);
    }

    public Map<String, String> getSyntaxValueEditorMap() {
        if (this.syntaxValueEditorCache == null) {
            this.syntaxValueEditorCache = new HashMap<String, String>();
            SyntaxValueEditorRelation[] relations = this.getSyntaxValueEditorRelations();
            for (int i = 0; i < relations.length; ++i) {
                if (relations[i].getSyntaxOID() == null) continue;
                this.syntaxValueEditorCache.put(Strings.toLowerCase((String)relations[i].getSyntaxOID()), relations[i].getValueEditorClassName());
            }
        }
        return this.syntaxValueEditorCache;
    }

    public void setSyntaxValueEditorRelations(SyntaxValueEditorRelation[] syntaxValueEditorRelations) {
        ValueEditorsPreferences.store("syntaxValueProviderRelations", syntaxValueEditorRelations);
        this.syntaxValueEditorCache = null;
    }

    public SyntaxValueEditorRelation[] getSyntaxValueEditorRelations() {
        IPreferenceStore store = BrowserCommonActivator.getDefault().getPreferenceStore();
        String s = store.getString("syntaxValueProviderRelations");
        s = s.replaceAll("SyntaxValueProviderRelation", "SyntaxValueEditorRelation");
        s = s.replaceAll("valueProviderClassname", "valueEditorClassName");
        SyntaxValueEditorRelation[] sver = (SyntaxValueEditorRelation[])Utils.deserialize((String)s);
        return sver;
    }

    public SyntaxValueEditorRelation[] getDefaultSyntaxValueEditorRelations() {
        IPreferenceStore store = BrowserCommonActivator.getDefault().getPreferenceStore();
        String s = store.getDefaultString("syntaxValueProviderRelations");
        s = s.replaceAll("SyntaxValueProviderRelation", "SyntaxValueEditorRelation");
        s = s.replaceAll("valueProviderClassname", "valueEditorClassName");
        SyntaxValueEditorRelation[] sver = (SyntaxValueEditorRelation[])Utils.deserialize((String)s);
        return sver;
    }

    public void setDefaultSyntaxValueEditorRelations(SyntaxValueEditorRelation[] syntaxValueEditorRelations) {
        ValueEditorsPreferences.storeDefault("syntaxValueProviderRelations", syntaxValueEditorRelations);
    }

    private static void store(String key, Object o) {
        IPreferenceStore store = BrowserCommonActivator.getDefault().getPreferenceStore();
        String s = Utils.serialize((Object)o);
        store.setValue(key, s);
    }

    private static void storeDefault(String key, Object o) {
        IPreferenceStore store = BrowserCommonActivator.getDefault().getPreferenceStore();
        String s = Utils.serialize((Object)o);
        store.setDefault(key, s);
    }
}

