/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor;

import java.util.HashMap;
import java.util.Map;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonConstants;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.common.actions.CopyAction;
import org.apache.directory.studio.ldapbrowser.common.actions.DeleteAction;
import org.apache.directory.studio.ldapbrowser.common.actions.NewValueAction;
import org.apache.directory.studio.ldapbrowser.common.actions.PropertiesAction;
import org.apache.directory.studio.ldapbrowser.common.actions.SelectAllAction;
import org.apache.directory.studio.ldapbrowser.common.actions.ShowDecoratedValuesAction;
import org.apache.directory.studio.ldapbrowser.common.actions.ValueEditorPreferencesAction;
import org.apache.directory.studio.ldapbrowser.common.actions.proxy.ActionHandlerManager;
import org.apache.directory.studio.ldapbrowser.common.actions.proxy.EntryEditorActionProxy;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorPasteAction;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetConfiguration;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.Messages;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.OpenBestEditorAction;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.OpenDefaultEditorAction;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.OpenEditorAction;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.OpenSortDialogAction;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.ShowQuickFilterAction;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.utils.ActionUtils;
import org.apache.directory.studio.valueeditors.IValueEditor;
import org.apache.directory.studio.valueeditors.ValueEditorManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;

public class EntryEditorWidgetActionGroup
implements ActionHandlerManager {
    protected OpenSortDialogAction openSortDialogAction;
    protected ShowDecoratedValuesAction showDecoratedValuesAction;
    protected ShowQuickFilterAction showQuickFilterAction;
    protected EntryEditorActionProxy openDefaultValueEditorActionProxy;
    protected EntryEditorActionProxy openBestValueEditorActionProxy;
    protected EntryEditorActionProxy[] openValueEditorActionProxies;
    protected ValueEditorPreferencesAction openValueEditorPreferencesAction;
    protected static final String newValueAction = "newValueAction";
    protected static final String copyAction = "copyAction";
    protected static final String pasteAction = "pasteAction";
    protected static final String deleteAction = "deleteAction";
    protected static final String selectAllAction = "selectAllAction";
    protected static final String propertyDialogAction = "propertyDialogAction";
    protected Map<String, EntryEditorActionProxy> entryEditorActionMap;
    protected IActionBars actionBars;
    private EntryEditorWidget mainWidget;

    public EntryEditorWidgetActionGroup(EntryEditorWidget mainWidget, EntryEditorWidgetConfiguration configuration) {
        this.mainWidget = mainWidget;
        this.entryEditorActionMap = new HashMap<String, EntryEditorActionProxy>();
        TreeViewer viewer = mainWidget.getViewer();
        ValueEditorManager valueEditorManager = configuration.getValueEditorManager(viewer);
        this.openSortDialogAction = new OpenSortDialogAction(configuration.getPreferences());
        this.showDecoratedValuesAction = new ShowDecoratedValuesAction();
        this.showQuickFilterAction = new ShowQuickFilterAction(mainWidget.getQuickFilterWidget());
        this.openBestValueEditorActionProxy = new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new OpenBestEditorAction(viewer, valueEditorManager, this));
        this.openDefaultValueEditorActionProxy = new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new OpenDefaultEditorAction(viewer, this.openBestValueEditorActionProxy));
        IValueEditor[] valueEditors = valueEditorManager.getAllValueEditors();
        this.openValueEditorActionProxies = new EntryEditorActionProxy[valueEditors.length];
        for (int i = 0; i < this.openValueEditorActionProxies.length; ++i) {
            this.openValueEditorActionProxies[i] = new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new OpenEditorAction(viewer, valueEditorManager, valueEditors[i], this));
        }
        this.openValueEditorPreferencesAction = new ValueEditorPreferencesAction();
        this.entryEditorActionMap.put(newValueAction, new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new NewValueAction()));
        this.entryEditorActionMap.put(pasteAction, new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new EntryEditorPasteAction()));
        this.entryEditorActionMap.put(copyAction, new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new CopyAction(this.entryEditorActionMap.get(pasteAction), valueEditorManager)));
        this.entryEditorActionMap.put(deleteAction, new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new DeleteAction()));
        this.entryEditorActionMap.put(selectAllAction, new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new SelectAllAction((Viewer)viewer)));
        this.entryEditorActionMap.put(propertyDialogAction, new EntryEditorActionProxy((Viewer)viewer, (BrowserAction)new PropertiesAction()));
    }

    public void dispose() {
        if (this.mainWidget != null) {
            this.openSortDialogAction = null;
            this.showQuickFilterAction.dispose();
            this.showQuickFilterAction = null;
            this.showDecoratedValuesAction = null;
            this.openDefaultValueEditorActionProxy.dispose();
            this.openDefaultValueEditorActionProxy = null;
            this.openBestValueEditorActionProxy.dispose();
            this.openBestValueEditorActionProxy = null;
            for (EntryEditorActionProxy action : this.openValueEditorActionProxies) {
                action.dispose();
            }
            this.openValueEditorPreferencesAction = null;
            for (EntryEditorActionProxy action : this.entryEditorActionMap.values()) {
                action.dispose();
            }
            this.entryEditorActionMap.clear();
            this.entryEditorActionMap = null;
            this.actionBars = null;
            this.mainWidget = null;
        }
    }

    public void enableGlobalActionHandlers(IActionBars actionBars) {
        this.actionBars = actionBars;
    }

    public void fillToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IAction)this.entryEditorActionMap.get(newValueAction));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.entryEditorActionMap.get(deleteAction));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.showQuickFilterAction);
        toolBarManager.update(true);
    }

    public void fillMenu(IMenuManager menuManager) {
        menuManager.add((IAction)this.openSortDialogAction);
        menuManager.add((IAction)this.showDecoratedValuesAction);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                EntryEditorWidgetActionGroup.this.showDecoratedValuesAction.setChecked(!BrowserCommonActivator.getDefault().getPreferenceStore().getBoolean("showRawValues"));
            }
        });
    }

    public void fillContextMenu(IMenuManager menuManager) {
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                EntryEditorWidgetActionGroup.this.contextMenuAboutToShow(manager);
            }
        });
    }

    protected void contextMenuAboutToShow(IMenuManager menuManager) {
        menuManager.add((IAction)this.entryEditorActionMap.get(newValueAction));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.entryEditorActionMap.get(copyAction));
        menuManager.add((IAction)this.entryEditorActionMap.get(pasteAction));
        menuManager.add((IAction)this.entryEditorActionMap.get(deleteAction));
        menuManager.add((IAction)this.entryEditorActionMap.get(selectAllAction));
        menuManager.add((IContributionItem)new Separator());
        this.addEditMenu(menuManager);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.entryEditorActionMap.get(propertyDialogAction));
    }

    protected void addEditMenu(IMenuManager menuManager) {
        menuManager.add((IAction)this.openDefaultValueEditorActionProxy);
        MenuManager editorMenuManager = new MenuManager(Messages.getString("EntryEditorWidgetActionGroup.EditValueWith"));
        if (this.openBestValueEditorActionProxy.isEnabled()) {
            editorMenuManager.add((IAction)this.openBestValueEditorActionProxy);
            editorMenuManager.add((IContributionItem)new Separator());
        }
        for (EntryEditorActionProxy action : this.openValueEditorActionProxies) {
            if (!action.isEnabled() || ((OpenEditorAction)action.getAction()).getValueEditor().getClass() == ((OpenBestEditorAction)this.openBestValueEditorActionProxy.getAction()).getBestValueEditor().getClass()) continue;
            editorMenuManager.add((IAction)action);
        }
        editorMenuManager.add((IContributionItem)new Separator());
        editorMenuManager.add((IAction)this.openValueEditorPreferencesAction);
        menuManager.add((IContributionItem)editorMenuManager);
    }

    @Override
    public void activateGlobalActionHandlers() {
        if (this.actionBars != null) {
            this.actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.entryEditorActionMap.get(copyAction));
            this.actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.entryEditorActionMap.get(pasteAction));
            this.actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.entryEditorActionMap.get(deleteAction));
            this.actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.entryEditorActionMap.get(selectAllAction));
            this.actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.entryEditorActionMap.get(propertyDialogAction));
            this.actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), (IAction)this.showQuickFilterAction);
            this.actionBars.updateActionBars();
        } else {
            IAction da = (IAction)this.entryEditorActionMap.get(deleteAction);
            da.setActionDefinitionId(BrowserCommonConstants.CMD_DELETE);
            ActionUtils.activateActionHandler((IAction)da);
            IAction ca = (IAction)this.entryEditorActionMap.get(copyAction);
            ca.setActionDefinitionId(BrowserCommonConstants.CMD_COPY);
            ActionUtils.activateActionHandler((IAction)ca);
            IAction pa = (IAction)this.entryEditorActionMap.get(pasteAction);
            pa.setActionDefinitionId(BrowserCommonConstants.CMD_PASTE);
            ActionUtils.activateActionHandler((IAction)pa);
            this.showQuickFilterAction.setActionDefinitionId(BrowserCommonConstants.CMD_FIND);
            ActionUtils.activateActionHandler((IAction)this.showQuickFilterAction);
            IAction pda = (IAction)this.entryEditorActionMap.get(propertyDialogAction);
            pda.setActionDefinitionId(BrowserCommonConstants.CMD_PROPERTIES);
            ActionUtils.activateActionHandler((IAction)pda);
        }
        IAction nva = (IAction)this.entryEditorActionMap.get(newValueAction);
        ActionUtils.activateActionHandler((IAction)nva);
        ActionUtils.activateActionHandler((IAction)this.openDefaultValueEditorActionProxy);
    }

    @Override
    public void deactivateGlobalActionHandlers() {
        if (this.actionBars != null) {
            this.actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), null);
            this.actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), null);
            this.actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), null);
            this.actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), null);
            this.actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), null);
            this.actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), null);
            this.actionBars.updateActionBars();
        } else {
            IAction ca = (IAction)this.entryEditorActionMap.get(copyAction);
            ActionUtils.deactivateActionHandler((IAction)ca);
            IAction pa = (IAction)this.entryEditorActionMap.get(pasteAction);
            ActionUtils.deactivateActionHandler((IAction)pa);
            IAction da = (IAction)this.entryEditorActionMap.get(deleteAction);
            ActionUtils.deactivateActionHandler((IAction)da);
            ActionUtils.deactivateActionHandler((IAction)this.showQuickFilterAction);
            IAction pda = (IAction)this.entryEditorActionMap.get(propertyDialogAction);
            ActionUtils.deactivateActionHandler((IAction)pda);
        }
        IAction nva = (IAction)this.entryEditorActionMap.get(newValueAction);
        ActionUtils.deactivateActionHandler((IAction)nva);
        ActionUtils.deactivateActionHandler((IAction)this.openDefaultValueEditorActionProxy);
    }

    public OpenDefaultEditorAction getOpenDefaultEditorAction() {
        return (OpenDefaultEditorAction)this.openDefaultValueEditorActionProxy.getAction();
    }

    public void setInput(IEntry entry) {
        for (EntryEditorActionProxy action : this.entryEditorActionMap.values()) {
            action.inputChanged(entry);
        }
    }

    public void setInput(AttributeHierarchy attributeHierarchy) {
        for (EntryEditorActionProxy action : this.entryEditorActionMap.values()) {
            action.inputChanged(attributeHierarchy);
        }
    }
}

