/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor;

import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetFilter;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EntryEditorWidgetQuickFilterWidget {
    private EntryEditorWidgetFilter filter;
    private EntryEditorWidget entryEditorWidget;
    private Composite parent;
    private Composite composite;
    private Composite innerComposite;
    private Text quickFilterAttributeText;
    private Text quickFilterValueText;
    private Button clearQuickFilterButton;

    public EntryEditorWidgetQuickFilterWidget(EntryEditorWidgetFilter filter, EntryEditorWidget entryEditorWidget) {
        this.filter = filter;
        this.entryEditorWidget = entryEditorWidget;
    }

    public void createComposite(Composite parent) {
        this.parent = parent;
        this.composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)1, (int)1);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 2;
        gl.marginWidth = 2;
        this.composite.setLayout((Layout)gl);
        GridData compositeGridData = new GridData(0, 0, false, false);
        compositeGridData.heightHint = 0;
        compositeGridData.widthHint = 0;
        this.composite.setLayoutData((Object)compositeGridData);
        this.innerComposite = null;
    }

    private void create() {
        GridData compositeGridData = new GridData(4, 0, true, false);
        this.composite.setLayoutData((Object)compositeGridData);
        this.innerComposite = BaseWidgetUtils.createColumnContainer((Composite)this.composite, (int)3, (int)1);
        this.quickFilterAttributeText = new Text(this.innerComposite, 2048);
        this.quickFilterAttributeText.setLayoutData((Object)new GridData(186, -1));
        this.quickFilterAttributeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EntryEditorWidgetQuickFilterWidget.this.filter.setQuickFilterAttribute(EntryEditorWidgetQuickFilterWidget.this.quickFilterAttributeText.getText());
                EntryEditorWidgetQuickFilterWidget.this.clearQuickFilterButton.setEnabled(!"".equals(EntryEditorWidgetQuickFilterWidget.this.quickFilterAttributeText.getText()) || !"".equals(EntryEditorWidgetQuickFilterWidget.this.quickFilterValueText.getText()));
            }
        });
        this.quickFilterValueText = new Text(this.innerComposite, 2048);
        this.quickFilterValueText.setLayoutData((Object)new GridData(768));
        this.quickFilterValueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EntryEditorWidgetQuickFilterWidget.this.filter.setQuickFilterValue(EntryEditorWidgetQuickFilterWidget.this.quickFilterValueText.getText());
                EntryEditorWidgetQuickFilterWidget.this.clearQuickFilterButton.setEnabled(!"".equals(EntryEditorWidgetQuickFilterWidget.this.quickFilterAttributeText.getText()) || !"".equals(EntryEditorWidgetQuickFilterWidget.this.quickFilterValueText.getText()));
            }
        });
        this.clearQuickFilterButton = new Button(this.innerComposite, 8);
        this.clearQuickFilterButton.setToolTipText(Messages.getString("EntryEditorWidgetQuickFilterWidget.ClearQuickFilter"));
        this.clearQuickFilterButton.setImage(BrowserCommonActivator.getDefault().getImage("resources/icons/clear.gif"));
        this.clearQuickFilterButton.setEnabled(false);
        this.clearQuickFilterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!"".equals(EntryEditorWidgetQuickFilterWidget.this.quickFilterAttributeText.getText())) {
                    EntryEditorWidgetQuickFilterWidget.this.quickFilterAttributeText.setText("");
                }
                if (!"".equals(EntryEditorWidgetQuickFilterWidget.this.quickFilterValueText.getText())) {
                    EntryEditorWidgetQuickFilterWidget.this.quickFilterValueText.setText("");
                }
            }
        });
        this.setEnabled(this.composite.isEnabled());
        this.composite.layout(true, true);
        this.parent.layout(true, true);
    }

    private void destroy() {
        GridData compositeGridData = new GridData(0, 0, false, false);
        compositeGridData.heightHint = 0;
        compositeGridData.widthHint = 0;
        this.composite.setLayoutData((Object)compositeGridData);
        if (!"".equals(this.quickFilterAttributeText.getText())) {
            this.quickFilterAttributeText.setText("");
        }
        if (!"".equals(this.quickFilterValueText.getText())) {
            this.quickFilterValueText.setText("");
        }
        this.innerComposite.dispose();
        this.innerComposite = null;
        this.composite.layout(true, true);
        this.parent.layout(true, true);
    }

    public void dispose() {
        if (this.filter != null) {
            this.quickFilterAttributeText = null;
            this.quickFilterValueText = null;
            this.clearQuickFilterButton = null;
            this.innerComposite = null;
            this.composite.dispose();
            this.composite = null;
            this.parent = null;
            this.filter = null;
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.composite != null && !this.composite.isDisposed()) {
            this.composite.setEnabled(enabled);
        }
        if (this.innerComposite != null && !this.innerComposite.isDisposed()) {
            this.innerComposite.setEnabled(enabled);
            this.quickFilterAttributeText.setEnabled(enabled);
            this.quickFilterValueText.setEnabled(enabled);
            this.clearQuickFilterButton.setEnabled(enabled);
        }
    }

    public void setActive(boolean visible) {
        if (visible && this.innerComposite == null && this.composite != null) {
            this.create();
            this.quickFilterAttributeText.setFocus();
        } else if (!visible && this.innerComposite != null && this.composite != null) {
            this.destroy();
            this.entryEditorWidget.getViewer().getTree().setFocus();
        }
    }
}

