/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.editor.v151;

import java.util.List;
import org.apache.directory.studio.apacheds.configuration.ApacheDSConfigurationPlugin;
import org.apache.directory.studio.apacheds.configuration.editor.ServerConfigurationEditor;
import org.apache.directory.studio.apacheds.configuration.editor.v151.ExtendedOperationDetailsPage;
import org.apache.directory.studio.apacheds.configuration.model.v151.ExtendedOperation;
import org.apache.directory.studio.apacheds.configuration.model.v151.ServerConfigurationV151;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class ExtendedOperationsMasterDetailsBlock
extends MasterDetailsBlock {
    private FormPage page;
    private ServerConfigurationV151 serverConfiguration;
    private List<ExtendedOperation> extendedOperations;
    private ExtendedOperationDetailsPage detailsPage;
    private static final String NEW_NAME = "newExtendedOperation";
    private TableViewer viewer;
    private Button addButton;
    private Button deleteButton;

    public ExtendedOperationsMasterDetailsBlock(FormPage page) {
        this.page = page;
        this.serverConfiguration = (ServerConfigurationV151)((ServerConfigurationEditor)page.getEditor()).getServerConfiguration();
        this.extendedOperations = this.serverConfiguration.getExtendedOperations();
    }

    protected void createMasterPart(final IManagedForm managedForm, Composite parent) {
        FormToolkit toolkit = managedForm.getToolkit();
        Section section = toolkit.createSection(parent, 256);
        section.setText("All Extended Operations");
        section.marginWidth = 10;
        section.marginHeight = 5;
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
        Table table = toolkit.createTable(client, 0);
        GridData gd = new GridData(4, 4, true, true, 1, 2);
        gd.heightHint = 20;
        gd.widthHint = 100;
        table.setLayoutData((Object)gd);
        final SectionPart spart = new SectionPart(section);
        managedForm.addPart((IFormPart)spart);
        this.viewer = new TableViewer(table);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                managedForm.fireSelectionChanged((IFormPart)spart, event.getSelection());
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return ApacheDSConfigurationPlugin.getDefault().getImage("resources/icons/extended_operation.gif");
            }
        });
        this.addButton = toolkit.createButton(client, "Add...", 8);
        this.addButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.deleteButton = toolkit.createButton(client, "Delete", 8);
        this.deleteButton.setEnabled(false);
        this.deleteButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.initFromInput();
        this.addListeners();
    }

    private void initFromInput() {
        this.viewer.setInput(this.extendedOperations);
    }

    private void addListeners() {
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ExtendedOperationsMasterDetailsBlock.this.viewer.refresh();
                ExtendedOperationsMasterDetailsBlock.this.deleteButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedOperation newExtendedOperation = new ExtendedOperation(ExtendedOperationsMasterDetailsBlock.this.getNewName());
                ExtendedOperationsMasterDetailsBlock.this.extendedOperations.add(newExtendedOperation);
                ExtendedOperationsMasterDetailsBlock.this.viewer.refresh();
                ExtendedOperationsMasterDetailsBlock.this.viewer.setSelection((ISelection)new StructuredSelection((Object)newExtendedOperation));
                ExtendedOperationsMasterDetailsBlock.this.setEditorDirty();
            }
        });
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)ExtendedOperationsMasterDetailsBlock.this.viewer.getSelection();
                if (!selection.isEmpty()) {
                    ExtendedOperation extendedOperation = (ExtendedOperation)selection.getFirstElement();
                    ExtendedOperationsMasterDetailsBlock.this.extendedOperations.remove(extendedOperation);
                    ExtendedOperationsMasterDetailsBlock.this.viewer.refresh();
                    ExtendedOperationsMasterDetailsBlock.this.setEditorDirty();
                }
            }
        });
    }

    private String getNewName() {
        int counter = 1;
        String name = NEW_NAME;
        boolean ok = false;
        while (!ok) {
            ok = true;
            name = NEW_NAME + counter;
            for (ExtendedOperation extendedOperation : this.extendedOperations) {
                if (!extendedOperation.getClassType().equalsIgnoreCase(name)) continue;
                ok = false;
            }
            ++counter;
        }
        return name;
    }

    protected void createToolBarActions(IManagedForm managedForm) {
        final ScrolledForm form = managedForm.getForm();
        Action horizontalAction = new Action("Horizontal layout", 8){

            public void run() {
                ExtendedOperationsMasterDetailsBlock.this.sashForm.setOrientation(256);
                form.reflow(true);
            }
        };
        horizontalAction.setChecked(true);
        horizontalAction.setToolTipText("Horizontal Orientation");
        horizontalAction.setImageDescriptor(ApacheDSConfigurationPlugin.getDefault().getImageDescriptor("resources/icons/horizontal_orientation.gif"));
        Action verticalAction = new Action("Vertical Orientation", 8){

            public void run() {
                ExtendedOperationsMasterDetailsBlock.this.sashForm.setOrientation(512);
                form.reflow(true);
            }
        };
        verticalAction.setChecked(false);
        verticalAction.setToolTipText("Vertical Orientation");
        verticalAction.setImageDescriptor(ApacheDSConfigurationPlugin.getDefault().getImageDescriptor("resources/icons/vertical_orientation.gif"));
        form.getToolBarManager().add((IAction)horizontalAction);
        form.getToolBarManager().add((IAction)verticalAction);
    }

    protected void registerPages(DetailsPart detailsPart) {
        this.detailsPage = new ExtendedOperationDetailsPage(this);
        detailsPart.registerPage(ExtendedOperation.class, (IDetailsPage)this.detailsPage);
    }

    public void setEditorDirty() {
        ((ServerConfigurationEditor)this.page.getEditor()).setDirty(true);
    }

    public void save() {
        this.detailsPage.commit(true);
        this.viewer.setInput(this.extendedOperations);
    }
}

