/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.events.SearchUpdateEvent;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.eclipse.osgi.util.NLS;

public class SearchManager
implements Serializable {
    private static final long serialVersionUID = 8665227628274097691L;
    private List<ISearch> searchList;
    private IBrowserConnection connection;

    protected SearchManager() {
    }

    public SearchManager(IBrowserConnection connection) {
        this.connection = connection;
        this.searchList = new ArrayList<ISearch>();
    }

    public IBrowserConnection getConnection() {
        return this.connection;
    }

    public void addSearch(ISearch search) {
        this.addSearch(this.searchList.size(), search);
    }

    public void addSearch(int index, ISearch search) {
        if (this.getSearch(search.getName()) != null) {
            String newSearchName = NLS.bind((String)BrowserCoreMessages.copy_n_of_s, (Object)"", (Object)search.getName());
            int i = 2;
            while (this.getSearch(newSearchName) != null) {
                newSearchName = NLS.bind((String)BrowserCoreMessages.copy_n_of_s, (Object)(i + " "), (Object)search.getName());
                ++i;
            }
            search.setName(newSearchName);
        }
        this.searchList.add(index, search);
        EventRegistry.fireSearchUpdated(new SearchUpdateEvent(search, SearchUpdateEvent.EventDetail.SEARCH_ADDED), this);
    }

    public ISearch getSearch(String name) {
        for (ISearch search : this.searchList) {
            if (!search.getName().equals(name)) continue;
            return search;
        }
        return null;
    }

    public int indexOf(ISearch search) {
        return this.searchList.indexOf(search);
    }

    public void removeSearch(ISearch search) {
        this.searchList.remove(search);
        EventRegistry.fireSearchUpdated(new SearchUpdateEvent(search, SearchUpdateEvent.EventDetail.SEARCH_REMOVED), this);
    }

    public void removeSearch(String name) {
        this.removeSearch(this.getSearch(name));
    }

    public List<ISearch> getSearches() {
        return new ArrayList<ISearch>(this.searchList);
    }

    public int getSearchCount() {
        return this.searchList.size();
    }
}

