/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.model.filter;

import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapFilter;
import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapFilterComponent;
import org.apache.directory.studio.ldapbrowser.core.model.filter.Messages;
import org.apache.directory.studio.ldapbrowser.core.model.filter.parser.LdapFilterToken;

public class LdapAndFilterComponent
extends LdapFilterComponent {
    public LdapAndFilterComponent(LdapFilter parent) {
        super(parent);
    }

    @Override
    public boolean setStartToken(LdapFilterToken andToken) {
        if (andToken != null && andToken.getType() == 21) {
            return super.setStartToken(andToken);
        }
        return false;
    }

    @Override
    public String getInvalidCause() {
        if (this.startToken == null) {
            return Messages.LdapAndFilterComponent_MissingAndCharacter;
        }
        if (this.filterList == null || this.filterList.isEmpty()) {
            return Messages.LdapAndFilterComponent_MissingFilters;
        }
        return Messages.LdapAndFilterComponent_InvalidAndFilter;
    }

    public String toString() {
        String s = this.startToken != null ? "&" : "";
        for (LdapFilter filter : this.filterList) {
            if (filter == null) continue;
            s = s + filter.toString();
        }
        return s;
    }
}

