/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.dialogs;

import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.ui.dialogs.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ResetPasswordDialog
extends Dialog {
    private String title;
    private String message;
    private String currentPassword = "";
    private String newPassword = "";
    private Button okButton;
    private Text currentPasswordText;
    private Button showCurrentPasswordCheckbox;
    private Text newPasswordText;
    private Button showNewPasswordCheckbox;
    private Text verifyNewPasswordText;
    private Button showVerifyNewPasswordCheckbox;

    public ResetPasswordDialog(Shell parentShell, String title, String message, String initialValue) {
        super(parentShell);
        this.title = title;
        this.message = message;
        this.currentPassword = initialValue == null ? "" : initialValue;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.validate();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.currentPassword = this.currentPasswordText.getText();
            this.newPassword = this.newPasswordText.getText();
        } else {
            this.currentPassword = null;
            this.newPassword = null;
        }
        super.buttonPressed(buttonId);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData compositeGridData = new GridData(4, 4, true, true);
        compositeGridData.widthHint = this.convertHorizontalDLUsToPixels(300);
        composite.setLayoutData((Object)compositeGridData);
        if (this.message != null) {
            Label messageLabel = BaseWidgetUtils.createWrappedLabel((Composite)composite, (String)this.message, (int)1);
            GridData messageLabelGridData = new GridData(4, 0x1000000, true, true, 2, 1);
            messageLabelGridData.widthHint = this.convertHorizontalDLUsToPixels(300);
            messageLabel.setLayoutData((Object)messageLabelGridData);
        }
        Group currentPasswordGroup = BaseWidgetUtils.createGroup((Composite)composite, (String)Messages.getString("ResetPasswordDialog.CurrentPassword"), (int)1);
        currentPasswordGroup.setLayout((Layout)new GridLayout(2, false));
        BaseWidgetUtils.createLabel((Composite)currentPasswordGroup, (String)Messages.getString("ResetPasswordDialog.CurrentPasswordColon"), (int)1);
        this.currentPasswordText = BaseWidgetUtils.createText((Composite)currentPasswordGroup, (String)"", (int)1);
        this.currentPasswordText.setEchoChar('\u2022');
        this.currentPasswordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ResetPasswordDialog.this.validate();
            }
        });
        BaseWidgetUtils.createLabel((Composite)currentPasswordGroup, (String)"", (int)1);
        this.showCurrentPasswordCheckbox = BaseWidgetUtils.createCheckbox((Composite)currentPasswordGroup, (String)Messages.getString("ResetPasswordDialog.ShowPassword"), (int)1);
        this.showCurrentPasswordCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ResetPasswordDialog.this.showCurrentPasswordCheckbox.getSelection()) {
                    ResetPasswordDialog.this.currentPasswordText.setEchoChar('\u0000');
                } else {
                    ResetPasswordDialog.this.currentPasswordText.setEchoChar('\u2022');
                }
            }
        });
        Group newPasswordGroup = BaseWidgetUtils.createGroup((Composite)composite, (String)Messages.getString("ResetPasswordDialog.NewPassword"), (int)1);
        newPasswordGroup.setLayout((Layout)new GridLayout(2, false));
        BaseWidgetUtils.createLabel((Composite)newPasswordGroup, (String)Messages.getString("ResetPasswordDialog.NewPasswordColon"), (int)1);
        this.newPasswordText = BaseWidgetUtils.createText((Composite)newPasswordGroup, (String)"", (int)1);
        this.newPasswordText.setEchoChar('\u2022');
        this.newPasswordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ResetPasswordDialog.this.validate();
            }
        });
        BaseWidgetUtils.createLabel((Composite)newPasswordGroup, (String)"", (int)1);
        this.showNewPasswordCheckbox = BaseWidgetUtils.createCheckbox((Composite)newPasswordGroup, (String)Messages.getString("ResetPasswordDialog.ShowPassword"), (int)1);
        this.showNewPasswordCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ResetPasswordDialog.this.showNewPasswordCheckbox.getSelection()) {
                    ResetPasswordDialog.this.newPasswordText.setEchoChar('\u0000');
                } else {
                    ResetPasswordDialog.this.newPasswordText.setEchoChar('\u2022');
                }
            }
        });
        BaseWidgetUtils.createLabel((Composite)newPasswordGroup, (String)Messages.getString("ResetPasswordDialog.VerifyNewPasswordColon"), (int)1);
        this.verifyNewPasswordText = BaseWidgetUtils.createText((Composite)newPasswordGroup, (String)"", (int)1);
        this.verifyNewPasswordText.setEchoChar('\u2022');
        this.verifyNewPasswordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ResetPasswordDialog.this.validate();
            }
        });
        BaseWidgetUtils.createLabel((Composite)newPasswordGroup, (String)"", (int)1);
        this.showVerifyNewPasswordCheckbox = BaseWidgetUtils.createCheckbox((Composite)newPasswordGroup, (String)Messages.getString("ResetPasswordDialog.ShowPassword"), (int)1);
        this.showVerifyNewPasswordCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ResetPasswordDialog.this.showVerifyNewPasswordCheckbox.getSelection()) {
                    ResetPasswordDialog.this.verifyNewPasswordText.setEchoChar('\u0000');
                } else {
                    ResetPasswordDialog.this.verifyNewPasswordText.setEchoChar('\u2022');
                }
            }
        });
        currentPasswordGroup.setFocus();
        ResetPasswordDialog.applyDialogFont((Control)composite);
        return composite;
    }

    public String getCurrentPassword() {
        return this.currentPassword;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    private void validate() {
        String currentPassword = this.currentPasswordText.getText();
        String newPassword = this.newPasswordText.getText();
        String verifyNewPassword = this.verifyNewPasswordText.getText();
        this.okButton.setEnabled(!"".equals(currentPassword) && !"".equals(newPassword) && newPassword.equals(verifyNewPassword) && !currentPassword.equals(newPassword));
    }
}

