/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime.auth;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.internal.runtime.auth.Activator;
import org.eclipse.core.internal.runtime.auth.CipherInputStream;
import org.eclipse.core.internal.runtime.auth.CipherOutputStream;
import org.eclipse.core.internal.runtime.auth.Messages;
import org.eclipse.core.internal.runtime.auth.URLTool;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class AuthorizationDatabase {
    public static final String PI_RUNTIME_AUTH = "org.eclipse.core.runtime.auth.compatibility";
    public static final int FAILED_READ_METADATA = 4;
    public static final int FAILED_WRITE_METADATA = 5;
    private static final int KEYRING_FILE_VERSION = 1;
    private Hashtable authorizationInfo = new Hashtable(5);
    private Hashtable protectionSpace = new Hashtable(5);
    private File file = null;
    private String password = null;
    private boolean needsSaving = true;

    public AuthorizationDatabase() {
    }

    public AuthorizationDatabase(String filename, String password) throws CoreException {
        Assert.isNotNull((Object)filename);
        Assert.isNotNull((Object)password);
        this.password = password;
        this.file = new File(filename).getAbsoluteFile();
        this.load();
    }

    public void addAuthorizationInfo(URL serverUrl, String realm, String authScheme, Map info) {
        Hashtable<String, Map> authSchemeToInfo;
        Assert.isNotNull((Object)serverUrl);
        Assert.isNotNull((Object)realm);
        Assert.isNotNull((Object)authScheme);
        Assert.isNotNull((Object)info);
        String url = serverUrl.toString();
        Hashtable<String, Hashtable<String, Map>> realmToAuthScheme = (Hashtable<String, Hashtable<String, Map>>)this.authorizationInfo.get(url);
        if (realmToAuthScheme == null) {
            realmToAuthScheme = new Hashtable<String, Hashtable<String, Map>>(5);
            this.authorizationInfo.put(url, realmToAuthScheme);
        }
        if ((authSchemeToInfo = (Hashtable<String, Map>)realmToAuthScheme.get(realm)) == null) {
            authSchemeToInfo = new Hashtable<String, Map>(5);
            realmToAuthScheme.put(realm, authSchemeToInfo);
        }
        authSchemeToInfo.put(authScheme.toLowerCase(), info);
        this.needsSaving = true;
    }

    public void addProtectionSpace(URL resourceUrl, String realm) {
        String oldRealm;
        Assert.isNotNull((Object)resourceUrl);
        Assert.isNotNull((Object)realm);
        if (!resourceUrl.getFile().endsWith("/")) {
            resourceUrl = URLTool.getParent(resourceUrl);
        }
        if ((oldRealm = this.getProtectionSpace(resourceUrl)) != null && oldRealm.equals(realm)) {
            return;
        }
        String url1 = resourceUrl.toString();
        Enumeration urls = this.protectionSpace.keys();
        while (urls.hasMoreElements()) {
            String url2 = (String)urls.nextElement();
            if (!url1.startsWith(url2) && !url2.startsWith(url1)) continue;
            this.protectionSpace.remove(url2);
            break;
        }
        this.protectionSpace.put(url1, realm);
        this.needsSaving = true;
    }

    public void flushAuthorizationInfo(URL serverUrl, String realm, String authScheme) {
        Hashtable realmToAuthScheme = (Hashtable)this.authorizationInfo.get(serverUrl.toString());
        if (realmToAuthScheme == null) {
            return;
        }
        Hashtable authSchemeToInfo = (Hashtable)realmToAuthScheme.get(realm);
        if (authSchemeToInfo == null) {
            return;
        }
        authSchemeToInfo.remove(authScheme.toLowerCase());
        this.needsSaving = true;
    }

    public Map getAuthorizationInfo(URL serverUrl, String realm, String authScheme) {
        Hashtable realmToAuthScheme = (Hashtable)this.authorizationInfo.get(serverUrl.toString());
        if (realmToAuthScheme == null) {
            return null;
        }
        Hashtable authSchemeToInfo = (Hashtable)realmToAuthScheme.get(realm);
        if (authSchemeToInfo == null) {
            return null;
        }
        return (Map)authSchemeToInfo.get(authScheme.toLowerCase());
    }

    public String getProtectionSpace(URL resourceUrl) {
        while (resourceUrl != null) {
            String realm = (String)this.protectionSpace.get(resourceUrl.toString());
            if (realm != null) {
                return realm;
            }
            resourceUrl = URLTool.getParent(resourceUrl);
        }
        return null;
    }

    private void load() throws CoreException {
        if (this.file == null) {
            return;
        }
        if (!this.file.exists()) {
            this.save();
            return;
        }
        try {
            FileInputStream input = new FileInputStream(this.file);
            try {
                this.load(input);
            }
            finally {
                ((InputStream)input).close();
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, PI_RUNTIME_AUTH, 4, NLS.bind((String)Messages.meta_unableToReadAuthorization, (Object)this.file), (Throwable)e));
        }
        catch (ClassNotFoundException e) {
            throw new CoreException((IStatus)new Status(4, PI_RUNTIME_AUTH, 4, NLS.bind((String)Messages.meta_unableToReadAuthorization, (Object)this.file), (Throwable)e));
        }
    }

    private void load(InputStream is) throws IOException, ClassNotFoundException, CoreException {
        int version = is.read();
        if (version == 1) {
            CipherInputStream cis = new CipherInputStream(is, this.password);
            ObjectInputStream ois = new ObjectInputStream(cis);
            try {
                this.authorizationInfo = (Hashtable)ois.readObject();
                this.protectionSpace = (Hashtable)ois.readObject();
            }
            finally {
                ois.close();
            }
        }
        Activator.log((IStatus)new Status(2, PI_RUNTIME_AUTH, 4, Messages.meta_authFormatChanged, null));
        try {
            is.close();
        }
        catch (IOException iOException) {}
        this.needsSaving = true;
        this.save();
    }

    public void save() throws CoreException {
        if (!this.needsSaving || this.file == null) {
            return;
        }
        try {
            this.file.delete();
            if (!this.file.getParentFile().exists() && !this.file.getParentFile().mkdirs() || !AuthorizationDatabase.canWrite(this.file.getParentFile())) {
                throw new CoreException((IStatus)new Status(4, PI_RUNTIME_AUTH, 5, NLS.bind((String)Messages.meta_unableToWriteAuthorization, (Object)this.file), null));
            }
            this.file.createNewFile();
            FileOutputStream out = new FileOutputStream(this.file);
            try {
                this.save(out);
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, PI_RUNTIME_AUTH, 5, NLS.bind((String)Messages.meta_unableToWriteAuthorization, (Object)this.file), (Throwable)e));
        }
        this.needsSaving = false;
    }

    private static boolean canWrite(File installDir) {
        if (!installDir.canWrite()) {
            return false;
        }
        if (!installDir.isDirectory()) {
            return false;
        }
        File fileTest = null;
        try {
            try {
                fileTest = File.createTempFile("writtableArea", null, installDir);
            }
            catch (IOException iOException) {
                if (fileTest != null) {
                    fileTest.delete();
                }
                return false;
            }
        }
        finally {
            if (fileTest != null) {
                fileTest.delete();
            }
        }
        return true;
    }

    private void save(FileOutputStream os) throws IOException {
        os.write(1);
        CipherOutputStream cos = new CipherOutputStream(os, this.password);
        ObjectOutputStream oos = new ObjectOutputStream(cos);
        try {
            oos.writeObject(this.authorizationInfo);
            oos.writeObject(this.protectionSpace);
            os.flush();
            os.getFD().sync();
        }
        finally {
            oos.close();
        }
    }

    public boolean setPassword(String oldValue, String newValue) {
        if (!oldValue.equals(this.password)) {
            return false;
        }
        this.password = newValue;
        this.needsSaving = true;
        return true;
    }
}

