/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.v2;

import java.io.IOException;
import java.net.URL;
import java.util.PropertyResourceBundle;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.registries.SchemaLoader;
import org.apache.directory.api.ldap.schemaloader.JarLdifSchemaLoader;
import org.apache.directory.api.ldap.schemamanager.impl.DefaultSchemaManager;
import org.apache.directory.studio.apacheds.configuration.v2.Messages;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ApacheDS2ConfigurationPlugin
extends AbstractUIPlugin {
    private static ApacheDS2ConfigurationPlugin plugin;
    private PropertyResourceBundle properties;
    private SchemaManager schemaManager;

    public ApacheDS2ConfigurationPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public SchemaManager getSchemaManager() throws Exception {
        if (this.schemaManager == null) {
            JarLdifSchemaLoader loader = new JarLdifSchemaLoader();
            this.schemaManager = new DefaultSchemaManager((SchemaLoader)loader);
            this.schemaManager.loadWithDeps(new String[]{"adsconfig"});
            if (this.schemaManager.getErrors().size() != 0) {
                throw new Exception(Messages.getString("ApacheDS2ConfigurationPlugin.CouldNotLoadSchemaCorrectly"));
            }
        }
        return this.schemaManager;
    }

    public static ApacheDS2ConfigurationPlugin getDefault() {
        return plugin;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        if (key != null) {
            URL url = FileLocator.find((Bundle)this.getBundle(), (IPath)new Path(key), null);
            if (url != null) {
                return ImageDescriptor.createFromURL((URL)url);
            }
            return null;
        }
        return null;
    }

    public Image getImage(String key) {
        ImageDescriptor id;
        Image image = this.getImageRegistry().get(key);
        if (image == null && (id = this.getImageDescriptor(key)) != null) {
            image = id.createImage();
            this.getImageRegistry().put(key, image);
        }
        return image;
    }

    public PropertyResourceBundle getPluginProperties() {
        if (this.properties == null) {
            try {
                this.properties = new PropertyResourceBundle(FileLocator.openStream((Bundle)this.getBundle(), (IPath)new Path("plugin.properties"), (boolean)false));
            }
            catch (IOException e) {
                this.getLog().log((IStatus)new Status(4, "org.apache.directory.studio.apacheds.configuration.v2", 0, Messages.getString("ApacheDS2ConfigurationPlugin.UnableGetProperties"), (Throwable)e));
            }
        }
        return this.properties;
    }
}

