/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifparser.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.directory.studio.ldifparser.LdifFormatParameters;
import org.apache.directory.studio.ldifparser.model.LdifInvalidPart;
import org.apache.directory.studio.ldifparser.model.LdifPart;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.apache.directory.studio.ldifparser.model.container.LdifContentRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifModSpec;
import org.apache.directory.studio.ldifparser.model.container.LdifRecord;

public class LdifFile
implements Serializable {
    private static final long serialVersionUID = 846864138240517008L;
    private List containerList = new ArrayList(1);

    public boolean isContentType() {
        for (Object o : this.containerList) {
            if (!(o instanceof LdifRecord)) continue;
            return o instanceof LdifContentRecord;
        }
        return false;
    }

    public boolean isChangeType() {
        for (Object o : this.containerList) {
            if (!(o instanceof LdifRecord)) continue;
            return o instanceof LdifChangeRecord;
        }
        return false;
    }

    public void addContainer(LdifContainer container) {
        this.containerList.add(container);
    }

    public LdifContainer[] getContainers() {
        return this.containerList.toArray(new LdifContainer[this.containerList.size()]);
    }

    public LdifRecord[] getRecords() {
        ArrayList l = new ArrayList();
        for (Object o : this.containerList) {
            if (!(o instanceof LdifRecord)) continue;
            l.add(o);
        }
        return l.toArray(new LdifRecord[l.size()]);
    }

    public LdifContainer getLastContainer() {
        if (this.containerList.isEmpty()) {
            return null;
        }
        return (LdifContainer)this.containerList.get(this.containerList.size() - 1);
    }

    public String toRawString() {
        StringBuffer sb = new StringBuffer();
        LdifContainer[] containers = this.getContainers();
        for (int i = 0; i < containers.length; ++i) {
            sb.append(containers[i].toRawString());
        }
        return sb.toString();
    }

    public String toFormattedString(LdifFormatParameters formatParameters) {
        StringBuffer sb = new StringBuffer();
        LdifContainer[] containers = this.getContainers();
        for (int i = 0; i < containers.length; ++i) {
            sb.append(containers[i].toFormattedString(formatParameters));
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        LdifContainer[] containers = this.getContainers();
        for (int i = 0; i < containers.length; ++i) {
            sb.append(containers[i].toString());
        }
        return sb.toString();
    }

    public static LdifContainer getContainer(LdifFile model, int offset) {
        if (model == null || offset < 0) {
            return null;
        }
        LdifContainer container = null;
        LdifContainer[] containers = model.getContainers();
        if (containers.length > 0) {
            for (int i = 0; i < containers.length; ++i) {
                if (containers[i].getOffset() > offset || offset >= containers[i].getOffset() + containers[i].getLength()) continue;
                container = containers[i];
                break;
            }
        }
        return container;
    }

    public static LdifModSpec getInnerContainer(LdifContainer container, int offset) {
        if (container == null || offset < container.getOffset() || offset > container.getOffset() + container.getLength()) {
            return null;
        }
        LdifModSpec innerContainer = null;
        LdifPart[] parts = container.getParts();
        if (parts.length > 0) {
            int partIndex = -1;
            for (int i = 0; i < parts.length; ++i) {
                int start = parts[i].getOffset();
                int end = parts[i].getOffset() + parts[i].getLength();
                if (start > offset || offset >= end) continue;
                partIndex = i;
                break;
            }
            if (partIndex > -1 && parts[partIndex] instanceof LdifModSpec) {
                innerContainer = (LdifModSpec)parts[partIndex];
            }
        }
        return innerContainer;
    }

    public static LdifContainer[] getContainers(LdifFile model, int offset, int length) {
        if (model == null || offset < 0) {
            return null;
        }
        ArrayList<LdifContainer> containerList = new ArrayList<LdifContainer>();
        LdifContainer[] containers = model.getContainers();
        if (containers.length > 0) {
            for (int i = 0; i < containers.length; ++i) {
                if (offset >= containers[i].getOffset() + containers[i].getLength() || offset + length <= containers[i].getOffset()) continue;
                containerList.add(containers[i]);
            }
        }
        return containerList.toArray(new LdifContainer[containerList.size()]);
    }

    public static LdifPart[] getParts(LdifFile model, int offset, int length) {
        if (model == null || offset < 0) {
            return null;
        }
        LdifContainer[] containers = model.getContainers();
        return LdifFile.getParts(containers, offset, length);
    }

    public static LdifPart[] getParts(LdifContainer[] containers, int offset, int length) {
        if (containers == null || offset < 0) {
            return null;
        }
        ArrayList<LdifPart> partList = new ArrayList<LdifPart>();
        for (int i = 0; i < containers.length; ++i) {
            LdifPart[] parts;
            if (offset >= containers[i].getOffset() + containers[i].getLength() || offset + length < containers[i].getOffset() || (parts = containers[i].getParts()).length <= 0) continue;
            for (int p = 0; p < parts.length; ++p) {
                if (offset >= parts[p].getOffset() + parts[p].getLength() || offset + length < parts[p].getOffset()) continue;
                LdifPart part = parts[p];
                if (part instanceof LdifModSpec) {
                    LdifModSpec spec = (LdifModSpec)part;
                    partList.addAll(Arrays.asList(LdifFile.getParts(new LdifContainer[]{spec}, offset, length)));
                    continue;
                }
                if (part instanceof LdifInvalidPart && p > 0) {
                    part = parts[p - 1];
                }
                partList.add(part);
            }
        }
        return partList.toArray(new LdifPart[partList.size()]);
    }

    public static LdifPart getContainerContent(LdifContainer container, int offset) {
        if (container == null || offset < container.getOffset() || offset > container.getOffset() + container.getLength()) {
            return null;
        }
        LdifPart part = null;
        LdifPart[] parts = container.getParts();
        if (parts.length > 0) {
            int partIndex = -1;
            for (int i = 0; i < parts.length; ++i) {
                int start = parts[i].getOffset();
                int end = parts[i].getOffset() + parts[i].getLength();
                if (start > offset || offset >= end) continue;
                partIndex = i;
                break;
            }
            if (partIndex > -1 && (part = parts[partIndex]) instanceof LdifModSpec) {
                part = LdifFile.getContainerContent((LdifModSpec)part, offset);
            }
        }
        return part;
    }

    public void replace(LdifContainer[] oldContainers, LdifContainer[] newContainers) {
        int index = 0;
        if (oldContainers.length > 0) {
            index = this.containerList.indexOf(oldContainers[0]);
        }
        int removeLength = 0;
        int removeOffset = 0;
        if (oldContainers.length > 0) {
            removeOffset = oldContainers[0].getOffset();
            for (int i = 0; i < oldContainers.length; ++i) {
                this.containerList.remove(index);
                removeLength += oldContainers[i].getLength();
            }
        }
        int insertLength = 0;
        for (int i = 0; i < newContainers.length; ++i) {
            newContainers[i].adjustOffset(removeOffset);
            insertLength += newContainers[i].getLength();
            this.containerList.add(index + i, newContainers[i]);
        }
        int adjust = insertLength - removeLength;
        for (int i = index + newContainers.length; i < this.containerList.size(); ++i) {
            LdifContainer container = (LdifContainer)this.containerList.get(i);
            container.adjustOffset(adjust);
        }
    }
}

