/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifeditor.editor;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreConstants;
import org.apache.directory.studio.ldifeditor.LdifEditorConstants;
import org.apache.directory.studio.ldifeditor.editor.LdifDocumentSetupParticipant;
import org.apache.directory.studio.ldifeditor.editor.text.LdifExternalAnnotationModel;
import org.apache.directory.studio.ldifparser.model.LdifFile;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.apache.directory.studio.ldifparser.model.container.LdifRecord;
import org.apache.directory.studio.ldifparser.parser.LdifParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;

public class LdifDocumentProvider
extends AbstractDocumentProvider
implements IDocumentListener {
    private final LdifParser ldifParser = new LdifParser();
    private final LdifDocumentSetupParticipant ldifDocumentSetupParticipant = new LdifDocumentSetupParticipant();
    private LdifFile ldifModel;

    public IDocument getDocument(Object element) {
        IDocument document = super.getDocument(element);
        return document;
    }

    public LdifFile getLdifModel() {
        return this.ldifModel;
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        try {
            int changeOffset = event.getOffset();
            int replacedTextLength = event.getLength();
            int insertedTextLength = event.getText() != null ? event.getText().length() : 0;
            IDocument document = event.getDocument();
            Region changeRegion = new Region(changeOffset - BrowserCoreConstants.LINE_SEPARATOR.length(), replacedTextLength + 2 * BrowserCoreConstants.LINE_SEPARATOR.length());
            ArrayList<LdifContainer> oldContainerList = new ArrayList<LdifContainer>();
            LdifContainer[] containers = this.ldifModel.getContainers();
            for (int i = 0; i < containers.length; ++i) {
                boolean changeOffsetAtEOF;
                Region containerRegion = new Region(containers[i].getOffset(), containers[i].getLength());
                boolean bl = changeOffsetAtEOF = i == containers.length - 1 && changeOffset >= containerRegion.getOffset() + containerRegion.getLength();
                if (!TextUtilities.overlaps((IRegion)containerRegion, (IRegion)changeRegion) && !changeOffsetAtEOF) continue;
                int index = i--;
                while (!(i < 0 || containers[i].isValid() && containers[i] instanceof LdifRecord)) {
                    oldContainerList.add(0, containers[i]);
                    --i;
                }
                for (i = index; i < containers.length && (TextUtilities.overlaps((IRegion)(containerRegion = new Region(containers[i].getOffset(), containers[i].getLength())), (IRegion)changeRegion) || changeOffsetAtEOF); ++i) {
                    oldContainerList.add(containers[i]);
                }
                while (!(i >= containers.length || containers[i].isValid() && containers[i] instanceof LdifRecord && oldContainerList.get(oldContainerList.size() - 1) instanceof LdifRecord)) {
                    oldContainerList.add(containers[i]);
                    ++i;
                }
            }
            LdifContainer[] oldContainers = oldContainerList.toArray(new LdifContainer[oldContainerList.size()]);
            int oldCount = oldContainers.length;
            int oldOffset = oldCount > 0 ? oldContainers[0].getOffset() : 0;
            int oldLength = oldCount > 0 ? oldContainers[oldContainers.length - 1].getOffset() + oldContainers[oldContainers.length - 1].getLength() - oldContainers[0].getOffset() : 0;
            int newOffset = oldOffset;
            int newLength = oldLength - replacedTextLength + insertedTextLength;
            String textToParse = document.get(newOffset, newLength);
            LdifFile newModel = this.ldifParser.parse(textToParse);
            LdifContainer[] newContainers = newModel.getContainers();
            this.ldifModel.replace(oldContainers, newContainers);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        return new LdifExternalAnnotationModel();
    }

    private boolean setDocumentContent(IDocument document, IEditorInput input) throws CoreException {
        FileReader reader;
        block6: {
            try {
                String inputClassName = input.getClass().getName();
                if (input instanceof IPathEditorInput) {
                    reader = new FileReader(((IPathEditorInput)input).getPath().toFile());
                    break block6;
                }
                if (inputClassName.equals("org.eclipse.ui.internal.editors.text.JavaFileEditorInput") || inputClassName.equals("org.eclipse.ui.ide.FileStoreEditorInput")) {
                    reader = new FileReader(new File(input.getToolTipText()));
                    break block6;
                }
                return false;
            }
            catch (FileNotFoundException e) {
                return true;
            }
        }
        try {
            this.setDocumentContent(document, reader);
            return true;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, LdifEditorConstants.PLUGIN_ID, 0, "error reading file", (Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDocumentContent(IDocument document, Reader reader) throws IOException {
        BufferedReader in = new BufferedReader(reader);
        try {
            StringBuffer buffer = new StringBuffer(512);
            char[] readBuffer = new char[512];
            int n = in.read(readBuffer);
            while (n > 0) {
                buffer.append(readBuffer, 0, n);
                n = in.read(readBuffer);
            }
            document.set(buffer.toString());
        }
        finally {
            ((Reader)in).close();
        }
    }

    protected void setupDocument(IDocument document) {
        this.ldifDocumentSetupParticipant.setup(document);
        this.ldifModel = this.ldifParser.parse(document.get());
        document.addDocumentListener((IDocumentListener)this);
    }

    protected void disposeElementInfo(Object element, AbstractDocumentProvider.ElementInfo info) {
        IDocument document = info.fDocument;
        document.removeDocumentListener((IDocumentListener)this);
        super.disposeElementInfo(element, info);
    }

    protected IDocument createDocument(Object element) throws CoreException {
        if (element instanceof IEditorInput) {
            Document document = new Document();
            if (this.setDocumentContent((IDocument)document, (IEditorInput)element)) {
                this.setupDocument((IDocument)document);
            }
            return document;
        }
        return null;
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        File file = null;
        String elementClassName = element.getClass().getName();
        if (element instanceof FileEditorInput) {
            this.writeDocumentContent(document, ((FileEditorInput)element).getFile(), monitor);
            return;
        }
        if (element instanceof IPathEditorInput) {
            IPathEditorInput pei = (IPathEditorInput)element;
            IPath path = pei.getPath();
            file = path.toFile();
        } else if (elementClassName.equals("org.eclipse.ui.internal.editors.text.JavaFileEditorInput") || elementClassName.equals("org.eclipse.ui.ide.FileStoreEditorInput")) {
            file = new File(((IEditorInput)element).getToolTipText());
        }
        if (file != null) {
            try {
                file.createNewFile();
                if (file.exists()) {
                    if (!file.canWrite()) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.examples.rcp.texteditor", 0, "file is read-only", null));
                    }
                } else {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.examples.rcp.texteditor", 0, "error creating file", null));
                }
                FileWriter writer = new FileWriter(file);
                this.writeDocumentContent(document, writer, monitor);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.examples.rcp.texteditor", 0, "error when saving file", (Throwable)e));
            }
        }
    }

    private void writeDocumentContent(IDocument document, IFile file, IProgressMonitor monitor) throws CoreException {
        if (file != null) {
            file.setContents((InputStream)new ByteArrayInputStream(document.get().getBytes()), true, true, monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDocumentContent(IDocument document, Writer writer, IProgressMonitor monitor) throws IOException {
        BufferedWriter out = new BufferedWriter(writer);
        try {
            out.write(document.get());
        }
        finally {
            ((Writer)out).close();
        }
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return null;
    }

    public boolean isModifiable(Object element) {
        String elementClassName = element.getClass().getName();
        if (element instanceof IPathEditorInput) {
            IPathEditorInput pei = (IPathEditorInput)element;
            File file = pei.getPath().toFile();
            return file.canWrite() || !file.exists();
        }
        if (elementClassName.equals("org.eclipse.ui.internal.editors.text.JavaFileEditorInput") || elementClassName.equals("org.eclipse.ui.ide.FileStoreEditorInput")) {
            File file = new File(((IEditorInput)element).getToolTipText());
            return file.canWrite() || !file.exists();
        }
        return false;
    }

    public boolean isReadOnly(Object element) {
        return !this.isModifiable(element);
    }

    public boolean isStateValidated(Object element) {
        return true;
    }
}

