/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.util.Strings;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginUtils;
import org.apache.directory.studio.schemaeditor.view.dialogs.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractAliasesDialog
extends Dialog {
    private List<String> initialLowerCasedAliases = new ArrayList<String>();
    private List<String> aliases = new ArrayList<String>();
    private List<String> lowerCasedAliases = new ArrayList<String>();
    private Listener returnKeyListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.detail == 4) {
                event.detail = 16;
                AbstractAliasesDialog.this.closeTableEditor();
            }
        }
    };
    private Table aliasesTable;
    private TableEditor tableEditor;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private Composite errorComposite;
    private Image errorImage;
    private Label errorLabel;

    public AbstractAliasesDialog(List<String> aliases) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        if (aliases != null) {
            for (String alias : aliases) {
                this.initialLowerCasedAliases.add(Strings.toLowerCase((String)alias));
                this.aliases.add(alias);
                this.lowerCasedAliases.add(Strings.toLowerCase((String)alias));
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label aliasesLabel = new Label(composite, 0);
        aliasesLabel.setText(Messages.getString("AbstractAliasesDialog.Aliases"));
        aliasesLabel.setLayoutData((Object)new GridData(4, 0, true, true, 2, 1));
        this.aliasesTable = new Table(composite, 101122);
        GridData gridData = new GridData(4, 4, true, true, 1, 3);
        gridData.heightHint = 90;
        gridData.minimumHeight = 90;
        gridData.widthHint = 200;
        gridData.minimumWidth = 200;
        this.aliasesTable.setLayoutData((Object)gridData);
        this.tableEditor = new TableEditor(this.aliasesTable);
        this.tableEditor.horizontalAlignment = 16384;
        this.tableEditor.grabHorizontal = true;
        this.tableEditor.minimumWidth = 200;
        this.addButton = new Button(composite, 8);
        this.addButton.setText(Messages.getString("AbstractAliasesDialog.Add"));
        this.addButton.setLayoutData((Object)new GridData(4, 0, false, false));
        this.editButton = new Button(composite, 8);
        this.editButton.setText(Messages.getString("AbstractAliasesDialog.Edit"));
        this.editButton.setLayoutData((Object)new GridData(4, 0, false, false));
        this.editButton.setEnabled(false);
        this.removeButton = new Button(composite, 8);
        this.removeButton.setText(Messages.getString("AbstractAliasesDialog.Remove"));
        this.removeButton.setLayoutData((Object)new GridData(4, 0, false, false));
        this.removeButton.setEnabled(false);
        this.errorComposite = new Composite(composite, 0);
        this.errorComposite.setLayout((Layout)new GridLayout(2, false));
        this.errorComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.errorComposite.setVisible(false);
        this.errorImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
        Label label = new Label(this.errorComposite, 0);
        label.setImage(this.errorImage);
        label.setSize(16, 16);
        this.errorLabel = new Label(this.errorComposite, 0);
        this.errorLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.errorLabel.setText(this.getAliasAlreadyExistsErrorMessage());
        this.fillAliasesTable();
        this.initListeners();
        this.checkAliases();
        return composite;
    }

    private void fillAliasesTable() {
        this.aliasesTable.removeAll();
        this.aliasesTable.setItemCount(0);
        for (String alias : this.aliases) {
            TableItem newItem = new TableItem(this.aliasesTable, 0);
            newItem.setText(alias);
        }
    }

    private void initListeners() {
        this.aliasesTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127 || e.keyCode == Action.findKeyCode((String)"BACKSPACE")) {
                    AbstractAliasesDialog.this.removeSelectedAliases();
                    AbstractAliasesDialog.this.fillAliasesTable();
                    AbstractAliasesDialog.this.updateButtonsState();
                    AbstractAliasesDialog.this.checkAliases();
                }
            }
        });
        this.aliasesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractAliasesDialog.this.closeTableEditor();
                AbstractAliasesDialog.this.updateButtonsState();
            }
        });
        this.aliasesTable.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                AbstractAliasesDialog.this.openTableEditor(AbstractAliasesDialog.this.aliasesTable.getItem(AbstractAliasesDialog.this.aliasesTable.getSelectionIndex()));
            }
        });
        Menu menu = new Menu((Decorations)this.getShell(), 8);
        this.aliasesTable.setMenu(menu);
        MenuItem removeMenuItem = new MenuItem(menu, 8);
        removeMenuItem.setText(Messages.getString("AbstractAliasesDialog.Remove"));
        removeMenuItem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        removeMenuItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AbstractAliasesDialog.this.removeSelectedAliases();
                AbstractAliasesDialog.this.fillAliasesTable();
                AbstractAliasesDialog.this.updateButtonsState();
                AbstractAliasesDialog.this.checkAliases();
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractAliasesDialog.this.addANewAlias();
            }
        });
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractAliasesDialog.this.openTableEditor(AbstractAliasesDialog.this.aliasesTable.getItem(AbstractAliasesDialog.this.aliasesTable.getSelectionIndex()));
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractAliasesDialog.this.removeSelectedAliases();
                AbstractAliasesDialog.this.fillAliasesTable();
                AbstractAliasesDialog.this.updateButtonsState();
                AbstractAliasesDialog.this.checkAliases();
            }
        });
    }

    private void updateButtonsState() {
        if (this.aliasesTable.getSelectionCount() >= 1) {
            this.editButton.setEnabled(true);
            this.removeButton.setEnabled(true);
        } else {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
    }

    private void removeSelectedAliases() {
        TableItem[] selectedItems;
        for (TableItem item : selectedItems = this.aliasesTable.getSelection()) {
            this.aliases.remove(item.getText());
            this.lowerCasedAliases.remove(Strings.toLowerCase((String)item.getText()));
        }
    }

    private void addANewAlias() {
        TableItem item = new TableItem(this.aliasesTable, 0);
        item.setText("");
        this.openTableEditor(item);
    }

    private void openTableEditor(TableItem item) {
        Control oldEditor = this.tableEditor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
        }
        if (item == null) {
            return;
        }
        Text newEditor = new Text((Composite)this.aliasesTable, 0);
        newEditor.setText(item.getText());
        newEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractAliasesDialog.this.saveTableEditorText();
            }
        });
        newEditor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == Action.findKeyCode((String)"RETURN") || e.keyCode == 0x1000050) {
                    AbstractAliasesDialog.this.closeTableEditor();
                }
            }
        });
        newEditor.selectAll();
        newEditor.setFocus();
        this.tableEditor.setEditor((Control)newEditor, item, 0);
        Activator.getDefault().getWorkbench().getDisplay().addFilter(31, this.returnKeyListener);
    }

    private void saveTableEditorText() {
        String newText;
        TableItem item;
        String oldText;
        Text text = (Text)this.tableEditor.getEditor();
        if (text != null && !text.isDisposed() && !(oldText = (item = this.tableEditor.getItem()).getText()).equals(newText = text.getText())) {
            this.aliases.remove(oldText);
            this.lowerCasedAliases.remove(Strings.toLowerCase((String)oldText));
            if (!newText.equals("")) {
                this.aliases.add(newText);
                this.lowerCasedAliases.add(Strings.toLowerCase((String)newText));
            }
            item.setText(newText);
        }
        this.checkAliases();
    }

    private void closeTableEditor() {
        Text text = (Text)this.tableEditor.getEditor();
        if (text != null && !text.isDisposed()) {
            this.saveTableEditorText();
            text.dispose();
        }
        Activator.getDefault().getWorkbench().getDisplay().removeFilter(31, this.returnKeyListener);
    }

    private void checkAliases() {
        this.errorComposite.setVisible(false);
        for (String alias : this.aliases) {
            if (this.isAliasAlreadyTaken(alias) && !this.initialLowerCasedAliases.contains(Strings.toLowerCase((String)alias))) {
                this.errorComposite.setVisible(true);
                this.errorLabel.setText(this.getAliasAlreadyExistsErrorMessage());
                return;
            }
            if (PluginUtils.verifyName(alias)) continue;
            this.errorComposite.setVisible(true);
            this.errorLabel.setText(NLS.bind((String)Messages.getString("AbstractAliasesDialog.InvalidAlias"), (Object[])new String[]{alias}));
            return;
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("AbstractAliasesDialog.EditAlias"));
    }

    public String[] getAliases() {
        return this.aliases.toArray(new String[0]);
    }

    protected abstract String getAliasAlreadyExistsErrorMessage();

    protected abstract boolean isAliasAlreadyTaken(String var1);
}

