/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.editors.attributetype;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.util.Strings;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ATEUsedByOptionalTableContentProvider
implements IStructuredContentProvider {
    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof AttributeType) {
            ArrayList<ObjectClass> results = new ArrayList<ObjectClass>();
            AttributeType inputAT = (AttributeType)inputElement;
            SchemaHandler schemaHandler = Activator.getDefault().getSchemaHandler();
            ArrayList<String> names = new ArrayList<String>();
            List atNames = inputAT.getNames();
            if (atNames != null) {
                for (String name : atNames) {
                    names.add(Strings.toLowerCase((String)name));
                }
            }
            List<ObjectClass> objectClasses = schemaHandler.getObjectClasses();
            for (ObjectClass oc : objectClasses) {
                List mays = oc.getMayAttributeTypeOids();
                if (mays == null) continue;
                for (String may : mays) {
                    if (!names.contains(Strings.toLowerCase((String)may))) continue;
                    results.add(oc);
                }
            }
            Collections.sort(results, new Comparator<ObjectClass>(){

                @Override
                public int compare(ObjectClass oc1, ObjectClass oc2) {
                    if (oc1 instanceof ObjectClass && oc1 instanceof ObjectClass) {
                        List oc1Names = oc1.getNames();
                        List oc2Names = oc2.getNames();
                        if (oc1Names != null && oc2Names != null && oc1Names.size() > 0 && oc2Names.size() > 0) {
                            return ((String)oc1Names.get(0)).compareToIgnoreCase((String)oc2Names.get(0));
                        }
                    }
                    return 0;
                }
            });
            return results.toArray();
        }
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

