/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.editors.objectclass;

import org.apache.directory.api.ldap.model.schema.MutableObjectClass;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.PluginUtils;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandlerAdapter;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandlerListener;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.Messages;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditorInput;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditorOverviewPage;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditorSourceCodePage;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;

public class ObjectClassEditor
extends FormEditor {
    private static Logger logger = Logger.getLogger(ObjectClassEditor.class);
    public static final String ID = PluginConstants.EDITOR_OBJECT_CLASS_ID;
    private ObjectClassEditor instance;
    private ObjectClassEditorOverviewPage overviewPage;
    private ObjectClassEditorSourceCodePage sourceCodePage;
    private boolean dirty = false;
    private MutableObjectClass originalObjectClass;
    private MutableObjectClass modifiedObjectClass;
    private Schema originalSchema;
    private IPageChangedListener pageChangedListener = new IPageChangedListener(){

        public void pageChanged(PageChangedEvent event) {
            Object selectedPage = event.getSelectedPage();
            if (selectedPage instanceof ObjectClassEditorOverviewPage) {
                if (!ObjectClassEditor.this.sourceCodePage.canLeaveThePage()) {
                    ObjectClassEditor.this.notifyError(Messages.getString("ObjectClassEditor.CodeError"));
                    return;
                }
                ObjectClassEditor.this.overviewPage.refreshUI();
            } else if (selectedPage instanceof ObjectClassEditorSourceCodePage && ObjectClassEditor.this.sourceCodePage.canLeaveThePage()) {
                ObjectClassEditor.this.sourceCodePage.refreshUI();
            }
        }
    };
    private SchemaHandlerListener schemaHandlerListener = new SchemaHandlerAdapter(){

        @Override
        public void objectClassModified(ObjectClass oc) {
            if (oc.equals((Object)ObjectClassEditor.this.originalObjectClass)) {
                ObjectClassEditor.this.modifiedObjectClass = PluginUtils.getClone((ObjectClass)ObjectClassEditor.this.originalObjectClass);
                ObjectClassEditor.this.overviewPage.refreshUI();
                ObjectClassEditor.this.sourceCodePage.refreshUI();
                ObjectClassEditor.this.setPartName(ObjectClassEditor.this.getEditorInput().getName());
            }
        }

        @Override
        public void objectClassRemoved(ObjectClass oc) {
            if (oc.equals((Object)ObjectClassEditor.this.originalObjectClass)) {
                ObjectClassEditor.this.getEditorSite().getPage().closeEditor((IEditorPart)ObjectClassEditor.this.instance, false);
            }
        }

        @Override
        public void schemaRemoved(Schema schema) {
            if (((Object)((Object)schema)).equals((Object)ObjectClassEditor.this.originalSchema)) {
                ObjectClassEditor.this.getEditorSite().getPage().closeEditor((IEditorPart)ObjectClassEditor.this.instance, false);
            }
        }

        @Override
        public void schemaRenamed(Schema schema) {
            if (((Object)((Object)schema)).equals((Object)ObjectClassEditor.this.originalSchema)) {
                ObjectClassEditor.this.modifiedObjectClass = PluginUtils.getClone((ObjectClass)ObjectClassEditor.this.originalObjectClass);
                ObjectClassEditor.this.overviewPage.refreshUI();
                ObjectClassEditor.this.sourceCodePage.refreshUI();
            }
        }
    };

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.instance = this;
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
        this.originalObjectClass = (MutableObjectClass)((ObjectClassEditorInput)this.getEditorInput()).getObjectClass();
        this.modifiedObjectClass = PluginUtils.getClone((ObjectClass)this.originalObjectClass);
        SchemaHandler schemaHandler = Activator.getDefault().getSchemaHandler();
        this.originalSchema = schemaHandler.getSchema(this.originalObjectClass.getSchemaName());
        schemaHandler.addListener(this.schemaHandlerListener);
        this.addPageChangedListener(this.pageChangedListener);
    }

    public void dispose() {
        SchemaHandler schemaHandler = Activator.getDefault().getSchemaHandler();
        schemaHandler.removeListener(this.schemaHandlerListener);
        super.dispose();
    }

    protected void addPages() {
        try {
            this.overviewPage = new ObjectClassEditorOverviewPage(this);
            this.addPage((IFormPage)this.overviewPage);
            this.sourceCodePage = new ObjectClassEditorSourceCodePage(this);
            this.addPage((IFormPage)this.sourceCodePage);
        }
        catch (PartInitException e) {
            logger.debug((Object)"error when adding pages");
        }
    }

    public void doSave(IProgressMonitor monitor) {
        if (!this.sourceCodePage.canLeaveThePage()) {
            this.notifyError(Messages.getString("ObjectClassEditor.CodeErrorObject"));
            monitor.setCanceled(true);
            return;
        }
        Activator.getDefault().getSchemaHandler().modifyObjectClass(this.originalObjectClass, (ObjectClass)this.modifiedObjectClass);
        this.setPartName(this.getEditorInput().getName());
        if (!monitor.isCanceled()) {
            this.setDirty(false);
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.editorDirtyStateChanged();
    }

    public ObjectClass getOriginalObjectClass() {
        return this.originalObjectClass;
    }

    public MutableObjectClass getModifiedObjectClass() {
        return this.modifiedObjectClass;
    }

    public void setModifiedObjectClass(MutableObjectClass modifiedObjectClass) {
        this.modifiedObjectClass = modifiedObjectClass;
    }

    private void notifyError(String message) {
        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getString("ObjectClassEditor.Error"), (String)message);
    }
}

