/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.widget;

import java.util.ArrayList;
import org.apache.directory.studio.schemaeditor.view.widget.SchemaTextAttributeProvider;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class SchemaCodeScanner
extends RuleBasedScanner {
    String attributype = "attributetype";
    String objectclass = "objectclass";
    String[] keywords = new String[]{"NAME", "DESC", "OBSOLETE", "SUP", "EQUALITY", "ORDERING", "MUST", "MAY", "STRUCTURAL", "SUBSTR", "SYNTAX", "SINGLE-VALUE", "COLLECTIVE", "NO-USER-MODIFICATION", "USAGE", "userApplications", "directoryOperation", "distributedOperation", "dSAOperation", "ABSTRACT", "STRUCTURAL", "AUXILIARY", "MUST", "MAY"};

    public SchemaCodeScanner(SchemaTextAttributeProvider provider) {
        ArrayList<Object> rules = new ArrayList<Object>();
        Token keyword = new Token((Object)provider.getAttribute("__pos_schema_keyword_attribute"));
        Token string = new Token((Object)provider.getAttribute("__pos_schema_string_attribute"));
        Token undefined = new Token((Object)provider.getAttribute("__pos_schema_default_attribute"));
        Token ATToken = new Token((Object)provider.getAttribute("__pos_schema_attributetype_attribute"));
        Token OCToken = new Token((Object)provider.getAttribute("__pos_schema_objectclass_attribute"));
        Token oid = new Token((Object)provider.getAttribute("__pos_schema_oid_attribute"));
        rules.add(new SingleLineRule("\"", "\"", (IToken)string, '\u0000', true));
        rules.add(new SingleLineRule("'", "'", (IToken)string, '\u0000', true));
        rules.add(new WhitespaceRule(new IWhitespaceDetector(){

            public boolean isWhitespace(char c) {
                return Character.isWhitespace(c);
            }
        }));
        WordRule wrOID = new WordRule((IWordDetector)new SchemaOIDDetector(), (IToken)oid);
        rules.add(wrOID);
        WordRule wr = new WordRule((IWordDetector)new SchemaWordDetector(), (IToken)undefined);
        wr.addWord(this.attributype, (IToken)ATToken);
        wr.addWord(this.objectclass, (IToken)OCToken);
        for (String kw : this.keywords) {
            wr.addWord(kw, (IToken)keyword);
        }
        rules.add(wr);
        IRule[] param = new IRule[rules.size()];
        rules.toArray(param);
        this.setRules(param);
    }

    static class SchemaOIDDetector
    implements IWordDetector {
        SchemaOIDDetector() {
        }

        public boolean isWordPart(char c) {
            return Character.isDigit(c) || c == '.';
        }

        public boolean isWordStart(char c) {
            return Character.isDigit(c);
        }
    }

    static class SchemaWordDetector
    implements IWordDetector {
        SchemaWordDetector() {
        }

        public boolean isWordPart(char c) {
            return Character.isLetterOrDigit(c) || c == '_' || c == '-' || c == '$' || c == '#' || c == '@' || c == '~' || c == '.' || c == '?';
        }

        public boolean isWordStart(char c) {
            return Character.isLetter(c) || c == '.' || c == '_' || c == '?' || c == '$';
        }
    }
}

