/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core.io.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.BasicControl;
import javax.naming.ldap.PagedResultsResponseControl;
import org.apache.directory.api.ldap.codec.api.CodecControl;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.ldap.model.cursor.SearchCursor;
import org.apache.directory.api.ldap.model.entry.AttributeUtils;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.Referral;
import org.apache.directory.api.ldap.model.message.Response;
import org.apache.directory.api.ldap.model.message.SearchResultDone;
import org.apache.directory.api.ldap.model.message.SearchResultEntry;
import org.apache.directory.api.ldap.model.message.SearchResultReference;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.IJndiLogger;
import org.apache.directory.studio.connection.core.io.AbstractStudioNamingEnumeration;
import org.apache.directory.studio.connection.core.io.ConnectionWrapperUtils;
import org.apache.directory.studio.connection.core.io.StudioNamingEnumeration;
import org.apache.directory.studio.connection.core.io.jndi.ReferralsInfo;
import org.apache.directory.studio.connection.core.io.jndi.StudioSearchResult;

public class CursorStudioNamingEnumeration
extends AbstractStudioNamingEnumeration {
    private SearchCursor cursor;
    private SearchResultEntry currentSearchResultEntry;
    private List<Referral> referralsList = new ArrayList<Referral>();
    private List<String> currentReferralUrlsList;
    private StudioNamingEnumeration cursorNamingEnumeration;
    private SearchResultDone searchResultDone;
    private LdapApiService codec = LdapApiServiceFactory.getSingleton();

    public CursorStudioNamingEnumeration(Connection connection, SearchCursor cursor, String searchBase, String filter, SearchControls searchControls, Connection.AliasDereferencingMethod aliasesDereferencingMethod, Connection.ReferralHandlingMethod referralsHandlingMethod, javax.naming.ldap.Control[] controls, long requestNum, StudioProgressMonitor monitor, ReferralsInfo referralsInfo) {
        super(connection, searchBase, filter, searchControls, aliasesDereferencingMethod, referralsHandlingMethod, controls, requestNum, monitor, referralsInfo);
        this.connection = connection;
        this.cursor = cursor;
        this.searchBase = searchBase;
        this.filter = filter;
        this.searchControls = searchControls;
        this.aliasesDereferencingMethod = aliasesDereferencingMethod;
        this.referralsHandlingMethod = referralsHandlingMethod;
        this.controls = controls;
        this.monitor = monitor;
        this.referralsInfo = referralsInfo;
    }

    @Override
    public void close() throws NamingException {
        try {
            this.cursor.close();
        }
        catch (Exception e) {
            throw new NamingException(e.getMessage());
        }
    }

    @Override
    public boolean hasMore() throws NamingException {
        try {
            this.currentSearchResultEntry = null;
            while (this.cursor.next()) {
                Response currentResponse = (Response)this.cursor.get();
                if (currentResponse instanceof SearchResultEntry) {
                    this.currentSearchResultEntry = (SearchResultEntry)currentResponse;
                    return true;
                }
                if (!(currentResponse instanceof SearchResultReference) || this.referralsHandlingMethod == Connection.ReferralHandlingMethod.IGNORE) continue;
                this.referralsList.add(((SearchResultReference)currentResponse).getReferral());
            }
            if (this.searchResultDone == null) {
                this.searchResultDone = this.cursor.getSearchResultDone();
            }
            if (this.referralsHandlingMethod == Connection.ReferralHandlingMethod.FOLLOW_MANUALLY) {
                if (this.currentReferralUrlsList != null && this.currentReferralUrlsList.size() > 0) {
                    return true;
                }
                if (this.referralsList != null && this.referralsList.size() > 0) {
                    this.currentReferralUrlsList = new ArrayList<String>(this.referralsList.remove(0).getLdapUrls());
                    return this.currentReferralUrlsList.size() > 0;
                }
            } else if (this.referralsHandlingMethod == Connection.ReferralHandlingMethod.FOLLOW) {
                if (this.cursorNamingEnumeration != null && this.cursorNamingEnumeration.hasMore()) {
                    return true;
                }
                if (this.referralsList != null && this.referralsList.size() > 0) {
                    Referral referral = this.referralsList.remove(0);
                    ArrayList referralUrls = new ArrayList(referral.getLdapUrls());
                    LdapUrl url = new LdapUrl((String)referralUrls.get(0));
                    Connection referralConnection = ConnectionWrapperUtils.getReferralConnection(referral, this.monitor, this);
                    if (referralConnection != null) {
                        String referralSearchBase = url.getDn() != null && !url.getDn().isEmpty() ? url.getDn().getName() : this.searchBase;
                        String referralFilter = url.getFilter() != null && url.getFilter().length() == 0 ? url.getFilter() : this.filter;
                        SearchControls referralSearchControls = new SearchControls();
                        referralSearchControls.setSearchScope(url.getScope().getScope() > -1 ? url.getScope().getScope() : this.searchControls.getSearchScope());
                        referralSearchControls.setReturningAttributes(url.getAttributes() != null && url.getAttributes().size() > 0 ? url.getAttributes().toArray(new String[url.getAttributes().size()]) : this.searchControls.getReturningAttributes());
                        referralSearchControls.setCountLimit(this.searchControls.getCountLimit());
                        referralSearchControls.setTimeLimit(this.searchControls.getTimeLimit());
                        referralSearchControls.setDerefLinkFlag(this.searchControls.getDerefLinkFlag());
                        referralSearchControls.setReturningObjFlag(this.searchControls.getReturningObjFlag());
                        this.cursorNamingEnumeration = referralConnection.getConnectionWrapper().search(referralSearchBase, referralFilter, referralSearchControls, this.aliasesDereferencingMethod, this.referralsHandlingMethod, this.controls, this.monitor, this.referralsInfo);
                        return this.cursorNamingEnumeration.hasMore();
                    }
                }
            }
            for (IJndiLogger logger : ConnectionCorePlugin.getDefault().getJndiLoggers()) {
                logger.logSearchResultDone(this.connection, this.resultEntryCounter, this.requestNum, null);
            }
            return false;
        }
        catch (Exception e) {
            throw new NamingException(e.getMessage());
        }
    }

    @Override
    public boolean hasMoreElements() {
        throw new UnsupportedOperationException("Call hasMore() instead of hasMoreElements() !");
    }

    @Override
    public StudioSearchResult next() throws NamingException {
        try {
            if (this.currentSearchResultEntry != null) {
                ++this.resultEntryCounter;
                SearchResult sr = new SearchResult(this.currentSearchResultEntry.getObjectName().toString(), (Object)null, AttributeUtils.toAttributes((Entry)this.currentSearchResultEntry.getEntry()));
                sr.setNameInNamespace(this.currentSearchResultEntry.getObjectName().toString());
                StudioSearchResult ssr = new StudioSearchResult(sr, this.connection, false, null);
                return ssr;
            }
            if (this.referralsHandlingMethod == Connection.ReferralHandlingMethod.FOLLOW_MANUALLY) {
                if (this.currentReferralUrlsList != null && this.currentReferralUrlsList.size() > 0) {
                    ++this.resultEntryCounter;
                    LdapUrl url = new LdapUrl(this.currentReferralUrlsList.remove(0));
                    SearchResult searchResult = new SearchResult(url.getDn().getName(), (Object)null, new BasicAttributes(), false);
                    searchResult.setNameInNamespace(url.getDn().getName());
                    return new StudioSearchResult(searchResult, null, false, url);
                }
            } else if (this.referralsHandlingMethod == Connection.ReferralHandlingMethod.FOLLOW) {
                ++this.resultEntryCounter;
                return new StudioSearchResult((SearchResult)this.cursorNamingEnumeration.next(), this.connection, true, null);
            }
            return null;
        }
        catch (Exception e) {
            throw new NamingException(e.getMessage());
        }
    }

    @Override
    public StudioSearchResult nextElement() {
        throw new UnsupportedOperationException("Call next() instead of nextElement() !");
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public javax.naming.ldap.Control[] getResponseControls() throws NamingException {
        Map controlsMap;
        if (this.searchResultDone != null && (controlsMap = this.searchResultDone.getControls()) != null && controlsMap.size() > 0) {
            return this.convertControls(controlsMap.values());
        }
        return new javax.naming.ldap.Control[0];
    }

    private javax.naming.ldap.Control[] convertControls(Collection<Control> controls) {
        if (controls != null) {
            ArrayList<BasicControl> convertedControls = new ArrayList<BasicControl>();
            for (Control control : controls) {
                BasicControl convertedControl = null;
                CodecControl wrapped = null;
                wrapped = control instanceof CodecControl ? (CodecControl)control : this.codec.newControl(control);
                if ("1.2.840.113556.1.4.319".equals(control.getOid())) {
                    try {
                        convertedControl = new PagedResultsResponseControl(wrapped.getOid(), wrapped.isCritical(), wrapped.getValue());
                    }
                    catch (IOException e) {
                        convertedControl = new BasicControl(wrapped.getOid(), wrapped.isCritical(), wrapped.getValue());
                    }
                } else {
                    convertedControl = new BasicControl(wrapped.getOid(), wrapped.isCritical(), wrapped.getValue());
                }
                convertedControls.add(convertedControl);
            }
            return convertedControls.toArray(new javax.naming.ldap.Control[0]);
        }
        return new javax.naming.ldap.Control[0];
    }
}

