/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapservers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.common.ui.CommonUIUtils;
import org.apache.directory.studio.ldapservers.ConsolePrinterThread;
import org.apache.directory.studio.ldapservers.ConsolesManager;
import org.apache.directory.studio.ldapservers.LdapServersManager;
import org.apache.directory.studio.ldapservers.Messages;
import org.apache.directory.studio.ldapservers.model.LdapServer;
import org.apache.directory.studio.ldapservers.model.LdapServerStatus;
import org.apache.mina.util.AvailablePortFinder;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.console.MessageConsole;
import org.osgi.framework.Bundle;

public class LdapServersUtils {
    public static final String LAUNCH_CONFIGURATION_CUSTOM_OBJECT = "launchConfiguration";
    public static final String CONSOLE_PRINTER_CUSTOM_OBJECT = "consolePrinter";

    public static void runStartupListenerWatchdog(LdapServer server, int port) throws Exception {
        long startTime = System.currentTimeMillis();
        long watchDog = startTime + 180000L;
        while (System.currentTimeMillis() < watchDog && LdapServerStatus.STARTING == server.getStatus()) {
            try {
                if (port != 0 && AvailablePortFinder.available((int)port)) {
                    throw new Exception();
                }
                server.setStatus(LdapServerStatus.STARTED);
                return;
            }
            catch (Exception e) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {}
            }
        }
        if (LdapServerStatus.STARTING == server.getStatus()) {
            server.setStatus(LdapServerStatus.STOPPED);
        }
    }

    public static void startTerminateListenerThread(final LdapServer server, final ILaunch launch) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                DebugPlugin.getDefault().addDebugEventListener(new IDebugEventSetListener(){

                    public void handleDebugEvents(DebugEvent[] events) {
                        for (DebugEvent debugEvent : events) {
                            RuntimeProcess runtimeProcess;
                            ILaunch debugEventLaunch;
                            Object source;
                            if (debugEvent.getKind() != 8 || !((source = debugEvent.getSource()) instanceof RuntimeProcess) || !(debugEventLaunch = (runtimeProcess = (RuntimeProcess)source).getLaunch()).equals(launch)) continue;
                            server.setStatus(LdapServerStatus.STOPPED);
                            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                            return;
                        }
                    }
                });
            }
        };
        thread.start();
    }

    public static void startConsolePrinterThread(LdapServer server) {
        LdapServersUtils.startConsolePrinterThread(server, LdapServersManager.getServerFolder(server).append("log").append("apacheds.log").toFile());
    }

    public static void startConsolePrinterThread(LdapServer server, File serverLogsFile) {
        MessageConsole messageConsole = ConsolesManager.getDefault().getMessageConsole(server);
        ConsolePrinterThread consolePrinter = new ConsolePrinterThread(serverLogsFile, messageConsole.newMessageStream());
        consolePrinter.start();
        server.putCustomObject(CONSOLE_PRINTER_CUSTOM_OBJECT, consolePrinter);
    }

    public static void stopConsolePrinterThread(LdapServer server) {
        ConsolePrinterThread consolePrinter = (ConsolePrinterThread)server.removeCustomObject(CONSOLE_PRINTER_CUSTOM_OBJECT);
        if (consolePrinter != null && consolePrinter.isAlive()) {
            consolePrinter.close();
        }
    }

    public static ILaunch launchApacheDS(LdapServer server, IPath apacheDsLibrariesFolder, String[] libraries) throws Exception {
        IVMInstall vmInstall = JavaRuntime.getDefaultVMInstall();
        ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, server.getId());
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, vmInstall.getInstallLocation().toString());
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "org.apache.directory.studio.apacheds.Launcher");
        ArrayList<String> classpath = new ArrayList<String>();
        for (String library : libraries) {
            IRuntimeClasspathEntry libraryClasspathEntry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)apacheDsLibrariesFolder.append(library));
            libraryClasspathEntry.setClasspathProperty(3);
            classpath.add(libraryClasspathEntry.getMemento());
        }
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, classpath);
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
        IPath serverFolderPath = LdapServersManager.getServerFolder(server);
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "\"" + serverFolderPath.toOSString() + "\"");
        StringBuffer vmArguments = new StringBuffer();
        vmArguments.append("-Dlog4j.configuration=file:\"" + serverFolderPath.append("conf").append("log4j.properties").toOSString() + "\"");
        vmArguments.append(" ");
        vmArguments.append("-Dapacheds.var.dir=\"" + serverFolderPath.toOSString() + "\"");
        vmArguments.append(" ");
        vmArguments.append("-Dapacheds.log.dir=\"" + serverFolderPath.append("log").toOSString() + "\"");
        vmArguments.append(" ");
        vmArguments.append("-Dapacheds.run.dir=\"" + serverFolderPath.append("run").toOSString() + "\"");
        vmArguments.append(" ");
        vmArguments.append("-Dapacheds.instance=\"" + server.getName() + "\"");
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArguments.toString());
        workingCopy.setAttribute("org.eclipse.debug.ui.private", true);
        workingCopy.setAttribute("org.eclipse.debug.core.capture_output", false);
        ILaunchConfiguration configuration = workingCopy.doSave();
        ILaunch launch = configuration.launch("run", (IProgressMonitor)new NullProgressMonitor());
        server.putCustomObject(LAUNCH_CONFIGURATION_CUSTOM_OBJECT, launch);
        return launch;
    }

    public static void terminateLaunchConfiguration(LdapServer server) throws Exception {
        ILaunch launch = (ILaunch)server.removeCustomObject(LAUNCH_CONFIGURATION_CUSTOM_OBJECT);
        if (launch == null || launch.isTerminated()) {
            throw new Exception(Messages.getString("LdapServersUtils.AssociatedLaunchConfigurationCouldNotBeFoundOrTerminated"));
        }
        launch.terminate();
    }

    private static void verifyAndCopyLibraries(Bundle bundle, IPath sourceLibrariesPath, IPath destinationLibrariesPath, String[] libraries) {
        File destinationLibraries = destinationLibrariesPath.toFile();
        if (!destinationLibraries.exists()) {
            destinationLibraries.mkdir();
        }
        for (String library : libraries) {
            File destinationLibraryFile = destinationLibrariesPath.append(library).toFile();
            if (destinationLibraryFile.exists()) continue;
            try {
                LdapServersUtils.copyResource(bundle, sourceLibrariesPath.append(library), destinationLibraryFile);
            }
            catch (IOException e) {
                CommonUIUtils.openErrorDialog((String)NLS.bind((String)Messages.getString("LdapServersUtils.ErrorCopyingLibrary"), (Object[])new String[]{library, destinationLibraryFile.getAbsolutePath(), e.getMessage()}));
            }
        }
    }

    public static void verifyAndCopyLibraries(Bundle bundle, IPath sourceLibrariesPath, IPath destinationLibrariesPath, String[] libraries, StudioProgressMonitor monitor, String monitorTaskName) {
        monitor.subTask(monitorTaskName);
        LdapServersUtils.verifyAndCopyLibraries(bundle, sourceLibrariesPath, destinationLibrariesPath, libraries);
    }

    public static void copyResource(Bundle bundle, IPath resource, File destination) throws IOException {
        URL resourceUrl = FileLocator.find((Bundle)bundle, (IPath)resource, null);
        InputStream resourceInputStream = resourceUrl.openStream();
        FileOutputStream resourceOutputStream = new FileOutputStream(destination);
        LdapServersUtils.copyFile(resourceInputStream, resourceOutputStream);
        resourceInputStream.close();
        resourceOutputStream.close();
    }

    private static void copyFile(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = inputStream.read(buf)) != -1) {
            outputStream.write(buf, 0, i);
        }
    }
}

