<div style="overflow: hidden; clear: both;">
  <div align="center" class="sws-logo">
    <a href="https://static-web-server.net" title="static-web-server website">
    <svg xmlns="http://www.w3.org/2000/svg" width="100" height="100" viewBox="0 0 53.505 53.505"><path d="M161.49 84.99a.664.664 0 0 0-.38.149c-.081.07-.498.613-.927 1.207l-.778 1.079-.232.014c-.56.032-.46.11-1.354-1.054-.445-.58-.873-1.104-.95-1.165a.909.909 0 0 0-.345-.15c-.174-.03-.234-.02-.41.072a.873.873 0 0 0-.292.246c-.047.077-.327.672-.623 1.323-.594 1.309-.516 1.213-1.068 1.308l-.23.04-1.003-.874c-.552-.48-1.081-.914-1.177-.964-.327-.17-.8-.009-.946.321-.036.083-.198.719-.36 1.414-.163.695-.317 1.29-.345 1.324-.027.033-.188.12-.358.192l-.31.132-1.224-.707c-1.162-.67-1.239-.707-1.473-.697a.68.68 0 0 0-.403.12c-.273.193-.313.385-.354 1.719-.021.667-.042 1.285-.047 1.374-.008.14-.047.185-.317.362l-.309.203-1.296-.438c-1.449-.49-1.628-.519-1.883-.3-.084.073-.193.21-.243.306-.105.204-.102.244.172 1.87.104.612.183 1.136.176 1.164-.007.027-.122.159-.256.292l-.243.243-1.328-.172c-.73-.094-1.415-.16-1.52-.148a.717.717 0 0 0-.612.773c.011.105.232.756.49 1.446l.468 1.254-.18.292c-.1.16-.202.303-.227.316-.025.013-.553.054-1.173.093-1.646.103-1.685.109-1.86.258-.082.07-.19.207-.242.305-.157.3-.088.467.72 1.765l.722 1.161-.128.348c-.112.305-.147.354-.282.393-.084.025-.682.186-1.327.358-1.29.344-1.467.426-1.593.736a.677.677 0 0 0-.025.42c.044.23.097.296 1.014 1.275l.967 1.032-.058.332c-.033.182-.08.358-.106.392-.026.034-.571.32-1.211.636-.64.316-1.223.619-1.295.673-.275.208-.334.696-.117.974.059.076.606.498 1.216.937l1.108.8.008.274c.005.151.005.324 0 .383-.007.079-.277.312-1.042.9-.567.437-1.084.846-1.148.91a.876.876 0 0 0-.173.34c-.05.192-.046.252.024.415.045.105.146.24.223.302.078.061.687.358 1.353.66.899.408 1.22.576 1.244.652.018.056.058.224.088.372l.055.27-.897 1.03c-.494.566-.93 1.101-.971 1.189-.148.32.02.782.336.921.082.037.718.2 1.413.362.696.162 1.292.316 1.324.343.033.027.12.189.193.359l.132.309-.708 1.226c-.67 1.161-.706 1.238-.697 1.471.007.18.04.29.12.403.194.274.385.313 1.72.355.667.02 1.285.041 1.373.046.14.008.186.048.364.32l.203.309-.436 1.289c-.24.708-.44 1.361-.444 1.45-.01.218.052.365.221.525.29.273.31.273 1.713.05.693-.11 1.324-.219 1.402-.24.126-.034.169-.01.41.23l.27.268-.172 1.328c-.095.73-.16 1.413-.148 1.518.045.37.401.653.772.613.105-.01.756-.231 1.446-.49l1.255-.469.292.181c.16.1.302.202.315.227.013.025.055.553.094 1.174.102 1.645.108 1.684.258 1.859.07.082.207.19.305.242.299.156.467.088 1.766-.72l1.163-.721.352.13c.194.07.355.14.355.154.025.215.715 2.625.789 2.753a.795.795 0 0 0 .295.274c.163.083.235.09.449.048.244-.05.295-.09 1.286-1.019l1.033-.967.331.059c.182.032.359.079.393.105.034.026.32.571.636 1.211.316.64.62 1.223.673 1.295.217.288.714.336.994.097.082-.07.499-.613.927-1.206l.777-1.08.305-.019c.167-.01.343-.014.39-.006.047.008.448.488.891 1.067.444.579.846 1.088.893 1.133a.952.952 0 0 0 .288.147c.252.083.345.072.578-.068.221-.132.256-.196.91-1.64.268-.595.524-1.096.568-1.114.044-.018.215-.056.381-.083l.301-.05 1.004.873c.551.481 1.08.915 1.176.965.327.169.8.009.945-.321.037-.083.2-.719.362-1.414.162-.695.317-1.291.344-1.324.027-.033.188-.12.358-.192l.31-.133 1.225.707c1.161.67 1.238.707 1.471.698a.678.678 0 0 0 .403-.12c.275-.195.315-.385.355-1.72.02-.666.041-1.285.046-1.373.008-.14.049-.185.32-.364l.31-.203 1.294.439c1.448.491 1.626.52 1.882.3.084-.073.193-.21.243-.306.106-.204.102-.244-.172-1.87-.104-.612-.183-1.136-.176-1.163.007-.027.122-.16.255-.293l.243-.242 1.33.171c.73.094 1.414.161 1.519.148a.717.717 0 0 0 .612-.772c-.01-.105-.231-.756-.49-1.446l-.469-1.255.181-.292c.1-.16.202-.302.227-.315.025-.013.553-.055 1.174-.094 1.645-.103 1.684-.108 1.859-.257.082-.07.19-.208.242-.306.157-.3.088-.466-.72-1.764l-.722-1.162.128-.347c.112-.305.147-.354.282-.394.085-.025.681-.186 1.326-.358 1.29-.344 1.468-.426 1.594-.736a.676.676 0 0 0 .025-.42c-.044-.229-.096-.295-1.014-1.274l-.967-1.033.058-.33c.033-.183.08-.36.106-.393.026-.033.57-.318 1.208-.634.639-.315 1.221-.619 1.295-.674.29-.219.34-.715.1-.996-.07-.082-.613-.5-1.207-.927l-.054-.04-.55-1.873c.17-.139.347-.282.566-.45.579-.443 1.095-.854 1.148-.914a.957.957 0 0 0 .15-.326c.048-.186.044-.247-.026-.41a.905.905 0 0 0-.223-.3c-.078-.062-.685-.358-1.35-.66-.665-.301-1.223-.584-1.241-.628a2.895 2.895 0 0 1-.083-.38l-.05-.3.874-1.003c.48-.552.914-1.082.964-1.178.17-.328.009-.8-.324-.947-.085-.037-.72-.2-1.414-.362-.694-.162-1.288-.316-1.321-.342-.03-.025-.104-.164-.172-.316l-.12-.407.675-1.17c.67-1.162.706-1.238.697-1.472-.007-.178-.04-.29-.12-.403-.193-.273-.385-.313-1.72-.354-.666-.021-1.284-.042-1.372-.047-.14-.008-.186-.048-.365-.32l-.203-.309.44-1.295c.49-1.447.52-1.626.299-1.881a1.235 1.235 0 0 0-.306-.243c-.204-.106-.243-.102-1.869.172-.613.103-1.137.183-1.164.176-.027-.007-.159-.122-.292-.256l-.243-.242.172-1.33c.094-.73.16-1.414.147-1.519a.717.717 0 0 0-.772-.613c-.105.012-.756.232-1.446.49l-1.255.47-.292-.181c-.16-.1-.301-.202-.314-.227-.013-.025-.056-.554-.094-1.174-.103-1.645-.108-1.685-.258-1.86a1.236 1.236 0 0 0-.306-.242c-.299-.156-.467-.087-1.765.72l-1.16.723-.354-.13c-.195-.072-.357-.14-.357-.152-.025-.218-.715-2.63-.788-2.756a.802.802 0 0 0-.295-.274c-.163-.083-.235-.09-.449-.048-.244.05-.296.09-1.287 1.018l-1.033.968-.33-.059c-.183-.032-.36-.08-.394-.105-.034-.026-.32-.571-.635-1.211-.316-.64-.62-1.223-.674-1.295-.135-.18-.38-.266-.614-.247zm-.697 7.073.23.007c.772.027 2.37.305 3.543.618 1.461.39 2.871.954 4.201 1.67l-15.344 16.098 19.624-3.681-6.154 7.367 12.21-1.083c-.164 2.326-.664 4.402-1.554 6.473-.565 1.316-1.393 2.779-2.134 3.768l-.21.28-1.853-.083c-1.285-.056-1.935-.065-2.115-.028-.517.103-.958.5-1.118 1.001-.06.19-.101.723-.153 2.007-.038.961-.074 1.806-.08 1.877-.008.105-.077.168-.38.352-1.565.945-3.403 1.693-5.481 2.23-.636.163-3.37.523-4.096.538-2.105.044-4.413-.275-6.32-.874-.48-.15-.564-.193-.598-.3-.022-.068-.25-.884-.508-1.811-.342-1.232-.505-1.75-.607-1.92a1.507 1.507 0 0 0-1.317-.72c-.184.006-.814.162-2.052.51l-1.788.5-.267-.224c-.946-.794-2.086-2.03-2.935-3.183-1.563-2.121-2.609-4.365-3.314-7.108-.272-1.06-.592-3.89-.538-4.759.009-.152.061-.192 1.583-1.198 1.691-1.117 1.847-1.25 2.014-1.72.073-.205.08-.325.044-.657l-.046-.406-1.082-1.63-1.082-1.629.108-.264a23.32 23.32 0 0 1 .919-1.88 19.752 19.752 0 0 1 10.462-8.984c.31-.114.663-.235.782-.267l.219-.059 1.5 1.185c1.713 1.353 1.825 1.416 2.433 1.346.607-.07.703-.157 2.064-1.865z" transform="translate(-132.667 -84.987)"/></svg>
    </a>
  </div>

<h1 class="sws-title" align="center">Static Web Server</h1>

<h4 align="center">
    A cross-platform, high-performance & asynchronous web server for static files serving
  </h4>

<div align="center">
    <a href="https://github.com/static-web-server/static-web-server/actions/workflows/devel.yml" title="devel ci"><img src="https://github.com/static-web-server/static-web-server/actions/workflows/devel.yml/badge.svg?branch=master"></a> 
    <a href="https://hub.docker.com/r/joseluisq/static-web-server/" title="Docker Image Version (tag latest semver)"><img src="https://img.shields.io/docker/v/joseluisq/static-web-server/2"></a> 
    <a href="https://hub.docker.com/r/joseluisq/static-web-server/tags" title="Docker Image Size (tag)"><img src="https://img.shields.io/docker/image-size/joseluisq/static-web-server/2"></a> 
    <a href="https://hub.docker.com/r/joseluisq/static-web-server/" title="Docker Image"><img src="https://img.shields.io/docker/pulls/joseluisq/static-web-server.svg"></a> 
    <a href="https://crates.io/crates/static-web-server" title="static-web-server crate"><img src="https://img.shields.io/crates/v/static-web-server.svg"></a> 
    <a href="https://docs.rs/static-web-server" title="static-web-server crate docs"><img src="https://img.shields.io/docsrs/static-web-server/latest?label=docs.rs"></a> 
    <a href="https://github.com/static-web-server/static-web-server/blob/master/LICENSE-APACHE" title="static-web-server license"><img src="https://img.shields.io/crates/l/static-web-server"></a> 
    <a href="https://discord.gg/VWvtZeWAA7" title="Static Web Server Community on Discord">
      <img src="https://img.shields.io/discord/1086203405225164842?logo=discord&label=discord">
    </a>
  </div>
</div>

## Overview

**Static Web Server** (or **`SWS`** abbreviated) is a tiny and fast production-ready web server suitable to serve static web files or assets.

It is focused on **lightness and easy-to-use** principles while keeping [high performance and safety](https://blog.rust-lang.org/2015/04/10/Fearless-Concurrency.html) powered by [The Rust Programming Language](https://rust-lang.org).

Written on top of [Hyper](https://github.com/hyperium/hyper) and [Tokio](https://github.com/tokio-rs/tokio) runtime, it provides [concurrent and asynchronous networking abilities](https://rust-lang.github.io/async-book/01_getting_started/02_why_async.html) and the latest HTTP/1 - HTTP/2 implementations.

Cross-platform and available for `Linux`, `macOS`, `Windows`, `FreeBSD`, `NetBSD`, `Android`, `Docker` and `Wasm` (via [Wasmer](https://wasmer.io/wasmer/static-web-server)).

![static-web-server running](https://github.com/static-web-server/static-web-server/assets/1700322/102bef12-1f30-4054-a1bc-30c650d4ffa7)

## Features

- Built with [Rust](https://rust-lang.org), which focuses on [safety, speed and concurrency](https://kornel.ski/rust-c-speed).
- Memory-safe and significantly reduced CPU and RAM overhead.
- Blazing fast static files-serving and asynchronous powered by the latest [Hyper](https://github.com/hyperium/hyper/), [Tokio](https://github.com/tokio-rs/tokio) and a set of [awesome crates](https://github.com/static-web-server/static-web-server/blob/master/Cargo.toml).
- Single __4MB__ (uncompressed) and fully static binary with no dependencies ([Musl libc](https://doc.rust-lang.org/edition-guide/rust-2018/platform-and-target-support/musl-support-for-fully-static-binaries.html)). Suitable for running on [any Linux distro](https://en.wikipedia.org/wiki/Linux_distribution) or [Docker container](https://hub.docker.com/r/joseluisq/static-web-server/tags).
- Optional GZip, Deflate, Brotli or Zstandard (zstd) compression for text-based web files only.
- Compression on-demand via [Accept-Encoding](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Accept-Encoding) header.
- Markdown content negotiation via [Accept](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Accept) header for serving `.md` files.
- [Partial Content Delivery](https://en.wikipedia.org/wiki/Byte_serving) support for byte-serving of large files.
- Optional [Cache-Control](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Cache-Control) headers for assets.
- [Termination signal](https://www.gnu.org/software/libc/manual/html_node/Termination-Signals.html) handling with [graceful shutdown](https://cloud.google.com/blog/products/containers-kubernetes/kubernetes-best-practices-terminating-with-grace) ability and grace period.
- [HTTP/2](https://tools.ietf.org/html/rfc7540) and TLS support.
- [Security headers](https://web.dev/security-headers/) for HTTP/2 by default.
- [HEAD](https://tools.ietf.org/html/rfc7231#section-4.3.2) and [OPTIONS](https://datatracker.ietf.org/doc/html/rfc7231#section-4.3.7) responses.
- Lightweight and configurable logging via [tracing](https://github.com/tokio-rs/tracing) crate.
- Customizable number of blocking and worker threads.
- Optional directory listing with sorting and JSON output format support.
- [CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) with preflight requests support.
- Basic HTTP Authentication.
- Customizable HTTP response headers for specific file requests via glob patterns.
- Fallback pages for 404 errors, useful for Single-page applications.
- Run the server as a [Windows Service](<https://docs.microsoft.com/en-us/previous-versions/windows/it-pro/windows-server-2003/cc783643(v=ws.10)>).
- Configurable using CLI arguments, environment variables or a TOML file.
- Default and custom error pages.
- Built-in HTTP to HTTPS redirect.
- GET/HEAD Health check endpoint.
- Support for serving pre-compressed (Gzip/Brotli/Zstd) files directly from disk.
- Custom URL rewrites and redirects via glob patterns with replacements.
- Virtual hosting support.
- Multiple index files.
- Maintenance Mode functionality.
- Available as a library crate with opt-in features.
- First-class [Docker](https://docs.docker.com/get-started/overview/) support. [Scratch](https://hub.docker.com/_/scratch), latest [Alpine Linux](https://hub.docker.com/_/alpine) and [Debian](https://hub.docker.com/_/alpine) Docker images.
- Ability to accept a socket listener as a file descriptor for sandboxing and on-demand applications (e.g. [systemd](http://0pointer.de/blog/projects/socket-activation.html)).
- Cross-platform. Pre-compiled binaries for Linux, macOS, Windows, FreeBSD, NetBSD, Android (`x86/x86_64`, `ARM/ARM64`) and WebAssembly (via [Wasmer](https://wasmer.io/wasmer/static-web-server)).

## Benchmarks

<img title="SWS - Benchmarks April 2023" src="https://raw.githubusercontent.com/static-web-server/benchmarks/master/data/2023-04/benchmark-2023-04.png" width="860">

For more details see [the benchmarks repository](https://github.com/static-web-server/benchmarks).

For feedback or questions feel free to reach us on [the discussions page](https://github.com/static-web-server/static-web-server/discussions).

## Community

[SWS Community on Discord](https://discord.gg/VWvtZeWAA7)
