# Semantic Versioning

**`SWS`** project adheres to [Semantic Versioning](https://semver.org/) (SemVer) for every release like the latest [`v2`](https://github.com/static-web-server/static-web-server/blob/master/CHANGELOG.md).

The project privileges stability, security and performance, so you can rely on a major version like **v2** and expect to get features (minor) and bug/security fixes (patch) without breaking changes.

## Breaking changes for major versions

Only switches between ***major*** versions "could" contain *breaking changes* or not depending on the particular case.<br>
However, this project tries to keep away from any kind of _breaking change_ possible between ***major*** versions. But it still supports and prioritizes ***"no breaking changes"*** for ***minor*** and ***patch*** (bug fixes) versions.

On the other hand, if a *breaking change* is found to be *"strictly necessary"* to do. Then a new ***major*** version must be promoted as well and users informed accordingly so they can do a seamless transition.
