/*  VirtualCue XMMS
 *  Copyright (C) 2005 Barraud Manuel
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* include required header files */
#include <pthread.h>
#include <gtk/gtk.h>
#include <sys/stat.h>
#include "xmmsctrl.h" /* in here you can find all the functions to control the xmms behaviour */
#include <plugin.h>
#include "../Cueparser/CueParser.h"


#include <unistd.h>
#include <stdio.h>
#include <string.h>
#define VERSION "0.1.0"



int _GeneralCueValue_=0;

static void GenCuePlayer_init(void);
static void GenCuePlayer_about(void);
static void GenCuePlayer_config(void);
static void GenCuePlayer_cleanup(void);





/* the structures for InputPlugins etc can be found in 'plugin.h' */
GeneralPlugin GeneralCuePlayer =
{
	NULL,
	NULL,
	-1,
	"XMMS-General Cue Player "VERSION,
	GenCuePlayer_init,
	GenCuePlayer_about,
	GenCuePlayer_config,
	GenCuePlayer_cleanup,
};




void AddCueToPlayList(char *filename)// efface l'element actuel
{
gint pos;
char oldfilename[1024];
char *temp,*path;	
char buffer[1024],realfilename[1024];
int i;
InfoCue *ICue;
struct stat infofile;
	

//etant donne que le fichier va etre efface de la playlist on stocke le chemin quelque part
	
strcpy(oldfilename,filename);	
pos=xmms_remote_get_playlist_pos(GeneralCuePlayer.xmms_session);
// on stop le fichier qui es en train de lire
xmms_remote_stop(GeneralCuePlayer.xmms_session);
xmms_remote_playlist_delete(GeneralCuePlayer.xmms_session,pos);

//on ajoute autant d'entrée qu'il ya dans le fichier cue

ICue=GetInfoCue(oldfilename);	
if(ICue)
{	
	
	
	//on verifie si le fichier file exist!	
	path = g_strdup(oldfilename);
	temp = strrchr(path, '/');
	if (temp)
	*temp = '\0';
	sprintf(realfilename,"%s/%s",path,ICue->File);
					
	if(lstat (realfilename, &infofile)!=-1)
	{		
;
						
		for(i=1;i<=ICue->nbtrack;i++)
		{
			sprintf(buffer,"%s#%d",oldfilename,i);
			xmms_remote_playlist_ins_url_string(GeneralCuePlayer.xmms_session, buffer, pos+i);
		}
		
	
	}
	else
	printf("Le fichier %s n'existe pas!!\n",realfilename);
	g_free(path);
	g_free(ICue);
	
}	



}




char *GiveNextFile()
{
	gint pos;
	
	pos=xmms_remote_get_playlist_pos(GeneralCuePlayer.xmms_session);
	return xmms_remote_get_playlist_file(GeneralCuePlayer.xmms_session, pos+1);
	
}

void SetNextPosPlaylist()
{
	gint pos;
	pos = xmms_remote_get_playlist_pos(GeneralCuePlayer.xmms_session);
	xmms_remote_set_playlist_pos(GeneralCuePlayer.xmms_session,pos+1);
	
}

/* required by xmms to display info line */
GeneralPlugin *get_gplugin_info(void)
{
	return (&GeneralCuePlayer);
}


/* initialization of the plugin */
static void GenCuePlayer_init(void)
{
	

_GeneralCueValue_=1;

}

/* initialization of the plugin */
static void GenCuePlayer_cleanup(void)
{
	
	
}

/* the about window */
static void GenCuePlayer_about(void)
{
	
}





/* the config window */
static void GenCuePlayer_config(void)
{
	
}

/* end of file */
