/*  VirtualCue XMMS
 *  Copyright (C) 2005 Barraud Manuel
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef VCUE_H
#define VCUE_H

#include "xmmsctrl.h" /* in here you can find all the functions to control the xmms behaviour */
#include <plugin.h>
#include "GeneralInfo.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "../Cueparser/CueParser.h"

#define VERSION "0.0.1"

static void VirtualCue_init(void);
static int is_our_file(char *filename);
static void play_file(char *filename);
static void VirtualCue_about(void);
static void VirtualCue_file_info_box (char *filename);
static void stop(void);
static void seek(int time);
static void virtualcue_pause(short p);
static int get_time(void);
static void get_song_info(char *filename, char **title, int *length);
static void set_info_text (char *text);



#endif
