/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.refactoring.LaunchConfigChange;
import org.eclipse.jdt.internal.junit.refactoring.LaunchConfigurationContainer;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.ltk.core.refactoring.Change;

public class LaunchConfigRenameChange
extends LaunchConfigChange {
    private final String fNewName;
    private final ILaunchManager fLaunchManager;

    public LaunchConfigRenameChange(LaunchConfigurationContainer config, String newName, ILaunchManager lm, boolean shouldFlagWarning) {
        super(config, shouldFlagWarning);
        this.fNewName = newName;
        this.fLaunchManager = lm;
    }

    @Override
    protected void alterLaunchConfiguration(ILaunchConfigurationWorkingCopy copy) throws CoreException {
        if (!this.fLaunchManager.isExistingLaunchConfigurationName(this.fNewName)) {
            copy.rename(this.fNewName);
        }
    }

    @Override
    protected String getOldValue(ILaunchConfiguration config) {
        return this.fConfig.getName();
    }

    @Override
    public Change getUndo(String oldValue) throws CoreException {
        return new LaunchConfigRenameChange(this.fConfig, oldValue, this.fLaunchManager, this.shouldFlagWarning());
    }

    public String getName() {
        return Messages.format((String)JUnitMessages.LaunchConfigRenameChange_name, (Object[])new Object[]{this.fConfig.getName(), this.fNewName});
    }
}

