/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.persistence.load;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IDOM;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWsDOMRuntimeExtension;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.WsDOMLoadCanceledException;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.load.IWsDomCallback;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.load.IWsDomObtainer;
import org.eclipse.jst.ws.jaxws.utils.operation.IOperationRunner;

public class WsDomObtainer
implements IWsDomObtainer {
    private final IWsDOMRuntimeExtension domRuntime;
    private final IOperationRunner opRunner;

    public WsDomObtainer(IWsDOMRuntimeExtension domRuntime, IOperationRunner opRunner) {
        this.domRuntime = domRuntime;
        this.opRunner = opRunner;
    }

    @Override
    public void getDom(IWsDomCallback loadCallback) {
        if (this.isDomAlreadyLoaded()) {
            loadCallback.dom(this.getDomAlreadyLoaded());
            return;
        }
        this.opRunner.run(this.loadRunnable(loadCallback));
    }

    private IRunnableWithProgress loadRunnable(IWsDomCallback loadCallback) {
        return new LoadDomRunnable(loadCallback);
    }

    private IDOM getDomAlreadyLoaded() {
        try {
            return this.domRuntime.getDOM();
        }
        catch (WsDOMLoadCanceledException e) {
            throw new IllegalStateException(e);
        }
    }

    private boolean isDomAlreadyLoaded() {
        try {
            return this.domRuntime.getDOM() != null;
        }
        catch (WsDOMLoadCanceledException wsDOMLoadCanceledException) {
            return false;
        }
    }

    private final class LoadDomRunnable
    implements IRunnableWithProgress {
        private final IWsDomCallback loadCallback;

        private LoadDomRunnable(IWsDomCallback loadCallback) {
            this.loadCallback = loadCallback;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            if (WsDomObtainer.this.isDomAlreadyLoaded()) {
                this.loadCallback.dom(WsDomObtainer.this.getDomAlreadyLoaded());
                return;
            }
            try {
                this.loadCallback.domLoadStarting();
                this.loadCallback.dom(this.performLoad(monitor));
            }
            catch (WsDOMLoadCanceledException e) {
                this.cancelled(e);
            }
            catch (IOException e) {
                this.failed(e);
            }
        }

        private IDOM performLoad(IProgressMonitor monitor) throws IOException, WsDOMLoadCanceledException {
            WsDomObtainer.this.domRuntime.createDOM(monitor);
            return WsDomObtainer.this.domRuntime.getDOM();
        }

        private void failed(IOException e) throws InvocationTargetException {
            this.loadCallback.domLoadFailed();
            throw new InvocationTargetException(e);
        }

        private void cancelled(WsDOMLoadCanceledException e) throws InterruptedException {
            this.loadCallback.domLoadCancelled();
            throw new InterruptedException(e.getMessage());
        }
    }
}

