/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.schemaobjecteditor.ui.common;

import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.util.Images;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public abstract class CollapseableSection
extends AbstractFormPart {
    protected boolean _isWhiteBackgroud;
    protected FormToolkit _toolkit;
    protected Section _sec;
    protected String _title;
    protected Display _display;
    protected int _estyle;
    protected String _helpContextId;
    private Composite _content;
    protected String _pluginId;

    public CollapseableSection(FormToolkit toolkit, String title, Display display, boolean isCollapseable, boolean isCollapsed, int estyle) {
        this._toolkit = toolkit;
        this._title = title;
        this._display = display;
        this._estyle = estyle;
        this._isWhiteBackgroud = toolkit.getColors().getBackground().equals((Object)this._display.getSystemColor(1));
        if (this._isWhiteBackgroud) {
            this._estyle |= 0x100;
        } else {
            FormColors colors = toolkit.getColors();
            if (colors.getBorderColor() != null) {
                colors.createColor("org.eclipse.ui.forms.SEPARATOR", colors.getBorderColor().getRGB());
            }
        }
        if (isCollapseable) {
            this._estyle |= 0xA;
        }
        this._estyle |= isCollapsed ? 32 : 64;
    }

    public CollapseableSection(FormToolkit toolkit, String title, Display display, boolean isCollapsed, int estyle) {
        this(toolkit, title, display, true, isCollapsed, estyle);
    }

    public CollapseableSection(FormToolkit toolkit, String title, Display display, int estyle) {
        this(toolkit, title, display, false, false, estyle);
    }

    public Control createControl(Composite parent, int horizontalSpan, String helpContextId) {
        this._helpContextId = helpContextId;
        this._sec = this._toolkit.createSection(parent, this._estyle);
        this.hookListeners();
        this._sec.setText(this._title);
        if (!this._isWhiteBackgroud) {
            this._toolkit.createCompositeSeparator((Composite)this._sec);
        }
        this._content = this._toolkit.createComposite((Composite)this._sec, 0);
        this._content.setBackground(parent.getBackground());
        this.createSectionContent(this._content);
        if (this._helpContextId != null) {
            ImageHyperlink helplink = new ImageHyperlink((Composite)this._sec, 0);
            this._toolkit.adapt((Control)helplink, false, false);
            helplink.setImage(Images.get("org.eclipse.datatools.sqltools.schemaobjecteditor.pageshelp.gif"));
            helplink.setToolTipText("Help");
            helplink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    CollapseableSection.this.displayHelp(CollapseableSection.this._helpContextId);
                }
            });
            this._sec.setTextClient((Control)helplink);
        }
        this._sec.setClient((Control)this._content);
        Object data = this._sec.getLayoutData();
        if (data != null) {
            if (data instanceof GridData) {
                GridData gd = (GridData)data;
                gd.horizontalSpan = horizontalSpan;
                this._sec.setLayoutData((Object)gd);
            } else if (data instanceof TableWrapData) {
                TableWrapData td = (TableWrapData)data;
                td.colspan = horizontalSpan;
                this._sec.setLayoutData((Object)td);
            }
        }
        return this._sec;
    }

    private void displayHelp(String contextHelpId) {
        String contextId = HelpUtil.getContextId((String)contextHelpId, (String)this._pluginId);
        if (contextId != null && contextId.length() > 0) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(contextId);
        } else {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp();
        }
    }

    protected abstract void createSectionContent(Composite var1);

    public Section getSection() {
        return this._sec;
    }

    public Composite getSectionContent() {
        return this._content;
    }

    protected void hookListeners() {
        if ((this._sec.getExpansionStyle() & 2) != 0 || (this._sec.getExpansionStyle() & 4) != 0) {
            this._sec.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanging(ExpansionEvent e) {
                    CollapseableSection.this.expansionStateChanging(e.getState());
                }

                public void expansionStateChanged(ExpansionEvent e) {
                    CollapseableSection.this.expansionStateChanged(e.getState());
                }
            });
        }
    }

    protected void expansionStateChanging(boolean expanding) {
    }

    protected void expansionStateChanged(boolean expanded) {
        if (this.getManagedForm() != null) {
            this.getManagedForm().getForm().reflow(false);
        }
    }

    public void setPluginId(String id) {
        this._pluginId = id;
    }
}

