/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.properties.celleditors;

import java.text.MessageFormat;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public abstract class CellEditorWrapper
extends CellEditor {
    private Composite _editor;
    private CellEditor _wrapped;
    private Button _button;
    private static final int defaultStyle = 0;

    public CellEditorWrapper() {
        this.setStyle(0);
    }

    protected CellEditorWrapper(Composite parent) {
        this(parent, 0);
    }

    protected CellEditorWrapper(Composite parent, int style) {
        super(parent, style);
    }

    protected Button createButton(Composite parent) {
        Button result = new Button(parent, 1024);
        result.setImage(this.getBindingImage());
        return result;
    }

    protected abstract Image getBindingImage();

    protected Control createContents(Composite cell) {
        this._wrapped = this.createWrappedCellEditor(cell);
        if (this._wrapped == null) {
            this._wrapped = new TextCellEditor(cell);
        }
        this._wrapped.addListener(new ICellEditorListener(){

            public void applyEditorValue() {
                CellEditorWrapper.this.fireApplyEditorValue();
            }

            public void cancelEditor() {
                CellEditorWrapper.this.fireCancelEditor();
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                CellEditorWrapper.this.fireEditorValueChanged(oldValidState, newValidState);
            }
        });
        this._wrapped.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
            }
        });
        this._wrapped.getControl().setVisible(true);
        this._wrapped.getControl().addListener(23, new Listener(){

            public void handleEvent(Event event) {
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).CellEditorWrapper.this._wrapped != null && (this).CellEditorWrapper.this._wrapped.getControl() != null && !(this).CellEditorWrapper.this._wrapped.getControl().isDisposed()) {
                            (this).CellEditorWrapper.this._wrapped.getControl().setVisible(true);
                        } else {
                            CellEditorWrapper.this.deactivate();
                        }
                    }
                });
            }
        });
        return this._wrapped.getControl();
    }

    protected abstract CellEditor createWrappedCellEditor(Composite var1);

    protected Control createControl(Composite parent) {
        Font font = parent.getFont();
        Color bg = parent.getBackground();
        this._editor = new Composite(parent, this.getStyle());
        this._editor.setFont(font);
        this._editor.setBackground(bg);
        this._editor.setLayout((Layout)new DialogCellLayout());
        this.createContents(this._editor);
        this._button = this.createButton(this._editor);
        this._button.setFont(font);
        this._button.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u001b') {
                    CellEditorWrapper.this.fireCancelEditor();
                }
            }
        });
        this._button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object newValue = CellEditorWrapper.this.openDialogBox((Control)CellEditorWrapper.this._editor);
                if (newValue != null) {
                    boolean newValidState = CellEditorWrapper.this.isCorrect(newValue);
                    if (newValidState) {
                        CellEditorWrapper.this.markDirty();
                        CellEditorWrapper.this.doSetValue(newValue);
                    } else {
                        CellEditorWrapper.this.setErrorMessage(MessageFormat.format(CellEditorWrapper.this.getErrorMessage(), newValue.toString()));
                    }
                    CellEditorWrapper.this.fireApplyEditorValue();
                }
            }
        });
        this.setValueValid(true);
        return this._editor;
    }

    protected void doSetFocus() {
        if (this._wrapped != null && this._wrapped.getControl() != null && !this._wrapped.getControl().isDisposed()) {
            this._wrapped.setFocus();
        } else {
            this._button.setFocus();
        }
    }

    protected Object doGetValue() {
        return this._wrapped.getValue();
    }

    protected void doSetValue(Object value) {
        if (this._wrapped != null) {
            this._wrapped.setValue(value);
        }
    }

    protected abstract Object openDialogBox(Control var1);

    public void activate() {
        super.activate();
        this._wrapped.activate();
    }

    public void deactivate() {
        super.deactivate();
    }

    public void dispose() {
        this._wrapped.dispose();
        super.dispose();
    }

    private class DialogCellLayout
    extends Layout {
        private DialogCellLayout() {
        }

        public void layout(Composite editor, boolean force) {
            Rectangle bounds = editor.getClientArea();
            Point size = CellEditorWrapper.this._button.computeSize(-1, -1, force);
            CellEditorWrapper.this._wrapped.getControl().setBounds(0, 0, bounds.width - size.x, bounds.height);
            CellEditorWrapper.this._button.setBounds(bounds.width - size.x, 0, size.x, bounds.height);
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point contentsSize = CellEditorWrapper.this._wrapped.getControl().computeSize(-1, -1, force);
            Point buttonSize = CellEditorWrapper.this._button.computeSize(-1, -1, force);
            Point result = new Point(buttonSize.x, Math.max(contentsSize.y, buttonSize.y));
            return result;
        }
    }
}

