/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine;

import java.util.HashMap;
import java.util.Map;

public class ColorUtil {
    public static final int BLACK = -16777216;
    public static final int WHITE = -1;
    public static final int LIGHT_GRAY = -4144960;
    public static final int GRAY = -8355712;
    public static final int DARK_GRAY = -12566464;
    public static final int RED = -65536;
    public static final int PINK = -20561;
    public static final int ORANGE = -14336;
    public static final int YELLOW = -256;
    public static final int GREEN = -16711936;
    public static final int MAGENTA = -65281;
    public static final int CYAN = -16711681;
    public static final int BLUE = -16776961;
    static Map intToString = new HashMap();
    static Map stringToInt = new HashMap();

    static void add(int color, String name) {
        Integer c = new Integer(color);
        intToString.put(c, name);
        stringToInt.put(name, c);
    }

    public static String getStringForColor(int c) {
        String result = (String)intToString.get(new Integer(c));
        if (result != null) {
            return result;
        }
        return ColorUtil.getHexForColor(c);
    }

    public static int getColor(String nm) {
        Integer color = (Integer)stringToInt.get(nm);
        if (color != null) {
            return color;
        }
        try {
            Integer result = Integer.decode(nm);
            return 0xFF000000 | result;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public static int getTextColorFor(int c) {
        return ColorUtil.isColorLight(c) ? -16777216 : -1;
    }

    public static boolean isColorLight(int c) {
        int r = ColorUtil.getRed(c);
        int g = ColorUtil.getGreen(c);
        return r > 240 || g > 240 || r > 150 && g > 150;
    }

    public static int getRed(int rgb) {
        return rgb >> 16 & 0xFF;
    }

    public static int getGreen(int rgb) {
        return rgb >> 8 & 0xFF;
    }

    public static int getBlue(int rgb) {
        return rgb >> 0 & 0xFF;
    }

    public static int getAlpha(int rgb) {
        return rgb >> 24 & 0xFF;
    }

    public static int getBrightness(int rgb) {
        int cmin;
        int cmax;
        int r = ColorUtil.getRed(rgb);
        int g = ColorUtil.getGreen(rgb);
        int b = ColorUtil.getBlue(rgb);
        int n = cmax = r > g ? r : g;
        if (b > cmax) {
            cmax = b;
        }
        int n2 = cmin = r < g ? r : g;
        if (b < cmin) {
            cmin = b;
        }
        return cmax;
    }

    public static String getHexForColor(int c) {
        return "#" + Integer.toHexString(c & 0xFFFFFF | 0x1000000).substring(1);
    }

    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b << 0;
    }

    static {
        ColorUtil.add(-16777216, "black");
        ColorUtil.add(-16776961, "blue");
        ColorUtil.add(-16711681, "cyan");
        ColorUtil.add(-12566464, "darkgray");
        ColorUtil.add(-8355712, "gray");
        ColorUtil.add(-16711936, "green");
        ColorUtil.add(-4144960, "lightgray");
        ColorUtil.add(-65281, "magenta");
        ColorUtil.add(-14336, "orange");
        ColorUtil.add(-20561, "pink");
        ColorUtil.add(-65536, "red");
        ColorUtil.add(-1, "white");
        ColorUtil.add(-256, "yellow");
    }
}

