/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.yura.domination.engine.ColorUtil;
import net.yura.domination.engine.JavaCompatUtil;
import net.yura.domination.engine.RiskIO;
import net.yura.domination.engine.core.Continent;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.engine.translation.MapTranslator;

public class RiskUtil {
    public static final Object SUCCESS = "SUCCESS";
    public static final Object ERROR = "ERROR";
    public static final String RISK_VERSION_URL;
    public static final String RISK_LOBBY_URL;
    public static final String GAME_NAME;
    public static final String RISK_VERSION;
    private static boolean oldVersion;
    private static final Logger logger;
    public static RiskIO streamOpener;
    public static final Charset UTF_8;
    private static InetAddress localHost;

    public static void close(Closeable obj) {
        try {
            if (obj != null) {
                obj.close();
            }
        }
        catch (Exception ex) {
            logger.info("not able to close " + obj);
        }
    }

    public static InputStream openMapStream(String a) throws IOException {
        if (a == null) {
            throw new NullPointerException("map filename is null");
        }
        return streamOpener.openMapStream(a);
    }

    public static InputStream openStream(String a) throws IOException {
        return streamOpener.openStream(a);
    }

    public static ResourceBundle getResourceBundle(Class c, String n, Locale l) {
        return streamOpener.getResourceBundle(c, n, l);
    }

    public static void openURL(URL url) throws Exception {
        streamOpener.openURL(url);
    }

    public static void openDocs(String docs) throws Exception {
        streamOpener.openDocs(docs);
    }

    public static void saveFile(String file, RiskGame aThis) throws Exception {
        streamOpener.saveGameFile(file, aThis);
    }

    public static InputStream getLoadFileInputStream(String file) throws Exception {
        return streamOpener.loadGameFile(file);
    }

    public static void printStackTrace(Throwable ex) {
        RiskUtil.printStackTrace(null, ex);
    }

    public static void printStackTrace(String msg, Throwable ex) {
        logger.log(Level.WARNING, msg, ex);
    }

    public static void donate() throws Exception {
        RiskUtil.openURL(new URL("http://domination.sourceforge.net/donate.shtml"));
    }

    public static void patreon() throws Exception {
        RiskUtil.openURL(new URL("http://domination.sourceforge.net/patreon.shtml"));
    }

    public static void donatePayPal() throws Exception {
        RiskUtil.openURL(new URL("https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=yura%40yura%2enet&item_name=" + GAME_NAME + "%20Donation&no_shipping=0&no_note=1&tax=0&currency_code=GBP&lc=GB&bn=PP%2dDonationsBF&charset=UTF%2d8"));
    }

    public static BufferedReader readMap(InputStream in) throws IOException {
        PushbackInputStream pushback = new PushbackInputStream(in, 3);
        int first = pushback.read();
        if (first == 239) {
            int second = pushback.read();
            if (second == 187) {
                int third = pushback.read();
                if (third == 191) {
                    return new BufferedReader(new InputStreamReader((InputStream)pushback, "UTF-8"));
                }
                pushback.unread(third);
            }
            pushback.unread(second);
        }
        pushback.unread(first);
        return new BufferedReader(new InputStreamReader((InputStream)pushback, "ISO-8859-1"));
    }

    public static Map loadInfo(String fileName, boolean cards) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        int c = 0;
        while (true) {
            BufferedReader bufferin = null;
            try {
                bufferin = RiskUtil.readMap(RiskUtil.openMapStream(fileName));
                ArrayList<String> misss = null;
                MapTranslator mapTranslator = null;
                if (cards) {
                    mapTranslator = new MapTranslator();
                    mapTranslator.setCards(fileName);
                    misss = new ArrayList<String>();
                }
                String input = bufferin.readLine();
                String mode = null;
                while (input != null) {
                    if (!input.equals("")) {
                        if (input.charAt(0) == ';') {
                            String comment = (String)info.get("comment");
                            String com = input.substring(1).trim();
                            comment = comment == null ? com : comment + "\n" + com;
                            info.put("comment", comment);
                        } else {
                            if (input.charAt(0) == '[' && input.charAt(input.length() - 1) == ']') {
                                mode = "newsection";
                            }
                            if ("files".equals(mode)) {
                                int space = input.indexOf(32);
                                if (space < 0) {
                                    throw new RuntimeException("invalid file " + input);
                                }
                                String fm = input.substring(0, space);
                                String val = input.substring(space + 1);
                                info.put(fm, val);
                            } else {
                                if ("borders".equals(mode)) break;
                                if ("countries".equals(mode)) {
                                    int space = input.indexOf(32);
                                    if (space < 0) {
                                        throw new RuntimeException("invalid country " + input);
                                    }
                                    info.put("countries", Integer.parseInt(input.substring(0, space)));
                                } else if ("missions".equals(mode)) {
                                    StringTokenizer st = new StringTokenizer(input);
                                    String description = mapTranslator.getTranslatedMissionName(st.nextToken() + "-" + st.nextToken() + "-" + st.nextToken() + "-" + st.nextToken() + "-" + st.nextToken() + "-" + st.nextToken());
                                    if (description == null) {
                                        StringBuffer d = new StringBuffer();
                                        while (st.hasMoreElements()) {
                                            d.append(st.nextToken());
                                            d.append(" ");
                                        }
                                        description = d.toString();
                                    }
                                    misss.add(description);
                                } else if ("newsection".equals(mode)) {
                                    mode = input.substring(1, input.length() - 1);
                                } else if (mode == null && input.indexOf(32) > 0) {
                                    info.put(input.substring(0, input.indexOf(32)), input.substring(input.indexOf(32) + 1));
                                }
                            }
                        }
                    }
                    input = bufferin.readLine();
                }
                if (!cards) break;
                info.put("missions", misss.toArray(new String[misss.size()]));
                misss = null;
                break;
            }
            catch (IOException ex) {
                RiskUtil.printStackTrace("Error trying to load: " + fileName, ex);
                if (c >= 5) break;
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
            catch (RuntimeException ex) {
                System.out.println("Error trying to load: " + fileName);
                throw ex;
            }
            finally {
                if (bufferin != null) {
                    try {
                        bufferin.close();
                    }
                    catch (Exception ex) {}
                }
            }
            ++c;
        }
        return info;
    }

    public static String createRandomUniqueAddress() {
        String randomString = "#" + String.valueOf(Math.round(Math.random() * 9.223372036854776E18));
        try {
            try {
                String hostname = RiskUtil.getLocalHost().getHostName();
                hostname = JavaCompatUtil.replaceAll(hostname, " ", "");
                return hostname + randomString;
            }
            catch (Throwable th) {
                return "sandbox" + randomString;
            }
        }
        catch (Exception e) {
            return "nonet" + randomString;
        }
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        if (localHost == null) {
            long start = System.currentTimeMillis();
            localHost = InetAddress.getLocalHost();
            System.out.println("getLocalHost took " + (System.currentTimeMillis() - start) + "milliseconds");
        }
        return localHost;
    }

    public static String getContext(String f) {
        int slash = f.lastIndexOf(92);
        if (slash >= 0) {
            return f.substring(0, slash + 1);
        }
        slash = f.lastIndexOf(47);
        if (slash >= 0) {
            return f.substring(0, slash + 1);
        }
        return "";
    }

    public static void saveGameLog(File logFile, RiskGame game) throws IOException {
        FileWriter fileout = new FileWriter(logFile);
        BufferedWriter buffer = new BufferedWriter(fileout);
        PrintWriter printer = new PrintWriter(buffer);
        Vector commands = game.getCommands();
        int size = commands.size();
        for (int line = 0; line < size; ++line) {
            printer.println(commands.get(line));
        }
        printer.close();
    }

    public static OutputStream getOutputStream(File dir, String fileName) throws Exception {
        File outFile = new File(dir, fileName);
        File parent = outFile.getParentFile();
        if (!parent.isDirectory() && !parent.mkdirs()) {
            throw new RuntimeException("can not create dir " + parent);
        }
        return new FileOutputStream(outFile);
    }

    public static void rename(File oldFile, File newFile) {
        if (newFile.exists() && !newFile.delete()) {
            throw new RuntimeException("can not del dest file: " + newFile);
        }
        if (!oldFile.renameTo(newFile)) {
            try {
                RiskUtil.copy(oldFile, newFile);
                if (!oldFile.delete()) {
                    logger.warning("can not del source file: " + oldFile);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("rename failed: from: " + oldFile + " to: " + newFile, ex);
            }
        }
    }

    public static String getNewVersionCheck() {
        try {
            String v;
            URL url = new URL(RISK_VERSION_URL);
            BufferedReader bufferin = new BufferedReader(new InputStreamReader(url.openStream()));
            ArrayList<String> buffer = new ArrayList<String>();
            String input = bufferin.readLine();
            while (input != null) {
                buffer.add(input);
                input = bufferin.readLine();
            }
            String[] newversion = buffer.toArray(new String[buffer.size()]);
            if (newversion[0].startsWith("RISKOK ") && !(v = newversion[0].substring(7, newversion[0].length())).equals(RISK_VERSION)) {
                oldVersion = true;
                for (int c = 1; c < newversion.length; ++c) {
                    v = v + "\n" + newversion[c];
                }
                return v;
            }
        }
        catch (Throwable e) {
            logger.info("version check fail " + e);
        }
        return null;
    }

    public static void setOldVersion() {
        oldVersion = true;
    }

    public static boolean isOldVersion() {
        return oldVersion;
    }

    public static String asHTML(Continent[] continents) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html><table>");
        for (int c = 0; c < continents.length; ++c) {
            Continent continent = continents[c];
            buffer.append("<tr style=\"background-color: ");
            buffer.append(ColorUtil.getHexForColor(continent.getColor()));
            buffer.append("; color:");
            buffer.append(ColorUtil.getHexForColor(ColorUtil.getTextColorFor(continent.getColor())));
            buffer.append("\"><td>");
            buffer.append(continent.getName());
            buffer.append("</td><td> - </td><td>");
            buffer.append(continent.getArmyValue());
            buffer.append("</td></tr>");
        }
        buffer.append("</table></html>");
        return buffer.toString();
    }

    public static void copy(File src, File dest) throws IOException {
        if (src.isDirectory()) {
            if (!dest.exists()) {
                dest.mkdir();
                logger.info("Directory copied from " + src + "  to " + dest);
            }
            String[] files = src.list();
            for (int c = 0; c < files.length; ++c) {
                File srcFile = new File(src, files[c]);
                File destFile = new File(dest, files[c]);
                RiskUtil.copy(srcFile, destFile);
            }
        } else {
            int length;
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, length);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            logger.info("File copied from " + src + " to " + dest);
        }
    }

    public static String getAtLeastOne(StringTokenizer stringT) {
        StringBuilder text = new StringBuilder(stringT.nextToken());
        while (stringT.hasMoreTokens()) {
            text.append(' ');
            text.append(stringT.nextToken());
        }
        return text.toString();
    }

    public static String getFileNameWithoutExtension(String filename) {
        int dotIndex = filename.lastIndexOf(46);
        return dotIndex > 0 ? filename.substring(0, dotIndex) : filename;
    }

    static {
        logger = Logger.getLogger(RiskUtil.class.getName());
        UTF_8 = Charset.forName("UTF-8");
        Properties settings = new Properties();
        InputStream settingsData = RiskUtil.class.getResourceAsStream("settings.ini");
        try {
            settings.load(settingsData);
        }
        catch (Exception ex) {
            throw new RuntimeException("can not find settings.ini file!", ex);
        }
        finally {
            RiskUtil.close(settingsData);
        }
        RISK_VERSION_URL = settings.getProperty("VERSION_URL");
        RISK_LOBBY_URL = settings.getProperty("LOBBY_URL");
        GAME_NAME = settings.getProperty("name");
        RISK_VERSION = settings.getProperty("version");
        String dmap = settings.getProperty("defaultmap");
        String dcards = settings.getProperty("defaultcards");
        RiskGame.setDefaultMapAndCards(dmap, dcards);
    }
}

