/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine.ai.logic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import net.yura.domination.engine.ai.AISubmissive;
import net.yura.domination.engine.core.Card;
import net.yura.domination.engine.core.Continent;
import net.yura.domination.engine.core.Country;
import net.yura.domination.engine.core.Player;
import net.yura.domination.engine.core.StatType;
import net.yura.domination.engine.core.Statistic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AIDomination
extends AISubmissive {
    static final int MAX_AI_TURNS = 300;
    public static final int PLAYER_AI_AVERAGE = 4;
    public static final int PLAYER_AI_HARD = 2;
    public static final int PLAYER_AI_EASY = 1;
    protected final int type;
    private boolean eliminating;
    private Continent breaking;

    public AIDomination(int type) {
        this.type = type;
    }

    @Override
    public String getPlaceArmies() {
        if (this.type == 1 && this.game.NoEmptyCountries() && this.r.nextInt(6) != 0 || this.game.getSetupDone() && this.type == 4 && this.r.nextBoolean()) {
            return this.simplePlacement();
        }
        if (this.game.NoEmptyCountries()) {
            return this.plan(false);
        }
        return this.findEmptyCountry();
    }

    private String simplePlacement() {
        if (!this.game.NoEmptyCountries()) {
            return "autoplace";
        }
        Vector t = this.player.getTerritoriesOwned();
        List<Country> n = this.findAttackableTerritories(this.player, false);
        ArrayList<Country> copy = new ArrayList<Country>(n);
        Country c = null;
        if (n.isEmpty() || t.size() == 1) {
            c = (Country)t.get(0);
            return this.getPlaceCommand(c, this.player.getExtraArmies());
        }
        if (n.size() == 1) {
            c = n.get(0);
            return this.getPlaceCommand(c, this.player.getExtraArmies());
        }
        HashSet<Country> toTake = new HashSet<Country>();
        Country fallback = null;
        Country overload = null;
        int additional = 1;
        while (!n.isEmpty()) {
            c = n.remove(this.r.nextInt(n.size()));
            Vector cn = c.getNeighbours();
            for (int i = 0; i < cn.size(); ++i) {
                Country other = (Country)cn.get(i);
                if (other.getOwner() == this.player || toTake.contains(other)) continue;
                int diff = 0;
                diff = this.game.getMaxDefendDice() == 2 ? c.getArmies() - 2 - (3 * other.getArmies() / 2 + other.getArmies() % 2) : c.getArmies() - 2 - 2 * other.getArmies();
                if (diff >= 0) {
                    if (diff < other.getArmies() * 3) {
                        overload = c;
                        additional = other.getArmies() * 3 - diff;
                    }
                    toTake.add(other);
                    continue;
                }
                if (-diff <= this.player.getExtraArmies()) {
                    return this.getPlaceCommand(c, -diff);
                }
                if (fallback != null) continue;
                fallback = c;
                additional = Math.max(1, -diff);
            }
        }
        if (fallback == null) {
            if (overload != null) {
                return this.getPlaceCommand(overload, additional);
            }
            return this.getPlaceCommand(this.randomCountry(copy), this.player.getExtraArmies());
        }
        return this.getPlaceCommand(fallback, additional);
    }

    private String findEmptyCountry() {
        Continent[] cont = this.game.getContinents();
        double check = -1.7976931348623157E308;
        Country toPlace = null;
        HashMap<Player, Integer> players = new HashMap<Player, Integer>();
        for (int i = 0; i < this.game.getPlayers().size(); ++i) {
            players.put((Player)this.game.getPlayers().get(i), i);
        }
        ArrayList<Continent> conts = new ArrayList<Continent>(Arrays.asList(cont));
        Collections.sort(conts, new Comparator<Continent>(){

            @Override
            public int compare(Continent arg0, Continent arg1) {
                return (int)Math.signum(AIDomination.this.getContinentValue(arg1) - AIDomination.this.getContinentValue(arg0));
            }
        });
        block1: for (int i = 0; i < conts.size(); ++i) {
            Continent co = (Continent)conts.get(i);
            Vector ct = co.getTerritoriesContained();
            int bestCountryScore = 0;
            boolean hasFree = false;
            Country preferedCountry = null;
            int[] troops = new int[this.game.getPlayers().size()];
            boolean hasPlacement = false;
            Player otherOwner = null;
            for (int j = 0; j < ct.size(); ++j) {
                Country country = (Country)ct.get(j);
                if (country.getOwner() == null) {
                    hasFree = true;
                    int countryScore = this.scoreCountry(country);
                    if (preferedCountry != null && countryScore >= bestCountryScore && (countryScore != bestCountryScore || !this.r.nextBoolean())) continue;
                    bestCountryScore = countryScore;
                    preferedCountry = country;
                    continue;
                }
                Integer index = (Integer)players.get(country.getOwner());
                int n = index;
                troops[n] = troops[n] + 1;
                if (country.getOwner() == this.player) {
                    hasPlacement = true;
                    continue;
                }
                if (otherOwner == null) {
                    otherOwner = country.getOwner();
                    continue;
                }
                if (otherOwner == country.getOwner() || !this.r.nextBoolean()) continue;
                hasPlacement = true;
            }
            if (!hasFree) continue;
            if (this.type == 2 && !hasPlacement) {
                return this.getPlaceCommand(preferedCountry, 1);
            }
            double continentValue = this.getContinentValue(co);
            for (int j = 0; j < troops.length; ++j) {
                int numberofEnemyUnits = 0;
                int territorynum = 1;
                int numberOfEnemies = 0;
                for (int k = 0; k < troops.length; ++k) {
                    if (j == k) {
                        territorynum += troops[k];
                        continue;
                    }
                    numberofEnemyUnits += troops[k];
                    if (troops[k] <= 0) continue;
                    ++numberOfEnemies;
                }
                double score = (double)territorynum / Math.max(1.0, (double)(numberofEnemyUnits * numberOfEnemies));
                score *= continentValue;
                score /= (double)bestCountryScore;
                Player p = (Player)this.game.getPlayers().get(j);
                if (p != this.player && territorynum == ct.size()) {
                    toPlace = preferedCountry;
                    break block1;
                }
                if (check <= score) {
                    check = score;
                    toPlace = preferedCountry;
                    continue;
                }
                if (toPlace != null) continue;
                toPlace = preferedCountry;
            }
        }
        if (toPlace == null) {
            return "autoplace";
        }
        return this.getPlaceCommand(toPlace, 1);
    }

    protected int scoreCountry(Country country) {
        int n = country.getIncomingNeighbours().size();
        int countryScore = n + 6;
        if (country.getArmies() > 0) {
            countryScore += n;
            countryScore -= country.getArmies();
        }
        if (n < 3) {
            countryScore -= 2;
        }
        if (this.game.getSetupDone() && country.getCrossContinentNeighbours().size() == 1) {
            countryScore -= 3;
        }
        int neighborBonus = 0;
        int neighbors = 0;
        for (int k = 0; k < n; ++k) {
            Country cn = country.getIncomingNeighbours().get(k);
            if (cn.getOwner() == this.player) {
                neighborBonus -= cn.getArmies();
                ++neighbors;
                continue;
            }
            if (cn.getOwner() == null) continue;
            countryScore += cn.getArmies() / 2 + cn.getArmies() % 2;
        }
        int n1 = country.getNeighbours().size();
        for (int k = 0; k < n1; ++k) {
            Country cn = (Country)country.getNeighbours().get(k);
            if (cn.getOwner() == this.player) {
                neighborBonus -= cn.getArmies();
                ++neighbors;
                continue;
            }
            if (cn.getOwner() != null || cn.getContinent() == country.getContinent()) continue;
            --countryScore;
        }
        neighbors = neighbors / 2 + neighbors % 2;
        countryScore += neighborBonus / 4 + neighborBonus % 2;
        if (!this.game.getSetupDone() || neighbors > 1) {
            countryScore = (int)((double)countryScore - Math.pow(neighbors, 2.0));
            if (!this.game.getSetupDone()) {
                countryScore = Math.max(1, countryScore);
            }
        }
        return countryScore;
    }

    private String plan(boolean attack) {
        List<Country> attackable = this.findAttackableTerritories(this.player, attack);
        if (attack && attackable.isEmpty()) {
            return "endattack";
        }
        GameState gameState = this.getGameState(this.player, false);
        if (attack && this.game.getCurrentPlayer().getStatistics().size() > 300 && (gameState.me.playerValue < gameState.orderedPlayers.get((int)(gameState.orderedPlayers.size() - 1)).playerValue || this.r.nextBoolean())) {
            boolean keepPlaying = false;
            for (int i = 0; i < this.game.getPlayers().size(); ++i) {
                Player p = (Player)this.game.getPlayers().get(i);
                if (p.getType() != 0 || p.getTerritoriesOwned().isEmpty()) continue;
                keepPlaying = true;
                break;
            }
            if (!keepPlaying) {
                Country attackFrom = attackable.get(this.r.nextInt(attackable.size()));
                for (Country c : attackFrom.getNeighbours()) {
                    if (c.getOwner() == this.player) continue;
                    return "attack " + attackFrom.getColor() + " " + c.getColor();
                }
            }
        }
        HashMap<Country, AttackTarget> targets = this.searchAllTargets(attack, attackable, gameState);
        if (attack && this.player.getType() == 1 && this.game.getMaxDefendDice() == 2 && this.game.isCapturedCountry() && this.r.nextBoolean()) {
            ArrayList<AttackTarget> targetList = new ArrayList<AttackTarget>(targets.values());
            Collections.sort(targetList, Collections.reverseOrder());
            Iterator<AttackTarget> iterator = targetList.iterator();
            if (iterator.hasNext()) {
                AttackTarget at = iterator.next();
                if (at.remaining >= 1) {
                    int route = this.findBestRoute(attackable, gameState, attack, null, at, gameState.targetPlayers.get(0), targets);
                    Country start = attackable.get(route);
                    return this.getAttack(targets, at, route, start);
                }
            }
        }
        return this.plan(attack, attackable, gameState, targets);
    }

    private HashMap<Country, AttackTarget> searchAllTargets(Boolean attack, List<Country> attackable, GameState gameState) {
        HashMap<Country, AttackTarget> targets = new HashMap<Country, AttackTarget>();
        for (int i = 0; i < attackable.size(); ++i) {
            Country c = attackable.get(i);
            int attackForce = c.getArmies();
            this.searchTargets(targets, c, attackForce, i, attackable.size(), this.game.getSetupDone() ? this.player.getExtraArmies() : this.player.getExtraArmies() / 2 + this.player.getExtraArmies() % 2, attack, gameState);
        }
        return targets;
    }

    protected String plan(boolean attack, List<Country> attackable, GameState gameState, Map<Country, AttackTarget> targets) {
        String objective;
        String result;
        Object et;
        boolean shouldEndAttack = false;
        boolean pressAttack = false;
        int extra = this.player.getExtraArmies();
        HashSet<Country> allCountriesTaken = new HashSet<Country>();
        List<EliminationTarget> continents = this.findTargetContinents(gameState, targets, attack, true);
        List<Country> v = this.getBorder(gameState);
        boolean isTooWeak = false;
        if (this.game.getSetupDone()) {
            String result2;
            String objective2;
            EliminationTarget et2;
            pressAttack = this.pressAttack(gameState);
            shouldEndAttack = this.shouldEndAttack(gameState);
            isTooWeak = this.isTooWeak(gameState);
            List<EliminationTarget> toEliminate = this.findEliminationTargets(targets, gameState, attack, extra);
            if (!toEliminate.isEmpty()) {
                Collections.sort(toEliminate);
                for (int i = 0; i < toEliminate.size(); ++i) {
                    String result3;
                    et2 = toEliminate.get(i);
                    int totalCards = this.player.getCards().size() + et2.ps.p.getCards().size();
                    if (this.type == 2 && gameState.orderedPlayers.size() > 1 && gameState.me.playerValue < gameState.orderedPlayers.get((int)0).playerValue && shouldEndAttack && (double)et2.ps.armies > (double)gameState.me.armies * 0.4) {
                        double d = et2.ps.armies - this.getCardEstimate(et2.ps.p.getCards().size());
                        double d2 = totalCards > 5 ? 1.0 : gameState.me.playerValue / gameState.orderedPlayers.get((int)0).playerValue;
                        if (d > d2 * (double)this.getCardEstimate(this.player.getCards().size() + et2.ps.p.getCards().size())) {
                            toEliminate.remove(i--);
                            continue;
                        }
                    }
                    if (et2.ps.p.getCards().isEmpty() && gameState.orderedPlayers.get((int)0).playerValue > 0.7 * gameState.me.playerValue || et2.ps.p.getCards().size() > 2 && this.player.getCards().size() + et2.ps.p.getCards().size() <= 5) {
                        toEliminate.remove(i--);
                    }
                    if ((result3 = this.eliminate(attackable, targets, gameState, attack, extra, allCountriesTaken, et2, shouldEndAttack, false)) == null) continue;
                    this.eliminating = true;
                    return result3;
                }
            }
            if ((objective2 = this.planObjective(attack, attackable, gameState, targets, allCountriesTaken, pressAttack, shouldEndAttack, true)) != null) {
                return objective2;
            }
            if (this.type == 2 && gameState.orderedPlayers.size() > 1 && (this.isIncreasingSet() || gameState.me.playerValue > gameState.orderedPlayers.get((int)0).playerValue)) {
                if (!toEliminate.isEmpty()) {
                    if (!attack) {
                        HashMap<Country, AttackTarget> newTargets = this.searchAllTargets(true, attackable, gameState);
                        block1: for (int i = 0; i < toEliminate.size(); ++i) {
                            et = toEliminate.get(i);
                            for (int j = 0; j < ((EliminationTarget)et).attackTargets.size(); ++j) {
                                AttackTarget newTarget = newTargets.get(((EliminationTarget)et).attackTargets.get((int)j).targetCountry);
                                if (newTarget == null) continue block1;
                                ((EliminationTarget)et).attackTargets.set(j, newTarget);
                            }
                            String result4 = this.eliminate(attackable, newTargets, gameState, attack, extra, allCountriesTaken, (EliminationTarget)et, shouldEndAttack, true);
                            if (result4 == null) continue;
                            this.eliminating = true;
                            return result4;
                        }
                    } else if (this.isIncreasingSet()) {
                        et2 = toEliminate.get(0);
                        et2.allOrNone = false;
                        String result5 = this.eliminate(attackable, targets, gameState, attack, extra, allCountriesTaken, et2, shouldEndAttack, true);
                        if (result5 != null) {
                            return result5;
                        }
                    }
                }
                if (this.isIncreasingSet() && (double)gameState.me.defenseValue < gameState.orderedPlayers.get((int)0).attackValue) {
                    shouldEndAttack = true;
                }
            }
            if (!attack && allCountriesTaken.isEmpty() && shouldEndAttack && !pressAttack && !this.game.getCards().isEmpty() && (result2 = this.ensureRiskCard(attackable, gameState, targets, pressAttack, continents)) != null) {
                return result2;
            }
            if ((gameState.commonThreat != null && !gameState.commonThreat.owned.isEmpty() || gameState.breakOnlyTargets && !isTooWeak) && (result2 = this.breakContinent(attackable, targets, gameState, attack, pressAttack, v)) != null) {
                return result2;
            }
            if (!(attack || gameState.orderedPlayers.size() <= 1 && this.player.getCapital() == null && this.player.getMission() == null && this.game.getMaxDefendDice() <= 2 || (result2 = this.fortify(gameState, attackable, true, v)) == null)) {
                String toAttack;
                if (!continents.isEmpty() && pressAttack && this.player.getCapital() == null && (toAttack = this.eliminate(attackable, targets, gameState, attack, extra, allCountriesTaken, continents.get(0), false, false)) != null) {
                    return toAttack;
                }
                return result2;
            }
            if ((pressAttack || this.type != 2 && attack || this.type == 2 && !isTooWeak && (this.player.getMission() != null || !gameState.me.owned.isEmpty() || continents.isEmpty() || attack)) && (result2 = this.breakContinent(attackable, targets, gameState, attack, pressAttack, v)) != null) {
                return result2;
            }
        } else if (!attack && (result = this.fortify(gameState, attackable, this.game.getMaxDefendDice() == 2, v)) != null) {
            return result;
        }
        if ((objective = this.planObjective(attack, attackable, gameState, targets, allCountriesTaken, pressAttack, shouldEndAttack, false)) != null) {
            return objective;
        }
        if (!(continents.isEmpty() || shouldEndAttack && (this.game.isCapturedCountry() || this.game.getCards().isEmpty()) && attack && gameState.commonThreat == null && (isTooWeak || !gameState.breakOnlyTargets && !((double)gameState.me.defenseValue > gameState.orderedPlayers.get((int)0).attackValue)))) {
            int toConsider = continents.size();
            if (attack && isTooWeak) {
                toConsider = 1;
            }
            for (int i = 0; i < toConsider; ++i) {
                String result6 = this.eliminate(attackable, targets, gameState, attack, extra, allCountriesTaken, continents.get(i), shouldEndAttack, false);
                if (result6 == null) continue;
                this.eliminating = true;
                for (Country c : continents.get((int)i).co.getTerritoriesContained()) {
                    if (c.getOwner() == this.player || allCountriesTaken.contains(c)) continue;
                    this.eliminating = false;
                    break;
                }
                if (this.shouldProactivelyFortify(continents.get((int)i).co, attack, attackable, gameState, targets, pressAttack, continents)) {
                    ArrayList<Country> border = new ArrayList<Country>();
                    for (Country c : continents.get((int)i).co.getBorderCountries()) {
                        if (c.getOwner() != this.player) continue;
                        border.add(c);
                    }
                    String placement = this.fortify(gameState, attackable, false, border);
                    if (placement != null) {
                        return placement;
                    }
                }
                return result6;
            }
            if (!attack) {
                int route;
                AttackTarget min = null;
                for (int i = 0; i < toConsider; ++i) {
                    et = continents.get(i);
                    for (int k = 0; k < ((EliminationTarget)et).attackTargets.size(); ++k) {
                        AttackTarget at = ((EliminationTarget)et).attackTargets.get(k);
                        if (min != null && (allCountriesTaken.contains(at.targetCountry) || at.remaining >= min.remaining)) continue;
                        min = at;
                    }
                }
                if (min != null && (route = this.findBestRoute(attackable, gameState, attack, min.targetCountry.getContinent(), min, this.game.getSetupDone() ? gameState.targetPlayers.get(0) : null, targets)) != -1) {
                    int toPlace = -min.routeRemaining[route] + 2;
                    if (toPlace < 0) {
                        toPlace = this.player.getExtraArmies() / 3;
                    }
                    return this.getPlaceCommand(attackable.get(route), toPlace);
                }
            }
        }
        if (attack) {
            return this.lastAttacks(attack, attackable, gameState, targets, shouldEndAttack, v);
        }
        String result7 = this.fortify(gameState, attackable, false, v);
        if (result7 != null) {
            return result7;
        }
        return super.getPlaceArmies();
    }

    protected String planObjective(boolean attack, List<Country> attackable, GameState gameState, Map<Country, AttackTarget> targets, Set<Country> allCountriesTaken, boolean pressAttack, boolean shouldEndAttack, boolean highProbability) {
        return null;
    }

    protected boolean shouldProactivelyFortify(Continent c, boolean attack, List<Country> attackable, GameState gameState, Map<Country, AttackTarget> targets, boolean pressAttack, List<EliminationTarget> continents) {
        return this.type == 2 && !this.isIncreasingSet() && this.eliminating && gameState.commonThreat == null && !attack && this.ensureRiskCard(attackable, gameState, targets, pressAttack, continents) == null;
    }

    protected boolean isIncreasingSet() {
        return !(this.game.getCardMode() != 0 || this.type == 2 && this.game.getNewCardState() <= 12 || this.game.getCards().isEmpty() && !this.game.isRecycleCards());
    }

    private String ensureRiskCard(List<Country> attackable, GameState gameState, Map<Country, AttackTarget> targets, boolean pressAttack, List<EliminationTarget> continents) {
        if (this.type == 1) {
            return null;
        }
        ArrayList<AttackTarget> attacks = new ArrayList<AttackTarget>(targets.values());
        Collections.sort(attacks);
        AttackTarget target = null;
        boolean found = false;
        int bestRoute = 0;
        for (int i = attacks.size() - 1; i >= 0; --i) {
            AttackTarget at = (AttackTarget)attacks.get(i);
            if (target != null && at.remaining < target.remaining) break;
            if (found) continue;
            if (at.remaining > 0) {
                target = null;
                break;
            }
            if (continents.size() > 0 && at.targetCountry.getContinent() == continents.get((int)0).co) {
                bestRoute = this.findBestRoute(attackable, gameState, pressAttack, null, at, this.game.getSetupDone() ? gameState.targetPlayers.get(0) : null, targets);
                target = at;
                found = true;
                continue;
            }
            int route = this.findBestRoute(attackable, gameState, pressAttack, null, at, this.game.getSetupDone() ? gameState.targetPlayers.get(0) : null, targets);
            if (target != null && !gameState.targetPlayers.contains(at.targetCountry.getOwner()) && !this.r.nextBoolean()) continue;
            bestRoute = route;
            target = at;
        }
        if (target != null) {
            return this.getPlaceCommand(attackable.get(bestRoute), -target.remaining + 1);
        }
        return null;
    }

    private String lastAttacks(boolean attack, List<Country> attackable, GameState gameState, Map<Country, AttackTarget> targets, boolean shouldEndAttack, List<Country> border) {
        Country initialAttack;
        Country attackFrom;
        int bestRoute;
        AttackTarget target;
        int i;
        boolean isTooWeak = this.isTooWeak(gameState) && (double)gameState.me.defenseValue < 0.5 * (double)gameState.orderedPlayers.get((int)0).defenseValue;
        boolean forceReduction = this.game.isCapturedCountry() || this.game.getCards().isEmpty() || gameState.me.playerValue > 1.5 * gameState.orderedPlayers.get((int)0).playerValue;
        ArrayList<AttackTarget> sorted = new ArrayList<AttackTarget>(targets.values());
        Collections.sort(sorted);
        for (i = sorted.size() - 1; i >= 0; --i) {
            target = (AttackTarget)sorted.get(i);
            if (target.depth > 1) break;
            bestRoute = this.findBestRoute(attackable, gameState, attack, null, target, gameState.targetPlayers.get(0), targets);
            if (bestRoute == -1) continue;
            attackFrom = attackable.get(bestRoute);
            initialAttack = this.getCountryToAttack(targets, target, bestRoute, attackFrom);
            if (forceReduction) {
                if (!(attackFrom.getCrossContinentNeighbours().size() != 1 && border.contains(attackFrom) || !attackFrom.getCrossContinentNeighbours().contains(initialAttack) || (gameState.commonThreat == null || gameState.commonThreat.p != initialAttack.getOwner()) && !gameState.targetPlayers.contains(initialAttack.getOwner()) && (gameState.commonThreat != null || gameState.breakOnlyTargets) || initialAttack.getContinent().getOwner() == null || border.contains(attackFrom) && initialAttack.getArmies() != 1 && attackFrom.getArmies() <= 3 || target.remaining < -(attackFrom.getArmies() / 2 + attackFrom.getArmies() % 2))) {
                    return this.getAttack(targets, target, bestRoute, attackFrom);
                }
                if (gameState.commonThreat == null || gameState.commonThreat.p != initialAttack.getContinent().getOwner() || target.remaining < -(attackFrom.getArmies() / 2 + attackFrom.getArmies() % 2)) continue;
                return this.getAttack(targets, target, bestRoute, attackFrom);
            }
            if (target.remaining < -(attackFrom.getArmies() / 2 + attackFrom.getArmies() % 2) || gameState.commonThreat != null && !this.isIncreasingSet() && gameState.commonThreat.p != initialAttack.getOwner() && !gameState.targetPlayers.contains(initialAttack.getOwner()) && initialAttack.getContinent().getOwner() != null || this.type != 1 && attackFrom.getArmies() - target.remaining > this.getCardEstimate(this.player.getCards().size() < 4 ? 4 : 5) + initialAttack.getArmies() / 2 || isTooWeak && target.remaining < 0 && this.isIncreasingSet() && this.player.getCards().isEmpty()) continue;
            return this.getAttack(targets, target, bestRoute, attackFrom);
        }
        if (!isTooWeak && this.type != 1) {
            for (i = 0; i < sorted.size(); ++i) {
                int j;
                target = (AttackTarget)sorted.get(i);
                if (target.depth > 1 || (bestRoute = this.findBestRoute(attackable, gameState, attack, null, target, gameState.targetPlayers.get(0), targets)) == -1) continue;
                attackFrom = attackable.get(bestRoute);
                initialAttack = this.getCountryToAttack(targets, target, bestRoute, attackFrom);
                if (border.contains(attackFrom) && initialAttack.getArmies() < 5 || attackFrom.getArmies() < 3 || this.game.getMaxDefendDice() > 2 && initialAttack.getArmies() > 2 && (gameState.me.playerValue < 1.5 * gameState.orderedPlayers.get((int)0).playerValue || this.game.isCapturedCountry()) || attackFrom.getArmies() < 4 && attackFrom.getArmies() - 1 <= initialAttack.getArmies()) continue;
                if (gameState.commonThreat != null) {
                    if (gameState.commonThreat.p != initialAttack.getOwner()) continue;
                    return this.getAttack(targets, target, bestRoute, attackFrom);
                }
                if (this.ownsNeighbours(initialAttack) && target.remaining > -(attackFrom.getArmies() / 2 + attackFrom.getArmies() % 2)) {
                    if ((this.isIncreasingSet() || gameState.me.playerValue < 0.8 * gameState.orderedPlayers.get((int)0).playerValue) && !this.isGoodIdea(gameState, targets, bestRoute, target, attackFrom, null, shouldEndAttack)) continue;
                    return this.getAttack(targets, target, bestRoute, attackFrom);
                }
                List<Country> neighbours = attackFrom.getIncomingNeighbours();
                int count = 0;
                for (j = 0; j < neighbours.size(); ++j) {
                    if (neighbours.get(j).getOwner() == this.player) continue;
                    ++count;
                }
                if (shouldEndAttack && target.routeRemaining[bestRoute] > 0 && count > 1) continue;
                if (gameState.orderedPlayers.get((int)0).playerValue > gameState.me.playerValue) {
                    for (j = 0; j < gameState.orderedPlayers.size(); ++j) {
                        PlayerState ps = gameState.orderedPlayers.get(j);
                        if (ps.p != initialAttack.getOwner() || gameState.breakOnlyTargets && !gameState.targetPlayers.contains(ps.p) || ps.attackOrder != 1 && gameState.orderedPlayers.size() != 1 && !((double)ps.defenseValue > (double)gameState.me.defenseValue * 1.2) && (shouldEndAttack || !this.isGoodIdea(gameState, targets, bestRoute, target, attackFrom, null, shouldEndAttack))) continue;
                        return this.getAttack(targets, target, bestRoute, attackFrom);
                    }
                    continue;
                }
                if ((this.isIncreasingSet() || this.game.getCardMode() == 2 && !this.game.getCards().isEmpty() || gameState.me.playerValue < 0.8 * gameState.orderedPlayers.get((int)0).playerValue) && !this.isGoodIdea(gameState, targets, bestRoute, target, attackFrom, null, shouldEndAttack)) continue;
                return this.getAttack(targets, target, bestRoute, attackFrom);
            }
        }
        return "endattack";
    }

    protected boolean isTooWeak(GameState gameState) {
        boolean result;
        block4: {
            block5: {
                boolean bl = result = (gameState.orderedPlayers.size() > 1 || this.player.getMission() != null || this.player.getCapital() != null) && (double)gameState.me.defenseValue < gameState.orderedPlayers.get((int)0).attackValue / (double)Math.max(2, gameState.orderedPlayers.size() - 1);
                if (result || this.type != 2 || gameState.orderedPlayers.size() <= 2) break block4;
                if ((double)gameState.me.defenseValue < 1.2 * (double)gameState.orderedPlayers.get((int)(gameState.orderedPlayers.size() - 1)).defenseValue) break block5;
                if (gameState.commonThreat == null && this.player.getStatistics().size() >= 4 && this.player.getCards().size() >= 2) break block4;
                double d = gameState.me.defenseValue;
                double d2 = this.game.getMaxDefendDice() == 2 ? 1.2 : 1.0;
                if (!(d < d2 * gameState.orderedPlayers.get((int)0).attackValue)) break block4;
            }
            if (this.shouldEndAttack(gameState)) {
                return true;
            }
        }
        return result;
    }

    protected boolean shouldEndAttack(GameState gameState) {
        if (gameState.orderedPlayers.size() < 2 || this.type == 1) {
            return false;
        }
        int defense = gameState.me.defenseValue;
        double sum = 0.0;
        for (int i = 0; i < gameState.orderedPlayers.size(); ++i) {
            sum += gameState.orderedPlayers.get((int)i).attackValue;
        }
        if ((double)defense > sum) {
            return false;
        }
        double ratio = (double)defense / sum;
        if (ratio < 0.5) {
            return true;
        }
        return this.r.nextDouble() > (ratio - 0.5) * 2.0;
    }

    protected boolean pressAttack(GameState gameState) {
        if (this.type == 1) {
            return this.r.nextBoolean();
        }
        if (gameState.orderedPlayers.size() < 2) {
            return true;
        }
        int defense = gameState.me.defenseValue;
        double sum = 0.0;
        for (int i = 0; i < gameState.orderedPlayers.size(); ++i) {
            sum += gameState.orderedPlayers.get((int)i).attackValue;
        }
        return (double)defense > sum;
    }

    private List<EliminationTarget> findTargetContinents(GameState gameState, Map<Country, AttackTarget> targets, boolean attack, boolean filterNoAttacks) {
        Continent[] c = this.game.getContinents();
        int targetContinents = Math.max(1, c.length - gameState.orderedPlayers.size());
        ArrayList<Double> vals = new ArrayList<Double>();
        List<EliminationTarget> result = new ArrayList<EliminationTarget>();
        HashSet<Country> seen = new HashSet<Country>();
        for (int i = 0; i < c.length; ++i) {
            Double key;
            int index;
            Continent co = c[i];
            if (gameState.owned[i] != null && (gameState.owned[i] == this.player || gameState.commonThreat != null && gameState.commonThreat.p != gameState.owned[i])) continue;
            Vector ct = co.getTerritoriesContained();
            ArrayList<AttackTarget> at = new ArrayList<AttackTarget>();
            int territories = 0;
            int troops = 0;
            int enemyTerritories = 0;
            int enemyTroops = 0;
            seen.clear();
            for (int j = 0; j < ct.size(); ++j) {
                Country country = (Country)ct.get(j);
                if (country.getOwner() == this.player) {
                    ++territories;
                    troops += country.getArmies();
                } else {
                    AttackTarget t = targets.get(country);
                    if (t != null) {
                        at.add(t);
                    }
                    ++enemyTerritories;
                    int toAttack = 0;
                    toAttack = gameState.commonThreat == null || gameState.commonThreat.p != country.getOwner() ? (toAttack += country.getArmies()) : (toAttack += country.getArmies() / 2);
                    if (toAttack >= this.game.getMaxDefendDice() && (t == null || t.remaining <= 0)) {
                        toAttack = this.game.getMaxDefendDice() == 2 ? 3 * toAttack / 2 : (toAttack *= 2);
                    }
                    enemyTroops += toAttack;
                }
                if (country.getCrossContinentNeighbours().isEmpty()) continue;
                for (int k = 0; k < country.getCrossContinentNeighbours().size(); ++k) {
                    Country ccn = country.getCrossContinentNeighbours().get(k);
                    if (!seen.add(ccn)) continue;
                    if (ccn.getOwner() == this.player) {
                        if (country.getOwner() == this.player) continue;
                        troops += ccn.getArmies() - 1;
                        continue;
                    }
                    if (gameState.commonThreat != null) continue;
                    enemyTroops = (int)((double)enemyTroops + (double)ccn.getArmies() * 0.8);
                }
            }
            if (at.isEmpty() && filterNoAttacks) continue;
            int needed = enemyTroops + enemyTerritories + territories - troops + (attack ? this.game.getMaxDefendDice() * co.getBorderCountries().size() : 0);
            if (attack && this.game.isCapturedCountry() && (double)needed * 0.8 > (double)troops) continue;
            double ratio = Math.max(1.0, (double)territories + 2.0 * (double)troops + (double)(this.player.getExtraArmies() / (this.game.getSetupDone() ? 2 : 3))) / (double)(enemyTerritories + 2 * enemyTroops);
            int pow = 2;
            if (!this.game.getSetupDone()) {
                pow = 3;
            }
            if (ratio < 0.5) {
                if (gameState.commonThreat != null) continue;
                ratio /= Math.pow(Math.max(1, enemyTroops - enemyTerritories), pow);
            } else {
                ++targetContinents;
            }
            if (gameState.commonThreat == null) {
                ratio *= Math.pow(this.getContinentValue(co), 1.0 / (double)(gameState.me.owned.size() + 1));
            }
            if ((index = Collections.binarySearch(vals, key = Double.valueOf(-ratio))) < 0) {
                index = -index - 1;
            }
            vals.add(index, key);
            EliminationTarget et = new EliminationTarget();
            et.allOrNone = false;
            et.attackTargets = at;
            et.co = co;
            et.ps = gameState.orderedPlayers.get(0);
            result.add(index, et);
        }
        if (result.size() > targetContinents) {
            result = result.subList(0, targetContinents);
        }
        return result;
    }

    protected int findBestRoute(List<Country> attackable, GameState gameState, boolean attack, Continent targetCo, AttackTarget selection, Player targetPlayer, Map<Country, AttackTarget> targets) {
        int bestRoute = 0;
        HashSet<Country> bestPath = null;
        for (int i = 1; i < selection.routeRemaining.length; ++i) {
            if (selection.routeRemaining[i] == Integer.MIN_VALUE) continue;
            int diff = selection.routeRemaining[bestRoute] - selection.routeRemaining[i];
            Country start = attackable.get(i);
            if (selection.routeRemaining[bestRoute] == Integer.MIN_VALUE) {
                bestRoute = i;
                continue;
            }
            if (attack && selection.routeRemaining[i] >= 0 && diff != 0 && selection.routeRemaining[bestRoute] >= 0) {
                HashSet<Country> path = this.getPath(selection, targets, i, start);
                if (bestPath == null) {
                    bestPath = this.getPath(selection, targets, bestRoute, attackable.get(bestRoute));
                }
                HashSet<Country> path1 = new HashSet<Country>(path);
                Iterator<Country> iter = path1.iterator();
                while (iter.hasNext()) {
                    Country attacked = iter.next();
                    if (bestPath.contains(attacked) && attacked.getArmies() <= 4) continue;
                    iter.remove();
                }
                if (diff < 0 && !path1.isEmpty()) {
                    HashMap<Country, AttackTarget> specificTargets = new HashMap<Country, AttackTarget>();
                    this.searchTargets(specificTargets, start, start.getArmies(), 0, 1, this.player.getExtraArmies(), attack, Collections.EMPTY_SET, path1, gameState);
                    int forwardMin = this.getMinRemaining(specificTargets, start.getArmies(), false, gameState);
                    if (forwardMin <= -diff) continue;
                    bestRoute = i;
                    bestPath = path;
                    continue;
                }
                if (diff <= 0 || !path1.isEmpty() || start.getArmies() < 3) continue;
                bestRoute = i;
                bestPath = path;
                continue;
            }
            if (diff == 0 && attack) {
                int adjustedCost2;
                Country start1 = attackable.get(bestRoute);
                int adjustedCost1 = start1.getArmies() - selection.routeRemaining[bestRoute];
                if (adjustedCost1 < (adjustedCost2 = start.getArmies() - selection.routeRemaining[i])) continue;
                if (adjustedCost2 < adjustedCost1) {
                    bestRoute = i;
                    continue;
                }
            }
            if ((diff >= 0 || attack && selection.routeRemaining[bestRoute] >= 0) && (diff != 0 || (selection.attackPath[i] == null || selection.attackPath[i].getOwner() != targetPlayer) && (targetPlayer != null && selection.attackPath[bestRoute].getOwner() == targetPlayer || start.getContinent() != targetCo))) continue;
            bestRoute = i;
        }
        if (selection.routeRemaining[bestRoute] == Integer.MIN_VALUE) {
            return -1;
        }
        return bestRoute;
    }

    private HashSet<Country> getPath(AttackTarget at, Map<Country, AttackTarget> targets, int i, Country start) {
        HashSet<Country> path = new HashSet<Country>();
        Country toAttack = at.targetCountry;
        path.add(toAttack);
        while (!start.isNeighbours(toAttack)) {
            at = targets.get(at.attackPath[i]);
            toAttack = at.targetCountry;
            path.add(toAttack);
        }
        return path;
    }

    protected String getAttack(Map<Country, AttackTarget> targets, AttackTarget selection, int best, Country start) {
        Country toAttack = this.getCountryToAttack(targets, selection, best, start);
        return "attack " + start.getColor() + " " + toAttack.getColor();
    }

    private Country getCountryToAttack(Map<Country, AttackTarget> targets, AttackTarget selection, int best, Country start) {
        Country toAttack = selection.targetCountry;
        while (!start.isNeighbours(toAttack)) {
            selection = targets.get(selection.attackPath[best]);
            toAttack = selection.targetCountry;
        }
        return toAttack;
    }

    protected String fortify(GameState gs, List<Country> attackable, boolean minimal, List<Country> borders) {
        Country c;
        int i;
        int min = Math.max(this.game.getMaxDefendDice(), this.getMinPlacement());
        for (i = 0; i < borders.size(); ++i) {
            c = borders.get(i);
            if (c.getArmies() >= min) continue;
            return this.getPlaceCommand(c, min - c.getArmies());
        }
        if (minimal && (!this.game.getSetupDone() || this.isIncreasingSet() && this.player.getCards().size() > 1)) {
            return null;
        }
        for (i = 0; i < borders.size(); ++i) {
            c = borders.get(i);
            int diff = this.additionalTroopsNeeded(c, gs);
            if (diff > 0) {
                return this.getPlaceCommand(c, Math.min(this.player.getExtraArmies(), diff));
            }
            if (minimal || -diff >= c.getArmies() + 2) continue;
            return this.getPlaceCommand(c, Math.min(this.player.getExtraArmies(), c.getArmies() + 2 + diff));
        }
        return null;
    }

    protected int additionalTroopsNeeded(Country c, GameState gs) {
        int needed = 0;
        boolean minimal = !gs.capitals.contains(c);
        List<Country> v = c.getIncomingNeighbours();
        for (int j = 0; j < v.size(); ++j) {
            Country n = v.get(j);
            if (n.getOwner() == this.player) continue;
            if (minimal) {
                needed = Math.max(needed, n.getArmies());
                continue;
            }
            needed += n.getArmies() - 1;
        }
        if (!this.isIncreasingSet() && this.type != 1 && gs.commonThreat == null && gs.me.playerValue < gs.orderedPlayers.get((int)0).playerValue) {
            for (Country cont : c.getCrossContinentNeighbours()) {
                if (gs.me.owned.contains(c.getContinent()) || cont.getArmies() >= cont.getContinent().getArmyValue()) continue;
                if (gs.me.owned.contains(cont.getContinent()) && needed > 0) {
                    needed += cont.getContinent().getArmyValue();
                    break;
                }
                needed = Math.max(needed, cont.getContinent().getArmyValue() / 2);
                break;
            }
        }
        int diff = needed - c.getArmies();
        return diff;
    }

    protected int getMinPlacement() {
        return 1;
    }

    protected List<Country> getBorder(GameState gs) {
        ArrayList<Country> borders = new ArrayList<Country>();
        if (gs.me.owned.isEmpty()) {
            return borders;
        }
        HashSet<Country> front = new HashSet<Country>();
        HashSet<Country> visited = new HashSet<Country>();
        for (Continent myCont : gs.me.owned) {
            Vector v = myCont.getBorderCountries();
            for (int j = 0; j < v.size(); ++j) {
                Country country;
                Country border = (Country)v.get(j);
                if (!this.ownsNeighbours(border) || this.isAttackable(border)) {
                    borders.add(border);
                    continue;
                }
                if (border.getCrossContinentNeighbours().size() == 1 && (country = border.getCrossContinentNeighbours().get(0)).getOwner() != this.player) {
                    borders.add(country);
                    continue;
                }
                List<Country> n = border.getCrossContinentNeighbours();
                this.findFront(gs, front, myCont, visited, n);
            }
        }
        borders.addAll(front);
        return borders;
    }

    private boolean ownsNeighbours(Country c) {
        return this.ownsNeighbours(this.player, c);
    }

    private boolean isAttackable(Country c) {
        for (Country country : c.getIncomingNeighbours()) {
            if (country.getOwner() == this.player) continue;
            return true;
        }
        return false;
    }

    private void findFront(GameState gs, Set<Country> front, Continent myCont, Set<Country> visited, List<Country> n) {
        Stack<Country> c = new Stack<Country>();
        c.addAll(n);
        while (!c.isEmpty()) {
            Country b = (Country)c.pop();
            if (!visited.add(b) || b.getOwner() != this.player || b.getContinent() == myCont || gs.me.owned.contains(b.getContinent())) continue;
            if (this.isAttackable(b)) {
                front.add(b);
                continue;
            }
            c.addAll(b.getNeighbours());
        }
    }

    protected double getContinentValue(Continent co) {
        int players = 0;
        for (int i = 0; i < this.game.getPlayers().size(); ++i) {
            if (((Player)this.game.getPlayers().get(i)).getTerritoriesOwned().isEmpty()) continue;
            ++players;
        }
        int freeContinents = this.game.getContinents().length - players;
        double continentValue = co.getArmyValue() + co.getTerritoriesContained().size() / 3;
        int neighbors = 0;
        for (int i = 0; i < co.getBorderCountries().size(); ++i) {
            neighbors += ((Country)co.getBorderCountries().get(i)).getCrossContinentNeighbours().size();
        }
        continentValue /= Math.pow(2 * neighbors - co.getBorderCountries().size(), 2.0);
        if (freeContinents > co.getBorderCountries().size()) {
            continentValue *= (double)co.getBorderCountries().size();
        }
        return continentValue;
    }

    private String breakContinent(List<Country> attackable, Map<Country, AttackTarget> targets, GameState gameState, boolean attack, boolean press, List<Country> borders) {
        List<Continent> toBreak = this.getContinentsToBreak(gameState);
        if (!attack && this.type == 1) {
            return null;
        }
        for (int i = 0; i < toBreak.size(); ++i) {
            String result;
            Continent c = toBreak.get(i);
            Player tp = ((Country)c.getTerritoriesContained().get(0)).getOwner();
            PlayerState ps = null;
            for (int j = 0; j < gameState.orderedPlayers.size(); ++j) {
                ps = gameState.orderedPlayers.get(j);
                if (ps.p == tp) break;
            }
            if ((!press || !attack) && !gameState.targetPlayers.contains(tp) && (gameState.commonThreat != null || gameState.breakOnlyTargets || ps.attackOrder != 1 && ps.playerValue < gameState.me.playerValue)) continue;
            Vector t = c.getTerritoriesContained();
            int best = Integer.MAX_VALUE;
            AttackTarget selection = null;
            int bestRoute = 0;
            for (int j = 0; j < t.size(); ++j) {
                Country target = (Country)t.get(j);
                AttackTarget attackTarget = targets.get(target);
                if (attackTarget == null || attackTarget.remaining == Integer.MIN_VALUE || attackTarget.remaining + this.player.getExtraArmies() < 1 && (!this.game.getCards().isEmpty() || !press)) continue;
                int route = this.findBestRoute(attackable, gameState, attack, null, attackTarget, gameState.orderedPlayers.get((int)0).p, targets);
                Country attackFrom = attackable.get(route);
                if (gameState.commonThreat == null && !gameState.breakOnlyTargets && gameState.me.owned.isEmpty() && attackTarget.routeRemaining[route] + this.player.getExtraArmies() < 1) continue;
                int cost = attackFrom.getArmies() - attackTarget.routeRemaining[route];
                if (borders.contains(attackFrom)) {
                    cost += this.game.getMaxDefendDice();
                }
                if (cost >= best && (cost != best || !this.r.nextBoolean())) continue;
                best = cost;
                bestRoute = route;
                selection = attackTarget;
            }
            if (selection == null) continue;
            Country attackFrom = attackable.get(bestRoute);
            if (best > 3 * c.getArmyValue() + 2 * selection.targetCountry.getArmies() && this.game.getMaxDefendDice() == 2) {
                int value = 3 * c.getArmyValue();
                int collateral = 0;
                HashSet<Country> path = this.getPath(selection, targets, bestRoute, attackFrom);
                for (Country attacked : path) {
                    ++value;
                    if (attacked.getOwner() == selection.targetCountry.getOwner() || gameState.targetPlayers.contains(attacked.getOwner())) {
                        if (this.game.getMaxDefendDice() == 2 || attacked.getArmies() < 3) {
                            value += 3 * attacked.getArmies() / 2 + attacked.getArmies() % 2;
                            continue;
                        }
                        value += 2 * attacked.getArmies();
                        continue;
                    }
                    if (this.game.getMaxDefendDice() == 2 || attacked.getArmies() < 3) {
                        collateral += 3 * attacked.getArmies() / 2 + attacked.getArmies() % 2;
                        continue;
                    }
                    collateral += 2 * attacked.getArmies();
                }
                if (value < best && (!attack || this.r.nextInt(best - value) != 0) && (gameState.commonThreat == null || !gameState.breakOnlyTargets || value / ps.attackOrder < collateral)) continue;
            }
            if ((result = this.getMove(targets, attack, selection, bestRoute, attackFrom)) == null) continue;
            this.breaking = c;
            return result;
        }
        return null;
    }

    protected List<Continent> getContinentsToBreak(GameState gs) {
        ArrayList<Continent> result = new ArrayList<Continent>();
        ArrayList<Double> vals = new ArrayList<Double>();
        for (int i = 0; i < gs.owned.length; ++i) {
            if (gs.owned[i] == null || gs.owned[i] == this.player) continue;
            Continent co = this.game.getContinents()[i];
            Double val = -this.getContinentValue(co) * (double)this.game.getContinents()[i].getArmyValue();
            int index = Collections.binarySearch(vals, val);
            if (index < 0) {
                index = -index - 1;
            }
            vals.add(index, val);
            result.add(index, co);
        }
        return result;
    }

    protected String eliminate(List<Country> attackable, Map<Country, AttackTarget> targets, GameState gameState, boolean attack, int remaining, Set<Country> allCountriesTaken, EliminationTarget et, boolean shouldEndAttack, boolean lowProbability) {
        int i;
        AttackTarget selection = null;
        int bestRoute = 0;
        if (this.type == 1 || this.type == 4 && !et.allOrNone && this.r.nextInt(3) != 0 || !et.allOrNone && !et.target && shouldEndAttack && attack) {
            for (int i2 = 0; i2 < et.attackTargets.size(); ++i2) {
                AttackTarget at = et.attackTargets.get(i2);
                if (at.depth != 1 || allCountriesTaken.contains(at.targetCountry)) continue;
                int route = this.findBestRoute(attackable, gameState, attack, null, at, et.ps.p, targets);
                Country attackFrom = attackable.get(route);
                if ((at.routeRemaining[route] <= 0 || selection != null && at.routeRemaining[route] >= selection.routeRemaining[bestRoute] && selection.routeRemaining[bestRoute] >= 1) && (at.remaining <= 1 || attackFrom.getArmies() <= 3 || selection == null || at.remaining >= selection.remaining) || !this.isGoodIdea(gameState, targets, route, at, attackFrom, et, attack)) continue;
                selection = at;
                bestRoute = route;
            }
            return this.getMove(targets, attack, selection, bestRoute, attackable.get(bestRoute));
        }
        HashSet<Country> countriesTaken = new HashSet<Country>(allCountriesTaken);
        HashSet<Country> placements = new HashSet<Country>();
        int bestCost = Integer.MAX_VALUE;
        Collections.sort(et.attackTargets, Collections.reverseOrder());
        HashSet<Country> toTake = new HashSet<Country>();
        for (i = 0; i < et.attackTargets.size(); ++i) {
            AttackTarget at = et.attackTargets.get(i);
            if (allCountriesTaken.contains(at.targetCountry)) continue;
            toTake.add(at.targetCountry);
        }
        block2: for (i = 0; i < et.attackTargets.size() && !toTake.isEmpty(); ++i) {
            int pathRemaining;
            AttackTarget attackTarget = et.attackTargets.get(i);
            if (!toTake.contains(attackTarget.targetCountry)) continue;
            Country attackFrom = null;
            int route = 0;
            boolean clone = true;
            HashSet<Country> path = null;
            while (true) {
                if ((route = this.findBestRoute(attackable, gameState, attack, null, attackTarget, et.ps.p, targets)) == -1) {
                    if (!et.allOrNone) continue block2;
                    return null;
                }
                attackFrom = attackable.get(route);
                if (!placements.contains(attackFrom)) {
                    pathRemaining = attackTarget.routeRemaining[route];
                    if ((pathRemaining + remaining >= 1 || attackTarget.remaining + remaining >= 2 && attackFrom.getArmies() + remaining >= 4) && (et.allOrNone || this.isGoodIdea(gameState, targets, route, attackTarget, attackFrom, et, attack))) {
                        path = this.getPath(attackTarget, targets, route, attackFrom);
                        if (Collections.disjoint(path, countriesTaken)) {
                            if (pathRemaining + remaining < 3) break;
                            HashSet<Country> exclusions = new HashSet<Country>(countriesTaken);
                            exclusions.addAll(path);
                            HashMap<Country, AttackTarget> newTargets = new HashMap<Country, AttackTarget>();
                            this.searchTargets(newTargets, attackTarget.targetCountry, pathRemaining, 0, 1, remaining, lowProbability ? true : attack, toTake, exclusions, gameState);
                            AttackTarget newTarget = null;
                            for (AttackTarget next : newTargets.values()) {
                                if (!toTake.contains(next.targetCountry) || next.routeRemaining[0] >= pathRemaining || next.routeRemaining[0] + remaining < 1) continue;
                                pathRemaining = next.routeRemaining[0];
                                newTarget = next;
                            }
                            if (newTarget == null) break;
                            path.addAll(this.getPath(newTarget, newTargets, 0, attackTarget.targetCountry));
                            attackTarget.routeRemaining[route] = pathRemaining;
                            break;
                        }
                    } else if (et.allOrNone && et.attackTargets.size() == 1 && this.type == 2 && attackTarget.remaining + remaining > -attackTarget.targetCountry.getArmies() && gameState.me.playerValue < gameState.orderedPlayers.get((int)0).playerValue) {
                        path = this.getPath(attackTarget, targets, route, attackFrom);
                        break;
                    }
                }
                if (clone) {
                    attackTarget = attackTarget.clone();
                    attackTarget.routeRemaining = AIDomination.ArraysCopyOf(attackTarget.routeRemaining, attackTarget.routeRemaining.length);
                    clone = false;
                }
                attackTarget.routeRemaining[route] = Integer.MIN_VALUE;
            }
            for (Country c : path) {
                countriesTaken.add(c);
                toTake.remove(c);
            }
            if (pathRemaining < 1) {
                remaining += pathRemaining - 1;
            }
            int cost = attackFrom.getArmies() - pathRemaining;
            if (selection == null || attack && cost < bestCost && cost > 0) {
                selection = attackTarget;
                bestCost = cost;
                bestRoute = route;
            }
            placements.add(attackFrom);
        }
        Country attackFrom = attackable.get(bestRoute);
        String result = this.getMove(targets, attack, selection, bestRoute, attackFrom);
        if (result != null) {
            allCountriesTaken.addAll(countriesTaken);
        }
        return result;
    }

    public static int[] ArraysCopyOf(int[] original, int newLength) {
        int[] copy = new int[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    protected boolean isGoodIdea(GameState gameState, Map<Country, AttackTarget> targets, int route, AttackTarget attackTarget, Country attackFrom, EliminationTarget et, boolean attack) {
        Country c = this.getCountryToAttack(targets, attackTarget, route, attackFrom);
        if (!(gameState.orderedPlayers.size() <= 1 || et != null && et.ps != null && c.getOwner() == et.ps.p || gameState.targetPlayers.contains(c.getOwner()))) {
            if (gameState.commonThreat != null && c.getOwner() != gameState.commonThreat.p && c.getContinent().getOwner() != null) {
                return false;
            }
            if (this.player.getMission() == null && this.game.getCardMode() == 2 && c.getOwner().getCards().size() < 4) {
                return true;
            }
            if (gameState.commonThreat != null && c.getOwner().getCards().size() <= 2) {
                return true;
            }
            if (this.player.getMission() != null || (attack || this.isIncreasingSet()) && (c.getOwner().getCards().size() > 1 || c.getOwner().getCards().size() == 1 && this.game.getCards().isEmpty())) {
                for (int i = gameState.orderedPlayers.size() - 1; i >= 0; --i) {
                    PlayerState ps = gameState.orderedPlayers.get(i);
                    if (ps.playerValue >= gameState.me.playerValue) break;
                    if (ps.p != c.getOwner()) continue;
                    if (ps.attackOrder == 1 && c.getOwner().getCards().size() > 3) {
                        return true;
                    }
                    if (this.type == 2 && this.isIncreasingSet() && gameState.me.playerValue < gameState.orderedPlayers.get((int)0).playerValue && this.game.getNewCardState() > gameState.me.defenseValue) {
                        return true;
                    }
                    PlayerState top = gameState.orderedPlayers.get(0);
                    if (!((double)(ps.defenseValue - 5 * c.getArmies() / 4 - c.getArmies() % 4 - 1) < 2.0 * (top.attackValue - (double)(top.armies / 3)) / 3.0)) break;
                    return false;
                }
            }
        }
        return true;
    }

    private String getMove(Map<Country, AttackTarget> targets, boolean attack, AttackTarget selection, int route, Country attackFrom) {
        if (selection == null) {
            return null;
        }
        if (attack) {
            Country toAttack;
            if (attackFrom.getArmies() < 5 && selection.remaining < 1 && (toAttack = this.getCountryToAttack(targets, selection, route, attackFrom)).getArmies() >= attackFrom.getArmies()) {
                return null;
            }
            return this.getAttack(targets, selection, route, attackFrom);
        }
        if (selection.remaining < 1 || selection.routeRemaining[route] < 2) {
            return this.getPlaceCommand(attackFrom, -selection.routeRemaining[route] + 2);
        }
        return null;
    }

    private List<EliminationTarget> findEliminationTargets(Map<Country, AttackTarget> targets, GameState gameState, boolean attack, int remaining) {
        ArrayList<EliminationTarget> toEliminate = new ArrayList<EliminationTarget>();
        block0: for (int i = 0; i < gameState.orderedPlayers.size(); ++i) {
            PlayerState ps = gameState.orderedPlayers.get(i);
            Player player2 = ps.p;
            if (player2.getCards().isEmpty() && player2.getTerritoriesOwned().size() > 1 || (double)ps.defenseValue > gameState.me.attackValue + (double)this.player.getExtraArmies()) continue;
            boolean isTarget = gameState.targetPlayers.size() > 1 && gameState.targetPlayers.get(0) == player2;
            double divisor = 1.0;
            int cardCount = player2.getCards().size();
            if (!(this.isIncreasingSet() && this.game.getNewCardState() >= gameState.me.defenseValue / 8 || attack && player2.getTerritoriesOwned().size() <= 1 || this.game.getCards().isEmpty() || cardCount >= 3 || cardCount + this.player.getCards().size() >= this.game.getMaxCardsPerPlayer())) {
                divisor += 0.5 * (double)Math.max(0, this.isIncreasingSet() ? 2 : 4 - cardCount);
            }
            if (!isTarget && (double)ps.defenseValue > (double)gameState.me.armies / divisor + (double)this.player.getExtraArmies()) continue;
            Vector targetCountries = player2.getTerritoriesOwned();
            EliminationTarget et = new EliminationTarget();
            et.ps = ps;
            for (int j = 0; j < targetCountries.size(); ++j) {
                Country target = (Country)targetCountries.get(j);
                AttackTarget attackTarget = targets.get(target);
                if (attackTarget == null || attackTarget.remaining == Integer.MIN_VALUE || !attack && -attackTarget.remaining > remaining) continue block0;
                et.attackTargets.add(attackTarget);
            }
            et.target = isTarget;
            et.allOrNone = true;
            toEliminate.add(et);
        }
        return toEliminate;
    }

    private void searchTargets(Map<Country, AttackTarget> targets, Country startCountry, int startArmies, int start, int totalStartingPoints, int extra, boolean attack, GameState gs) {
        this.searchTargets(targets, startCountry, startArmies, start, totalStartingPoints, extra, attack, Collections.EMPTY_SET, Collections.EMPTY_SET, gs);
    }

    private void searchTargets(Map<Country, AttackTarget> targets, Country startCountry, int startArmies, final int start, int totalStartingPoints, int extra, boolean attack, final Set<Country> wayPoints, final Set<Country> exclusions, GameState gameState) {
        PriorityQueue<AttackTarget> remaining = new PriorityQueue<AttackTarget>(11, new Comparator<AttackTarget>(){

            @Override
            public int compare(AttackTarget o1, AttackTarget o2) {
                int diff = o2.routeRemaining[start] - o1.routeRemaining[start];
                if (AIDomination.this.type == 2) {
                    if (wayPoints.contains(o1.targetCountry)) {
                        if (wayPoints.contains(o2.targetCountry)) {
                            int outs1 = this.neighboursOpen(o1.targetCountry);
                            int outs2 = this.neighboursOpen(o2.targetCountry);
                            if (outs1 == 1) {
                                if (outs2 == 1) {
                                    return -diff;
                                }
                                return 1;
                            }
                            if (outs2 == 1) {
                                return -1;
                            }
                            return diff + 2 * (outs1 - outs2);
                        }
                        return -1;
                    }
                    if (wayPoints.contains(o2)) {
                        return 1;
                    }
                }
                return diff;
            }

            public int neighboursOpen(Country c) {
                Vector neighbours = c.getNeighbours();
                int count = 0;
                for (int i = 0; i < neighbours.size(); ++i) {
                    if (((Country)neighbours.get(i)).getOwner() == AIDomination.this.player || exclusions.contains(c)) continue;
                    ++count;
                }
                return count;
            }
        });
        if (this.type == 2) {
            double ratio = gameState.me.playerValue / gameState.orderedPlayers.get((int)0).playerValue;
            if (ratio < 0.4) {
                attack = false;
            }
        } else if (this.type == 1) {
            attack = false;
        }
        AttackTarget at = new AttackTarget(totalStartingPoints, startCountry);
        at.routeRemaining[start] = startArmies;
        remaining.add(at);
        while (!remaining.isEmpty()) {
            AttackTarget current = remaining.poll();
            if (wayPoints.contains(current)) {
                HashSet<Country> path = this.getPath(current, targets, start, startCountry);
                exclusions.addAll(path);
                startCountry = current.targetCountry;
                targets.keySet().retainAll(exclusions);
                remaining.clear();
                remaining.add(current);
                continue;
            }
            int attackForce = current.routeRemaining[start];
            attackForce -= this.getMinPlacement();
            if ((attackForce -= Math.min(current.targetCountry.getArmies() / (attack ? 3 : 2), current.depth)) + extra < 1) break;
            Vector v = current.targetCountry.getNeighbours();
            for (int i = 0; i < v.size(); ++i) {
                int rounds;
                int toAttack;
                Country c = (Country)v.get(i);
                if (c.getOwner() == this.player) continue;
                AttackTarget cumulativeForces = targets.get(c);
                if (cumulativeForces == null) {
                    if (exclusions.contains(c)) continue;
                    cumulativeForces = new AttackTarget(totalStartingPoints, c);
                    targets.put(c, cumulativeForces);
                } else if (cumulativeForces.routeRemaining[start] != Integer.MIN_VALUE) continue;
                cumulativeForces.depth = current.depth + 1;
                int available = attackForce;
                if (this.game.getMaxDefendDice() == 2 || gameState.me.playerValue > gameState.orderedPlayers.get((int)0).playerValue || gameState.me.p.getType() == 1) {
                    if (attack) {
                        for (toAttack = c.getArmies(); toAttack >= 10 || available >= 10 && toAttack >= 5; toAttack -= 4, available -= 3) {
                        }
                    }
                    while (toAttack >= 5 || available >= 5 && toAttack >= 2) {
                        toAttack -= 2;
                        available -= 2;
                    }
                } else if (attack && (rounds = (toAttack - 3) / 3) > 0) {
                    toAttack -= 3 * rounds;
                    available -= 3 * rounds;
                }
                available = attack && available == toAttack + 1 && toAttack <= 2 ? 1 : (this.game.getMaxDefendDice() == 2 || toAttack <= 2 ? available - 3 * toAttack / 2 - toAttack % 2 : (available -= 2 * toAttack));
                cumulativeForces.attackPath[start] = current.targetCountry;
                cumulativeForces.routeRemaining[start] = available;
                cumulativeForces.remaining = cumulativeForces.remaining >= 0 && available >= 0 ? (cumulativeForces.remaining += available) : Math.max(cumulativeForces.remaining, available);
                remaining.add(cumulativeForces);
            }
        }
    }

    @Override
    public String getBattleWon() {
        GameState gameState = this.getGameState(this.player, false);
        return this.getBattleWon(gameState);
    }

    protected String getBattleWon(GameState gameState) {
        if (this.ownsNeighbours(this.game.getDefender())) {
            return "move " + this.game.getMustMove();
        }
        int needed = -this.game.getAttacker().getArmies();
        List<Country> border = this.getBorder(gameState);
        boolean specialCase = false;
        if (!this.isIncreasingSet() && !this.eliminating && this.type != 1) {
            Continent cont = null;
            if (!border.contains(this.game.getDefender()) || !gameState.me.owned.contains(this.game.getDefender().getContinent())) {
                for (Country c : this.game.getAttacker().getCrossContinentNeighbours()) {
                    if (!gameState.me.owned.contains(c.getContinent())) continue;
                    cont = c.getContinent();
                    specialCase = true;
                    break;
                }
            }
            if (border.contains(this.game.getAttacker())) {
                specialCase = true;
                if (cont != null && this.game.getCardMode() == 1 && border.contains(this.game.getDefender()) && this.game.getDefender().getContinent() == this.game.getAttacker().getContinent()) {
                    cont = null;
                    specialCase = false;
                } else if (gameState.me.owned.contains(this.game.getAttacker().getContinent())) {
                    cont = this.game.getAttacker().getContinent();
                }
            }
            if (specialCase && this.game.getCardMode() != 1) {
                needed = this.additionalTroopsNeeded(this.game.getAttacker(), gameState);
            }
            if (cont != null) {
                if (cont.getBorderCountries().size() > 2) {
                    needed += cont.getArmyValue();
                } else {
                    if (specialCase && this.game.getCardMode() == 1) {
                        needed = this.additionalTroopsNeeded(this.game.getAttacker(), gameState);
                    }
                    needed += 4 * cont.getArmyValue() / Math.max(1, cont.getBorderCountries().size());
                }
            } else if (specialCase) {
                needed += this.game.getMaxDefendDice();
            }
        }
        if (specialCase && (this.breaking != null && this.breaking.getOwner() != null || gameState.commonThreat != null)) {
            needed /= 2;
        }
        if (!specialCase && this.ownsNeighbours(this.game.getAttacker())) {
            return "move " + Math.max(this.game.getMustMove(), this.game.getAttacker().getArmies() - this.getMinPlacement());
        }
        if (!specialCase && this.game.getMaxDefendDice() == 3 && !this.ownsNeighbours(this.game.getAttacker()) && gameState.me.playerValue > gameState.orderedPlayers.get((int)0).playerValue) {
            needed += this.game.getMaxDefendDice();
        }
        int forwardMin = 0;
        if (this.game.getAttacker().getArmies() - 1 > this.game.getMustMove()) {
            Country defender = this.game.getDefender();
            HashMap<Country, AttackTarget> targets = new HashMap<Country, AttackTarget>();
            this.searchTargets(targets, defender, this.game.getAttacker().getArmies() - 1, 0, 1, this.player.getExtraArmies(), true, gameState);
            forwardMin = this.getMinRemaining(targets, this.game.getAttacker().getArmies() - 1, border.contains(this.game.getAttacker()), gameState);
            if (forwardMin == Integer.MAX_VALUE) {
                return "move " + this.game.getMustMove();
            }
        }
        return "move " + Math.max(Math.min(-needed, this.game.getAttacker().getArmies() - Math.max(this.getMinPlacement(), forwardMin)), this.game.getMustMove());
    }

    private int getMinRemaining(HashMap<Country, AttackTarget> targets, int forwardMin, boolean isBorder, GameState gameState) {
        int total = 0;
        for (AttackTarget attackTarget : targets.values()) {
            if (attackTarget.remaining < 0 && !isBorder) {
                return 0;
            }
            ++total;
            if (this.game.getMaxDefendDice() == 2 || attackTarget.targetCountry.getArmies() < 3) {
                total += attackTarget.targetCountry.getArmies();
                if (attackTarget.targetCountry.getArmies() >= 2) continue;
                total += attackTarget.targetCountry.getArmies();
                continue;
            }
            total += 2 * attackTarget.targetCountry.getArmies();
        }
        if (this.game.getMaxDefendDice() == 2) {
            total = (int)((double)total * 1.3);
            forwardMin -= total;
        } else {
            forwardMin -= total;
        }
        if (this.type == 2 && !this.isIncreasingSet() && isBorder && this.isTooWeak(gameState)) {
            return Integer.MAX_VALUE;
        }
        return Math.max(isBorder ? this.game.getMaxDefendDice() : 0, forwardMin);
    }

    @Override
    public String getTacMove() {
        Vector t = this.player.getTerritoriesOwned();
        Country sender = null;
        Country receiver = null;
        int lowestScore = Integer.MAX_VALUE;
        GameState gs = this.getGameState(this.player, false);
        List<Country> v = this.getBorder(gs);
        ArrayList<Country> filtered = new ArrayList<Country>();
        ArrayList<Continent> targetContinents = null;
        for (int i = 0; i < t.size(); ++i) {
            Country c = (Country)t.get(i);
            if (c.getArmies() <= this.getMinPlacement() || gs.capitals.contains(c)) continue;
            if (c.getArmies() > 2 && gs.commonThreat != null && c.getCrossContinentNeighbours().size() > 0 && !this.ownsNeighbours(c)) {
                for (int j = 0; j < c.getNeighbours().size(); ++j) {
                    int index;
                    Country n = (Country)c.getNeighbours().get(j);
                    if (n.getOwner() != this.player || n.getContinent() == c.getContinent()) continue;
                    if (targetContinents == null) {
                        List<EliminationTarget> co = this.findTargetContinents(gs, Collections.EMPTY_MAP, false, false);
                        targetContinents = new ArrayList<Continent>();
                        for (int k = 0; k < co.size(); ++k) {
                            EliminationTarget et = co.get(k);
                            targetContinents.add(et.co);
                        }
                    }
                    if ((index = targetContinents.indexOf(c.getContinent())) == -1 && c.getContinent().getOwner() == this.player) break;
                    int indexOther = targetContinents.indexOf(n.getContinent());
                    if ((indexOther <= -1 || index != -1 && index <= indexOther) && (index != -1 && index <= 0 || n.getContinent().getOwner() != this.player)) continue;
                    int toSend = c.getArmies() - this.getMinPlacement();
                    return this.getMoveCommand(c, n, toSend);
                }
            }
            if (v.contains(c) && this.additionalTroopsNeeded(c, gs) / 2 + this.getMinPlacement() >= 0) continue;
            filtered.add(c);
            int score = this.scoreCountry(c);
            for (int j = 0; j < c.getNeighbours().size(); ++j) {
                int total;
                Country n = (Country)c.getNeighbours().get(j);
                if (n.getOwner() != this.player || !v.contains(n) || this.additionalTroopsNeeded(n, gs) < -1 || (total = -score + this.scoreCountry(n)) >= lowestScore) continue;
                sender = c;
                receiver = n;
                lowestScore = total;
            }
        }
        if (receiver != null) {
            int toSend = sender.getArmies() - this.getMinPlacement();
            if (v.contains(sender)) {
                toSend = -this.additionalTroopsNeeded(sender, gs) / 2 - this.getMinPlacement();
            }
            return this.getMoveCommand(sender, receiver, toSend);
        }
        Country max = null;
        for (int i = filtered.size() - 1; i >= 0; --i) {
            Country c = (Country)filtered.get(i);
            if (!this.ownsNeighbours(c)) {
                filtered.remove(i);
                continue;
            }
            if (max == null || c.getArmies() > max.getArmies()) {
                max = c;
            }
            int score = this.scoreCountry(c);
            for (int j = 0; j < c.getNeighbours().size(); ++j) {
                int total;
                Country n = (Country)c.getNeighbours().get(j);
                if (n.getOwner() != this.player || this.ownsNeighbours(n) || (total = -score + this.scoreCountry(n)) >= lowestScore) continue;
                sender = c;
                receiver = n;
                lowestScore = total;
            }
        }
        if (receiver != null) {
            int toSend = sender.getArmies() - this.getMinPlacement();
            if (v.contains(sender)) {
                toSend = -this.additionalTroopsNeeded(sender, gs) / 2 - this.getMinPlacement();
            }
            return this.getMoveCommand(sender, receiver, toSend);
        }
        if (max != null && max.getArmies() > this.getMinPlacement() + 1) {
            int least = Integer.MAX_VALUE;
            for (int j = 0; j < max.getNeighbours().size(); ++j) {
                Country n = (Country)max.getNeighbours().get(j);
                if (max.getOwner() != this.player || n.getArmies() >= least) continue;
                receiver = n;
                least = n.getArmies();
            }
            if (receiver != null) {
                return this.getMoveCommand(max, receiver, max.getArmies() - this.getMinPlacement() - 1);
            }
        }
        return "nomove";
    }

    private String getMoveCommand(Country sender, Country receiver, int toSend) {
        return "movearmies " + sender.getColor() + " " + receiver.getColor() + " " + toSend;
    }

    @Override
    public String getAttack() {
        this.eliminating = false;
        this.breaking = null;
        return this.plan(true);
    }

    @Override
    public String getRoll() {
        int n = this.game.getAttacker().getArmies() - 1;
        int m = this.game.getDefender().getArmies();
        if (n < 3 && this.game.getBattleRounds() > 0 && (n < m || n == m && this.game.getDefender().getOwner().getTerritoriesOwned().size() != 1)) {
            return "retreat";
        }
        if (this.type != 1 && (this.game.getBattleRounds() % 3 == 2 || this.game.getBattleRounds() > 0 && n - Math.min(m, this.game.getMaxDefendDice()) <= 0)) {
            String result = this.plan(true);
            if (result.equals("endattack")) {
                return "retreat";
            }
            StringTokenizer st = new StringTokenizer(result);
            st.nextToken();
            if (this.game.getAttacker().getColor() != Integer.parseInt(st.nextToken()) || this.game.getDefender().getColor() != Integer.parseInt(st.nextToken())) {
                return "retreat";
            }
        }
        return "roll " + Math.min(3, n);
    }

    public GameState getGameState(Player p, boolean excludeCards) {
        Vector players = this.game.getPlayers();
        GameState g = new GameState();
        Continent[] c = this.game.getContinents();
        g.capitals = this.player.getCapital() == null ? Collections.EMPTY_SET : new HashSet<Country>();
        g.owned = new Player[c.length];
        for (int i = 0; i < c.length; ++i) {
            g.owned[i] = c[i].getOwner();
        }
        int index = -1;
        int playerCount = 1;
        for (int i = 0; i < players.size(); ++i) {
            Player player2 = (Player)players.get(i);
            if (player2.getCapital() != null) {
                g.capitals.add(player2.getCapital());
            }
            if (player2.getTerritoriesOwned().isEmpty()) continue;
            if (player2 == p) {
                index = i;
                continue;
            }
            ++playerCount;
        }
        g.orderedPlayers = new ArrayList<PlayerState>(playerCount);
        int attackOrder = 0;
        int strategicCount = 0;
        for (int i = 0; i < players.size(); ++i) {
            Player player2 = (Player)players.get((index + i) % players.size());
            if (player2.getTerritoriesOwned().isEmpty()) continue;
            int cards = player2.getCards().size() + 1;
            int cardEstimate = i == 0 && excludeCards ? 0 : this.getCardEstimate(cards);
            PlayerState ps = new PlayerState();
            Vector t = player2.getTerritoriesOwned();
            int noArmies = 0;
            int attackable = 0;
            boolean strategic = this.isStrategic(player2);
            if (strategic) {
                ++strategicCount;
            }
            for (int j = 0; j < t.size(); ++j) {
                Country country = (Country)t.get(j);
                noArmies += country.getArmies();
                int available = country.getArmies() - 1;
                if (this.ownsNeighbours(player2, country)) {
                    available = country.getArmies() / 2;
                }
                if (available > 4) {
                    if (available > 8 && strategic) {
                        if (available > 13) {
                            available = (int)((double)available * 1.3);
                        }
                        available += 2;
                    }
                    ++available;
                }
                attackable += available;
            }
            int reenforcements = Math.max(3, player2.getNoTerritoriesOwned() / 3) + cardEstimate;
            if (reenforcements > 8 && strategic) {
                reenforcements = (int)((double)reenforcements * 1.3);
            }
            int attack = attackable + reenforcements;
            HashSet<Continent> owned = new HashSet<Continent>();
            for (int j = 0; j < g.owned.length; ++j) {
                if (g.owned[j] != player2) continue;
                attack += c[j].getArmyValue();
                ps.playerValue = strategic ? (ps.playerValue += (double)(3 * c[j].getArmyValue())) : (ps.playerValue += 1.5 * (double)c[j].getArmyValue() + 1.0);
                owned.add(c[j]);
            }
            ps.strategic = strategic;
            ps.armies = noArmies;
            ps.owned = owned;
            ps.attackValue = attack;
            ps.attackOrder = attackOrder;
            ps.defenseValue = 5 * noArmies / 4 + noArmies % 4 + player2.getNoTerritoriesOwned();
            ps.p = player2;
            if (i == 0) {
                g.me = ps;
            } else {
                g.orderedPlayers.add(ps);
            }
            ps.playerValue = ps.playerValue + (ps.attackValue + (double)((this.game.getMaxDefendDice() == 2 && !this.isIncreasingSet() ? 1 : (this.game.getMaxDefendDice() > 2 ? 3 : 2)) * ps.defenseValue));
            ++attackOrder;
        }
        Collections.sort(g.orderedPlayers, Collections.reverseOrder());
        if (this.game.getSetupDone() && !g.orderedPlayers.isEmpty()) {
            double multiplier = this.game.getCards().isEmpty() ? (this.game.isRecycleCards() ? 1.2 : 1.1) : (this.player.getMission() != null || this.player.getCapital() != null ? 1.1 : 1.3);
            PlayerState topPlayer = g.orderedPlayers.get(0);
            if (this.type == 1) {
                multiplier *= 1.6;
            } else if (this.type == 2 && this.player.getStatistics().size() > 3) {
                if (!this.isIncreasingSet()) {
                    multiplier = Math.max(1.0, multiplier - 0.4 + (double)g.orderedPlayers.size() * 0.1);
                } else if (this.game.getCardMode() != 2) {
                    multiplier *= 1.5;
                }
            } else if (this.type == 4) {
                multiplier *= 1.2;
            }
            g.targetPlayers.add(topPlayer.p);
            if (g.orderedPlayers.size() > 1 && topPlayer.playerValue > multiplier * g.me.playerValue) {
                g.breakOnlyTargets = this.game.getMaxDefendDice() == 2;
                PlayerState ps = g.orderedPlayers.get(1);
                if (topPlayer.playerValue > multiplier * ps.playerValue) {
                    g.commonThreat = topPlayer;
                } else {
                    g.targetPlayers.add(ps.p);
                }
            } else if (this.type == 2 && this.isIncreasingSet() && (double)g.orderedPlayers.get((int)(g.orderedPlayers.size() - 1)).defenseValue / topPlayer.attackValue > 0.3) {
                g.targetPlayers.clear();
                g.targetPlayers.add(g.orderedPlayers.get((int)(g.orderedPlayers.size() - 1)).p);
            }
        }
        return g;
    }

    private int getCardEstimate(int cards) {
        int tradeIn = this.game.getCardMode() != 0 ? 8 : this.game.getNewCardState();
        int cardEstimate = cards < 3 ? 0 : (int)((double)(cards - 2) / 3.0 * (double)tradeIn);
        return cardEstimate;
    }

    private boolean isStrategic(Player player2) {
        if (player2 == this.player) {
            return false;
        }
        List<Statistic> stats = player2.getStatistics();
        if (stats.size() < 4) {
            return false;
        }
        int end = 4;
        int reenforcements = 0;
        int kills = 0;
        int casualities = 0;
        for (int i = stats.size() - 1; i >= end; --i) {
            Statistic s = stats.get(i);
            reenforcements = (int)((double)reenforcements + s.get(StatType.REINFORCEMENTS));
            kills = (int)((double)kills + s.get(StatType.KILLS));
            casualities = (int)((double)casualities + s.get(StatType.CASUALTIES));
            if (s.get(StatType.CONTINENTS) != 0.0) continue;
            return false;
        }
        return reenforcements + kills / (player2.getCards().size() > 2 ? 1 : 2) > 2 * casualities;
    }

    @Override
    public String getTrade() {
        if (!this.game.getTradeCap() && this.type != 1) {
            if (this.player.getCards().size() >= this.game.getMaxCardsPerPlayer()) {
                return super.getTrade();
            }
            GameState gs = this.getGameState(this.player, true);
            if (gs.commonThreat == null && gs.orderedPlayers.size() > 1 && !this.pressAttack(gs) && !this.isTooWeak(gs)) {
                return "endtrade";
            }
        }
        return super.getTrade();
    }

    public List<Country> findAttackableTerritories(Player p, boolean attack) {
        Vector countries = p.getTerritoriesOwned();
        ArrayList<Country> result = new ArrayList<Country>();
        for (int i = 0; i < countries.size(); ++i) {
            Country country = (Country)countries.get(i);
            if (attack && country.getArmies() <= 1 || this.ownsNeighbours(p, country)) continue;
            result.add(country);
        }
        return result;
    }

    public boolean ownsNeighbours(Player p, Country c) {
        Vector neighbours = c.getNeighbours();
        for (int i = 0; i < neighbours.size(); ++i) {
            if (((Country)neighbours.get(i)).getOwner() == p) continue;
            return false;
        }
        return true;
    }

    @Override
    protected String getTrade(Card[] result) {
        if (this.type != 1) {
            boolean[] owns = new boolean[result.length];
            int ownsCount = 0;
            for (int i = 0; i < result.length; ++i) {
                if (result[i].getCountry() == null || !this.player.getTerritoriesOwned().contains(result[i].getCountry())) continue;
                owns[i] = true;
                ++ownsCount;
            }
            if (ownsCount != 1 && this.player.getCards().size() > 3) {
                List<Card> toTrade = Arrays.asList(result);
                block1: for (Card card : this.player.getCards()) {
                    int i;
                    if (toTrade.contains(card)) continue;
                    if (ownsCount > 1) {
                        if (card.getCountry() != null && this.player.getTerritoriesOwned().contains(card.getCountry())) continue;
                        for (i = 0; i < result.length; ++i) {
                            if (!result[i].getName().equals(card.getName())) continue;
                            result[i] = card;
                            if (--ownsCount != 1) continue block1;
                            return super.getTrade(result);
                        }
                        continue;
                    }
                    if (card.getCountry() == null || !this.player.getTerritoriesOwned().contains(card.getCountry())) continue;
                    for (i = 0; i < result.length; ++i) {
                        if (!result[i].getName().equals(card.getName())) continue;
                        result[i] = card;
                        return super.getTrade(result);
                    }
                }
            }
        }
        return super.getTrade(result);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EliminationTarget
    implements Comparable<EliminationTarget> {
        List<AttackTarget> attackTargets = new ArrayList<AttackTarget>();
        PlayerState ps;
        boolean target;
        boolean allOrNone;
        Continent co;

        EliminationTarget() {
        }

        @Override
        public int compareTo(EliminationTarget other) {
            if (this.target) {
                return -1;
            }
            if (other.target) {
                return 1;
            }
            int diff = other.ps.p.getCards().size() - this.ps.p.getCards().size();
            if (diff != 0) {
                return diff;
            }
            return this.ps.defenseValue - other.ps.defenseValue;
        }

        public String toString() {
            return "Eliminate " + (this.co != null ? this.co : this.ps.p);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AttackTarget
    implements Comparable<AttackTarget>,
    Cloneable {
        int remaining = Integer.MIN_VALUE;
        int[] routeRemaining;
        int[] eliminationScore;
        Country[] attackPath;
        Country targetCountry;
        int depth;

        public AttackTarget(int fromCountries, Country targetCountry) {
            this.routeRemaining = new int[fromCountries];
            Arrays.fill(this.routeRemaining, Integer.MIN_VALUE);
            this.attackPath = new Country[fromCountries];
            this.targetCountry = targetCountry;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.targetCountry).append(" ").append(this.remaining).append(":(");
            for (int i = 0; i < this.attackPath.length; ++i) {
                if (this.attackPath[i] == null) continue;
                sb.append(this.attackPath[i]).append(" ").append(this.routeRemaining[i]).append(" ");
            }
            sb.append(")");
            return sb.toString();
        }

        @Override
        public int compareTo(AttackTarget obj) {
            int diff = this.remaining - obj.remaining;
            if (diff != 0) {
                return diff;
            }
            return this.targetCountry.getColor() - obj.targetCountry.getColor();
        }

        public AttackTarget clone() {
            try {
                return (AttackTarget)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class GameState {
        PlayerState me;
        Player[] owned;
        List<PlayerState> orderedPlayers;
        List<Player> targetPlayers = new ArrayList<Player>(3);
        Set<Country> capitals;
        PlayerState commonThreat;
        boolean breakOnlyTargets;

        GameState() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PlayerState
    implements Comparable<PlayerState> {
        Player p;
        double attackValue;
        int defenseValue;
        int attackOrder;
        double playerValue;
        Set<Continent> owned;
        int armies;
        boolean strategic;

        PlayerState() {
        }

        @Override
        public int compareTo(PlayerState ps) {
            if (this.playerValue != ps.playerValue) {
                return (int)Math.signum(this.playerValue - ps.playerValue);
            }
            return this.p.getCards().size() - ps.p.getCards().size();
        }

        public String toString() {
            return this.p.toString();
        }
    }
}

