/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine.p2pserver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.util.LinkedList;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.engine.p2pserver.ChatArea;
import net.yura.domination.engine.p2pserver.ChatReader;

public class ChatServerThread
extends Thread {
    LinkedList m_lList = new LinkedList();
    private Socket socket = null;
    int myIndex;
    ChatReader myReaderThread;
    ChatArea myChatArea;

    public ChatServerThread(Socket socket, ChatArea cArea, int me) {
        super("ChatServerThread");
        this.socket = socket;
        this.myChatArea = cArea;
        this.myIndex = me;
    }

    public void run() {
        String id = null;
        try {
            PrintWriter outChat = new PrintWriter((Writer)new OutputStreamWriter(this.socket.getOutputStream(), RiskUtil.UTF_8), true);
            BufferedReader inChat = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), RiskUtil.UTF_8));
            String hello = inChat.readLine();
            int index = hello.indexOf(32);
            if (index < 0) {
                throw new IllegalStateException("malformed hello command: " + hello);
            }
            String version = hello.substring(0, index);
            if (!"14".equals(version)) {
                outChat.println("ERROR version missmatch, server: 14, and client: " + version);
            } else {
                String outputLine;
                hello = hello.substring(index + 1);
                index = hello.indexOf(32);
                id = hello.substring(0, index);
                String map = hello.substring(index + 1);
                if (!RiskGame.getDefaultMap().equals(map)) {
                    outChat.println("server choosemap " + RiskGame.getDefaultMap());
                }
                this.myReaderThread = new ChatReader(inChat, this.myChatArea, this.myIndex);
                this.myReaderThread.start();
                do {
                    if ((outputLine = this.myChatArea.waitForString(this.myIndex)) == null) continue;
                    outChat.println(outputLine);
                } while (outputLine != null);
            }
            this.socket.shutdownInput();
            this.socket.shutdownOutput();
            this.socket.close();
            inChat.close();
            outChat.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.myChatArea.putString(this.myIndex, "LEAVE " + id);
    }
}

