/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.lobby.mini;

import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import net.yura.domination.LoadingManager;
import net.yura.domination.audio.GameSound;
import net.yura.domination.engine.OnlineRisk;
import net.yura.domination.engine.OnlineUtil;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.core.Player;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.lobby.mini.MapPreviewClient;
import net.yura.domination.mapstore.GetMap;
import net.yura.domination.mapstore.MapPreview;
import net.yura.domination.mapstore.MapUpdateService;
import net.yura.lobby.mini.MiniLobbyClient;
import net.yura.lobby.mini.MiniLobbyGame;
import net.yura.lobby.model.Game;
import net.yura.lobby.model.GameType;
import net.yura.mobile.gui.Application;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.util.Properties;
import net.yura.swingme.core.CoreUtil;

public abstract class MiniLobbyRisk
implements MiniLobbyGame,
OnlineRisk {
    private static final Logger logger = Logger.getLogger(MiniLobbyRisk.class.getName());
    private Risk myrisk;
    protected MiniLobbyClient lobby;
    private boolean openGame;
    WeakHashMap mapping = new WeakHashMap();
    MapPreviewClient mapPreviewClient = new MapPreviewClient(){

        public void publishMap(net.yura.domination.mapstore.Map map) {
            MiniLobbyRisk.this.mapMetaData(map);
        }

        public void publishImg(String mapUID) {
            MiniLobbyRisk.this.lobby.getRoot().repaint();
        }
    };

    public MiniLobbyRisk(Risk risk) {
        this.myrisk = risk;
        GameSound.INSTANCE.setLobbyOpen(true);
    }

    public void addLobbyGameMoveListener(MiniLobbyClient lgl) {
        this.lobby = lgl;
    }

    public Properties getProperties() {
        return CoreUtil.wrap(TranslationBundle.getBundle());
    }

    public void openChat() {
        Application.openURL("http://domination.sourceforge.net/chat.shtml");
    }

    public boolean isMyGameType(GameType gametype) {
        return RiskUtil.GAME_NAME.equals(gametype.getName());
    }

    public void prepareAndOpenGame(final Game game) {
        LoadingManager.showLoadingScreen(true);
        final String mapUID = OnlineUtil.getMapNameFromLobbyStartGameOption(game.getOptions());
        if (MapPreview.haveLocalMap(mapUID) && !MapUpdateService.getInstance().contains(mapUID)) {
            this.lobby.mycom.playGame(game.getId());
        } else {
            GetMap.getMap(mapUID, new Observer(){

                public void update(Observable observable, Object data) {
                    if (data == RiskUtil.SUCCESS) {
                        MiniLobbyRisk.this.lobby.mycom.playGame(game.getId());
                    } else {
                        LoadingManager.showLoadingScreen(false);
                        MiniLobbyRisk.this.lobby.error("map download failed for: " + mapUID);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void objectForGame(Object object) {
        try {
            if (object instanceof RiskGame) {
                RiskGame thegame = (RiskGame)object;
                Player player = thegame.getPlayer(this.lobby.whoAmI());
                String address = player == null ? "_watch_" : player.getAddress();
                this.myrisk.setOnlinePlay(this);
                this.myrisk.setAddress(address);
                this.myrisk.setGame(thegame);
                this.openGame = true;
            } else if (object instanceof Map) {
                Map map = (Map)object;
                String command = (String)map.get("command");
                if ("game".equals(command)) {
                    String address = (String)map.get("playerId");
                    RiskGame thegame = (RiskGame)map.get("game");
                    this.myrisk.setOnlinePlay(this);
                    this.myrisk.setAddress(address);
                    this.myrisk.setGame(thegame);
                    this.openGame = true;
                } else {
                    System.out.println("MiniLobbyRisk unknown command " + command + " " + map);
                }
            } else {
                System.out.println("MiniLobbyRisk unknown object " + object);
            }
        }
        finally {
            LoadingManager.showLoadingScreen(false);
        }
    }

    public void stringForGame(String message) {
        if (this.openGame) {
            this.myrisk.parserFromNetwork(message);
        } else {
            logger.info("GAME NOT OPEN SO IGNORING: " + message);
        }
    }

    public void disconnected() {
        LoadingManager.showLoadingScreen(false);
        this.myrisk.disconnected();
    }

    public void connected(String username) {
        GameSound.INSTANCE.playSound("lobby_set_nick");
    }

    public void loginGoogle() {
    }

    public void gameStarted(int id) {
    }

    public void gameActionPerformed(int action) {
        String sound = null;
        switch (action) {
            case 1: {
                sound = "lobby_join";
                break;
            }
            case 2: {
                sound = "lobby_leave";
                break;
            }
            case 3: {
                sound = "lobby_watch";
                break;
            }
            case 4: {
                sound = "lobby_play";
            }
        }
        if (sound != null) {
            GameSound.INSTANCE.playSound(sound);
        }
    }

    protected void mapMetaData(net.yura.domination.mapstore.Map map) {
    }

    public Icon getIconForGame(Game game) {
        String mapUID = OnlineUtil.getMapNameFromLobbyStartGameOption(game.getOptions());
        this.mapping.put(game, mapUID);
        return this.mapPreviewClient.getIconForMap(mapUID);
    }

    public void lobbyShutdown() {
        this.mapPreviewClient.shutdown();
        GameSound.INSTANCE.setLobbyOpen(false);
    }

    public String getGameDescription(Game game) {
        return OnlineUtil.getGameDescriptionFromLobbyStartGameOption(game.getOptions());
    }

    public void sendUserCommand(String messagefromgui) {
        this.lobby.sendGameMessage(messagefromgui);
    }

    public void sendGameCommand(String gameCommand) {
        logger.info("ignore GameCommand " + gameCommand);
    }

    public void closeGame() {
        this.openGame = false;
        this.lobby.closeGame();
    }

    public void playerRenamed(String oldName, String newName, String newAddress, int newType) {
        if (oldName.equals(this.lobby.whoAmI())) {
            this.myrisk.setAddress("_watch_");
        }
        if (newName.equals(this.lobby.whoAmI())) {
            this.myrisk.setAddress(newAddress);
        }
    }
}

