/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.mobile;

import android.graphics.ColorMatrix;
import collisionphysics.BallWorld;
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import net.yura.domination.engine.ColorUtil;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.core.Card;
import net.yura.domination.engine.core.Country;
import net.yura.domination.engine.core.Player;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.guishared.MapPanel;
import net.yura.domination.mapstore.MapPreview;
import net.yura.domination.mobile.MouseListener;
import net.yura.domination.mobile.flashgui.DominationMain;
import net.yura.mobile.gui.Application;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.Font;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.KeyEvent;
import net.yura.mobile.gui.border.Border;
import net.yura.mobile.gui.components.ImageView;
import net.yura.mobile.logging.Logger;

public class PicturePanel
extends ImageView
implements MapPanel {
    public static final int NO_COUNTRY = 255;
    public static final int PP_X = 677;
    public static final int PP_Y = 425;
    public static final int VIEW_CONTINENTS = 0;
    public static final int VIEW_OWNERSHIP = 1;
    public static final int VIEW_BORDER_THREAT = 2;
    public static final int VIEW_CARD_OWNERSHIP = 3;
    public static final int VIEW_TROOP_STRENGTH = 4;
    public static final int VIEW_CONNECTED_EMPIRE = 5;
    private Risk myrisk;
    private int c1;
    private int c2;
    private int cc;
    private Image img;
    private Image tempimg;
    private byte[][] map;
    private CountryImage[] countryImages;
    private static final ColorMatrix HighLight;
    public static final ColorMatrix gray;
    MouseListener ml;
    int x = -1000;
    int y = -1000;
    public int BALL_SIZE = 20;
    static Map<Integer, Image> icons;
    static int fontBallSize;
    static Font font;
    BallWorld ballWorld;
    int oldState;
    public static final int GRAY;
    public static final int DARK_GRAY;
    public static final int LIGHT_GRAY;
    public static final int BLUE;
    public static final int YELLOW;

    public PicturePanel(Risk r) {
        this.getDesktopPane().IPHONE_SCROLL = true;
        this.myrisk = r;
        this.img = null;
        this.map = null;
        this.setName("PicturePanel");
    }

    public void processMouseEvent(int type, int x, int y, KeyEvent keys) {
        if (type == 1) {
            this.x = x;
            this.y = y;
        } else {
            DesktopPane dp = DesktopPane.getDesktopPane();
            if (DesktopPane.isAccurate(this.x, x, dp.inaccuracy) && DesktopPane.isAccurate(this.y, y, dp.inaccuracy)) {
                if (type == 2) {
                    if (this.ml != null) {
                        this.ml.click(x, y, keys.isDownKey(-51));
                    }
                    if (this.myrisk.getGame().getState() == 8) {
                        if (this.ballWorld == null) {
                            this.startAni();
                        } else {
                            this.stopAni();
                        }
                    }
                }
            } else {
                this.x = -1000;
                this.y = -1000;
            }
        }
    }

    public void addMouseListener(MouseListener ml) {
        this.ml = ml;
    }

    public void load() throws IOException {
        RiskGame game = this.myrisk.getGame();
        this.countryImages = null;
        if (game.getImageMap() == null) {
            throw new IllegalStateException("ImageMap can not be null");
        }
        if (game.getImagePic() == null) {
            throw new IllegalStateException("ImagePic can not be null");
        }
        this.memoryLoad(MapPreview.createImage(RiskUtil.openMapStream(game.getImageMap())), MapPreview.createImage(RiskUtil.openMapStream(game.getImagePic())));
    }

    public int getMapWidth() {
        return this.map.length;
    }

    public int getMapHeight() {
        return this.map[0].length;
    }

    public void memoryLoad(Image m, Image original) {
        CountryImage cci;
        byte[][] newMap;
        Image newTempimg;
        Image newImg;
        this.cc = 255;
        this.c1 = 255;
        this.c2 = 255;
        this.imgW = original.getWidth();
        this.imgH = original.getHeight();
        int mW = m.getWidth();
        int mH = m.getHeight();
        RiskGame game = this.myrisk.getGame();
        int noc = game.getCountries().length;
        this.BALL_SIZE = game.getCircleSize();
        if (this.map == null || this.map.length != mW || this.map[0].length != mH) {
            this.setPreferredSize(mW, mH);
            this.img = null;
            this.tempimg = null;
            this.map = null;
            newImg = Image.createImage(mW, mH);
            newTempimg = Image.createImage(mW, mH);
            newMap = new byte[mW][mH];
        } else {
            newImg = this.img;
            newTempimg = this.tempimg;
            newMap = this.map;
            this.img = null;
            this.tempimg = null;
            this.map = null;
        }
        Graphics zg = newImg.getGraphics();
        zg.drawImage(original, 0, 0, 0);
        CountryImage[] newCountryImages = new CountryImage[noc];
        for (int c = 0; c < noc; ++c) {
            newCountryImages[c] = new CountryImage();
        }
        int[] pixels = new int[m.getWidth()];
        for (int y = 0; y < m.getHeight(); ++y) {
            try {
                m.getRGB(pixels, 0, m.getWidth(), 0, y, m.getWidth(), 1);
            }
            catch (Exception ex) {
                throw new RuntimeException("can not getRGB from " + m + " offset=0 scanlength=" + m.getWidth() + " x=0 y=" + y + " width=" + m.getWidth() + " height=1", ex);
            }
            for (int x = 0; x < m.getWidth(); ++x) {
                int num = pixels[x] & 0xFF;
                if (num == 0) {
                    num = 255;
                }
                newMap[x][y] = (byte)(num - 128);
                if (num == 255) continue;
                if (num > noc) {
                    throw new CountryNotFoundException("Strange color found: " + num + " (" + Integer.toHexString(pixels[x]) + ") countries: " + noc + " at: " + x + "," + y);
                }
                cci = newCountryImages[num - 1];
                if (x < cci.getX1()) {
                    cci.setX1(x);
                }
                if (x > cci.getX2()) {
                    cci.setX2(x);
                }
                if (y < cci.getY1()) {
                    cci.setY1(y);
                }
                if (y <= cci.getY2()) continue;
                cci.setY2(y);
            }
        }
        pixels = null;
        m = null;
        for (int c = 0; c < newCountryImages.length; ++c) {
            cci = newCountryImages[c];
            int color = c + 1;
            try {
                int x1 = cci.getX1();
                int y1 = cci.getY1();
                int y2 = cci.getY2();
                int w = cci.getWidth();
                int h = cci.getHeight();
                Image cimg = Image.createImage(w, h);
                Graphics g = cimg.getGraphics();
                g.drawRegion(original, x1, y1, w, h, 0, 0, 0, 0);
                cci.setSourceImage(cimg);
                for (int y = y1; y <= y2; ++y) {
                    for (int x = 0; x < w; ++x) {
                        if (newMap[x + x1][y] + 128 == color) continue;
                        cimg.setRGB(x, y - y1, 0);
                    }
                }
                continue;
            }
            catch (RuntimeException ex) {
                if (cci.getWidth() < 0 || cci.getHeight() < 0) {
                    throw new CountryNotFoundException("index=" + c + " color=" + color + " " + cci);
                }
                throw new RuntimeException("Error creating CountryImages: index=" + c + " color=" + color + " " + cci, ex);
            }
        }
        this.countryImages = newCountryImages;
        this.img = newImg;
        this.tempimg = newTempimg;
        this.map = newMap;
        for (Country country : game.getCountries()) {
            if (country.getX() <= this.img.getWidth() && country.getY() <= this.img.getHeight()) continue;
            Logger.warn("country outside map " + country);
        }
    }

    protected void paintBorder(Graphics2D g) {
        Border b = this.getBorder();
        if (b != null) {
            double s = this.getScale();
            int x = this.getImgX(s);
            int y = this.getImgY(s);
            int w = (int)((double)this.imgW * s);
            int h = (int)((double)this.imgH * s);
            g.translate(x, y);
            b.paintBorder(this, g, w, h);
            g.translate(-x, -y);
        }
    }

    public void paintComponent(Graphics2D g) {
        super.paintComponent(g);
        try {
            if (this.img != null) {
                RiskGame game;
                int state;
                Graphics g2 = g.getGraphics();
                double s = this.getScale();
                int x = this.getImgX(s);
                int y = this.getImgY(s);
                g.translate(x, y);
                g2.scale(s, s);
                g.drawImage(this.img, 0, 0);
                int c1 = this.c1;
                int c2 = this.c2;
                int cc = this.cc;
                if (c1 != 255) {
                    this.drawHighLightImage(g, c1);
                }
                if (c2 != 255) {
                    this.drawHighLightImage(g, c2);
                }
                if (cc != 255) {
                    this.drawHighLightImage(g, cc);
                }
                if ((state = (game = this.myrisk.getGame()).getState()) == 1 && this.myrisk.showHumanCurrentPlayerInfo()) {
                    Player me = this.myrisk.getGame().getCurrentPlayer();
                    ArrayList cards = new ArrayList(me.getCards());
                    for (Card card : cards) {
                        Country country = card.getCountry();
                        if (country == null || country.getOwner() != me) continue;
                        this.drawHighLightImage(g, country.getColor());
                    }
                }
                if (state == 4 || state == 5 || state == 10) {
                    Country attacker = game.getAttacker();
                    Country defender = game.getDefender();
                    if (attacker != null && defender != null) {
                        this.drawHighLightImage(g, attacker.getColor());
                        this.drawHighLightImage(g, defender.getColor());
                    }
                }
                g2.scale(1.0 / s, 1.0 / s);
                this.drawArmies(g, s);
                g.translate(-x, -y);
            }
        }
        catch (Exception e) {
            RiskUtil.printStackTrace(e);
        }
    }

    public void drawArmies(Graphics2D g2, double scale) {
        RiskGame game = this.myrisk.getGame();
        int state = game.getState();
        int ballSize = (int)((double)this.BALL_SIZE * scale);
        Country[] v = game.getCountries();
        if (state == 4 || state == 5 || state == 10) {
            DirectGraphics g = DirectUtils.getDirectGraphics(g2.getGraphics());
            Country attacker = game.getAttacker();
            Country defender = game.getDefender();
            if (attacker != null && defender != null) {
                Polygon pol1;
                int argb = PicturePanel.colorWithAlpha(attacker.getOwner().getColor(), 150);
                int ax = (int)((double)attacker.getX() * scale);
                int ay = (int)((double)attacker.getY() * scale);
                int dx = (int)((double)defender.getX() * scale);
                int dy = (int)((double)defender.getY() * scale);
                int mapWidth = (int)((double)this.map.length * scale);
                if (Math.abs(ax - dx) > mapWidth / 2) {
                    Polygon pol2;
                    if (ax > mapWidth / 2) {
                        pol1 = this.makeArrow(ax, ay, dx + mapWidth, dy, ballSize);
                        pol2 = this.makeArrow(ax - mapWidth, ay, dx, dy, ballSize);
                        g.fillPolygon(pol1.xpoints, 0, pol1.ypoints, 0, pol1.npoints, argb);
                        g.fillPolygon(pol2.xpoints, 0, pol2.ypoints, 0, pol2.npoints, argb);
                    } else {
                        pol1 = this.makeArrow(ax, ay, dx - mapWidth, dy, ballSize);
                        pol2 = this.makeArrow(ax + mapWidth, ay, dx, dy, ballSize);
                        g.fillPolygon(pol1.xpoints, 0, pol1.ypoints, 0, pol1.npoints, argb);
                        g.fillPolygon(pol2.xpoints, 0, pol2.ypoints, 0, pol2.npoints, argb);
                    }
                } else {
                    pol1 = this.makeArrow(ax, ay, dx, dy, ballSize);
                    g.fillPolygon(pol1.xpoints, 0, pol1.ypoints, 0, pol1.npoints, argb);
                }
            }
        }
        if (this.oldState != state) {
            this.oldState = state;
            if (state == 8) {
                this.startAni();
            } else {
                this.stopAni();
            }
        }
        HashMap<Country, Player> capitals = Collections.EMPTY_MAP;
        if (game.getGameMode() == 2 && game.getSetupDone() && game.getState() != 9) {
            capitals = new HashMap<Country, Player>(game.getNoPlayers());
            Vector players = game.getPlayers();
            for (int c = 0; c < players.size(); ++c) {
                Player player = (Player)players.get(c);
                Country capital = player.getCapital();
                if (capital == null) continue;
                capitals.put(capital, player);
            }
        }
        for (int c = 0; c < v.length; ++c) {
            int y;
            int x;
            Country t = v[c];
            if (t.getOwner() == null) continue;
            if (this.ballWorld == null) {
                x = t.getX();
                y = t.getY();
            } else {
                x = (int)this.ballWorld.balls[c].x;
                y = (int)this.ballWorld.balls[c].y;
            }
            PicturePanel.drawArmy(g2, t.getOwner().getColor(), t.getArmies(), (int)((double)x * scale), (int)((double)y * scale), ballSize, (Player)capitals.get(t));
        }
    }

    public static Image getIconForColor(int color) {
        return DominationMain.getBoolean("color_blind", false) ? icons.get(color) : null;
    }

    public static void drawArmy(Graphics2D g, int countryOwnerColor, int armies, int x, int y, int ballSize, Player capital) {
        int r = ballSize / 2;
        Image icon = PicturePanel.getIconForColor(countryOwnerColor);
        if (icon != null) {
            int w = (int)((double)ballSize * 1.1);
            int h = (int)((double)icon.getHeight() * ((double)w / (double)icon.getWidth()));
            g.drawScaledImage(icon, x - w / 2, y - w / 2, w, h);
        } else {
            g.setColor(countryOwnerColor);
            g.fillArc(x - r, y - r, ballSize, ballSize, 0, 360);
        }
        if (Application.getPlatform() != 8 && ballSize != fontBallSize) {
            String density = System.getProperty("display.scaledDensity");
            float d = density != null ? Float.parseFloat(density) : 1.0f;
            int fontSize = Math.max((int)((double)ballSize * 0.75 / (double)d + 0.5), 1);
            font = new Font(64, 0, -fontSize);
            fontBallSize = ballSize;
        }
        int h = y - (int)Math.round((double)font.getHeight() / 2.0);
        String noa = String.valueOf(armies);
        g.setColor(ColorUtil.getTextColorFor(countryOwnerColor));
        g.setFont(font);
        g.drawString(noa, x - (int)Math.round((double)font.getWidth(noa) / 2.0), h);
        if (capital != null) {
            int capitalColor = capital.getColor();
            int stroke = ballSize / 10;
            int old = g.getGraphics().getStrokeWidth();
            g.getGraphics().setStrokeWidth(stroke);
            g.setColor(ColorUtil.getTextColorFor(capitalColor));
            g.drawArc(x - r, y - r, ballSize, ballSize, 0, 360);
            g.setColor(capitalColor);
            int size = ballSize + stroke * 2;
            g.drawArc(x - size / 2, y - size / 2, size, size, 0, 360);
            g.getGraphics().setStrokeWidth(old);
        }
    }

    public void startAni() {
        if (this.ballWorld == null) {
            this.ballWorld = new BallWorld(this.myrisk, this, this.BALL_SIZE / 2);
        }
    }

    public void stopAni() {
        if (this.ballWorld != null) {
            this.ballWorld.stop();
            this.ballWorld = null;
            this.repaint();
        }
    }

    private void drawHighLightImage(Graphics2D g, int id) {
        ColorMatrix m;
        CountryImage countryImage = this.countryImages[id - 1];
        int val = countryImage.color;
        Graphics g2 = g.getGraphics();
        if (val == 0) {
            m = HighLight;
        } else {
            m = PicturePanel.getMatrix(val);
            m.preConcat(gray);
            m.postConcat(HighLight);
        }
        g2.setColorMatrix(m);
        g.drawImage(countryImage.getSourceImage(), countryImage.getX1(), countryImage.getY1());
        g2.setColorMatrix(null);
    }

    public Polygon makeArrow(int x1i, int y1i, int x2i, int y2i, int d) {
        Polygon arrow;
        double x1 = x1i;
        double y1 = y1i;
        double x2 = x2i;
        double y2 = y2i;
        double xd = x2 - x1;
        double yd = y1 - y2;
        double r = d / 2;
        double l = Math.sqrt(Math.pow(xd, 2.0) + Math.pow(yd, 2.0));
        double a = Math.acos(r / l);
        double b = Math.atan(yd / xd);
        double c = Math.atan(xd / yd);
        double x3 = r * Math.cos(a - b);
        double y3 = r * Math.sin(a - b);
        double x4 = r * Math.sin(a - c);
        double y4 = r * Math.cos(a - c);
        if (x2 >= x1 && y2 <= y1) {
            int[] xCoords = new int[]{(int)x1, (int)Math.round(x1 + x3), (int)x2, (int)Math.round(x1 - x4)};
            int[] yCoords = new int[]{(int)y1, (int)Math.round(y1 + y3), (int)y2, (int)Math.round(y1 - y4)};
            arrow = new Polygon(xCoords, yCoords, xCoords.length);
        } else if (x2 >= x1 && y2 >= y1) {
            int[] xCoords = new int[]{(int)x1, (int)Math.round(x1 + x3), (int)x2, (int)Math.round(x1 + x4)};
            int[] yCoords = new int[]{(int)y1, (int)Math.round(y1 + y3), (int)y2, (int)Math.round(y1 + y4)};
            arrow = new Polygon(xCoords, yCoords, xCoords.length);
        } else if (x2 <= x1 && y2 <= y1) {
            int[] xCoords = new int[]{(int)x1, (int)Math.round(x1 - x3), (int)x2, (int)Math.round(x1 - x4)};
            int[] yCoords = new int[]{(int)y1, (int)Math.round(y1 - y3), (int)y2, (int)Math.round(y1 - y4)};
            arrow = new Polygon(xCoords, yCoords, xCoords.length);
        } else {
            int[] xCoords = new int[]{(int)x1, (int)Math.round(x1 - x3), (int)x2, (int)Math.round(x1 + x4)};
            int[] yCoords = new int[]{(int)y1, (int)Math.round(y1 - y3), (int)y2, (int)Math.round(y1 + y4)};
            arrow = new Polygon(xCoords, yCoords, xCoords.length);
        }
        return arrow;
    }

    public synchronized void repaintCountries(int view) {
        if (this.tempimg == null) {
            return;
        }
        RiskGame game = this.myrisk.getGame();
        Graphics zg = this.tempimg.getGraphics();
        zg.drawImage(this.img, 0, 0, 0);
        ArrayList allConnectedEmpires = null;
        boolean showHumanCurrentPlayerInfo = false;
        if (view == 5) {
            Vector players = game.getPlayers();
            allConnectedEmpires = new ArrayList();
            for (int c = 0; c < players.size(); ++c) {
                allConnectedEmpires.addAll(game.getConnectedEmpire((Player)players.get(c)));
            }
        } else if (view == 3) {
            showHumanCurrentPlayerInfo = this.myrisk.showHumanCurrentPlayerInfo();
        }
        for (int c = 0; c < this.countryImages.length; ++c) {
            int val = 0;
            if (view == 0) {
                val = 0;
            } else if (view == 1) {
                val = game.getCountryInt(c + 1).getOwner() != null ? game.getCountryInt(c + 1).getOwner().getColor() : GRAY;
                val = PicturePanel.colorWithAlpha(val, 100);
            } else if (view == 2) {
                Player player = game.getCountryInt(c + 1).getOwner();
                if (player != game.getCurrentPlayer()) {
                    val = GRAY;
                } else {
                    Vector neighbours = game.getCountryInt(c + 1).getNeighbours();
                    int threat = 0;
                    for (int j = 0; j < neighbours.size(); ++j) {
                        if (((Country)neighbours.get(j)).getOwner() == player) continue;
                        ++threat;
                    }
                    if ((threat *= 40) > 255) {
                        threat = 255;
                    }
                    val = PicturePanel.newColor(threat, 0, 0);
                }
                val = PicturePanel.colorWithAlpha(val, 200);
            } else if (view == 3) {
                boolean mine;
                boolean bl = mine = game.getCountryInt(c + 1).getOwner() == game.getCurrentPlayer();
                if (showHumanCurrentPlayerInfo) {
                    List cards = this.myrisk.getCurrentCards();
                    for (int j = 0; j < cards.size(); ++j) {
                        if (((Card)cards.get(j)).getCountry() != game.getCountryInt(c + 1)) continue;
                        val = mine ? BLUE : YELLOW;
                    }
                    if (val == 0) {
                        val = mine ? DARK_GRAY : LIGHT_GRAY;
                    }
                } else {
                    val = LIGHT_GRAY;
                }
                val = PicturePanel.colorWithAlpha(val, 100);
            } else if (view == 4) {
                Country country = game.getCountryInt(c + 1);
                int armies = country.getArmies();
                if ((armies *= 25) > 255) {
                    armies = 255;
                }
                val = country.getOwner() == null ? GRAY : (country.getOwner() != game.getCurrentPlayer() ? PicturePanel.newColor(255, 255 - armies, 255 - armies) : PicturePanel.newColor(0, armies, 0));
                val = PicturePanel.colorWithAlpha(val, 200);
            } else if (view == 5) {
                Country thecountry = game.getCountryInt(c + 1);
                val = thecountry.getOwner() == null ? LIGHT_GRAY : (allConnectedEmpires.contains(thecountry) ? thecountry.getOwner().getColor() : DARK_GRAY);
                val = PicturePanel.colorWithAlpha(val, 100);
            }
            CountryImage ci = this.countryImages[c];
            int x1 = ci.getX1();
            int y1 = ci.getY1();
            if (!ci.checkChange(val)) continue;
            if (view != 0) {
                ColorMatrix m = PicturePanel.getMatrix(val);
                m.preConcat(gray);
                zg.setColorMatrix(m);
            }
            zg.drawImage(ci.getSourceImage(), x1, y1, 0);
        }
        Image newback = this.img;
        this.img = this.tempimg;
        this.tempimg = newback;
    }

    public int getCountryNumber(int x, int y) {
        double s = this.getScale();
        x -= this.getImgX(s);
        y -= this.getImgY(s);
        x = (int)((double)x / s);
        y = (int)((double)y / s);
        if (x < 0 || y < 0 || x >= this.map.length || y >= this.map[0].length) {
            return 255;
        }
        int result = this.map[x][y] + 128;
        return result == 255 ? this.myrisk.getGame().getClosestCountry(x, y) : result;
    }

    public void setHighLight(int a) {
        this.cc = a;
    }

    public int getHighLight() {
        return this.cc;
    }

    public void setC1(int a) {
        this.c1 = a;
    }

    public void setC2(int a) {
        this.c2 = a;
    }

    public int getC1() {
        return this.c1;
    }

    public int getC2() {
        return this.c2;
    }

    public static ColorMatrix RescaleOp(float a, float b) {
        ColorMatrix cm = new ColorMatrix(new float[]{a, 0.0f, 0.0f, 0.0f, b, 0.0f, a, 0.0f, 0.0f, b, 0.0f, 0.0f, a, 0.0f, b, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f});
        return cm;
    }

    public static ColorMatrix getMatrix(int color) {
        float r = ColorUtil.getRed(color);
        float g = ColorUtil.getGreen(color);
        float b = ColorUtil.getBlue(color);
        float alpha = (float)ColorUtil.getAlpha(color) / 255.0f;
        float alpha2 = 1.0f - alpha;
        ColorMatrix cm = new ColorMatrix(new float[]{alpha2, 0.0f, 0.0f, 0.0f, r * alpha, 0.0f, alpha2, 0.0f, 0.0f, g * alpha, 0.0f, 0.0f, alpha2, 0.0f, b * alpha, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f});
        return cm;
    }

    public Image getCountryImage(int num) {
        if (this.countryImages == null) {
            return null;
        }
        CountryImage ci = this.countryImages[num - 1];
        return ci.getSourceImage();
    }

    public static int colorWithAlpha(int color, int alpha) {
        return (alpha & 0xFF) << 24 | color & 0xFFFFFF;
    }

    private static int newColor(int r, int g, int b) {
        return 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
    }

    static {
        float scale = 1.5f;
        float offset = 1.0f;
        HighLight = PicturePanel.RescaleOp(scale, offset);
        gray = new ColorMatrix();
        gray.setSaturation(0.0f);
        icons = new HashMap<Integer, Image>();
        icons.put(-65536, Application.createImage("/color_red.png"));
        icons.put(-16776961, Application.createImage("/color_blue.png"));
        icons.put(-256, Application.createImage("/color_yellow.png"));
        icons.put(-16711681, Application.createImage("/color_cyan.png"));
        icons.put(-16711936, Application.createImage("/color_green.png"));
        icons.put(-65281, Application.createImage("/color_magenta.png"));
        font = DesktopPane.getDefaultTheme("").getFont(0);
        GRAY = PicturePanel.newColor(128, 128, 128);
        DARK_GRAY = PicturePanel.newColor(64, 64, 64);
        LIGHT_GRAY = PicturePanel.newColor(192, 192, 192);
        BLUE = PicturePanel.newColor(0, 0, 255);
        YELLOW = PicturePanel.newColor(255, 255, 0);
    }

    class Polygon {
        public int[] xpoints;
        public int[] ypoints;
        public int npoints;

        public Polygon(int[] xCoords, int[] yCoords, int length) {
            this.xpoints = xCoords;
            this.ypoints = yCoords;
            this.npoints = length;
        }
    }

    class CountryImage {
        private int x1 = Integer.MAX_VALUE;
        private int y1 = Integer.MAX_VALUE;
        private int x2;
        private int y2;
        private Image SourceImage;
        private int color;

        public boolean checkChange(int b) {
            if (b != this.color) {
                this.color = b;
                return true;
            }
            return false;
        }

        public void setSourceImage(Image a) {
            this.SourceImage = a;
        }

        public void setX1(int a) {
            this.x1 = a;
        }

        public void setY1(int a) {
            this.y1 = a;
        }

        public void setX2(int a) {
            this.x2 = a;
        }

        public void setY2(int a) {
            this.y2 = a;
        }

        public Image getSourceImage() {
            return this.SourceImage;
        }

        public int getX1() {
            return this.x1;
        }

        public int getY1() {
            return this.y1;
        }

        public int getX2() {
            return this.x2;
        }

        public int getY2() {
            return this.y2;
        }

        public int getWidth() {
            return this.x2 - this.x1 + 1;
        }

        public int getHeight() {
            return this.y2 - this.y1 + 1;
        }

        public String toString() {
            return "CountryImage{x1=" + this.x1 + ", y1=" + this.y1 + ", x2=" + this.x2 + ", y2=" + this.y2 + ", w=" + this.getWidth() + ", h=" + this.getHeight() + ", highlight=" + (this.color == 0 ? "none" : ColorUtil.getStringForColor(this.color)) + '}';
        }
    }

    public static class CountryNotFoundException
    extends RuntimeException {
        public CountryNotFoundException(String msg) {
            super(msg);
        }
    }
}

