/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.mobile.flashgui;

import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import java.util.Random;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import net.yura.domination.audio.GameSound;
import net.yura.domination.engine.Risk;
import net.yura.domination.mobile.flashgui.GameWindow;
import net.yura.domination.mobile.flashgui.MoveDialog;
import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.Application;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.KeyEvent;
import net.yura.mobile.gui.components.Button;
import net.yura.mobile.gui.components.CheckBox;
import net.yura.mobile.gui.components.Frame;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.layout.XULLoader;
import net.yura.mobile.util.Properties;

public class BattleDialog
extends Frame
implements ActionListener {
    Properties resb = GameWindow.resb;
    Risk myrisk;
    Sprite red_dice;
    Sprite blue_dice;
    Random r = new Random();
    Button rollButton;
    Button retreat;
    Button kill;
    int[] att;
    int[] def;
    private int noda;
    private int nodd;
    private boolean spinA;
    private boolean spinD;
    int c1num;
    int c2num;
    Image c1img;
    Image c2img;
    boolean canRetreat;
    int max;
    private static final int DICE_NORMAL = 0;
    private static final int DICE_DARK = 1;
    private static final int COLOR_BLUE = -16776961;
    private static final int COLOR_RED = -65536;

    public BattleDialog(Risk a) {
        this.myrisk = a;
        this.red_dice = BattleDialog.getSprite("/red_dice.png", 3, 3);
        this.blue_dice = BattleDialog.getSprite("/blue_dice.png", 3, 3);
        this.setName("TransparentDialog");
        this.setForeground(-16777216);
        this.setBackground(-1442840576);
        this.rollButton = new Button(this.resb.getProperty("battle.roll"));
        this.rollButton.addActionListener(this);
        this.rollButton.setActionCommand("fight");
        this.kill = new CheckBox(this.resb.getProperty("battle.annihilate"));
        this.kill.setName(this.rollButton.getName());
        this.kill.addActionListener(this);
        this.kill.setActionCommand("kill");
        this.retreat = new Button(this.resb.getProperty("battle.retreat"));
        this.retreat.addActionListener(this);
        this.retreat.setActionCommand("close");
        this.retreat.setMnemonic(-7);
        Panel controls = new Panel();
        controls.add(this.rollButton);
        controls.add(this.kill);
        controls.add(this.retreat);
        Panel contentPane = this.getContentPane();
        contentPane.setLayout(new MoveDialog.DialogLayout(this.getImageAreaHeight()));
        contentPane.add(controls);
        this.setMaximum(true);
        this.addWindowListener(this);
    }

    public static Sprite getSprite(String name, int cols, int rows) {
        Image img = Application.createImage(name);
        try {
            int w = img.getWidth() / cols;
            int h = img.getHeight() / rows;
            return new Sprite(img, w, h);
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("error creating sprite " + name + " " + img + " " + (img != null ? "(" + img.getWidth() + "x" + img.getHeight() + ") m=" + img.isMutable() + " " : "") + cols + "x" + rows, ex);
        }
    }

    private int getImageAreaHeight() {
        return XULLoader.adjustSizeToDensity(180);
    }

    public void actionPerformed(String actionCommand) {
        if ("fight".equals(actionCommand)) {
            GameSound.INSTANCE.playSound("dice_roll");
            this.go("roll " + (this.canRetreat ? this.noda : this.nodd));
        } else if ("kill".equals(actionCommand)) {
            if (this.kill.isSelected()) {
                GameSound.INSTANCE.playSound("dice_roll");
                this.go("roll " + (this.canRetreat ? this.noda : this.nodd));
            }
        } else if ("close".equals(actionCommand)) {
            if (this.canRetreat) {
                GameSound.INSTANCE.playSound("battle_retreat");
                this.go("retreat");
            } else {
                GameWindow.showClosePrompt(this.myrisk);
            }
        } else {
            System.out.println("Unknown command in BattleDialog " + actionCommand);
        }
    }

    private void go(String input) {
        int gameState = this.myrisk.getGame().getState();
        if (gameState == 4 || gameState == 10) {
            this.blockInput();
        }
        this.myrisk.parser(input);
    }

    public void run() throws InterruptedException {
        while (this.spinA || this.spinD) {
            this.repaint();
            this.wait(200);
        }
    }

    void setup(int c1num, int c2num, Image c1img, Image c2img) {
        this.c1num = c1num;
        this.c2num = c2num;
        this.c1img = c1img;
        this.c2img = c2img;
        this.att = null;
        this.def = null;
        this.noda = 0;
        this.nodd = 0;
        this.spinA = false;
        this.spinD = false;
        this.kill.setSelected(false);
        this.blockInput();
    }

    public void blockInput() {
        this.rollButton.setFocusable(false);
        this.retreat.setVisible(false);
        this.kill.setVisible(false);
        this.canRetreat = false;
        this.max = 0;
        this.setTitle(this.resb.getProperty("battle.title"));
        this.revalidate();
        this.repaint();
    }

    public void setNODAttacker(int n) {
        this.att = null;
        this.def = null;
        this.noda = n;
        this.spinA = true;
        this.repaint();
        this.getDesktopPane().animateComponent(this);
    }

    public void setNODDefender(int n) {
        this.nodd = n;
        this.spinD = true;
        this.repaint();
    }

    public void showDiceResults(int[] atti, int[] defi) {
        this.att = atti;
        this.def = defi;
        this.spinA = false;
        this.spinD = false;
        this.repaint();
    }

    void needInput(int n, boolean c) {
        this.max = n;
        this.canRetreat = c;
        if (this.canRetreat) {
            if (this.noda == 0 || this.noda > this.max) {
                this.noda = this.max;
            }
        } else if (this.nodd == 0 || this.nodd > this.max) {
            this.nodd = this.max;
        }
        this.att = null;
        this.def = null;
        this.rollButton.setFocusable(true);
        this.setTitle(this.resb.getProperty(this.canRetreat ? "battle.select.attack" : "battle.select.defend"));
        this.retreat.setVisible(this.canRetreat);
        this.kill.setVisible(this.canRetreat);
        this.revalidate();
        this.repaint();
        if (this.canRetreat && this.kill.isSelected()) {
            this.go("roll " + (this.canRetreat ? this.noda : this.nodd));
        }
    }

    public void paintComponent(Graphics2D g) {
        int csrc = this.myrisk.hasArmiesInt(this.c1num);
        int cdes = this.myrisk.hasArmiesInt(this.c2num);
        int color1 = this.myrisk.getColorOfOwner(this.c1num);
        int color2 = this.myrisk.getColorOfOwner(this.c2num);
        int imageAreaHeight = this.getImageAreaHeight();
        int heightOfComponents = ((MoveDialog.DialogLayout)this.getContentPane().getLayout()).getHeightOfComponents(this.getContentPane());
        int xOffset = this.getContentPane().getWidth() / 2;
        int yOffset = (this.getContentPane().getHeight() - heightOfComponents) / 2 + imageAreaHeight / 4 + this.getContentPane().getY();
        MoveDialog.paintMove(g, xOffset, yOffset, this.c1img, this.c2img, color1, color2, this.myrisk.getCountryCapital(this.c1num), this.myrisk.getCountryCapital(this.c2num), this.myrisk.getCountryName(this.c1num), this.myrisk.getCountryName(this.c2num), csrc, cdes, 0);
        int[] diceXs = this.getDiceX();
        int ax = diceXs[0];
        int dx = diceXs[1];
        int y1 = yOffset + imageAreaHeight / 4;
        int y2 = y1 + this.red_dice.getHeight() + XULLoader.adjustSizeToDensity(2);
        int y3 = y2 + this.red_dice.getHeight() + XULLoader.adjustSizeToDensity(2);
        int[] atti = this.att;
        int[] defi = this.def;
        int deadDice = this.myrisk.hasArmiesInt(this.c2num);
        if (deadDice > this.myrisk.getGame().getMaxDefendDice()) {
            deadDice = this.myrisk.getGame().getMaxDefendDice();
        }
        if (this.max != 0) {
            if (this.canRetreat) {
                g.drawSprite(this.red_dice, 0, ax, y1);
                if (this.noda > 1) {
                    g.drawSprite(this.red_dice, 0, ax, y2);
                } else if (this.max > 1) {
                    g.drawSprite(this.red_dice, 1, ax, y2);
                }
                if (this.noda > 2) {
                    g.drawSprite(this.red_dice, 0, ax, y3);
                } else if (this.max > 2) {
                    g.drawSprite(this.red_dice, 1, ax, y3);
                }
                g.drawSprite(this.blue_dice, 1, dx, y1);
                if (deadDice > 1) {
                    g.drawSprite(this.blue_dice, 1, dx, y2);
                }
                if (deadDice > 2) {
                    g.drawSprite(this.blue_dice, 1, dx, y3);
                }
            } else {
                g.drawSprite(this.blue_dice, 0, dx, y1);
                if (this.nodd > 1) {
                    g.drawSprite(this.blue_dice, 0, dx, y2);
                } else if (this.max > 1) {
                    g.drawSprite(this.blue_dice, 1, dx, y2);
                }
                if (this.nodd > 2) {
                    g.drawSprite(this.blue_dice, 0, dx, y3);
                } else if (this.max > 2) {
                    g.drawSprite(this.blue_dice, 1, dx, y3);
                }
            }
        } else if (atti == null && defi == null && !this.spinD) {
            g.drawSprite(this.blue_dice, 1, dx, y1);
            if (deadDice > 1) {
                g.drawSprite(this.blue_dice, 1, dx, y2);
            }
            if (deadDice > 2) {
                g.drawSprite(this.blue_dice, 1, dx, y3);
            }
            if (!this.spinA) {
                int AdeadDice = this.myrisk.hasArmiesInt(this.c1num) - 1;
                g.drawSprite(this.red_dice, 1, ax, y1);
                if (AdeadDice > 1) {
                    g.drawSprite(this.red_dice, 1, ax, y2);
                }
                if (AdeadDice > 2) {
                    g.drawSprite(this.red_dice, 1, ax, y3);
                }
            }
        }
        int SPINS_OFFSET = 3;
        if (this.spinA) {
            g.drawSprite(this.red_dice, 3 + this.r.nextInt(6), ax, y1);
            if (this.noda > 1) {
                g.drawSprite(this.red_dice, 3 + this.r.nextInt(6), ax, y2);
            }
            if (this.noda > 2) {
                g.drawSprite(this.red_dice, 3 + this.r.nextInt(6), ax, y3);
            }
            if (this.spinD) {
                g.drawSprite(this.blue_dice, 3 + this.r.nextInt(6), dx, y1);
                if (this.nodd > 1) {
                    g.drawSprite(this.blue_dice, 3 + this.r.nextInt(6), dx, y2);
                }
                if (this.nodd > 2) {
                    g.drawSprite(this.blue_dice, 3 + this.r.nextInt(6), dx, y3);
                }
            }
        }
        DirectGraphics g2 = DirectUtils.getDirectGraphics(g.getGraphics());
        int offset = (int)((double)this.red_dice.getWidth() / 7.25 + 0.5);
        int bottom = this.red_dice.getHeight() - offset - 1;
        int halfDice = this.red_dice.getHeight() / 2;
        if (atti != null && defi != null) {
            int[] xCoords;
            int[] yCoords = new int[]{y1 + offset, y1 + bottom, y1 + halfDice};
            if (defi[0] >= atti[0]) {
                xCoords = new int[]{dx + offset, dx + offset, ax + bottom};
                g2.fillPolygon(xCoords, 0, yCoords, 0, xCoords.length, -16776961);
            } else {
                xCoords = new int[]{ax + bottom, ax + bottom, dx + offset};
                g2.fillPolygon(xCoords, 0, yCoords, 0, xCoords.length, -65536);
            }
            if (atti.length > 1 && defi.length > 1) {
                yCoords = new int[]{y2 + offset, y2 + bottom, y2 + halfDice};
                if (defi[1] >= atti[1]) {
                    xCoords = new int[]{dx + offset, dx + offset, ax + bottom};
                    g2.fillPolygon(xCoords, 0, yCoords, 0, xCoords.length, -16776961);
                } else {
                    xCoords = new int[]{ax + bottom, ax + bottom, dx + offset};
                    g2.fillPolygon(xCoords, 0, yCoords, 0, xCoords.length, -65536);
                }
            }
            if (atti.length > 2 && defi.length > 2) {
                yCoords = new int[]{y3 + offset, y3 + bottom, y3 + halfDice};
                if (defi[2] >= atti[2]) {
                    xCoords = new int[]{dx + offset, dx + offset, ax + bottom};
                    g2.fillPolygon(xCoords, 0, yCoords, 0, xCoords.length, -16776961);
                } else {
                    xCoords = new int[]{ax + bottom, ax + bottom, dx + offset};
                    g2.fillPolygon(xCoords, 0, yCoords, 0, xCoords.length, -65536);
                }
            }
            this.drawDice(true, atti[0], ax, y1, g);
            if (atti.length > 1) {
                this.drawDice(true, atti[1], ax, y2, g);
            }
            if (atti.length > 2) {
                this.drawDice(true, atti[2], ax, y3, g);
            }
            this.drawDice(false, defi[0], dx, y1, g);
            if (defi.length > 1) {
                this.drawDice(false, defi[1], dx, y2, g);
            }
            if (defi.length > 2) {
                this.drawDice(false, defi[2], dx, y3, g);
            }
        }
    }

    public void drawDice(boolean isAttacker, int result, int dx, int dy, Graphics2D g) {
        g.translate(dx, dy);
        if (isAttacker) {
            g.drawSprite(this.red_dice, 0, 0, 0);
        } else {
            g.drawSprite(this.blue_dice, 0, 0, 0);
        }
        int w = this.red_dice.getWidth();
        int size = (int)((double)w / 9.666666666666666 + 0.5);
        int close = (int)((double)w / 4.142857142857143 + 0.5);
        int middle = (w - size) / 2;
        int far = w - close - size;
        g.setColor(-922746881);
        if (result == 0) {
            g.fillOval(middle, middle, size, size);
        } else if (result == 1) {
            g.fillOval(close, close, size, size);
            g.fillOval(far, far, size, size);
        } else if (result == 2) {
            g.fillOval(close, close, size, size);
            g.fillOval(middle, middle, size, size);
            g.fillOval(far, far, size, size);
        } else if (result == 3) {
            g.fillOval(close, close, size, size);
            g.fillOval(far, close, size, size);
            g.fillOval(far, far, size, size);
            g.fillOval(close, far, size, size);
        } else if (result == 4) {
            g.fillOval(close, close, size, size);
            g.fillOval(far, close, size, size);
            g.fillOval(far, far, size, size);
            g.fillOval(close, far, size, size);
            g.fillOval(middle, middle, size, size);
        } else if (result == 5) {
            g.fillOval(close, close, size, size);
            g.fillOval(far, close, size, size);
            g.fillOval(far, far, size, size);
            g.fillOval(close, far, size, size);
            g.fillOval(middle, close, size, size);
            g.fillOval(middle, far, size, size);
        }
        g.translate(-dx, -dy);
    }

    private int[] getDiceX() {
        int w = this.getWidth();
        int diceWidth = this.red_dice.getWidth();
        int ax = w / 2 - MoveDialog.distanceFromCenter - diceWidth / 2;
        int dx = w / 2 + MoveDialog.distanceFromCenter - diceWidth / 2;
        return new int[]{ax, dx};
    }

    public int insideButton(int x, int y) {
        int imageAreaHeight = this.getImageAreaHeight();
        int heightOfComponents = ((MoveDialog.DialogLayout)this.getContentPane().getLayout()).getHeightOfComponents(this.getContentPane());
        int xOffset = this.getContentPane().getWidth() / 2;
        int yOffset = (this.getContentPane().getHeight() - heightOfComponents) / 2 + imageAreaHeight / 4 + this.getContentPane().getY();
        int y1 = yOffset + imageAreaHeight / 4;
        int y2 = y1 + this.red_dice.getHeight() + XULLoader.adjustSizeToDensity(2);
        int y3 = y2 + this.red_dice.getHeight() + XULLoader.adjustSizeToDensity(2);
        int[] diceXs = this.getDiceX();
        int ax = diceXs[0];
        int dx = diceXs[1];
        int W = this.red_dice.getWidth();
        int H = this.red_dice.getHeight();
        if (x >= ax && x < ax + W && y >= y1 && y < y1 + H) {
            return 1;
        }
        if (x >= ax && x < ax + W && y >= y2 && y < y2 + H) {
            return 2;
        }
        if (x >= ax && x < ax + W && y >= y3 && y < y3 + H) {
            return 3;
        }
        if (x >= dx && x < dx + W && y >= y1 && y < y1 + H) {
            return 4;
        }
        if (x >= dx && x < dx + W && y >= y2 && y < y2 + H) {
            return 5;
        }
        if (x >= dx && x < dx + W && y >= y3 && y < y3 + H) {
            return 6;
        }
        return 0;
    }

    public void processMouseEvent(int type, int x, int y, KeyEvent keys) {
        super.processMouseEvent(type, x, y, keys);
        if (type == 2) {
            int click = this.insideButton(x, y);
            if (this.max != 0) {
                if (this.canRetreat) {
                    if (click == 1) {
                        this.noda = 1;
                    }
                    if (click == 2 && this.max > 1) {
                        this.noda = 2;
                    }
                    if (click == 3 && this.max > 2) {
                        this.noda = 3;
                    }
                } else {
                    if (click == 4) {
                        this.nodd = 1;
                    }
                    if (click == 5 && this.max > 1) {
                        this.nodd = 2;
                    }
                    if (click == 6 && this.max > 2) {
                        this.nodd = 3;
                    }
                }
                this.repaint();
            }
        }
    }
}

