/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.mobile.flashgui;

import java.util.Arrays;
import javax.microedition.lcdui.Image;
import net.yura.domination.engine.JavaCompatUtil;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.mobile.PicturePanel;
import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.celleditor.TableCellEditor;
import net.yura.mobile.gui.cellrenderer.ListCellRenderer;
import net.yura.mobile.gui.components.Button;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.FileChooser;
import net.yura.mobile.gui.components.Frame;
import net.yura.mobile.gui.components.Table;
import net.yura.mobile.gui.layout.XULLoader;

public class ColorPicker
extends FileChooser.GridList
implements ActionListener {
    public static final String CMD_OK = "ok";
    private ActionListener listener;
    private Frame dialog;

    public ColorPicker() {
        super(XULLoader.adjustSizeToDensity(75));
        this.setPreferredSize(XULLoader.adjustSizeToDensity(75) * 4, -1);
        this.setListData(JavaCompatUtil.asVector(Arrays.asList(PlayerColor.values())));
        this.setDefaultRenderer(PlayerColor.class, new ColorButton());
        ColorButton button = new ColorButton();
        button.addActionListener(this);
        button.setActionCommand(CMD_OK);
        this.setDefaultEditor(PlayerColor.class, button);
    }

    public int getSelectedColor() {
        PlayerColor playerColor = (PlayerColor)((Object)this.getSelectedValue());
        return playerColor.rgb;
    }

    public void actionPerformed(String actionCommand) {
        this.dialog.setVisible(false);
        this.dialog = null;
        this.listener.actionPerformed(actionCommand);
    }

    public void showDialog(ActionListener listener, String name) {
        this.listener = listener;
        this.dialog = new Frame();
        this.dialog.setTitle(TranslationBundle.getBundle().getString("newgame.label.color") + " - " + name);
        this.dialog.setCloseOnFocusLost(true);
        this.dialog.setName("Dialog");
        this.dialog.getTitlePane().setName("InternalFrameTitlePane");
        Button cancel = new Button((String)DesktopPane.get("cancelText"));
        cancel.setActionCommand("close");
        cancel.addActionListener(this.dialog.getTitlePane());
        cancel.setMnemonic(-11);
        this.dialog.addCommand(cancel);
        this.dialog.add(this);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setVisible(true);
    }

    class ColorButton
    extends Button
    implements ListCellRenderer,
    TableCellEditor {
        private Object value;

        public ColorButton() {
            this.setName("ColorButton");
        }

        public Component getListCellRendererComponent(Component listOrTable, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            PlayerColor playerColor = (PlayerColor)((Object)value);
            this.setBackground(playerColor.rgb);
            this.setToolTipText(playerColor.name);
            Image image = PicturePanel.getIconForColor(playerColor.rgb);
            this.setIcon(image == null ? null : new Icon(image));
            return this;
        }

        public Component getTableCellEditorComponent(Table table, Object value, boolean isSelected, int row, int column) {
            this.value = value;
            return this.getListCellRendererComponent(table, value, 0, isSelected, false);
        }

        public Object getCellEditorValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PlayerColor {
        PINK(-20561, "pink"),
        RED(-65536, "red"),
        ORANGE(-14336, "orange"),
        YELLOW(-256, "yellow"),
        GREEN(-16711936, "green"),
        CYAN(-16711681, "cyan"),
        BLUE(-16776961, "blue"),
        MAGENTA(-65281, "magenta"),
        WHITE(-1, "white"),
        LTGRAY(-4144960, "lightgray"),
        DKGRAY(-12566464, "darkgray"),
        BLACK(-16777216, "black");

        public final int rgb;
        public final String name;

        private PlayerColor(int rgb, String name) {
            this.rgb = rgb;
            this.name = name;
        }
    }
}

