/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.mobile.flashgui;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import net.yura.domination.audio.GameSound;
import net.yura.domination.engine.ColorUtil;
import net.yura.domination.engine.OnlineUtil;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskSettings;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.core.Player;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.mapstore.BadgeButton;
import net.yura.domination.mapstore.MapChooser;
import net.yura.domination.mapstore.MapPreview;
import net.yura.domination.mapstore.MapUpdateService;
import net.yura.domination.mobile.MiniUtil;
import net.yura.domination.mobile.flashgui.DominationMain;
import net.yura.domination.mobile.flashgui.GameWindow;
import net.yura.domination.mobile.flashgui.MainMenu;
import net.yura.domination.mobile.flashgui.MiniFlashRiskAdapter;
import net.yura.domination.mobile.flashgui.PlayerList;
import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.ButtonGroup;
import net.yura.mobile.gui.ChangeListener;
import net.yura.mobile.gui.components.Button;
import net.yura.mobile.gui.components.CheckBox;
import net.yura.mobile.gui.components.ComboBox;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.Frame;
import net.yura.mobile.gui.components.Label;
import net.yura.mobile.gui.components.OptionPane;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.components.Spinner;
import net.yura.mobile.gui.components.TextComponent;
import net.yura.mobile.gui.layout.XULLoader;
import net.yura.mobile.util.Option;
import net.yura.mobile.util.Properties;

public class GameSetup
extends Frame
implements ChangeListener,
ActionListener {
    private final String[] compsNames;
    private final int[] compTypes;
    Properties resb = GameWindow.resb;
    public Risk myrisk;
    MiniFlashRiskAdapter controller;
    XULLoader newgame;
    Button autoplaceall;
    private boolean localgame;
    private String[] allowedMaps;
    String lobbyMapName;

    public GameSetup(Risk risk, MiniFlashRiskAdapter controller) {
        this.myrisk = risk;
        this.controller = controller;
        this.setMaximum(true);
        this.addWindowListener(this);
        this.setBorder(MainMenu.background);
        this.setBackground(0xFFFFFF);
        String[] ais = this.myrisk.getAICommands();
        this.compsNames = new String[ais.length + 1];
        this.compTypes = new int[ais.length + 1];
        for (int c = 0; c < ais.length; ++c) {
            this.compsNames[c] = ais[c] + "AI";
            this.compTypes[c] = this.myrisk.getType("ai " + ais[c]);
        }
        this.compsNames[this.compsNames.length - 1] = "human";
        this.compTypes[this.compTypes.length - 1] = 0;
    }

    public void actionPerformed(String actionCommand) {
        if ("close".equals(actionCommand)) {
            GameSound.INSTANCE.playSound("back_button");
        } else if (!"startgame".equals(actionCommand)) {
            GameSound.INSTANCE.playSound("button");
        }
        if ("close".equals(actionCommand)) {
            if (this.localgame) {
                this.myrisk.parser("closegame");
            } else {
                this.controller.openMainMenu();
            }
        } else if ("startgame".equals(actionCommand)) {
            ButtonGroup gameType = (ButtonGroup)this.newgame.getGroups().get("GameType");
            ButtonGroup cardType = (ButtonGroup)this.newgame.getGroups().get("CardType");
            Button recycle = (Button)this.newgame.find("recycle");
            int numOfPlayers = this.getNoOfPlayers();
            if (numOfPlayers >= 2 && numOfPlayers <= RiskGame.MAX_PLAYERS) {
                if (this.localgame) {
                    this.newgame.find("startButton").setFocusable(false);
                    String gameTypeCommand = gameType.getSelection().getActionCommand();
                    String cardTypeCommand = cardType.getSelection().getActionCommand();
                    boolean autoPlaceAllBoolean = this.autoplaceall != null && this.autoplaceall.isSelected();
                    boolean recycleCardsBoolean = recycle != null && recycle.isSelected();
                    RiskSettings.savePlayers(this.myrisk, this.getClass());
                    RiskSettings.saveGameSettings(DominationMain.appPreferences, gameTypeCommand, cardTypeCommand, autoPlaceAllBoolean, recycleCardsBoolean);
                    this.myrisk.parser("startgame " + gameTypeCommand + " " + cardTypeCommand + (autoPlaceAllBoolean ? " autoplaceall" : "") + (recycleCardsBoolean ? " recycle" : ""));
                } else {
                    String name = ((TextComponent)this.newgame.find("GameName")).getText().trim();
                    if ("".equals(name)) {
                        OptionPane.showMessageDialog(null, this.resb.getProperty("newgame.error.nogamename"), this.resb.getProperty("newgame.error.title"), 0);
                    } else {
                        boolean privateGame = ((Button)this.newgame.find("private")).isSelected();
                        int easyAI = this.getNoPlayers(1);
                        int averageAI = this.getNoPlayers(4);
                        int hardAI = this.getNoPlayers(2);
                        this.controller.createLobbyGame(name, OnlineUtil.createGameString(easyAI, averageAI, hardAI, this.getStartGameOption(gameType.getSelection().getActionCommand()), this.getStartGameOption(cardType.getSelection().getActionCommand()), this.autoplaceall.isSelected(), recycle.isSelected(), this.lobbyMapName), this.getNoPlayers(0), Integer.parseInt(((Option)((ComboBox)this.newgame.find("TimeoutValue")).getSelectedItem()).getKey()), privateGame ? ((TextComponent)this.newgame.find("password")).getText() : null);
                        this.controller.openMainMenu();
                    }
                }
            } else {
                OptionPane.showMessageDialog(null, this.resb.getProperty("newgame.error.numberofplayers"), this.resb.getProperty("newgame.error.title"), 0);
            }
        } else if ("choosemap".equals(actionCommand)) {
            MapChooser mapc;
            MapListener al = new MapListener();
            al.mapc = mapc = new MapChooser(al, MiniUtil.getFileList("map"), (Set<String>)(this.allowedMaps == null ? null : new HashSet<String>(Arrays.asList(this.allowedMaps))));
            Frame mapFrame = new Frame(this.resb.getProperty("newgame.choosemap"));
            mapFrame.setContentPane(mapc.getRoot());
            mapFrame.setMaximum(true);
            mapFrame.setVisible(true);
        } else if ("mission".equals(actionCommand)) {
            this.autoplaceall.setFocusable(false);
        } else if ("domination".equals(actionCommand)) {
            this.autoplaceall.setFocusable(true);
        } else if ("capital".equals(actionCommand)) {
            this.autoplaceall.setFocusable(true);
        } else if (!("increasing".equals(actionCommand) || "fixed".equals(actionCommand) || "italianlike".equals(actionCommand))) {
            if ("private".equals(actionCommand)) {
                CheckBox privateButton = (CheckBox)this.newgame.find("private");
                this.newgame.find("passwordLabel").setVisible(privateButton.isSelected());
                Component password = this.newgame.find("password");
                password.setVisible(privateButton.isSelected());
                if (privateButton.isSelected()) {
                    password.requestFocusInWindow();
                }
                this.newgame.getRoot().revalidate();
                this.newgame.getRoot().repaint();
            } else if (!"customPlayers".equals(actionCommand)) {
                System.err.println("GameSetup unknown command: " + actionCommand);
            }
        }
    }

    int getNoOfPlayers() {
        if (this.localgame) {
            return this.myrisk.getGame().getPlayers().size();
        }
        int count = 0;
        for (int c = 0; c < this.compTypes.length; ++c) {
            count += this.getNoPlayers(this.compTypes[c]);
        }
        return count;
    }

    int getNoPlayers(int type) {
        for (int c = 0; c < this.compTypes.length; ++c) {
            if (this.compTypes[c] != type) continue;
            Component comp = this.newgame.find(this.compsNames[c]);
            if (comp != null) {
                return (Integer)((Spinner)comp).getValue();
            }
            return 0;
        }
        throw new RuntimeException("invalid type " + type);
    }

    int getStartGameOption(String newOption) {
        if (newOption.equals("domination")) {
            return 0;
        }
        if (newOption.equals("capital")) {
            return 2;
        }
        if (newOption.equals("mission")) {
            return 3;
        }
        if (newOption.equals("increasing")) {
            return 0;
        }
        if (newOption.equals("fixed")) {
            return 1;
        }
        if (newOption.equals("italianlike")) {
            return 2;
        }
        throw new RuntimeException("unknown option " + newOption);
    }

    void setLobbyMap(String name) {
        this.lobbyMapName = name;
        this.showMapPic(name);
        Map mapinfo = RiskUtil.loadInfo(name, false);
        String cardsFile = (String)mapinfo.get("crd");
        Map cardsinfo = RiskUtil.loadInfo(cardsFile, true);
        String[] missions = (String[])cardsinfo.get("missions");
        this.showCardsFile(cardsFile, missions.length > 0);
    }

    public void openNewGame(boolean islocalgame, String[] allowedMaps, String gameName) {
        this.localgame = islocalgame;
        this.allowedMaps = allowedMaps;
        this.newgame = GameWindow.getPanel("/newgame.xml", this);
        if (gameName != null) {
            TextComponent tc = (TextComponent)this.newgame.find("GameName");
            tc.setTitle(this.resb.getProperty("newgame.label.name"));
            tc.setText(gameName);
            tc.setVisible(true);
            this.newgame.find("Online").setVisible(true);
        }
        MapUpdateService.getInstance().addObserver((BadgeButton)this.newgame.find("MapImg"));
        ButtonGroup gameType = (ButtonGroup)this.newgame.getGroups().get("GameType");
        ButtonGroup cardType = (ButtonGroup)this.newgame.getGroups().get("CardType");
        this.autoplaceall = (Button)this.newgame.find("autoplaceall");
        Button recycle = (Button)this.newgame.find("recycle");
        GameSetup.setSelected(gameType, DominationMain.getString("default.gametype", gameType.getSelection().getActionCommand()));
        GameSetup.setSelected(cardType, DominationMain.getString("default.cardtype", cardType.getSelection().getActionCommand()));
        if (this.autoplaceall != null) {
            this.autoplaceall.setSelected(DominationMain.getBoolean("default.autoplaceall", this.autoplaceall.isSelected()));
        }
        if (recycle != null) {
            recycle.setSelected(DominationMain.getBoolean("default.recycle", recycle.isSelected()));
        }
        ((Spinner)this.newgame.find("human")).setMinimum(this.localgame ? (Boolean.getBoolean("debug") ? 0 : 1) : (Boolean.getBoolean("debug") ? 1 : 2));
        for (int c = 0; c < this.compsNames.length; ++c) {
            this.addChangeListener(this.compsNames[c]);
        }
        PlayerList playerList = (PlayerList)this.newgame.find("playerList");
        if (this.localgame) {
            RiskSettings.loadPlayers(this.myrisk, this.getClass());
            playerList.setGame(this.myrisk);
        } else {
            this.setLobbyMap(allowedMaps[0]);
            playerList.setVisible(false);
        }
        this.setTitle(this.resb.getProperty(this.localgame ? "newgame.title.local" : "newgame.title.network"));
        this.setContentPane((Panel)this.newgame.getRoot());
        this.revalidate();
        this.setVisible(true);
    }

    private static void setSelected(ButtonGroup group, String actionCommand) {
        Enumeration buttons = group.getElements();
        while (buttons.hasMoreElements()) {
            Button button = (Button)buttons.nextElement();
            if (!(actionCommand == null ? button.getActionCommand() == null : actionCommand.equals(button.getActionCommand()))) continue;
            button.setSelected(true);
            return;
        }
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (!b && this.newgame != null) {
            MapUpdateService.getInstance().deleteObserver((BadgeButton)this.newgame.find("MapImg"));
        }
    }

    private void addChangeListener(String name) {
        Component comp = this.newgame.find(name);
        if (comp != null && comp instanceof Spinner) {
            ((Spinner)comp).addChangeListener(this);
        }
    }

    private void removeChangeListener(String name) {
        Component comp = this.newgame.find(name);
        if (comp != null && comp instanceof Spinner) {
            ((Spinner)comp).removeChangeListener(this);
        }
    }

    public void updatePlayers() {
        int c;
        Vector players = this.myrisk.getGame().getPlayers();
        int[] count = new int[this.compTypes.length];
        block0: for (c = 0; c < players.size(); ++c) {
            int type = ((Player)players.get(c)).getType();
            for (int a = 0; a < this.compTypes.length; ++a) {
                if (type != this.compTypes[a]) continue;
                int n = a;
                count[n] = count[n] + 1;
                continue block0;
            }
        }
        for (c = 0; c < this.compsNames.length; ++c) {
            Component comp = this.newgame.find(this.compsNames[c]);
            if (comp == null) continue;
            this.removeChangeListener(this.compsNames[c]);
            comp.setValue(new Integer(count[c]));
            this.addChangeListener(this.compsNames[c]);
        }
        this.revalidate();
        this.repaint();
    }

    public void changeEvent(Component source, int num) {
        int type = -1;
        for (int c = 0; c < this.compsNames.length; ++c) {
            Component comp = this.newgame.find(this.compsNames[c]);
            if (source != comp) continue;
            type = this.compTypes[c];
            break;
        }
        if (type == -1) {
            throw new RuntimeException("type for this Component can not be found " + source);
        }
        if (this.localgame) {
            int c;
            Vector players = this.myrisk.getGame().getPlayers();
            int count = 0;
            for (int c2 = 0; c2 < players.size(); ++c2) {
                int ptype = ((Player)players.get(c2)).getType();
                if (ptype != type) continue;
                ++count;
            }
            int newval = (Integer)((Spinner)source).getValue();
            if (newval < count) {
                for (c = players.size() - 1; c >= 0; --c) {
                    Player p = (Player)players.get(c);
                    if (p.getType() != type) continue;
                    this.myrisk.parser("delplayer " + p.getName());
                    break;
                }
            } else if (newval > count) {
                if (players.size() == RiskGame.MAX_PLAYERS) {
                    for (c = players.size() - 1; c >= 0; --c) {
                        Player p = (Player)players.get(c);
                        if (p.getType() == type) continue;
                        p.setType(type);
                        this.updatePlayers();
                        return;
                    }
                } else {
                    String newname = null;
                    String newcolor = null;
                    for (int c3 = 0; c3 < Risk.names.length; ++c3) {
                        boolean badname = false;
                        boolean badcolor = false;
                        for (int a = 0; a < players.size(); ++a) {
                            if (Risk.names[c3].equals(((Player)players.get(a)).getName())) {
                                badname = true;
                            }
                            if (ColorUtil.getColor(Risk.colors[c3]) == ((Player)players.get(a)).getColor()) {
                                badcolor = true;
                            }
                            if (badname && badcolor) break;
                        }
                        if (newname == null && !badname) {
                            newname = Risk.names[c3];
                        }
                        if (newcolor == null && !badcolor) {
                            newcolor = Risk.colors[c3];
                        }
                        if (newname != null && newcolor != null) break;
                    }
                    if (newname != null && newcolor != null) {
                        this.myrisk.parser("newplayer " + this.myrisk.getType(type) + " " + newcolor + " " + newname);
                    } else {
                        throw new RuntimeException("new name and color can not be found");
                    }
                }
            }
        }
    }

    public void showMapPic(String mapFile) {
        ((Label)this.newgame.find("MapImg")).setIcon(MapPreview.getLocalIconForMap(MapPreview.createMap(mapFile)));
        this.revalidate();
        this.repaint();
    }

    public void showCardsFile(String c, boolean hasMission) {
        Button mission = (Button)this.newgame.find("mission");
        Button domination = (Button)this.newgame.find("domination");
        if (!hasMission && mission.isSelected()) {
            domination.setSelected(true);
            this.autoplaceall.setFocusable(true);
        }
        mission.setFocusable(hasMission);
    }

    class MapListener
    implements ActionListener {
        MapChooser mapc;

        MapListener() {
        }

        public void actionPerformed(String arg0) {
            String name = this.mapc.getSelectedMap();
            if (name != null) {
                if (GameSetup.this.localgame) {
                    GameSetup.this.myrisk.parser("choosemap " + name);
                } else {
                    GameSetup.this.setLobbyMap(name);
                }
            }
            this.mapc.getRoot().getWindow().setVisible(false);
            this.mapc.destroy();
        }
    }
}

