/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.mobile.flashgui;

import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Image;
import net.yura.domination.LoadingManager;
import net.yura.domination.audio.GameSound;
import net.yura.domination.engine.JavaCompatUtil;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.core.Player;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.guishared.MapMouseListener;
import net.yura.domination.mobile.MiniUtil;
import net.yura.domination.mobile.MouseListener;
import net.yura.domination.mobile.PicturePanel;
import net.yura.domination.mobile.flashgui.CardsDialog;
import net.yura.domination.mobile.flashgui.DominationMain;
import net.yura.domination.mobile.flashgui.GamePreferences;
import net.yura.domination.mobile.flashgui.MainMenu;
import net.yura.domination.mobile.flashgui.MiniFlashRiskAdapter;
import net.yura.domination.mobile.flashgui.MoveDialog;
import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.Application;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.Font;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.components.Button;
import net.yura.mobile.gui.components.CheckBox;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.Frame;
import net.yura.mobile.gui.components.Menu;
import net.yura.mobile.gui.components.OptionPane;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.components.ScrollPane;
import net.yura.mobile.gui.components.TextArea;
import net.yura.mobile.gui.components.TextField;
import net.yura.mobile.gui.components.Window;
import net.yura.mobile.gui.layout.BorderLayout;
import net.yura.mobile.gui.layout.GridBagConstraints;
import net.yura.mobile.gui.layout.GridBagLayout;
import net.yura.mobile.gui.layout.XHTMLLoader;
import net.yura.mobile.gui.layout.XULLoader;
import net.yura.mobile.io.kdom.Document;
import net.yura.mobile.io.kdom.Element;
import net.yura.mobile.io.kxml2.KXmlSerializer;
import net.yura.mobile.util.Option;
import net.yura.mobile.util.Properties;
import net.yura.mobile.util.Url;
import net.yura.swingme.core.CoreUtil;
import net.yura.swingme.core.ViewChooser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameWindow
extends Frame
implements ActionListener {
    public static final Logger logger = Logger.getLogger(GameWindow.class.getName());
    public static final Properties resb = CoreUtil.wrap(TranslationBundle.getBundle());
    Risk myrisk;
    PicturePanel pp;
    ViewChooser mapViewControl;
    Button note;
    Button gobutton;
    Button closebutton;
    Button savebutton;
    Button undobutton;
    Button graphbutton;
    String status;
    int gameState;
    private CheckBox AutoEndGo;
    private CheckBox AutoDefend;
    private Button cardsbutton;
    private Button missionbutton;
    private Button options;
    Menu menu;
    MiniFlashRiskAdapter controller;
    ScrollPane scroll;
    boolean localGame;
    CardsDialog cardsDialog;
    public static final String EASY_INCREASING_CAPITAL = "CgkIpcXiv-UWEAIQGA";
    public static final String EASY_FIXED_CAPITAL = "CgkIpcXiv-UWEAIQGQ";
    public static final String EASY_ITALIAN_CAPITAL = "CgkIpcXiv-UWEAIQGg";
    public static final String AVERAGE_INCREASING_CAPITAL = "CgkIpcXiv-UWEAIQGw";
    public static final String AVERAGE_FIXED_CAPITAL = "CgkIpcXiv-UWEAIQHA";
    public static final String AVERAGE_ITALIAN_CAPITAL = "CgkIpcXiv-UWEAIQHQ";
    public static final String HARD_INCREASING_CAPITAL = "CgkIpcXiv-UWEAIQHg";
    public static final String HARD_FIXED_CAPITAL = "CgkIpcXiv-UWEAIQHw";
    public static final String HARD_ITALIAN_CAPITAL = "CgkIpcXiv-UWEAIQIA";
    public static final String EASY_INCREASING_DOMINATION = "CgkIpcXiv-UWEAIQAQ";
    public static final String EASY_FIXED_DOMINATION = "CgkIpcXiv-UWEAIQBA";
    public static final String EASY_ITALIAN_DOMINATION = "CgkIpcXiv-UWEAIQCA";
    public static final String AVERAGE_INCREASING_DOMINATION = "CgkIpcXiv-UWEAIQAg";
    public static final String AVERAGE_FIXED_DOMINATION = "CgkIpcXiv-UWEAIQBQ";
    public static final String AVERAGE_ITALIAN_DOMINATION = "CgkIpcXiv-UWEAIQCQ";
    public static final String HARD_INCREASING_DOMINATION = "CgkIpcXiv-UWEAIQAw";
    public static final String HARD_FIXED_DOMINATION = "CgkIpcXiv-UWEAIQBg";
    public static final String HARD_ITALIAN_DOMINATION = "CgkIpcXiv-UWEAIQCg";
    private MoveDialog tacMove;

    public GameWindow(Risk risk, MiniFlashRiskAdapter controller) {
        this.myrisk = risk;
        this.controller = controller;
        this.setMaximum(true);
        this.setUndecorated(true);
        this.setBorder(MainMenu.background);
        this.setBackground(0xFFFFFF);
        this.setForeground(-1);
        this.pp = new PicturePanel(this.myrisk);
        final MapMouseListener mml = new MapMouseListener(this.myrisk, this.pp);
        this.pp.addMouseListener(new MouseListener(){

            public void click(int x, int y, boolean rightClick) {
                if (GameWindow.this.gameState == 1) {
                    GameWindow.this.openCards();
                } else {
                    int[] countries = mml.mouseReleased(x, y, GameWindow.this.gameState);
                    if (countries != null) {
                        GameWindow.this.mapClick(countries, rightClick);
                    }
                }
            }
        });
        this.savebutton = new Button(resb.getProperty("game.menu.save"));
        this.savebutton.setIcon(new Icon("/save.png"));
        this.savebutton.addActionListener(this);
        this.savebutton.setActionCommand("save");
        this.graphbutton = new Button(resb.getProperty("game.button.statistics"));
        this.graphbutton.setIcon(new Icon("/ic_menu_chartsettings.png"));
        this.graphbutton.addActionListener(this);
        this.graphbutton.setActionCommand("graph");
        this.undobutton = new Button(resb.getProperty("game.button.undo"));
        this.undobutton.setIcon(new Icon("/undo.png"));
        this.undobutton.addActionListener(this);
        this.undobutton.setActionCommand("undo");
        this.options = new Button(resb.getProperty("swing.menu.options"));
        this.options.setIcon(new Icon("/ic_menu_preferences.png"));
        this.options.setActionCommand("options");
        this.options.addActionListener(this);
        this.AutoEndGo = new CheckBox(resb.getProperty("game.menu.autoendgo"));
        this.AutoEndGo.setActionCommand("autoendgo");
        this.AutoEndGo.addActionListener(this);
        this.AutoDefend = new CheckBox(resb.getProperty("game.menu.autodefend"));
        this.AutoDefend.setActionCommand("autodefend");
        this.AutoDefend.addActionListener(this);
        this.menu = new Menu();
        this.menu.setIcon(new Icon("/menu.png"));
        this.menu.setMnemonic(-6);
        this.menu.setActionCommand("menu");
        this.menu.addActionListener(this);
        this.menu.setName("ActionbarMenuButton");
        this.gobutton = new Button(" "){

            protected boolean getDefaultEnabled() {
                return false;
            }
        };
        this.gobutton.setName("GoButton");
        this.gobutton.setPreferredSize(this.gobutton.getFont().getWidth("WWWWWWWWWWW"), -1);
        this.gobutton.setActionCommand("go");
        this.gobutton.addActionListener(this);
        this.note = new Button(" "){

            protected boolean getDefaultEnabled() {
                return false;
            }
        };
        this.note.setName("GoNote");
        this.note.setHorizontalAlignment(1);
        this.note.setActionCommand("go");
        this.note.addActionListener(this);
        this.cardsbutton = new Button();
        this.cardsbutton.setName("CardsButton");
        this.cardsbutton.setToolTipText(resb.getProperty("game.button.cards"));
        this.cardsbutton.setActionCommand("cards");
        this.cardsbutton.addActionListener(this);
        this.missionbutton = new Button();
        this.missionbutton.setName("HintButton");
        this.missionbutton.setToolTipText(resb.getProperty("game.button.mission"));
        this.missionbutton.setActionCommand("mission");
        this.missionbutton.addActionListener(this);
        Panel gamecontrol = new Panel(new BorderLayout());
        gamecontrol.setName("TransPanel");
        this.closebutton = new Button();
        this.closebutton.setIcon(new Icon("/back.png"));
        this.closebutton.setName("ActionbarBackButton");
        this.closebutton.setMnemonic(-11);
        this.closebutton.setActionCommand("close");
        this.closebutton.addActionListener(this);
        gamecontrol.add((Component)this.closebutton, 4);
        Option[] options = new Option[]{new Option(String.valueOf(0), resb.getProperty("game.tabs.continents")), new Option(String.valueOf(1), resb.getProperty("game.tabs.ownership")), new Option(String.valueOf(2), resb.getProperty("game.tabs.borderthreat")), new Option(String.valueOf(3), resb.getProperty("game.tabs.cardownership")), new Option(String.valueOf(4), resb.getProperty("game.tabs.troopstrength")), new Option(String.valueOf(5), resb.getProperty("game.tabs.connectedempire"))};
        this.mapViewControl = new ViewChooser(options);
        this.mapViewControl.addActionListener(this);
        this.mapViewControl.setActionCommand("mapViewChanged");
        gamecontrol.add(this.mapViewControl);
        gamecontrol.add((Component)this.menu, 8);
        Panel mainWindow = new Panel(new BorderLayout());
        this.scroll = new ScrollPane(this.pp){
            private final int ARROW_COLOR;
            private Font font;
            {
                this.ARROW_COLOR = PicturePanel.colorWithAlpha(-1, 200);
            }

            public void repaint() {
                Window w = this.getWindow();
                if (w != null) {
                    w.repaint();
                }
            }

            public void paintComponent(Graphics2D g) {
                if (!GameWindow.this.isErrorShowing()) {
                    Vector players = GameWindow.this.myrisk.getGame().getPlayers();
                    Player current = GameWindow.this.myrisk.getGame().getCurrentPlayer();
                    g.setFont(this.font);
                    int x = this.font.getHeight();
                    int y = this.font.getHeight();
                    for (Player p : players) {
                        g.setColor(p.getColor());
                        String emoji = p.isAlive() ? (p.getType() == 0 ? "\ud83e\uddd1" : "\ud83e\udd16") : (p.getType() == 0 ? "\ud83d\udc80" : "\ud83d\uddd1");
                        String text = emoji + " " + p.getName() + " - " + p.getCards().size();
                        g.drawString(text, x, y);
                        if (p == current) {
                            int offset = x + this.font.getWidth(text) + x / 2;
                            MoveDialog.drawArrow(g, offset + (int)((double)x * 1.5), offset, y, y + x, this.ARROW_COLOR);
                        }
                        y += x;
                    }
                }
            }

            public void updateUI() {
                super.updateUI();
                this.font = this.theme.getFont(0);
            }
        };
        this.scroll.setClip(false);
        mainWindow.add(this.scroll);
        mainWindow.add((Component)gamecontrol, 16);
        mainWindow.add((Component)this.makeBottomPanel(), 32);
        Panel contentPane = new Panel(new BorderLayout());
        contentPane.add(mainWindow);
        this.setContentPane(contentPane);
    }

    private Panel makeBottomPanel() {
        Panel bottom = new Panel(new BorderLayout());
        int g = XULLoader.adjustSizeToDensity(2);
        Panel gamepanel2 = new Panel(new GridBagLayout(3, g, g, g, g, g));
        gamepanel2.setName("TransPanel");
        GridBagConstraints gc = new GridBagConstraints();
        gc.rowSpan = 2;
        gamepanel2.add((Component)this.cardsbutton, gc);
        GridBagConstraints gc1 = new GridBagConstraints();
        gc1.rowSpan = 2;
        gc1.halign = "left";
        gc1.weightx = 1;
        gamepanel2.add((Component)this.missionbutton, gc1);
        GridBagConstraints gc2 = new GridBagConstraints();
        gamepanel2.add((Component)this.note, gc2);
        gamepanel2.add((Component)this.gobutton, gc2);
        bottom.add((Component)new PlayersPanel(), 16);
        bottom.add(gamepanel2);
        return bottom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startGame(final boolean localGame) {
        this.localGame = localGame;
        String mapFile = this.myrisk.getGame().getMapFile();
        logger.log(Level.INFO, "Starting new game: {0}", mapFile);
        this.closebutton.setToolTipText(GameWindow.getLeaveCloseText(localGame));
        boolean retry = false;
        boolean error = this.isErrorShowing();
        if (!error) {
            LoadingManager.showLoadingScreen(true);
        }
        try {
            this.pp.load();
            if (error) {
                this.scroll.removeAll();
                this.scroll.add(this.pp);
                this.scroll.revalidate();
            }
        }
        catch (Throwable ex) {
            File file;
            System.gc();
            String text = ex instanceof OutOfMemoryError ? "Not enough memory to load map: " + mapFile + " " + ex : "Error loading map: " + mapFile + " " + ex + (ex.getCause() != null ? " " + ex.getCause() : "") + (error ? " TWO ERRORS!!" : "") + "\nThis may be caused by your operator or wifi re-compressing or changing the images,Please try and re-download this map on a different wifi network.\nIf this does not help then please email a screenshot of this error to: yura@yura.net\n";
            TextArea ta = new TextArea(text);
            ta.setName("Label");
            ta.setLineWrap(true);
            ta.setFocusable(false);
            this.scroll.removeAll();
            this.scroll.add(ta);
            this.scroll.revalidate();
            if (!error && ex instanceof PicturePanel.CountryNotFoundException && (file = new File(MiniUtil.getSaveMapDir(), mapFile)).exists()) {
                System.out.println("deleting file: " + file + " date: " + new Date(file.lastModified()));
                file.delete();
                RiskUtil.streamOpener.getMap(mapFile, new Observer(){

                    public void update(Observable o, Object arg) {
                        if (arg == RiskUtil.SUCCESS) {
                            if (GameWindow.this.myrisk.getGame() != null) {
                                GameWindow.this.startGame(localGame);
                            }
                        } else {
                            OptionPane.showMessageDialog(null, "error downloading map", null, 0);
                        }
                    }
                });
                retry = true;
            }
            logger.log(retry || ex instanceof OutOfMemoryError ? Level.INFO : Level.WARNING, text, ex);
        }
        finally {
            if (!retry) {
                LoadingManager.showLoadingScreen(false);
            }
        }
        this.note.setText(resb.getString("game.pleasewait"));
        this.mapViewControl.resetMapView();
        Button[] buttons = new Button[]{this.savebutton, this.AutoEndGo, this.AutoDefend, this.undobutton, this.gobutton};
        for (int c = 0; c < buttons.length; ++c) {
            buttons[c].setFocusable(false);
        }
        this.cardsbutton.setFocusable(this.myrisk.getSingleLocalHumanPlayer() != null);
    }

    private boolean isErrorShowing() {
        return this.pp != this.scroll.getView();
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (Application.getPlatform() == 10 || Application.getPlatform() == 12) {
            Application.openURL("wakelock://" + b);
        }
        if (!b) {
            if (this.cardsDialog != null) {
                this.cardsDialog.setVisible(false);
            }
            if (this.tacMove != null) {
                this.tacMove.setVisible(false);
            }
        }
    }

    @Override
    public void actionPerformed(String actionCommand) {
        if (!"go".equals(actionCommand) || this.gameState != 2) {
            GameSound.INSTANCE.playSound("button");
        }
        if ("go".equals(actionCommand)) {
            this.goOn();
        } else if ("mapViewChanged".equals(actionCommand)) {
            this.pp.repaintCountries(this.getMapView());
            this.pp.repaint();
        } else if ("menu".equals(actionCommand)) {
            if (this.myrisk.getGame().getCurrentPlayer() != null) {
                this.AutoEndGo.setSelected(this.myrisk.getAutoEndGo());
                this.AutoDefend.setSelected(this.myrisk.getAutoDefend());
            }
            this.menu.removeAll();
            if (this.localGame) {
                this.menu.add(this.savebutton);
            }
            if (Application.getPlatform() == 10 || Application.getPlatform() == 12) {
                this.menu.add(this.graphbutton);
            }
            if (this.localGame) {
                this.menu.add(this.undobutton);
            }
            this.menu.add(this.options);
            this.menu.add(this.AutoEndGo);
            this.menu.add(this.AutoDefend);
            this.controller.addExtraButtons(this.menu);
        } else if ("save".equals(actionCommand)) {
            final TextField saveText = new TextField();
            saveText.setText(MiniUtil.getSaveGameName(this.myrisk.getGame()));
            Button ok = new Button((String)DesktopPane.get("okText"));
            ok.setActionCommand("ok");
            Button send = new Button(resb.getProperty("game.menu.send"));
            send.setActionCommand("send");
            Button cancel = new Button((String)DesktopPane.get("cancelText"));
            cancel.setActionCommand("cancel");
            cancel.setMnemonic(-7);
            OptionPane.showOptionDialog(new ActionListener(){

                public void actionPerformed(String actionCommand) {
                    String name = JavaCompatUtil.replaceAll(JavaCompatUtil.replaceAll(saveText.getText(), "/", "-"), "\\", "-");
                    String filePath = new File(MiniUtil.getSaveGameDir(), name + ".save").toString();
                    if ("ok".equals(actionCommand)) {
                        GameWindow.this.go("savegame " + filePath);
                    } else if ("send".equals(actionCommand)) {
                        try {
                            GameWindow.this.myrisk.parserAndWait("savegame " + filePath);
                            String url = "mailto:yura@yura.net?subject=" + Url.encode("Saved game") + "&attachment=" + Url.encode(filePath) + "&authority=" + Url.encode("net.yura.domination.fileprovider");
                            Application.openURL(url);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }, saveText, resb.getProperty("game.menu.save"), 0, 3, null, new Button[]{ok, send, cancel}, ok);
        } else if ("cards".equals(actionCommand)) {
            this.openCards();
        } else if ("undo".equals(actionCommand)) {
            this.pp.setC1(255);
            this.pp.setC2(255);
            this.go("undo");
        } else if ("autoendgo".equals(actionCommand)) {
            this.go("autoendgo " + (this.AutoEndGo.isSelected() ? "on" : "off"));
        } else if ("autodefend".equals(actionCommand)) {
            this.go("autodefend " + (this.AutoDefend.isSelected() ? "on" : "off"));
        } else if ("help".equals(actionCommand)) {
            MiniUtil.openHelp();
        } else if ("close".equals(actionCommand)) {
            if (this.controller.shouldShowClosePrompt()) {
                GameWindow.showClosePrompt(this.myrisk);
            } else {
                this.go("closegame");
            }
        } else if ("mission".equals(actionCommand)) {
            Object[] message;
            String missionTitle = resb.getProperty("core.showmission.mission");
            Element html = new Element("html", new Element("p", this.status), this.myrisk.showHumanCurrentPlayerInfo() ? new Element("p", new Element("b", missionTitle), new Element("br"), this.myrisk.getHumanPlayerMission()) : new Element("p", resb.getString("game.pleasewaitnetwork")));
            if (Application.getPlatform() == 10) {
                message = GameWindow.toString(html);
            } else {
                Component continentsPanel = XHTMLLoader.load(RiskUtil.asHTML(this.myrisk.getGame().getContinents()), this);
                message = new Object[]{GameWindow.toString(html), "<html><b>" + resb.getString("swing.button.continents") + "</b></html>", continentsPanel};
            }
            Button ok = new Button((String)DesktopPane.get("okText"));
            ok.setActionCommand("dismissInfo");
            Button help = new Button(resb.getProperty("game.menu.manual"));
            help.setActionCommand("help");
            OptionPane.showOptionDialog(this, message, resb.getProperty("swing.menu.help"), 0, 1, null, new Button[]{help, ok}, ok);
        } else if (!"dismissInfo".equals(actionCommand)) {
            if ("graph".equals(actionCommand)) {
                if (Application.getPlatform() == 10) {
                    Application.openURL("nativeNoResult://net.yura.domination.android.StatsActivity");
                } else if (Application.getPlatform() == 12) {
                    Application.openURL("native://net.yura.domination.ios.StatsViewController");
                }
            } else if ("options".equals(actionCommand)) {
                if (Application.getPlatform() == 10) {
                    Application.openURL("nativeNoResult://net.yura.domination.android.GamePreferenceActivity");
                } else {
                    GamePreferences.showGamePreferences();
                }
            } else {
                throw new IllegalArgumentException("unknown command " + actionCommand);
            }
        }
    }

    void openCards() {
        this.cardsDialog = new CardsDialog(this.myrisk, this.pp){

            public void setVisible(boolean b) {
                super.setVisible(b);
                if (!b) {
                    GameWindow.this.cardsDialog = null;
                }
            }
        };
        Player human = this.myrisk.getSingleLocalHumanPlayer();
        Player currentPlayer = this.myrisk.getGame().getCurrentPlayer();
        if (human == null) {
            human = currentPlayer;
        }
        this.cardsDialog.setup(human, human == currentPlayer && this.gameState == 1);
        this.cardsDialog.setVisible(true);
    }

    static String toString(Element element) {
        try {
            Document doc = new Document();
            doc.setEncoding("UTF-8");
            doc.addChild(element);
            StringWriter writer = new StringWriter();
            KXmlSerializer makeXml = new KXmlSerializer();
            makeXml.setOutput(writer);
            doc.write(makeXml);
            makeXml.flush();
            String text = writer.toString();
            return text.substring(text.indexOf("?>") + 2);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void showClosePrompt(final Risk myrisk) {
        OptionPane.showOptionDialog(new ActionListener(){

            public void actionPerformed(String actionCommand) {
                if ("ok".equals(actionCommand)) {
                    myrisk.parser("closegame");
                }
            }
        }, resb.getProperty("game.areyousurequit"), GameWindow.getLeaveCloseText(myrisk.getLocalGame()), 2, 3, null, null, null);
    }

    static String getLeaveCloseText(boolean locagame) {
        return resb.getProperty(locagame ? "game.menu.close" : "game.menu.leave");
    }

    void setGameStatus(String state) {
        this.status = state;
    }

    public void needInput(int s) {
        this.gameState = s;
        String goButtonText = null;
        String noteText = null;
        boolean mustTrade = false;
        switch (this.gameState) {
            case 1: {
                this.pp.setC1(255);
                this.pp.setC2(255);
                noteText = this.getArmiesLeftText();
                if (this.myrisk.getGame().canEndTrade()) {
                    goButtonText = resb.getProperty("game.button.go.endtrade");
                    break;
                }
                mustTrade = true;
                break;
            }
            case 2: {
                goButtonText = resb.getProperty("game.button.go.autoplace");
                noteText = this.getArmiesLeftText();
                break;
            }
            case 3: {
                this.pp.setC1(255);
                this.pp.setC2(255);
                noteText = resb.getProperty("game.note.selectattacker");
                goButtonText = resb.getProperty("game.button.go.endattack");
                break;
            }
            case 6: {
                noteText = resb.getProperty("game.note.selectsource");
                goButtonText = resb.getProperty("game.button.go.nomove");
                break;
            }
            case 7: {
                goButtonText = resb.getProperty("game.button.go.endgo");
                break;
            }
            case 8: {
                noteText = resb.getProperty("game.over");
                this.checkIfPlayerUnlockedAchievement();
                if (this.myrisk.getGame().canContinue()) {
                    goButtonText = resb.getProperty("game.button.go.continue");
                    break;
                }
                if (this.localGame) {
                    goButtonText = resb.getProperty("game.button.go.closegame");
                    break;
                }
                goButtonText = resb.getProperty("game.button.go.leavegame");
                break;
            }
            case 9: {
                noteText = resb.getProperty("core.help.selectcapital");
                goButtonText = null;
                break;
            }
        }
        this.setGoButtonText(goButtonText);
        this.note.setText(noteText == null ? " " : noteText);
        this.cardsbutton.setName(mustTrade ? "MustTradeButton" : "CardsButton");
        if (this.gameState != 10) {
            this.cardsbutton.setFocusable(true);
            if (this.localGame) {
                this.undobutton.setFocusable(true);
                this.savebutton.setFocusable(true);
            }
            this.AutoEndGo.setFocusable(true);
            this.AutoEndGo.setSelected(this.myrisk.getAutoEndGo());
            this.AutoDefend.setFocusable(true);
            this.AutoDefend.setSelected(this.myrisk.getAutoDefend());
        }
        this.repaint();
        if (this.isFocused() && DominationMain.getBoolean("show_toasts", false)) {
            GameWindow.toast(this.status);
        }
    }

    void checkIfPlayerUnlockedAchievement() {
        Vector players;
        RiskGame game;
        if (this.myrisk.getLocalGame() && "luca.map".equals((game = this.myrisk.getGame()).getMapFile()) && (players = game.getPlayers()).size() == 6) {
            int hard;
            int average;
            int easy;
            HashMap<Integer, List<Player>> map = new HashMap<Integer, List<Player>>();
            for (Player player : players) {
                int type = player.getType();
                ArrayList<Player> pl = (ArrayList<Player>)map.get(type);
                if (pl == null) {
                    pl = new ArrayList<Player>();
                    map.put(type, pl);
                }
                pl.add(player);
            }
            if (GameWindow.getPlayerCount(map, 0) == 1 && this.myrisk.getWinner().getType() == 0 && (easy = GameWindow.getPlayerCount(map, 1)) + (average = GameWindow.getPlayerCount(map, 4)) + (hard = GameWindow.getPlayerCount(map, 2)) == 5) {
                int difficulty;
                if (easy > 0) {
                    difficulty = 1;
                } else if (average > 0) {
                    difficulty = 4;
                } else if (hard > 0) {
                    difficulty = 2;
                } else {
                    throw new IllegalStateException();
                }
                GameWindow.unlockAchievement(game.getGameMode(), game.getCardMode(), difficulty);
            }
        }
    }

    private static int getPlayerCount(Map<Integer, List<Player>> map, int type) {
        List<Player> players = map.get(type);
        return players == null ? 0 : players.size();
    }

    private static void unlockAchievement(int gameMode, int cardMode, int difficulty) {
        DominationMain.GooglePlayGameServices ncl = DominationMain.getGooglePlayGameServices();
        if (ncl != null) {
            if (gameMode == 2) {
                if (difficulty == 1) {
                    if (cardMode == 0) {
                        ncl.unlockAchievement(EASY_INCREASING_CAPITAL);
                    } else if (cardMode == 1) {
                        ncl.unlockAchievement(EASY_FIXED_CAPITAL);
                    } else if (cardMode == 2) {
                        ncl.unlockAchievement(EASY_ITALIAN_CAPITAL);
                    }
                } else if (difficulty == 4) {
                    if (cardMode == 0) {
                        ncl.unlockAchievement(AVERAGE_INCREASING_CAPITAL);
                    } else if (cardMode == 1) {
                        ncl.unlockAchievement(AVERAGE_FIXED_CAPITAL);
                    } else if (cardMode == 2) {
                        ncl.unlockAchievement(AVERAGE_ITALIAN_CAPITAL);
                    }
                } else if (difficulty == 2) {
                    if (cardMode == 0) {
                        ncl.unlockAchievement(HARD_INCREASING_CAPITAL);
                    } else if (cardMode == 1) {
                        ncl.unlockAchievement(HARD_FIXED_CAPITAL);
                    } else if (cardMode == 2) {
                        ncl.unlockAchievement(HARD_ITALIAN_CAPITAL);
                    }
                }
            } else if (gameMode == 0) {
                if (difficulty == 1) {
                    if (cardMode == 0) {
                        ncl.unlockAchievement(EASY_INCREASING_DOMINATION);
                    } else if (cardMode == 1) {
                        ncl.unlockAchievement(EASY_FIXED_DOMINATION);
                    } else if (cardMode == 2) {
                        ncl.unlockAchievement(EASY_ITALIAN_DOMINATION);
                    }
                } else if (difficulty == 4) {
                    if (cardMode == 0) {
                        ncl.unlockAchievement(AVERAGE_INCREASING_DOMINATION);
                    } else if (cardMode == 1) {
                        ncl.unlockAchievement(AVERAGE_FIXED_DOMINATION);
                    } else if (cardMode == 2) {
                        ncl.unlockAchievement(AVERAGE_ITALIAN_DOMINATION);
                    }
                } else if (difficulty == 2) {
                    if (cardMode == 0) {
                        ncl.unlockAchievement(HARD_INCREASING_DOMINATION);
                    } else if (cardMode == 1) {
                        ncl.unlockAchievement(HARD_FIXED_DOMINATION);
                    } else if (cardMode == 2) {
                        ncl.unlockAchievement(HARD_ITALIAN_DOMINATION);
                    }
                }
            }
        }
    }

    private void setGoButtonText(String goButtonText) {
        if (this.gobutton != null) {
            if (goButtonText != null) {
                this.note.setFocusable(true);
                this.gobutton.setFocusable(true);
                this.gobutton.setText(goButtonText);
            } else {
                this.note.setFocusable(false);
                this.gobutton.setFocusable(false);
                this.gobutton.setText(" ");
            }
        }
    }

    public String getArmiesLeftText() {
        int l = this.myrisk.getGame().getCurrentPlayer().getExtraArmies();
        return JavaCompatUtil.replaceAll(resb.getString("game.note.armiesleft"), "{0}", String.valueOf(l));
    }

    private void goOn() {
        if (this.gameState == 1) {
            this.go("endtrade");
        } else if (this.gameState == 2) {
            GameSound.INSTANCE.playSound("place_army");
            this.go("autoplace");
        } else if (this.gameState == 3) {
            this.pp.setC1(255);
            this.go("endattack");
        } else if (this.gameState == 6) {
            this.pp.setC1(255);
            this.go("nomove");
        } else if (this.gameState == 7) {
            this.go("endgo");
        } else if (this.gameState == 8) {
            if (this.myrisk.getGame().canContinue()) {
                this.go("continue");
            } else {
                this.go("closegame");
            }
        } else if (this.gameState == 9) {
            int c1Id = this.pp.getC1();
            this.pp.setC1(255);
            this.go("capital " + c1Id);
        }
    }

    private void go(String input) {
        this.pp.setHighLight(255);
        if (this.gameState != 2 || !this.myrisk.getGame().getSetupDone()) {
            this.noInput();
        }
        this.myrisk.parser(input);
    }

    public void noInput() {
        if (this.tacMove != null) {
            this.tacMove.setVisible(false);
        }
        this.cardsbutton.setFocusable(this.myrisk.getSingleLocalHumanPlayer() != null);
        this.undobutton.setFocusable(false);
        this.savebutton.setFocusable(false);
        this.AutoEndGo.setFocusable(false);
        this.AutoDefend.setFocusable(false);
        this.setGoButtonText(null);
        this.note.setText(resb.getString("game.pleasewait"));
        this.gameState = 0;
        this.repaint();
    }

    public void mapClick(int[] countries, boolean rightClick) {
        if (this.gameState == 2) {
            if (countries.length == 1) {
                if (rightClick) {
                    GameSound.INSTANCE.playSound("place_armies");
                    this.go("placearmies " + countries[0] + " 10");
                } else {
                    GameSound.INSTANCE.playSound("place_army");
                    this.go("placearmies " + countries[0] + " 1");
                }
            }
        } else if (this.gameState == 3) {
            if (countries.length == 0) {
                this.note.setText(resb.getProperty("game.note.selectattacker"));
            } else if (countries.length == 1) {
                this.note.setText(resb.getProperty("game.note.selectdefender"));
            } else {
                GameSound.INSTANCE.playSound("attack");
                this.go("attack " + countries[0] + " " + countries[1]);
                this.note.setText(" ");
            }
        } else if (this.gameState == 6) {
            if (countries.length == 0) {
                this.note.setText(resb.getProperty("game.note.selectsource"));
            } else if (countries.length == 1) {
                this.note.setText(resb.getProperty("game.note.selectdestination"));
            } else {
                this.note.setText(" ");
                this.tacMove = new MoveDialog(this.myrisk){

                    public void setVisible(boolean b) {
                        super.setVisible(b);
                        if (!b) {
                            GameWindow.this.tacMove = null;
                            GameWindow.this.pp.setC1(255);
                            GameWindow.this.pp.setC2(255);
                            GameWindow.this.note.setText(this.resb.getProperty("game.note.selectsource"));
                        }
                    }
                };
                Image c1img = this.pp.getCountryImage(countries[0]);
                Image c2img = this.pp.getCountryImage(countries[1]);
                this.tacMove.setupMove(1, countries[0], countries[1], c1img, c2img, true);
                this.tacMove.setVisible(true);
            }
        } else if (this.gameState == 9) {
            this.note.setText(resb.getProperty("game.note.happyok"));
            this.setGoButtonText(resb.getProperty("game.button.go.ok"));
        }
    }

    public int getMapView() {
        return Integer.parseInt(this.mapViewControl.getSelectedItem().getKey());
    }

    public void mapRedrawRepaint(boolean redrawNeeded, boolean repaintNeeded) {
        if (this.pp != null) {
            if (redrawNeeded) {
                this.pp.repaintCountries(this.getMapView());
            }
            if (repaintNeeded) {
                this.pp.repaint();
            }
        }
    }

    static void toast(String message) {
        if (Display.getDisplay(Application.getInstance()).getCurrent() != null) {
            if (Application.getPlatform() == 10) {
                Application.openURL("toast://show?message=" + Url.encode(message) + "&duration=SHORT");
            } else {
                DesktopPane.getDesktopPane().toast(message);
            }
        }
    }

    public static XULLoader getPanel(String xmlfile, ActionListener al) {
        XULLoader loader;
        InputStream data = Application.getResourceAsStream(xmlfile);
        try {
            loader = XULLoader.load(data, al, resb);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            RiskUtil.close(data);
        }
        return loader;
    }

    class PlayersPanel
    extends Component {
        PlayersPanel() {
        }

        protected String getDefaultName() {
            return "PlayersPanel";
        }

        protected boolean getDefaultEnabled() {
            return false;
        }

        public void paintComponent(Graphics2D g) {
            int[] colors = GameWindow.this.myrisk.getPlayerColors();
            int w = XULLoader.adjustSizeToDensity(28);
            int x = 0;
            for (int c = 0; c < colors.length; ++c) {
                g.setColor(PicturePanel.colorWithAlpha(colors[c], 150));
                int ww = c == 0 ? this.width - w * (colors.length - 1) : w;
                g.fillRect(x, 0, ww, this.height);
                x += ww;
            }
        }

        protected void workoutMinimumSize() {
            this.width = 10;
            this.height = XULLoader.adjustSizeToDensity(5);
        }
    }
}

