/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.mobile.flashgui;

import android.graphics.ColorMatrix;
import javax.microedition.lcdui.Image;
import net.yura.domination.engine.ColorUtil;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.core.Player;
import net.yura.domination.mobile.PicturePanel;
import net.yura.domination.mobile.flashgui.ColorPicker;
import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.Application;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.cellrenderer.DefaultListCellRenderer;
import net.yura.mobile.gui.components.List;
import net.yura.mobile.gui.layout.XULLoader;

public class PlayerList
extends List {
    final ColorMatrix invert = new ColorMatrix(new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 255.0f, 0.0f, -1.0f, 0.0f, 0.0f, 255.0f, 0.0f, 0.0f, -1.0f, 0.0f, 255.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f});
    private Risk risk;

    public PlayerList() {
        this.setLayoutOrientation(3);
        this.setCellRenderer(new DefaultListCellRenderer(){
            int playerType;
            Image human;
            Image ai_easy;
            Image ai_average;
            Image ai_hard;
            {
                this.setName("PlayerListRenderer");
                this.padding = XULLoader.adjustSizeToDensity(4);
                this.human = Application.createImage("/type_human.png");
                this.ai_easy = Application.createImage("/type_ai_easy.png");
                this.ai_average = Application.createImage("/type_ai_average.png");
                this.ai_hard = Application.createImage("/type_ai_hard.png");
            }

            public void setValue(Object obj) {
                Player player = (Player)obj;
                this.setBackground(player.getColor());
                this.setToolTipText(player.getName());
                this.playerType = player.getType();
            }

            public void paintComponent(Graphics2D g) {
                Image typeIcon;
                super.paintComponent(g);
                int color = this.getBackground();
                Image img = PicturePanel.getIconForColor(color);
                if (img != null) {
                    int iconSize;
                    int h = iconSize = this.getWidth() - this.padding;
                    int w = (int)((double)img.getWidth() * ((double)h / (double)img.getHeight()));
                    g.drawScaledImage(img, (this.getWidth() - w) / 2, (this.getHeight() - h) / 2, w, h);
                }
                switch (this.playerType) {
                    case 0: 
                    case 3: {
                        typeIcon = this.human;
                        break;
                    }
                    case 1: {
                        typeIcon = this.ai_easy;
                        break;
                    }
                    case 4: {
                        typeIcon = this.ai_average;
                        break;
                    }
                    case 2: {
                        typeIcon = this.ai_hard;
                        break;
                    }
                    default: {
                        typeIcon = null;
                    }
                }
                int foreground = ColorUtil.getTextColorFor(color);
                if (typeIcon != null) {
                    boolean doInvert;
                    boolean bl = doInvert = foreground == -1;
                    if (doInvert) {
                        g.getGraphics().setColorMatrix(PlayerList.this.invert);
                    }
                    int iconSize = this.getWidth() / 2;
                    g.drawScaledImage(typeIcon, (this.getWidth() - iconSize) / 2, (this.getHeight() - iconSize) / 2, iconSize, iconSize);
                    if (doInvert) {
                        g.getGraphics().setColorMatrix(null);
                    }
                }
                if ((this.getCurrentState() & 4) != 0) {
                    int padding = XULLoader.adjustSizeToDensity(5);
                    g.setColor(foreground);
                    int oldStroke = g.getGraphics().getStrokeWidth();
                    g.getGraphics().setStrokeWidth(Math.max(1, XULLoader.adjustSizeToDensity(1)));
                    g.drawRect(padding, padding, this.getWidth() - padding * 2, this.getHeight() - padding * 2);
                    g.getGraphics().setStrokeWidth(oldStroke);
                }
            }
        });
        this.addActionListener(new ActionListener(){

            public void actionPerformed(String actionCommand) {
                final Player player = (Player)PlayerList.this.getSelectedValue();
                if (player != null) {
                    final ColorPicker colorPicker = new ColorPicker();
                    colorPicker.showDialog(new ActionListener(){

                        public void actionPerformed(String actionCommand) {
                            if ("ok".equals(actionCommand)) {
                                PlayerList.this.setPlayerColor(player, colorPicker.getSelectedColor());
                            }
                        }
                    }, player.getName());
                }
            }
        });
    }

    private void setPlayerColor(Player player, int color) {
        if (player.getColor() != color) {
            Player playerWithColor = this.getPlayerByColor(color);
            if (playerWithColor == null) {
                player.setColor(color);
                this.repaint();
            } else {
                playerWithColor.setColor(player.getColor());
                player.setColor(color);
                this.repaint();
            }
        }
    }

    private Player getPlayerByColor(int color) {
        for (Player player : this.risk.getGame().getPlayers()) {
            if (player.getColor() != color) continue;
            return player;
        }
        return null;
    }

    protected void workoutMinimumSize() {
        int screen;
        int size = XULLoader.adjustSizeToDensity(75);
        size = size > (screen = (DesktopPane.getDesktopPane().getWidth() - XULLoader.adjustSizeToDensity(10)) / 6) ? screen : size;
        this.setFixedCellWidth(size);
        this.setFixedCellHeight(size);
        super.workoutMinimumSize();
    }

    public void setGame(Risk risk) {
        this.risk = risk;
    }

    public int getSize() {
        return this.risk.getGame().getNoPlayers();
    }

    public Object getElementAt(int index) {
        return this.risk.getGame().getPlayers().get(index);
    }
}

