/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.mobile.simplegui;

import java.util.Vector;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskAdapter;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.ai.AIManager;
import net.yura.domination.mobile.MiniUtil;
import net.yura.domination.mobile.PicturePanel;
import net.yura.domination.mobile.simplegui.GamePanel;
import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.KeyEvent;
import net.yura.mobile.gui.border.LineBorder;
import net.yura.mobile.gui.components.Button;
import net.yura.mobile.gui.components.CheckBox;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.Frame;
import net.yura.mobile.gui.components.Label;
import net.yura.mobile.gui.components.Menu;
import net.yura.mobile.gui.components.MenuBar;
import net.yura.mobile.gui.components.OptionPane;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.components.ScrollPane;
import net.yura.mobile.gui.components.TextArea;
import net.yura.mobile.gui.components.TextField;
import net.yura.mobile.gui.layout.BorderLayout;
import net.yura.mobile.gui.layout.GridBagConstraints;
import net.yura.mobile.gui.layout.GridBagLayout;

public class GameFrame
extends Frame {
    private static final String version = "1.1.1.1";
    private static final String product = "Simple GUI for RISK";
    private TextArea Console;
    private TextField Command;
    private Button Submit;
    private CheckBox autoPlay;
    private PicturePanel pp;
    private Label statusBar;
    private Label gameStatus;
    private ScrollPane Con;
    private Risk risk;
    private Vector history;
    private int pointer;
    private String temptext;
    private Panel guiMain;
    private Panel gp;
    private Label Pix;
    private GamePanel gamecontrol;

    public GameFrame(Risk r) {
        this.risk = r;
        this.gameStatus = new Label("");
        this.gameStatus.setPreferredSize(200, -1);
        this.history = new Vector();
        this.pointer = -1;
        this.Console = new TextArea("AAAAAAAA");
        this.Submit = new Button();
        this.Pix = new Label("Hello!");
        this.pp = new PicturePanel(this.risk);
        this.gp = new Panel(new BorderLayout());
        this.gamecontrol = new GamePanel(this.risk, this.pp);
        this.gp.add((Component)this.gamecontrol, 16);
        this.gp.add(this.pp);
        this.statusBar = new Label("Loading...");
        this.Con = new ScrollPane(this.Console);
        this.statusBar.setText("Ready");
        this.Command = new TextField(){

            public boolean processKeyEvent(KeyEvent key) {
                if (key.isDownAction(1) || key.isDownAction(6) || key.justReleasedAction(1) || key.justReleasedAction(6)) {
                    if (key.justReleasedAction(1)) {
                        if (GameFrame.this.pointer >= 0) {
                            if (GameFrame.this.pointer == GameFrame.this.history.size() - 1) {
                                GameFrame.this.temptext = GameFrame.this.Command.getText();
                            }
                            GameFrame.this.Command.setText((String)GameFrame.this.history.elementAt(GameFrame.this.pointer));
                            GameFrame.this.pointer--;
                        }
                    } else if (key.justReleasedAction(6) && GameFrame.this.pointer <= GameFrame.this.history.size() - 2) {
                        if (GameFrame.this.pointer == GameFrame.this.history.size() - 2) {
                            GameFrame.this.Command.setText(GameFrame.this.temptext);
                            GameFrame.this.pointer++;
                        } else {
                            GameFrame.this.pointer = GameFrame.this.pointer + 2;
                            GameFrame.this.Command.setText((String)GameFrame.this.history.elementAt(GameFrame.this.pointer));
                            GameFrame.this.pointer--;
                        }
                    }
                    return true;
                }
                GameFrame.this.pointer = GameFrame.this.history.size() - 1;
                return super.processKeyEvent(key);
            }
        };
        this.initGUI();
        RiskAdapter SimpleRiskAdapter = new RiskAdapter(){

            public void sendMessage(final String output, final boolean redrawNeeded, final boolean repaintNeeded) {
                DesktopPane.invokeLater(new Runnable(){

                    public void run() {
                        GameFrame.this.Console.append(output + "\n");
                        if (GameFrame.this.Console.getHeight() > 10000) {
                            GameFrame.this.Console.setText("");
                        }
                        if (redrawNeeded) {
                            GameFrame.this.pp.repaintCountries(GameFrame.this.gamecontrol.getMapView());
                        }
                        if (repaintNeeded) {
                            GameFrame.this.repaint();
                        }
                    }
                });
            }

            public void needInput(int s) {
                GameFrame.this.Submit.setFocusable(true);
                GameFrame.this.Command.setFocusable(true);
                GameFrame.this.Command.requestFocusInWindow();
                GameFrame.this.statusBar.setText("Done... Ready");
                if (s == 8 && GameFrame.this.autoPlay.isSelected()) {
                    GameFrame.this.risk.parser("closegame");
                }
            }

            public void noInput() {
                GameFrame.this.statusBar.setText("Working...");
                GameFrame.this.Submit.setFocusable(false);
                GameFrame.this.Command.setFocusable(false);
            }

            public void setGameStatus(String state) {
                GameFrame.this.gameStatus.setText(state);
                GameFrame.this.gameStatus.repaint();
            }

            public void startGame(boolean s) {
                try {
                    GameFrame.this.pp.load();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                GameFrame.this.gamecontrol.resetMapView();
                GameFrame.this.guiMain.remove(GameFrame.this.Pix);
                GameFrame.this.guiMain.add(GameFrame.this.gp);
                GameFrame.this.guiMain.revalidate();
                GameFrame.this.guiMain.repaint();
            }

            public void closeGame() {
                GameFrame.this.guiMain.remove(GameFrame.this.gp);
                GameFrame.this.guiMain.add(GameFrame.this.Pix);
                GameFrame.this.guiMain.revalidate();
                GameFrame.this.guiMain.repaint();
                if (GameFrame.this.autoPlay.isSelected()) {
                    GameFrame.this.autoPlay();
                }
            }
        };
        this.risk.addRiskListener(SimpleRiskAdapter);
    }

    private void initGUI() {
        this.setTitle(product);
        this.getContentPane().setLayout(new GridBagLayout(2, 3, 3, 3, 3, 3));
        this.pp.setPreferredSize(677, 425);
        this.pp.setBorder(new LineBorder(-16777216, 1));
        this.Console.setText("");
        this.Console.setFocusable(false);
        this.Con.setPreferredSize(200, 100);
        this.Command.setPreferredSize(200, 20);
        this.Submit.setText("Submit");
        this.guiMain = new Panel();
        this.guiMain.setPreferredSize(200, 200);
        this.guiMain.setLayout(new BorderLayout());
        this.guiMain.add(this.Pix);
        GridBagConstraints c = new GridBagConstraints();
        c.colSpan = 2;
        c.rowSpan = 2;
        c.weightx = 1;
        c.weighty = 1;
        this.getContentPane().add((Component)this.guiMain, c);
        c = new GridBagConstraints();
        c.colSpan = 2;
        c.rowSpan = 1;
        this.getContentPane().add((Component)this.Con, c);
        c = new GridBagConstraints();
        c.colSpan = 1;
        c.rowSpan = 1;
        c.weightx = 1;
        this.getContentPane().add((Component)this.Command, c);
        c = new GridBagConstraints();
        c.colSpan = 1;
        c.rowSpan = 1;
        this.getContentPane().add((Component)this.Submit, c);
        c = new GridBagConstraints();
        c.colSpan = 1;
        c.rowSpan = 1;
        this.getContentPane().add((Component)this.gameStatus, c);
        c = new GridBagConstraints();
        c.colSpan = 1;
        c.rowSpan = 1;
        this.getContentPane().add((Component)this.statusBar, c);
        ActionListener readCommand = new ActionListener(){

            public void actionPerformed(String a) {
                String input = GameFrame.this.Command.getText();
                GameFrame.this.Command.setText("");
                GameFrame.this.history.add(input);
                GameFrame.this.pointer = GameFrame.this.history.size() - 1;
                GameFrame.this.go(input);
            }
        };
        this.Submit.addActionListener(readCommand);
        this.Command.addActionListener(readCommand);
        MenuBar menuBar = new MenuBar();
        Menu menuFile = new Menu("File");
        menuFile.setMnemonic(70);
        Menu menuHelp = new Menu("Help");
        menuHelp.setMnemonic(72);
        Button Commands = new Button("Commands");
        Commands.setMnemonic(67);
        Commands.addActionListener(new ActionListener(){

            public void actionPerformed(String e) {
                GameFrame.this.Commands();
            }
        });
        menuHelp.add(Commands);
        Button helpMan = new Button("Manual");
        helpMan.setMnemonic(77);
        helpMan.addActionListener(new ActionListener(){

            public void actionPerformed(String e) {
                GameFrame.this.go("manual");
            }
        });
        menuHelp.add(helpMan);
        Button helpAbout = new Button("About");
        helpAbout.setMnemonic(65);
        helpAbout.addActionListener(new ActionListener(){

            public void actionPerformed(String e) {
                GameFrame.this.openAbout();
            }
        });
        menuHelp.add(helpAbout);
        Menu menuClear = new Menu("Clear");
        menuClear.setMnemonic(67);
        Button ClearConsole = new Button("Clear Console");
        ClearConsole.setMnemonic(67);
        ClearConsole.addActionListener(new ActionListener(){

            public void actionPerformed(String e) {
                GameFrame.this.Console.setText("");
            }
        });
        menuClear.add(ClearConsole);
        Button ClearHistory = new Button("Clear History");
        ClearHistory.setMnemonic(72);
        ClearHistory.addActionListener(new ActionListener(){

            public void actionPerformed(String e) {
                GameFrame.this.history.clear();
                GameFrame.this.pointer = -1;
            }
        });
        menuClear.add(ClearHistory);
        Button openFile = new Button("Run Script");
        openFile.setMnemonic(82);
        openFile.addActionListener(new ActionListener(){

            public void actionPerformed(String e) {
            }
        });
        menuFile.add(openFile);
        Button saveFile = new Button("Save Console");
        saveFile.setMnemonic(83);
        saveFile.addActionListener(new ActionListener(){

            public void actionPerformed(String e) {
            }
        });
        menuFile.add(saveFile);
        this.autoPlay = new CheckBox("AutoPlay", true);
        menuFile.add(this.autoPlay);
        Button fileExit = new Button("Exit");
        fileExit.setMnemonic(69);
        fileExit.addActionListener(new ActionListener(){

            public void actionPerformed(String e) {
                GameFrame.this.exitForm();
            }
        });
        menuFile.add(fileExit);
        menuBar.add(menuFile);
        menuBar.add(menuClear);
        menuBar.add(menuHelp);
        this.setMenuBar(menuBar);
        AIManager.setWait(5);
        if (this.autoPlay.isSelected()) {
            this.autoPlay();
        }
    }

    private void exitForm() {
        System.exit(0);
    }

    private void autoPlay() {
        this.risk.parser("newgame");
        this.risk.parser("newplayer ai hard blue bob");
        this.risk.parser("newplayer ai hard red fred");
        this.risk.parser("newplayer ai hard green greg");
        this.risk.parser("startgame domination increasing");
    }

    public void go(String input) {
        if (input.equals("exit")) {
            this.exitForm();
        } else if (input.equals("help")) {
            this.Commands();
        } else if (input.equals("about")) {
            this.openAbout();
        } else if (input.equals("clear")) {
            this.Console.setText("");
        } else if (input.equals("manual")) {
            try {
                RiskUtil.openDocs("help/index_commands.htm");
            }
            catch (Exception e) {
                OptionPane.showMessageDialog(null, "Unable to open manual: " + e.getMessage(), "Error", 0);
            }
        } else {
            this.risk.parser(input);
        }
    }

    public void Commands() {
    }

    public void openAbout() {
        MiniUtil.showAbout();
    }
}

