/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.mobile.simplegui;

import net.yura.domination.engine.ColorUtil;
import net.yura.domination.engine.Risk;
import net.yura.domination.mobile.MiniUtil;
import net.yura.domination.mobile.PicturePanel;
import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.border.LineBorder;
import net.yura.mobile.gui.components.Button;
import net.yura.mobile.gui.components.ComboBox;
import net.yura.mobile.gui.components.Label;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.layout.FlowLayout;

public class GamePanel
extends Panel {
    private ComboBox mapViewComboBox;
    private Risk risk;

    public GamePanel(Risk trisk, final PicturePanel pp) {
        this.risk = trisk;
        this.setLayout(new FlowLayout());
        Label mapLookLabel = new Label("Map Look:");
        this.mapViewComboBox = new ComboBox();
        Button closegame = new Button("closegame");
        Button about = new Button("About");
        this.mapViewComboBox.setPreferredSize(150, 20);
        this.mapViewComboBox.addItem("Continents");
        this.mapViewComboBox.addItem("Ownership");
        this.mapViewComboBox.addItem("Border Threat");
        this.mapViewComboBox.addItem("Risk Card Ownership");
        this.mapViewComboBox.addItem("Troop Strength");
        this.mapViewComboBox.addItem("Connected Empire");
        this.mapViewComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(String a) {
                pp.repaintCountries(GamePanel.this.getMapView());
                pp.repaint();
            }
        });
        Label playersLabel = new Label("Players:");
        PlayersPanel players = new PlayersPanel();
        players.setBorder(new LineBorder(-16777216, 1));
        players.setPreferredSize(120, 20);
        closegame.addActionListener(new ActionListener(){

            public void actionPerformed(String a) {
                GamePanel.this.risk.parser("closegame");
            }
        });
        about.addActionListener(new ActionListener(){

            public void actionPerformed(String a) {
                MiniUtil.showAbout();
            }
        });
        this.setPreferredSize(677, 30);
        this.add(mapLookLabel);
        this.add(this.mapViewComboBox);
        this.add(playersLabel);
        this.add(players);
        this.add(closegame);
        this.add(about);
    }

    public int getMapView() {
        int tmp = this.mapViewComboBox.getSelectedIndex();
        int newview = -1;
        switch (tmp) {
            case 0: {
                newview = 0;
                break;
            }
            case 1: {
                newview = 1;
                break;
            }
            case 2: {
                newview = 2;
                break;
            }
            case 3: {
                newview = 3;
                break;
            }
            case 4: {
                newview = 4;
                break;
            }
            case 5: {
                newview = 5;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return newview;
    }

    public void resetMapView() {
        this.mapViewComboBox.setSelectedIndex(0);
    }

    class PlayersPanel
    extends Panel {
        PlayersPanel() {
        }

        public void paintComponent(Graphics2D g) {
            int[] colors = GamePanel.this.risk.getPlayerColors();
            for (int c = 0; c < colors.length; ++c) {
                g.setColor(colors[c]);
                g.fillRect(120 / colors.length * c, 0, 120 / colors.length, 20);
            }
            g.setColor(ColorUtil.getTextColorFor(colors[0]));
            g.drawRect(2, 2, 120 / colors.length - 5, 15);
            g.setColor(-16777216);
            g.drawLine(120 / colors.length - 1, 0, 120 / colors.length - 1, 19);
        }
    }
}

