/*
 * Decompiled with CFR 0.152.
 */
package net.yura.lobby.mini;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import net.yura.domination.engine.ColorUtil;
import net.yura.lobby.mini.MiniLobbyClient;
import net.yura.lobby.model.Game;
import net.yura.lobby.model.Player;
import net.yura.lobby.util.TimeoutUtil;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.cellrenderer.DefaultListCellRenderer;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.TextArea;
import net.yura.mobile.gui.layout.XULLoader;
import net.yura.swingme.core.AnalogClock;

public class GameRenderer
extends DefaultListCellRenderer {
    AnalogClock clock = new AnalogClock();
    MiniLobbyClient lobby;
    ScaledIcon sicon;
    Icon privateGame;
    Game game;
    String line1;
    String line2;
    String part2;
    Component list;

    public GameRenderer(MiniLobbyClient l) {
        this.lobby = l;
        this.setName("ListRendererCollapsed");
        this.sicon = new ScaledIcon(XULLoader.adjustSizeToDensity(75), XULLoader.adjustSizeToDensity(47));
        int size = XULLoader.adjustSizeToDensity(25);
        this.clock.setSize(size, size);
        this.clock.setBackground(0xFFFFFF);
        this.padding = XULLoader.adjustSizeToDensity(2);
        this.gap = XULLoader.adjustSizeToDensity(2);
        this.privateGame = new Icon("/ms_private_game.png");
    }

    public Component getListCellRendererComponent(Component list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component c = super.getListCellRendererComponent(list, null, index, isSelected, cellHasFocus);
        this.list = list;
        this.game = (Game)value;
        this.sicon.setIcon(this.lobby.game.getIconForGame(this.game));
        this.setIcon(this.sicon);
        long time = (long)this.game.getTimeout() * 1000L;
        Calendar _now = Calendar.getInstance();
        _now.setTimeZone(TimeZone.getTimeZone("GMT"));
        _now.setTime(new Date(time));
        this.clock.setTime(_now);
        this.clock.setVisible(time != 0L);
        this.line1 = this.lobby.game.getGameDescription(this.game);
        if (time != 0L) {
            this.line1 = TimeoutUtil.formatPeriod(time) + " " + this.line1;
        }
        if (this.lobby.playerType >= 4) {
            ArrayList<String> playerStrings = new ArrayList<String>();
            for (Player player : this.game.getPlayers()) {
                playerStrings.add(GameRenderer.toAdminString(player));
            }
            String players = ((Object)playerStrings).toString();
            this.line2 = players + " " + this.game.getName();
        } else {
            this.line2 = this.game.getPlayers() + " " + this.game.getName();
        }
        this.setVerticalTextPosition("".equals(this.line2) ? 2 : 16);
        this.part2 = this.game.getNumOfPlayers() + "/" + this.game.getMaxPlayers();
        return c;
    }

    public static String toAdminString(Player player) {
        String icon;
        switch (player.getType()) {
            case 5: {
                icon = "\ud83d\udd34";
                break;
            }
            case 4: {
                icon = "\ud83d\udfe3";
                break;
            }
            case 3: {
                icon = "\ud83d\udd35";
                break;
            }
            case 2: {
                icon = "\ud83d\udfe2";
                break;
            }
            case 1: {
                icon = "\ud83d\udfe1";
                break;
            }
            case -1: {
                icon = "\ud83d\udea9";
                break;
            }
            case -2: {
                icon = "\u26d4";
                break;
            }
            default: {
                icon = "\u26aa";
            }
        }
        return icon + player.getName();
    }

    public int getFixedCellHeight() {
        return this.padding * 2 + Math.max(this.sicon.getIconHeight(), this.getFont().getHeight() * 2 + this.gap + this.padding * 2);
    }

    public void paintComponent(Graphics2D g) {
        int wh;
        int color;
        String action;
        super.paintComponent(g);
        int offsetx = this.padding + this.getIcon().getIconWidth() + this.gap;
        g.setFont(this.font);
        g.setColor(this.getForeground());
        if (this.clock.isVisible()) {
            int offsety = this.padding;
            this.clock.setForeground(this.getForeground());
            g.translate(offsetx, offsety);
            this.clock.paint(g);
            g.translate(-offsetx, -offsety);
            offsetx = offsetx + this.clock.getWidth() + this.padding;
        }
        g.drawString(this.line1, offsetx, this.padding * 2);
        offsetx = this.padding + this.getIcon().getIconWidth() + this.gap;
        int state = this.getCurrentState();
        if ((state & 4) == 0 && (state & 8) == 0) {
            this.list.setState(2);
            g.setColor(this.list.getForeground());
            this.list.setState(-1);
        }
        int offsety = this.getHeight() - this.font.getHeight() - this.padding;
        int space = this.getWidth() - offsetx - this.font.getWidth("10/10");
        String drawString = this.font.getWidth(this.line2) > space ? this.line2.substring(0, TextArea.searchStringCharOffset(this.line2, this.font, space)) + extension : this.line2;
        g.drawString(drawString, offsetx, offsety);
        g.drawString(this.part2, this.getWidth() - this.font.getWidth(this.part2) - this.padding, this.getHeight() - this.font.getHeight() - this.padding);
        int gameState = this.game.getState(this.lobby.whoAmI());
        switch (gameState) {
            case 1: {
                action = this.lobby.resBundle.getString("lobby.game.join");
                color = -16711936;
                break;
            }
            case 2: {
                action = this.lobby.resBundle.getString("lobby.game.leave");
                color = -65536;
                break;
            }
            case 4: {
                action = this.lobby.resBundle.getString("lobby.game.play");
                color = -16776961;
                break;
            }
            case 3: {
                action = this.lobby.resBundle.getString("lobby.game.watch");
                color = -1118482;
                break;
            }
            default: {
                action = null;
                color = 0;
            }
        }
        int actionx = this.getWidth();
        if (action != null) {
            int w = this.font.getWidth(action);
            int h = this.font.getHeight();
            g.setColor(color);
            actionx = this.getWidth() - w - this.padding * 3;
            g.fillRoundRect(actionx, this.padding, w + this.padding * 2, h + this.padding * 2, 5, 5);
            g.setColor(ColorUtil.getTextColorFor(color));
            g.drawString(action, this.getWidth() - w - this.padding * 2, this.padding * 2);
        }
        if ((gameState == 1 || gameState == 2) && this.game.getMagicWord() != null) {
            wh = this.privateGame.getIconHeight();
            this.privateGame.paintIcon(this, g, actionx - wh - this.padding, (this.getHeight() - wh) / 2);
        }
        if (this.lobby.whoAmI().equals(this.game.getWhosTurn())) {
            wh = this.font.getHeight();
            g.setColor(-65536);
            g.fillOval(actionx - wh - this.padding, (this.getHeight() - wh) / 2, wh, wh);
        }
    }

    public static class ScaledIcon
    extends Icon {
        Icon icon;

        public ScaledIcon(int w, int h) {
            this.width = w;
            this.height = h;
        }

        public void setIcon(Icon i) {
            this.icon = i;
        }

        public void paintIcon(Component c, Graphics2D g, int x, int y) {
            g.translate(x, y);
            double sx = (double)this.width / (double)this.icon.getIconWidth();
            double sy = (double)this.height / (double)this.icon.getIconHeight();
            g.getGraphics().scale(sx, sy);
            this.icon.paintIcon(c, g, 0, 0);
            g.getGraphics().scale(1.0 / sx, 1.0 / sy);
            g.translate(-x, -y);
        }
    }
}

