/*
 * Decompiled with CFR 0.152.
 */
package net.yura.swingme.core;

import net.yura.mobile.gui.Application;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.Label;
import net.yura.mobile.gui.components.ProgressBar;
import net.yura.mobile.gui.components.Window;
import net.yura.mobile.logging.Logger;
import net.yura.mobile.util.Url;

public class LoadingScreen {
    private static Window instance;

    public static void show(String message) {
        if (Application.getPlatform() == 10) {
            Application.openURL("nativeNoResult://net.yura.android.LoadingDialog?message=" + Url.encode(message));
            return;
        }
        if (instance == null) {
            instance = new Window();
            instance.setName("OpaqueDialog");
            ProgressBar bar = new ProgressBar();
            bar.setIndeterminate(true);
            instance.add(bar);
            instance.add((Component)new Label(message), 8);
            instance.pack();
            instance.setLocationRelativeTo(null);
        }
        if (!instance.isVisible()) {
            instance.setVisible(true);
        }
    }

    public static void hide() {
        if (Application.getPlatform() == 10) {
            Application app = Application.getInstance();
            if (app != null) {
                try {
                    app.platformRequest("nativeNoResult://net.yura.android.LoadingDialog?command=hide");
                }
                catch (Exception ex) {
                    if (LoadingScreen.hasMessage(ex, "AndroidME default activity is null")) {
                        Logger.info("unable to hide!", ex);
                    }
                    Logger.warn("unable to hide!", ex);
                }
            }
            return;
        }
        Window window = instance;
        if (window != null) {
            window.setVisible(false);
        }
        instance = null;
    }

    private static boolean hasMessage(Throwable ex, String message) {
        while (ex != null) {
            if (ex.getMessage() != null && ex.getMessage().contains(message)) {
                return true;
            }
            ex = ex.getCause();
        }
        return false;
    }
}

