/*
 * Decompiled with CFR 0.152.
 */
package net.yura.lobby.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.yura.lobby.client.Connection;
import net.yura.lobby.client.eyecandy.TranslucentJPanel;
import net.yura.lobby.client.eyecandy.TranslucentJScrollPane;
import net.yura.lobby.client.eyecandy.TranslucentJTextArea;
import net.yura.lobby.client.eyecandy.TranslucentJTextField;

public class ChatBox
extends TranslucentJPanel
implements ActionListener {
    public static final int NO_GAME = -1;
    private String playerName;
    private int id = -1;
    private Connection mycom;
    private JTextArea chat;
    private JTextField chatInput;
    private JLabel header;

    public ChatBox() {
        super(0.5f);
        this.setLayout(new BorderLayout());
        this.chat = new TranslucentJTextArea(0.4f);
        this.chat.setEditable(false);
        this.chat.setWrapStyleWord(true);
        this.chat.setLineWrap(true);
        this.chatInput = new TranslucentJTextField(0.0f);
        this.chatInput.setActionCommand("send");
        this.chatInput.addActionListener(this);
        TranslucentJPanel inchat = new TranslucentJPanel((LayoutManager)new BorderLayout(), 0.1f);
        JButton chatSend = new JButton("Send");
        chatSend.setActionCommand("send");
        chatSend.addActionListener(this);
        inchat.add(this.chatInput);
        inchat.add((Component)chatSend, "East");
        this.header = new JLabel();
        this.add((Component)this.header, "North");
        this.add(new TranslucentJScrollPane(this.chat, 0.0f));
        this.add((Component)inchat, "South");
    }

    public ChatBox(Connection con, String playerName, int id) {
        this();
        this.reset(con, playerName, id);
    }

    public int getChatRoomId() {
        return this.id;
    }

    public void reset(Connection con, String playerName, int roomId) {
        this.mycom = con;
        this.chat.setText("");
        this.id = roomId;
        this.setPlayerName(playerName);
    }

    public void setPlayerName(String playerName) {
        this.playerName = playerName;
        this.header.setText(this.playerName != null ? " Chat with: " + this.playerName : " Chat:");
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("send")) {
            String text = this.chatInput.getText();
            if (!"".equals(text)) {
                if (this.playerName != null) {
                    this.incomingChat("me", text);
                    this.mycom.sendPrivateChat(this.playerName, text);
                } else {
                    this.mycom.sendChat(this.id, text);
                }
                this.chatInput.setText("");
            }
        } else {
            System.err.println("unknown command " + ae.getActionCommand());
        }
    }

    public void incomingChat(String player, String message) {
        if (player == null) {
            this.chat.append("*" + message + "*\n");
        } else {
            this.chat.append(player + ": " + message + "\n");
        }
        this.chat.setCaretPosition(this.chat.getDocument().getLength());
    }
}

