/*
 * Decompiled with CFR 0.152.
 */
package net.yura.lobby.client;

import java.applet.Applet;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import net.yura.grasshopper.BugManager;
import net.yura.lobby.client.ChatBox;
import net.yura.lobby.client.Connection;
import net.yura.lobby.client.LobbyClient;
import net.yura.lobby.client.LobbyCom;
import net.yura.lobby.client.LobbyGame;
import net.yura.lobby.client.LobbyGameChatListener;
import net.yura.lobby.client.PlayerInfoWindow;
import net.yura.lobby.client.PlayerList;
import net.yura.lobby.client.eyecandy.TranslucentJButton;
import net.yura.lobby.client.eyecandy.TranslucentJPanel;
import net.yura.lobby.client.eyecandy.TranslucentJScrollPane;
import net.yura.lobby.client.eyecandy.TranslucentJTable;
import net.yura.lobby.client.eyecandy.TranslucentJTree;
import net.yura.lobby.model.Game;
import net.yura.lobby.model.GameType;
import net.yura.lobby.model.Player;
import net.yura.lobby.util.TimeoutUtil;

public class LobbyClientGUI
extends JPanel
implements ActionListener,
LobbyClient,
TreeSelectionListener {
    private static final String appName = "LobbySwingGUI";
    private static final String appVersion = "1";
    private static String CONFIG_FILENAME = "LobbyClient.conf";
    private static final String NOTLOGGEDIN_PANEL = "notlogged";
    private static final String LOGGEDIN_PANEL = "logged";
    public static final int DEFAULT_PORT = 1964;
    private CardLayout cardlayout;
    private JPanel playersactions;
    private JButton adminButton;
    private JButton onlineState;
    private BufferedImage backpic;
    private BufferedImage logopic;
    private ImageIcon backpicIcon;
    private ImageIcon privateGameIcon;
    private Color themeColor;
    private JTree gameTypes;
    private JTable games;
    private GameTableModel gamesModel;
    private JComponent glass;
    private JInternalFrame logbox;
    private JInternalFrame loadingbox;
    private JTextArea connectlog;
    private Connection mycom;
    private Map lobbyGamePool;
    private Map activegames;
    private Map privatechats;
    private String myusername;
    private int playerType;
    private JLabel myusernameLabel;
    private ChatBox chatwindow;
    private PlayerList playerswindow;
    private JPanel messages;
    private static Applet applet;
    private static URL codeBase;
    private Preferences prefs = null;
    private final int GAME_COL = 1;
    private Properties config;
    private static Thread loadFileThread;
    private static URL inputFileName;
    private static InputStream inputFileStream;
    private String adminUsername;
    private Map playerinfo;
    private String server;
    private int port;
    private List messagesVector = new Vector();

    public LobbyClientGUI(Applet a, URL cb) {
        String uuid;
        applet = a;
        codeBase = cb;
        loadFileThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                        return;
                    }
                }
                while (true) {
                    try {
                        inputFileStream = inputFileName.openStream();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    var1_1 = this;
                    synchronized (var1_1) {
                        URL ex = inputFileName;
                        synchronized (ex) {
                            inputFileName.notify();
                        }
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ex2) {
                            ex2.printStackTrace();
                            return;
                        }
                    }
                }
            }
        };
        loadFileThread.start();
        super.setVisible(false);
        this.config = new Properties();
        this.config.setProperty("default.port", String.valueOf(1964));
        this.config.setProperty("default.host", "lobby.yura.net");
        this.config.setProperty("default.mode", "debug");
        try {
            this.config.load(new URL(cb, CONFIG_FILENAME).openStream());
            uuid = this.config.getProperty("uuid");
            if (uuid == null) {
                if (applet == null) {
                    throw new RuntimeException("config file has no uuid");
                }
                uuid = UUID.randomUUID().toString();
            }
        }
        catch (Exception ex) {
            uuid = UUID.randomUUID().toString();
            this.config.setProperty("uuid", uuid);
            try {
                this.config.store(new FileOutputStream(CONFIG_FILENAME), "Lobby Client Config file");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.backpic = ImageIO.read(this.getClass().getResource("back.jpg"));
            this.logopic = ImageIO.read(this.getClass().getResource("logo.png"));
            this.backpicIcon = new ImageIcon(this.backpic);
            this.themeColor = Color.RED;
            this.privateGameIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("privateGame.png")));
        }
        catch (Exception e) {
            throw new RuntimeException("cant find default images", e);
        }
        this.setLobbyArt(this.config.getProperty("default.back"), this.config.getProperty("default.logo"), this.config.getProperty("default.color"));
        try {
            this.prefs = Preferences.userNodeForPackage(this.getClass());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.lobbyGamePool = new HashMap();
        this.activegames = new HashMap();
        this.privatechats = new HashMap();
        this.setLayout(new BorderLayout());
        JSplitPane top = new JSplitPane();
        JSplitPane bottom = new JSplitPane();
        JSplitPane main = new JSplitPane(0);
        main.setTopComponent(top);
        main.setBottomComponent(bottom);
        main.setResizeWeight(0.9);
        this.add(main);
        LobbyClientGUI.getRidOfColor(main);
        LobbyClientGUI.getRidOfColor(top);
        LobbyClientGUI.getRidOfColor(bottom);
        this.gameTypes = new TranslucentJTree(0.4f);
        this.gameTypes.setRootVisible(false);
        this.gameTypes.addTreeSelectionListener(this);
        this.gameTypes.setCellRenderer(new TreeRenderer());
        this.gamesModel = new GameTableModel();
        this.games = new TranslucentJTable(this.gamesModel, 0.5f){

            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                if (c instanceof JComponent) {
                    JComponent jc = (JComponent)c;
                    Game game = (Game)LobbyClientGUI.this.gamesModel.getDataVector().get(row);
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("<html>");
                    buffer.append("Description: ");
                    try {
                        buffer.append(LobbyClientGUI.this.getLobbyGame(game.getType(), false).getGameDescription(game.getOptions()));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        buffer.append(ex.toString());
                    }
                    buffer.append("<br>");
                    buffer.append("ID: ");
                    buffer.append(game.getId());
                    buffer.append("<br>");
                    buffer.append("WhosTurn: ");
                    buffer.append(game.getWhosTurn());
                    buffer.append("<br>");
                    buffer.append("Players: ");
                    for (Player player : game.getPlayers()) {
                        buffer.append("<img src=\"");
                        buffer.append(PlayerList.getPlayerIcon(player));
                        buffer.append("\"/>");
                        buffer.append(player);
                        buffer.append(" ");
                    }
                    jc.setToolTipText(buffer.toString());
                    if (!(jc instanceof TranslucentJButton || game.getWhosTurn() == null || "".equals(game.getWhosTurn()) || game.getPlayers().contains(new Player(game.getWhosTurn(), 0)))) {
                        jc.setBackground(Color.RED);
                        jc.setOpaque(true);
                    }
                }
                return c;
            }
        };
        this.gamesModel.addTableModelListener(this.games);
        this.games.getTableHeader().setReorderingAllowed(false);
        this.games.getTableHeader().setOpaque(false);
        this.games.getTableHeader().setDefaultRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (c instanceof JLabel) {
                    JLabel label = new JLabel(((JLabel)c).getText());
                    label.setOpaque(false);
                    label.setHorizontalAlignment(0);
                    if (column == table.getColumnCount()) {
                        label.setBorder(BorderFactory.createLineBorder(Color.BLACK));
                    } else {
                        label.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, Color.BLACK));
                    }
                    return label;
                }
                return c;
            }
        });
        this.games.setSelectionMode(2);
        this.games.getColumnModel().getColumn(0).setMaxWidth(32);
        this.games.getColumnModel().getColumn(3).setMaxWidth(50);
        this.games.getColumnModel().getColumn(4).setMaxWidth(50);
        this.games.getColumnModel().getColumn(5).setMaxWidth(50);
        this.games.getColumnModel().getColumn(6).setMaxWidth(50);
        this.games.getColumn("Action").setCellRenderer(new ButtonRenderer());
        this.games.getColumn("Action").setCellEditor(new ButtonEditor());
        this.games.getColumn("Players").setCellRenderer(new ListRenderer());
        this.games.getColumn("Players").setCellEditor(new ListEditor(this));
        String DELETE = "del";
        int condition = 2;
        InputMap inputMap = this.games.getInputMap(condition);
        ActionMap actionMap = this.games.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(127, 0), DELETE);
        inputMap.put(KeyStroke.getKeyStroke(8, 0), DELETE);
        actionMap.put(DELETE, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (LobbyClientGUI.this.playerType >= 3) {
                    int result;
                    int c;
                    int[] selections = LobbyClientGUI.this.games.getSelectedRows();
                    Game[] gamesToRemove = new Game[selections.length];
                    int startedGameCount = 0;
                    for (c = 0; c < selections.length; ++c) {
                        gamesToRemove[c] = LobbyClientGUI.this.gamesModel.getGame(selections[c]);
                        Game game = gamesToRemove[c];
                        if (game.getNumOfPlayers() != game.getMaxPlayers()) continue;
                        ++startedGameCount;
                    }
                    if (startedGameCount > 0 && (result = JOptionPane.showConfirmDialog(LobbyClientGUI.this, "are you sure, " + startedGameCount + " game is started!", "Delete Game?", 2)) != 0) {
                        return;
                    }
                    for (c = 0; c < gamesToRemove.length; ++c) {
                        LobbyClientGUI.this.mycom.delGame(gamesToRemove[c].getId());
                    }
                }
            }
        });
        this.games.setRowHeight(20);
        this.games.setTransferHandler(new TableTransferHandler());
        TranslucentJPanel gametypewindow = new TranslucentJPanel((LayoutManager)new BorderLayout(), 0.5f);
        gametypewindow.add((Component)new JLabel(" Game Types:"), "North");
        gametypewindow.add(new TranslucentJScrollPane(this.gameTypes, 0.0f));
        JButton newgamebutton = new JButton("New Game");
        newgamebutton.setActionCommand("newgame");
        newgamebutton.addActionListener(this);
        TranslucentJPanel gameactionspanel = new TranslucentJPanel(0.0f);
        gameactionspanel.add(newgamebutton);
        TranslucentJPanel gameswindow = new TranslucentJPanel((LayoutManager)new BorderLayout(), 0.5f);
        gameswindow.add((Component)new JLabel(" Games:"), "North");
        gameswindow.add(new TranslucentJScrollPane(this.games, 0.2f));
        gameswindow.add((Component)gameactionspanel, "South");
        JButton loginbutton = new JButton("Login");
        loginbutton.setActionCommand("login");
        loginbutton.addActionListener(this);
        JButton registerbutton = new JButton("Register");
        registerbutton.setActionCommand("register");
        registerbutton.addActionListener(this);
        JButton logoutButton = new JButton("Logout");
        logoutButton.setActionCommand("logout");
        logoutButton.addActionListener(this);
        JButton editmyinfoButton = new JButton("My Info");
        editmyinfoButton.setActionCommand("editinfo");
        editmyinfoButton.addActionListener(this);
        JButton editmyinfoButton2 = new JButton("My Info");
        editmyinfoButton2.setActionCommand("editinfo");
        editmyinfoButton2.addActionListener(this);
        this.adminButton = new JButton("Admin");
        this.adminButton.setActionCommand("admin");
        this.adminButton.addActionListener(this);
        this.playersactions = new TranslucentJPanel(0.0f);
        this.cardlayout = new CardLayout();
        this.playersactions.setLayout(this.cardlayout);
        JPanel notloggedinPanel = new JPanel();
        notloggedinPanel.setOpaque(false);
        notloggedinPanel.add(loginbutton);
        notloggedinPanel.add(registerbutton);
        notloggedinPanel.add(editmyinfoButton);
        JPanel loggedinPanel = new JPanel();
        loggedinPanel.setOpaque(false);
        loggedinPanel.add(logoutButton);
        loggedinPanel.add(editmyinfoButton2);
        loggedinPanel.add(this.adminButton);
        this.playersactions.add((Component)notloggedinPanel, NOTLOGGEDIN_PANEL);
        this.playersactions.add((Component)loggedinPanel, LOGGEDIN_PANEL);
        this.playerswindow = new PlayerList(this);
        this.playerswindow.add((Component)this.playersactions, "South");
        top.setLeftComponent(gametypewindow);
        top.setRightComponent(gameswindow);
        this.mycom = new LobbyCom(uuid, appName, appVersion);
        String wait = this.config.getProperty("wait");
        if (wait != null) {
            this.mycom.setWait(Integer.parseInt(wait));
        }
        this.mycom.addEventListener(this);
        this.chatwindow = new ChatBox(this.mycom, null, -1);
        bottom.setLeftComponent(this.chatwindow);
        bottom.setRightComponent(this.playerswindow);
        bottom.setResizeWeight(1.0);
        top.setDividerLocation(120);
        bottom.setDividerLocation(450);
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        main.setBorder(BorderFactory.createEmptyBorder(20, 0, 20, 0));
        this.myusernameLabel = new JLabel();
        TranslucentJPanel topInfoPanel = new TranslucentJPanel(0.5f);
        this.onlineState = new JButton(PlayerList.ICON_GREEN);
        this.onlineState.setBorderPainted(false);
        this.onlineState.setContentAreaFilled(false);
        this.onlineState.setBorder(null);
        this.onlineState.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                LobbyClientGUI.this.onlineState.setToolTipText("sent ping");
                LobbyClientGUI.this.mycom.ping();
            }
        });
        topInfoPanel.add(this.onlineState);
        topInfoPanel.add(new JLabel("you are logged in as:"));
        topInfoPanel.add(this.myusernameLabel);
        JPanel topPanel = new JPanel();
        topPanel.setOpaque(false);
        topPanel.setLayout(new BorderLayout());
        topPanel.add(Box.createHorizontalStrut(330), "West");
        topPanel.add(topInfoPanel);
        topPanel.setPreferredSize(new Dimension(10, 30));
        this.add((Component)topPanel, "North");
        this.messages = new TranslucentJPanel(0.5f);
        this.messages.setLayout(new FlowLayout(3));
        this.messages.add(new JLabel("Messages:"));
        this.messages.setPreferredSize(new Dimension(10, 40));
        this.add((Component)this.messages, "South");
    }

    private LobbyGameChatListener makeListener(final int id) {
        return new LobbyGameChatListener(){

            public void sendGameMessage(String message) {
                LobbyClientGUI.this.sendGameMessage(id, message);
            }

            public void sendChat(String text) {
                LobbyClientGUI.this.mycom.sendChat(id, text);
            }

            public void join() {
                LobbyClientGUI.this.join(id, null);
            }

            public void leave() {
                LobbyClientGUI.this.leave(id);
            }

            public void closeGame() {
                LobbyClientGUI.this.closeGame(id);
            }

            public String whoAmI() {
                return LobbyClientGUI.this.whoAmI();
            }
        };
    }

    public static InputStream openStream(String file) throws IOException {
        return LobbyClientGUI.openStream(new URL(codeBase, file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized InputStream openStream(URL file) throws IOException {
        if (applet != null) {
            inputFileName = file;
            inputFileStream = null;
            URL uRL = inputFileName;
            synchronized (uRL) {
                Thread thread = loadFileThread;
                synchronized (thread) {
                    loadFileThread.notify();
                }
                try {
                    inputFileName.wait();
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
            if (inputFileStream == null) {
                throw new IOException("cant load file: " + file);
            }
            return inputFileStream;
        }
        return file.openStream();
    }

    public static void openURL(URL url) throws Exception {
        System.out.println("OPEN URL: " + url);
    }

    public void paintComponent(Graphics g) {
        int w = this.backpic.getWidth();
        int h = this.backpic.getHeight();
        for (int i = 0; i < this.getWidth(); i += w) {
            for (int j = 0; j < this.getHeight(); j += h) {
                g.drawImage(this.backpic, i, j, this);
            }
        }
        g.drawImage(this.logopic, 0, 0, this);
    }

    public void setHostName(String host, int port) {
        this.config.setProperty("default.host", host);
        this.config.setProperty("default.port", String.valueOf(port));
    }

    public void setLobbyArt(String back, String logo, String color) {
        if (back != null && logo != null && color != null) {
            try {
                this.backpic = ImageIO.read(new URL(codeBase, back));
                this.logopic = ImageIO.read(new URL(codeBase, logo));
                this.backpicIcon = new ImageIcon(this.backpic);
                this.themeColor = Color.decode(color);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void connect() {
        this.connect(this.config.getProperty("default.host"), Integer.parseInt(this.config.getProperty("default.port")));
    }

    public void valueChanged(TreeSelectionEvent e) {
        GameType node = this.getCurrentGameType();
        if (node == null) {
            return;
        }
        this.mycom.getGames(node);
        this.games.removeEditor();
        this.gamesModel.setDataVector(new Vector());
        this.games.setModel(this.gamesModel);
        this.games.clearSelection();
    }

    private GameType getCurrentGameType() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.gameTypes.getLastSelectedPathComponent();
        Object userObject = node == null ? null : node.getUserObject();
        return userObject instanceof GameType ? (GameType)userObject : null;
    }

    private void makeLoginDialog() {
        this.glass = new JPanel(){

            public void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                AlphaComposite ac = AlphaComposite.getInstance(3, 0.5f);
                g2.setComposite(ac);
                g2.setColor(LobbyClientGUI.this.themeColor);
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        };
        this.glass.setOpaque(false);
        this.glass.addMouseListener(new MouseInputAdapter(){});
        this.getRootPane().getLayeredPane().setLayout(new OverlayLayout(this.getRootPane().getLayeredPane()));
        this.loadingbox = new JInternalFrame("loading...");
        JProgressBar loadingbar = new JProgressBar();
        loadingbar.setIndeterminate(true);
        this.loadingbox.getContentPane().add(loadingbar);
        this.logbox = new JInternalFrame("connecting...");
        JPanel cancelpanel = new JPanel();
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(this);
        cancel.setActionCommand("exit");
        cancelpanel.add(cancel);
        this.connectlog = new JTextArea();
        this.connectlog.setEditable(false);
        this.logbox.getContentPane().add(new JScrollPane(this.connectlog));
        this.logbox.getContentPane().add((Component)cancelpanel, "South");
        Dimension d = new Dimension(300, 200);
        this.logbox.setMinimumSize(d);
        this.logbox.setMaximumSize(d);
        this.logbox.setPreferredSize(d);
        d = new Dimension(300, 50);
        this.loadingbox.setMinimumSize(d);
        this.loadingbox.setMaximumSize(d);
        this.loadingbox.setPreferredSize(d);
        this.glass.setVisible(false);
        this.logbox.setVisible(false);
        this.loadingbox.setVisible(false);
        this.getRootPane().getLayeredPane().add((Component)this.glass, JLayeredPane.PALETTE_LAYER);
        this.getRootPane().getLayeredPane().add((Component)this.logbox, JLayeredPane.MODAL_LAYER);
        this.getRootPane().getLayeredPane().add((Component)this.loadingbox, JLayeredPane.MODAL_LAYER);
    }

    private static void getRidOfColor(JSplitPane a) {
        a.setBorder(BorderFactory.createEmptyBorder());
        a.setOpaque(false);
        a.setDividerSize(20);
        a.setContinuousLayout(true);
        a.setUI(new BasicSplitPaneUI(){

            public BasicSplitPaneDivider createDefaultDivider() {
                return new BasicSplitPaneDivider(this){

                    public void paint(Graphics g) {
                    }
                };
            }
        });
    }

    public void setUsername(String username, int type) {
        PlayerInfoWindow piw;
        String oldUsername = this.myusername;
        this.myusername = username;
        this.myusernameLabel.setText(username);
        this.playerType = type;
        this.adminButton.setVisible(this.playerType >= 3);
        this.cardlayout.show(this.playersactions, type == 0 ? NOTLOGGEDIN_PANEL : LOGGEDIN_PANEL);
        PlayerInfoWindow playerInfoWindow = piw = this.playerinfo == null ? null : (PlayerInfoWindow)this.playerinfo.remove(oldUsername);
        if (piw != null) {
            piw.setUsername(this.myusername);
            this.playerinfo.put(this.myusername, piw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent ae) {
        String ac = ae.getActionCommand();
        if (ac.equals("exit")) {
            this.exit();
        } else if (ac.equals("login")) {
            Object[] options;
            int result;
            String username = "";
            String password = "";
            if (this.prefs != null) {
                this.prefs = Preferences.userNodeForPackage(this.getClass());
                username = this.prefs.get("username", null);
                password = this.prefs.get("password", null);
            }
            Object[] message = new Object[]{"user name:", new JTextField(username), "password:", new JPasswordField(password), new JCheckBox("save password")};
            if (this.prefs == null) {
                ((JCheckBox)message[4]).setEnabled(false);
            }
            if (password != null && !"".equals(password)) {
                ((JCheckBox)message[4]).setSelected(true);
            }
            if ((result = JOptionPane.showOptionDialog(this, message, "Login", 2, 3, null, options = new String[]{"OK", "cancel"}, options[0])) == 0) {
                username = ((JTextField)message[1]).getText();
                password = new String(((JPasswordField)message[3]).getPassword());
                this.mycom.login(username, password);
            }
        } else if (ac.equals("register")) {
            Object[] options;
            int result;
            String username = "";
            String email = "";
            String password1 = "";
            String password2 = "";
            boolean savepassword = false;
            Object[] message = new Object[]{"user name:", new JTextField(username), "email:", new JTextField(email), "password:", new JPasswordField(password1), "retype password:", new JPasswordField(password2), new JCheckBox("save password", savepassword)};
            if (this.prefs == null) {
                ((JCheckBox)message[8]).setEnabled(false);
            }
            if ((result = JOptionPane.showOptionDialog(this, message, "Register", 2, 3, null, options = new String[]{"OK", "cancel"}, options[0])) == 0) {
                username = ((JTextField)message[1]).getText();
                email = ((JTextField)message[3]).getText();
                password1 = new String(((JPasswordField)message[5]).getPassword());
                password2 = new String(((JPasswordField)message[7]).getPassword());
                savepassword = ((JCheckBox)message[8]).isSelected();
                this.mycom.register(username, email, password1);
            }
        } else if (ac.equals("logout")) {
            this.mycom.logout();
        } else if (ac.equals("editinfo")) {
            if (this.myusername != null) {
                this.showInfoDialog(this.myusername);
            }
        } else if (ac.equals("admin")) {
            String username;
            Object[] options = new Object[]{"info", "chat", "cancel"};
            Object[] input = new Object[]{"username", new JTextField(this.adminUsername)};
            int result = JOptionPane.showOptionDialog(this, input, "admin", 1, 3, null, options, options[0]);
            String string = username = result == 2 ? null : ((JTextField)input[1]).getText();
            if (username != null && !"".equals(username)) {
                this.adminUsername = username;
                if (result == 0) {
                    this.showInfoDialog(username);
                } else {
                    this.showPrivateChat(username, true);
                }
            }
        } else if (ac.equals("newgame")) {
            GameType gametype = this.getCurrentGameType();
            if (gametype != null) {
                LobbyGame lg;
                this.startLoading();
                try {
                    lg = this.getLobbyGame(gametype, false);
                }
                finally {
                    this.stopLoading();
                }
                Game newGameOptions = lg.newGameDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, this), gametype.getOptions(), this.myusername);
                if (newGameOptions != null) {
                    newGameOptions.setType(gametype);
                    this.mycom.createNewGame(newGameOptions);
                }
            }
        } else {
            System.err.println("LobbyClientGUI unknown command: " + ac);
        }
    }

    public void setUserInfo(String user, List info) {
        PlayerInfoWindow infoWindow = (PlayerInfoWindow)this.playerinfo.get(user);
        infoWindow.updateInfo(info);
    }

    public void showInfoDialog(String user) {
        PlayerInfoWindow infoWindow;
        if (this.playerinfo == null) {
            this.playerinfo = new HashMap();
        }
        if ((infoWindow = (PlayerInfoWindow)this.playerinfo.get(user)) == null) {
            infoWindow = new PlayerInfoWindow(this, this.mycom, false);
            infoWindow.setUsername(user);
            infoWindow.showPanels(user.equals(this.myusername), this.playerType >= 3);
            infoWindow.setSize(500, 450);
            infoWindow.setLocationRelativeTo(this);
            this.playerinfo.put(user, infoWindow);
        }
        infoWindow.setVisible(true);
    }

    private LobbyGame makeLobbyGame(GameType gametype) {
        try {
            ClassLoader ucl = gametype.getClassLoader(codeBase.toString());
            return (LobbyGame)Class.forName(gametype.getClassName(), true, ucl).newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    List getGamePool(GameType gametype) {
        Vector a = (Vector)this.lobbyGamePool.get(gametype);
        if (a == null) {
            a = new Vector();
            this.lobbyGamePool.put(gametype, a);
        }
        return a;
    }

    private LobbyGame getLobbyGame(GameType gametype, boolean fresh) {
        List a = this.getGamePool(gametype);
        if (a.isEmpty()) {
            a.add(this.makeLobbyGame(gametype));
        }
        if (!fresh) {
            return (LobbyGame)a.get(0);
        }
        for (int c = 0; c < a.size(); ++c) {
            LobbyGame z = (LobbyGame)a.get(c);
            if (z.getLobbyGameMoveListener() != null) continue;
            return z;
        }
        LobbyGame game = this.makeLobbyGame(gametype);
        a.add(game);
        return game;
    }

    public static URL getCodeBase() {
        return codeBase;
    }

    public ClassLoader getClassLoader(GameType gameType) {
        return gameType.getClassLoader(codeBase.toString());
    }

    private void stopLoading() {
        this.glass.setVisible(false);
        this.loadingbox.setVisible(false);
    }

    public void error(String s) {
        JOptionPane.showMessageDialog(this, s, "Error", 0);
    }

    public void ping(long time) {
        this.onlineState.setToolTipText("ping " + time + "ms");
    }

    private void exit() {
        if (this.mycom != null) {
            try {
                this.mycom.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (applet == null) {
            System.exit(0);
        }
    }

    public void showConnectingDialog(boolean a) {
        if (this.glass == null) {
            this.makeLoginDialog();
        }
        this.glass.setVisible(a);
        this.logbox.setVisible(a);
    }

    public void disconnected() {
        this.showConnectingDialog(true);
        Iterator games = new HashSet(this.activegames.values()).iterator();
        while (games.hasNext()) {
            ((LobbyGame)games.next()).closegame();
        }
    }

    public void connected() {
        this.mycom.getGameTypes();
        this.showConnectingDialog(false);
    }

    public void connect(String s, int p) {
        this.server = s;
        this.port = p;
        if ("debug".equalsIgnoreCase(this.config.getProperty("default.mode"))) {
            // empty if block
        }
        this.mycom.connect(this.server, this.port);
    }

    public void connecting(String a) {
        this.connectlog.append(a + "\n");
        this.connectlog.setCaretPosition(this.connectlog.getDocument().getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGame(Game game) {
        LobbyGame lg = (LobbyGame)this.activegames.get(game.getId());
        if (lg == null) {
            this.startLoading();
            try {
                int gameId = game.getId();
                GameType gametype = game.getType();
                lg = this.getLobbyGame(gametype, true);
                ChatBox cb = new ChatBox(this.mycom, null, gameId);
                PlayerList pl = new PlayerList(this);
                lg.addLobbyGameMoveListener(this.makeListener(gameId));
                lg.openGame(game, cb, pl);
                this.activegames.put(gameId, lg);
                this.mycom.playGame(game.getId());
            }
            catch (Exception ex) {
                this.error(ex.toString());
                ex.printStackTrace();
            }
            finally {
                this.stopLoading();
            }
        } else {
            System.out.println("game already open: " + game);
            ((Frame)SwingUtilities.getAncestorOfClass(Frame.class, lg.getPlayerList())).toFront();
        }
    }

    private void startLoading() {
        this.glass.setVisible(true);
        this.loadingbox.setVisible(true);
    }

    public ChatBox showPrivateChat(String name, boolean pop) {
        JFrame dialog;
        ChatBox cb = (ChatBox)this.privatechats.get(name);
        if (cb == null) {
            cb = new ChatBox(this.mycom, name, -1);
            this.privatechats.put(name, cb);
            JFrame d = new JFrame("IM with " + name);
            cb.setBorder(BorderFactory.createMatteBorder(20, 20, 20, 20, this.backpicIcon));
            d.getContentPane().add(cb);
            d.setSize(250, 300);
        }
        if ((dialog = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, cb)).isVisible()) {
            if (!dialog.isFocused()) {
                dialog.requestFocus();
            }
        } else if (pop) {
            dialog.setVisible(true);
            dialog.requestFocus();
        } else {
            this.addNewMessage(new Message(name, "Message from player, click to view", null){

                public void action() {
                    dialog.setVisible(true);
                    dialog.requestFocus();
                }
            });
        }
        return cb;
    }

    public void addNewMessage(final Message m) {
        if (this.messagesVector.contains(m)) {
            return;
        }
        final JButton message = new JButton(m.getName());
        message.setIcon(m.getIcon());
        message.setToolTipText(m.getTooltip());
        message.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                m.action();
                LobbyClientGUI.this.messages.remove(message);
                LobbyClientGUI.this.messages.revalidate();
                LobbyClientGUI.this.messages.repaint();
                LobbyClientGUI.this.messagesVector.remove(m);
            }
        });
        this.messages.add(message);
        this.messages.revalidate();
        this.messages.repaint();
        this.messagesVector.add(m);
        ((Frame)SwingUtilities.getAncestorOfClass(Frame.class, this)).requestFocus();
    }

    public void sendGameMessage(int gameid, String message) {
        this.mycom.sendGameMessage(gameid, message);
    }

    public void closeGame(int gameid) {
        this.killGame(gameid);
        this.mycom.closeGame(gameid);
    }

    void killGame(int gameid) {
        LobbyGame gameToLeave = (LobbyGame)this.activegames.remove(gameid);
        gameToLeave.removeLobbyGameMoveListener(gameToLeave.getLobbyGameMoveListener());
    }

    public String whoAmI() {
        return this.myusername;
    }

    public synchronized void incomingChat(int chatid, String player, String message) {
        LobbyGame lg = (LobbyGame)this.activegames.get(chatid);
        if (lg != null) {
            lg.getChatBox().incomingChat(player, message);
        } else {
            System.out.println("ERROR!!!! chat comming in but there is no active game with that id");
        }
    }

    public void incomingChat(String player, String message) {
        this.chatwindow.incomingChat(player, message);
    }

    public void privateMessage(String player, String message) {
        ChatBox cb = this.showPrivateChat(player, false);
        cb.incomingChat(player, message);
    }

    public synchronized void addOrUpdateGame(final Game game) {
        LobbyGame lobbyGame = (LobbyGame)this.activegames.get(game.getId());
        if (lobbyGame != null) {
            lobbyGame.gameUpdate(game);
        } else if (game.getState(this.myusername) == 4) {
            Icon icon = this.getLobbyGame(game.getType(), false).getIcon(game.getOptions(), this.messages);
            this.addNewMessage(new Message(game.toString(), "New Game Started, click to play", icon){
                int id;
                {
                    super(n, t, i);
                    this.id = game.getId();
                }

                public void action() {
                    LobbyClientGUI.this.loadGame(game);
                }

                public boolean equals(Object obj) {
                    return this.getClass().isInstance(obj) && this.id == (this.getClass().cast((Object)obj)).id;
                }
            });
        }
        if (game.getType().equals(this.getCurrentGameType())) {
            Vector gameList = this.gamesModel.getDataVector();
            int index = Collections.binarySearch(gameList, game);
            if (index >= 0) {
                if (this.games.getEditingRow() == index) {
                    this.games.removeEditor();
                }
                gameList.set(index, game);
                this.gamesModel.fireTableRowsUpdated(index, index);
            } else {
                int row = -index - 1;
                int selected = this.games.getSelectedRow();
                int editing = this.games.getEditingRow();
                gameList.add(row, game);
                this.gamesModel.fireTableRowsInserted(row, row);
                if (selected >= row) {
                    this.games.setRowSelectionInterval(selected + 1, selected + 1);
                }
                if (editing >= row) {
                    this.games.setEditingRow(editing + 1);
                }
            }
            this.games.revalidate();
            this.games.repaint();
        }
    }

    public synchronized void addGameType(List list) {
        GameType current = this.getCurrentGameType();
        TreePath found = null;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        for (int c = 0; c < list.size(); ++c) {
            GameType gt = (GameType)list.get(c);
            DefaultMutableTreeNode gtNode = new DefaultMutableTreeNode(gt);
            root.add(gtNode);
            if (!gt.equals(current) && list.size() != 1) continue;
            found = new TreePath(gtNode.getPath());
        }
        DefaultTreeModel gameTypesModel = new DefaultTreeModel(root);
        this.gameTypes.setModel(gameTypesModel);
        if (found != null) {
            this.gameTypes.setSelectionPath(found);
        }
    }

    public synchronized void removeGame(int gameid) {
        Vector gameList = this.gamesModel.getDataVector();
        for (int c = 0; c < gameList.size(); ++c) {
            if (((Game)gameList.get(c)).getId() != gameid) continue;
            int selection = this.games.getSelectedRow();
            int editing = this.games.getEditingRow();
            this.gamesModel.removeRow(c);
            if (selection == c) {
                this.games.clearSelection();
            } else if (selection > c) {
                this.games.setRowSelectionInterval(selection - 1, selection - 1);
            }
            if (editing == c) {
                this.games.removeEditor();
            } else if (editing > c) {
                this.games.setEditingRow(editing - 1);
            }
            this.games.revalidate();
            this.games.repaint();
            return;
        }
    }

    public void gameStarted(int gameId) {
        Vector games = this.gamesModel.getDataVector();
        for (Game game : games) {
            if (game.getId() != gameId) continue;
            this.loadGame(game);
            return;
        }
    }

    public void addPlayer(Player player) {
        this.playerswindow.addSpectator(player);
    }

    public void addPlayer(int chatid, Player player) {
        LobbyGame lg = (LobbyGame)this.activegames.get(chatid);
        if (lg != null) {
            lg.getPlayerList().addSpectator(player);
        } else {
            System.out.println("ERROR!!!! trying to add player when list is not found");
        }
    }

    public void removePlayer(String player) {
        this.playerswindow.removeSpectator(player);
    }

    public void removePlayer(int chatid, String player) {
        LobbyGame lg = (LobbyGame)this.activegames.get(chatid);
        if (lg != null) {
            lg.getPlayerList().removeSpectator(player);
        } else {
            System.out.println("Got Nullpointer while removing player from list[LobbyClientGUI->removePlayer()]");
        }
    }

    public void messageForGame(int gameid, Object object) {
        LobbyGame lg = (LobbyGame)this.activegames.get(gameid);
        if (lg != null) {
            lg.gameMessage(object);
        } else {
            System.out.println("got command for game " + gameid + " but that game is not open");
        }
    }

    public void setVisible(boolean a) {
        super.setVisible(a);
        if (a) {
            this.disconnected();
            this.connect();
        } else {
            this.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renamePlayer(String oldname, String newname, int newType) {
        this.playerswindow.renameSpectator(oldname, newname, newType);
        for (LobbyGame game : this.activegames.values()) {
            game.getPlayerList().renameSpectator(oldname, newname, newType);
        }
        Map map = this.privatechats;
        synchronized (map) {
            ChatBox cb = (ChatBox)this.privatechats.remove(oldname);
            if (cb != null) {
                cb.setPlayerName(newname);
                ((JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, cb)).setTitle("IM with " + newname);
                this.privatechats.put(newname, cb);
            }
        }
    }

    public void join(int gameid, String magicWord) {
        this.mycom.joinGame(gameid, magicWord);
    }

    public void leave(int gameid) {
        this.mycom.leaveGame(gameid);
    }

    public static void main(String[] argv) throws Exception {
        try {
            BugManager.intercept();
        }
        catch (Throwable th) {
            System.out.println("Grasshopper not loaded");
        }
        if (argv.length == 1) {
            CONFIG_FILENAME = argv[0];
        }
        try {
            String systemLookAndFeel = UIManager.getSystemLookAndFeelClassName();
            AffineTransform dat = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getDefaultTransform();
            if (dat.getScaleX() != 1.0 && "com.sun.java.swing.plaf.gtk.GTKLookAndFeel".equals(systemLookAndFeel)) {
                UIManager.setLookAndFeel("javax.swing.plaf.nimbus.NimbusLookAndFeel");
            } else {
                UIManager.setLookAndFeel(systemLookAndFeel);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JFrame gui = new JFrame("yura.net Lobby");
        gui.setSize(800, 600);
        final LobbyClientGUI mt = new LobbyClientGUI(null, new File(".").toURI().toURL());
        gui.setContentPane(mt);
        gui.setDefaultCloseOperation(0);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = gui.getSize();
        frameSize.height = frameSize.height > screenSize.height ? screenSize.height : frameSize.height;
        frameSize.width = frameSize.width > screenSize.width ? screenSize.width : frameSize.width;
        gui.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        gui.setVisible(true);
        gui.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                mt.setVisible(false);
            }
        });
        mt.setVisible(true);
    }

    public JButton setupButton(JButton button, int state, boolean privateGame) {
        switch (state) {
            case 1: {
                button.setActionCommand("J");
                button.setText("join");
                button.setBackground(Color.GREEN);
                button.setIcon(privateGame ? this.privateGameIcon : null);
                break;
            }
            case 2: {
                button.setActionCommand("L");
                button.setText("leave");
                button.setBackground(Color.RED);
                button.setIcon(null);
                break;
            }
            case 3: {
                button.setActionCommand("W");
                button.setText("watch");
                button.setBackground(Color.WHITE);
                button.setIcon(null);
                break;
            }
            case 4: {
                button.setActionCommand("W");
                button.setText("play");
                button.setBackground(Color.BLUE);
                button.setIcon(null);
            }
        }
        return button;
    }

    class ButtonEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private JButton button = new TranslucentJButton(0.6f);
        private Game game;

        public ButtonEditor() {
            this.button.addActionListener(this);
            this.button.setMargin(new Insets(0, 0, 0, 0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent ae) {
            try {
                String a = ae.getActionCommand();
                if (a.equals("J")) {
                    String magicWord = null;
                    if (this.game.getMagicWord() != null && (magicWord = JOptionPane.showInputDialog(LobbyClientGUI.this, (Object)"Game Password?")) == null) {
                        return;
                    }
                    LobbyClientGUI.this.join(this.game.getId(), magicWord);
                } else if (a.equals("L")) {
                    LobbyClientGUI.this.leave(this.game.getId());
                } else if (a.equals("W")) {
                    LobbyClientGUI.this.loadGame(this.game);
                } else {
                    System.err.println("LobbyClientGUI.ButtonEditor unknown command " + a);
                }
            }
            finally {
                this.cancelCellEditing();
            }
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.game = (Game)table.getValueAt(row, 1);
            JButton button2 = LobbyClientGUI.this.setupButton(this.button, (Integer)value, this.game.getMagicWord() != null);
            return button2;
        }

        public Object getCellEditorValue() {
            throw new RuntimeException();
        }

        public boolean stopCellEditing() {
            this.cancelCellEditing();
            return true;
        }
    }

    class ButtonRenderer
    implements TableCellRenderer {
        private JButton button = new TranslucentJButton(0.6f);

        public ButtonRenderer() {
            this.button.setMargin(new Insets(0, 0, 0, 0));
            this.button.setBorder(BorderFactory.createEmptyBorder());
            this.button.setContentAreaFilled(false);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                Game game = (Game)table.getValueAt(row, 1);
                return LobbyClientGUI.this.setupButton(this.button, (Integer)value, game.getMagicWord() != null);
            }
            return this.button;
        }
    }

    class ListEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JList list = new JList();
        private JScrollPane scroll = new JScrollPane(this.list);

        public ListEditor(LobbyClientGUI g) {
            this.list.setLayoutOrientation(2);
            this.list.setVisibleRowCount(1);
            this.list.setCellRenderer(new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component renderer = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    this.setIcon(PlayerList.getPlayerIcon((Player)value));
                    return renderer;
                }
            });
            PlayerList.addRightClickPlayerOptions(this.list, g);
            this.scroll.setHorizontalScrollBarPolicy(31);
            this.scroll.setVerticalScrollBarPolicy(21);
            this.scroll.setBorder(null);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof Vector) {
                this.list.setListData((Vector)value);
            } else if (value instanceof Collection) {
                this.list.setListData(new Vector((Collection)value));
            }
            this.list.scrollRectToVisible(new Rectangle(1, 1));
            return this.scroll;
        }

        public Object getCellEditorValue() {
            throw new RuntimeException();
        }

        public boolean stopCellEditing() {
            this.cancelCellEditing();
            return true;
        }

        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)anEvent;
                return SwingUtilities.isRightMouseButton(mouseEvent) || mouseEvent.isPopupTrigger() || mouseEvent.getClickCount() >= 2;
            }
            return true;
        }
    }

    class ListRenderer
    extends DefaultTableCellRenderer {
        private Set<Player> players;

        ListRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.players = (Set)value;
            return super.getTableCellRendererComponent(table, null, isSelected, hasFocus, row, column);
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            int x = 0;
            if (!this.players.isEmpty()) {
                for (Player player : this.players) {
                    ImageIcon icon = PlayerList.getPlayerIcon(player);
                    icon.paintIcon(this, g, x, (this.getHeight() - icon.getIconHeight()) / 2);
                    g.drawString(player.getName(), x += icon.getIconWidth(), (this.getHeight() - g.getFontMetrics().getHeight()) / 2 + g.getFontMetrics().getAscent());
                    x += g.getFontMetrics().stringWidth(player.getName());
                    x += 5;
                }
            } else {
                g.drawString("[]", x, g.getFontMetrics().getHeight());
            }
        }
    }

    static class TableTransferHandler
    extends TransferHandler {
        TableTransferHandler() {
        }

        protected Transferable createTransferable(JComponent c) {
            JTable table = (JTable)c;
            int[] rows = table.getSelectedRows();
            if (rows == null || rows.length == 0) {
                return null;
            }
            StringBuilder plainStr = new StringBuilder();
            GameTableModel model = (GameTableModel)table.getModel();
            for (int row = 0; row < rows.length; ++row) {
                Game game = model.getGame(rows[row]);
                plainStr.append(game.getId()).append('\t');
                plainStr.append(game.getName()).append('\t');
                plainStr.append(game.getOptions()).append('\t');
                plainStr.append(game.getWhosTurn()).append('\t');
                plainStr.append(game.getPlayers());
                plainStr.append('\n');
            }
            plainStr.deleteCharAt(plainStr.length() - 1);
            return new StringSelection(plainStr.toString());
        }

        public int getSourceActions(JComponent c) {
            return 1;
        }
    }

    class GameTableModel
    extends DefaultTableModel {
        private final String[] colnames = new String[]{"Icon", "Name", "Players", "In Game", "Timeout", "Players", "Action"};

        public GameTableModel() {
            this.setColumnIdentifiers(this.colnames);
        }

        public boolean isCellEditable(int row, int column) {
            if (column == 1 || column == 2) {
                return LobbyClientGUI.this.playerType >= 3;
            }
            return column == this.colnames.length - 1;
        }

        public void setDataVector(Vector objects) {
            this.dataVector = objects;
            LobbyClientGUI.this.games.revalidate();
            LobbyClientGUI.this.games.repaint();
        }

        public Class getColumnClass(int c) {
            if (c == 0) {
                return ImageIcon.class;
            }
            return String.class;
        }

        public String getColumnName(int column) {
            return this.colnames[column];
        }

        public int getColumnCount() {
            return this.colnames.length;
        }

        public Object getValueAt(int row, int column) {
            Game game = this.getGame(row);
            switch (column) {
                case 0: {
                    try {
                        return LobbyClientGUI.this.getLobbyGame(game.getType(), false).getIcon(game.getOptions(), LobbyClientGUI.this.games);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        return null;
                    }
                }
                case 1: {
                    return game;
                }
                case 2: {
                    return game.getPlayers();
                }
                case 3: {
                    return game.getInGame() >= 0 ? Integer.valueOf(game.getInGame()) : "N/A";
                }
                case 4: {
                    return TimeoutUtil.formatPeriod((long)game.getTimeout() * 1000L);
                }
                case 5: {
                    return game.getNumOfPlayers() + "/" + game.getMaxPlayers();
                }
                case 6: {
                    return game.getState(LobbyClientGUI.this.myusername);
                }
            }
            throw new RuntimeException();
        }

        public void setValueAt(Object aValue, int row, int column) {
            if (column == 1) {
                if (LobbyClientGUI.this.playerType >= 3) {
                    Game game = this.getGame(row);
                    String newName = (String)aValue;
                    if (!game.getName().equals(newName)) {
                        game.setName(newName);
                        LobbyClientGUI.this.mycom.createNewGame(game);
                    }
                }
            } else {
                super.setValueAt(aValue, row, column);
            }
        }

        public Game getGame(int row) {
            return (Game)this.getDataVector().get(row);
        }

        public Vector getDataVector() {
            return super.getDataVector();
        }
    }

    class TreeRenderer
    implements TreeCellRenderer {
        TreeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, final boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel label = new JLabel(value.toString()){

                public void paintComponent(Graphics g) {
                    if (selected) {
                        Color oldColor = g.getColor();
                        Graphics2D g2d = (Graphics2D)g;
                        Composite oldComp = g2d.getComposite();
                        g2d.setComposite(AlphaComposite.getInstance(3, 0.5f));
                        g2d.setColor(this.getBackground());
                        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                        g2d.setColor(oldColor);
                        g2d.setComposite(oldComp);
                        super.paintComponent(g);
                    } else {
                        super.paintComponent(g);
                    }
                }
            };
            if (leaf) {
                label.setIcon((Icon)UIManager.get("Tree.leafIcon"));
            } else if (expanded) {
                label.setIcon((Icon)UIManager.get("Tree.openIcon"));
            } else {
                label.setIcon((Icon)UIManager.get("Tree.closedIcon"));
            }
            return label;
        }
    }

    abstract class Message {
        private String name;
        private String tooltip;
        private Icon icon;

        public Message(String n, String t, Icon i) {
            this.name = n;
            this.tooltip = t;
            this.icon = i;
        }

        public String getName() {
            return this.name;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public abstract void action();

        public boolean equals(Object obj) {
            return this.name.equals(((Message)obj).getName());
        }
    }
}

