/*
 * Decompiled with CFR 0.152.
 */
package net.yura.lobby.client;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import net.yura.lobby.util.SimplePreferences;

public class LobbySettings {
    public static final String LOBBY_OLD_SETTINGS_FILE = ".lobby";
    private static final String UUID_KEY = "uuid";
    private static final Logger logger = Logger.getLogger(LobbySettings.class.getName());

    public static Preferences getLobbyPreferences() {
        Preferences newPrefs = Preferences.userNodeForPackage(LobbySettings.class);
        String uuid = newPrefs.get(UUID_KEY, null);
        if (uuid != null) {
            return newPrefs;
        }
        File lobbySettingsFile = new File(System.getProperty("user.home"), LOBBY_OLD_SETTINGS_FILE);
        SimplePreferences oldPrefs = new SimplePreferences(lobbySettingsFile, "yura.net Lobby");
        uuid = ((Preferences)oldPrefs).get(UUID_KEY, null);
        if (uuid != null) {
            LobbySettings.makeFileHidden(lobbySettingsFile);
            newPrefs.put(UUID_KEY, uuid);
            try {
                newPrefs.flush();
                return newPrefs;
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "failed to save prefs, fallback to props", ex);
                return oldPrefs;
            }
        }
        uuid = UUID.randomUUID().toString();
        newPrefs.put(UUID_KEY, uuid);
        try {
            newPrefs.flush();
            return newPrefs;
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "failed to save prefs, saving props instead", ex);
            ((Preferences)oldPrefs).put(UUID_KEY, uuid);
            try {
                ((Preferences)oldPrefs).flush();
            }
            catch (Exception ex2) {
                logger.log(Level.WARNING, "can not save lobby properties", ex2);
            }
            LobbySettings.makeFileHidden(lobbySettingsFile);
            return oldPrefs;
        }
    }

    public static void saveSettings(Preferences prefs) {
        try {
            prefs.flush();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "can not save lobby preferences", ex);
        }
    }

    public static String getLobbyClientUUID() {
        return LobbySettings.getLobbyPreferences().get(UUID_KEY, null);
    }

    private static void makeFileHidden(File file) {
        String os;
        if (!file.isHidden() && (os = System.getProperty("os.name")) != null && os.toLowerCase().contains("windows")) {
            String jv = System.getProperty("java.version");
            if (jv != null && (jv.startsWith("1.5.") || jv.startsWith("1.6."))) {
                try {
                    Process p = Runtime.getRuntime().exec("attrib +H " + file.getAbsolutePath());
                    p.waitFor();
                }
                catch (Throwable th) {
                    logger.log(Level.WARNING, "legacy can not set file properties", th);
                }
            } else {
                try {
                    Files.setAttribute(file.toPath(), "dos:hidden", true, LinkOption.NOFOLLOW_LINKS);
                }
                catch (Throwable th) {
                    logger.log(Level.WARNING, "can not set file properties", th);
                }
            }
        }
    }
}

