/*
 * Decompiled with CFR 0.152.
 */
package net.yura.lobby.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.yura.lobby.client.LobbyClientGUI;
import net.yura.lobby.client.eyecandy.TranslucentJList;
import net.yura.lobby.client.eyecandy.TranslucentJPanel;
import net.yura.lobby.client.eyecandy.TranslucentJScrollPane;
import net.yura.lobby.model.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerList
extends TranslucentJPanel {
    public static final ImageIcon ICON_ARROW = new ImageIcon(PlayerList.class.getResource("icons/arrow.gif"));
    public static final ImageIcon ICON_BLUE = new ImageIcon(PlayerList.class.getResource("icons/blue.gif"));
    public static final ImageIcon ICON_CYAN = new ImageIcon(PlayerList.class.getResource("icons/cyan.gif"));
    public static final ImageIcon ICON_GRAY = new ImageIcon(PlayerList.class.getResource("icons/gray.gif"));
    public static final ImageIcon ICON_GREEN = new ImageIcon(PlayerList.class.getResource("icons/green.gif"));
    public static final ImageIcon ICON_MAGENTA = new ImageIcon(PlayerList.class.getResource("icons/magenta.gif"));
    public static final ImageIcon ICON_RED = new ImageIcon(PlayerList.class.getResource("icons/red.gif"));
    public static final ImageIcon ICON_YELLOW = new ImageIcon(PlayerList.class.getResource("icons/yellow.gif"));
    private JList lobbyPlayers;
    private DefaultListModel playersModel;
    private Map<Player, Color> inGamePlayers;
    private String currentPlayer;

    public PlayerList(LobbyClientGUI gui) {
        super(0.5f);
        this.setLayout(new BorderLayout());
        this.playersModel = new DefaultListModel();
        this.lobbyPlayers = new TranslucentJList(this.playersModel, 0.4f);
        this.lobbyPlayers.setCellRenderer(new PlayerListCellRenderer());
        this.lobbyPlayers.setSelectionForeground(new Color(this.lobbyPlayers.getForeground().getRGB(), true));
        this.add((Component)new JLabel(" Players:"), "North");
        this.add(new TranslucentJScrollPane(this.lobbyPlayers, 0.0f));
        if (gui != null) {
            PlayerList.addRightClickPlayerOptions(this.lobbyPlayers, gui);
        }
    }

    public static void addRightClickPlayerOptions(final JList lobbyPlayers, final LobbyClientGUI gui) {
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Player player = (Player)lobbyPlayers.getSelectedValue();
                if (ae.getActionCommand().equals("pchat")) {
                    gui.showPrivateChat(player.toString(), true);
                } else if (ae.getActionCommand().equals("showinfo")) {
                    gui.showInfoDialog(player.toString());
                } else {
                    System.err.println("unkown command: " + ae.getActionCommand());
                }
            }
        };
        JMenuItem pchat = new JMenuItem("chat");
        pchat.setActionCommand("pchat");
        pchat.addActionListener(al);
        pchat.setOpaque(false);
        JMenuItem info = new JMenuItem("info");
        info.setActionCommand("showinfo");
        info.addActionListener(al);
        info.setOpaque(false);
        final JPopupMenu menu = new JPopupMenu();
        menu.setOpaque(false);
        menu.add(pchat);
        menu.add(info);
        lobbyPlayers.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3 && lobbyPlayers.getSelectedValue() != null) {
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    public void addSpectator(Player player) {
        this.playersModel.addElement(player);
        this.revalidate();
        this.lobbyPlayers.repaint();
    }

    public void renameSpectator(String oldname, String newName, int newtype) {
        for (int index = 0; index < this.playersModel.size(); ++index) {
            Player player = (Player)this.playersModel.get(index);
            if (!oldname.equals(player.getName())) continue;
            player.renamePlayer(newName, newtype);
            break;
        }
        if (oldname.equals(this.currentPlayer)) {
            this.currentPlayer = newName;
        }
        this.lobbyPlayers.repaint();
    }

    public void removeSpectator(String playerName) {
        for (int index = 0; index < this.playersModel.size(); ++index) {
            Player player = (Player)this.playersModel.get(index);
            if (!playerName.equals(player.getName())) continue;
            this.playersModel.removeElementAt(index);
            this.lobbyPlayers.revalidate();
            this.lobbyPlayers.repaint();
            return;
        }
        System.out.println("player not found \"" + playerName + "\" in list: " + this.playersModel);
    }

    public void clearSpectatorList() {
        this.playersModel.clear();
        this.lobbyPlayers.repaint();
    }

    public void setPlayers(Collection<Player> playerInGame) {
        if (this.inGamePlayers == null) {
            this.inGamePlayers = new HashMap<Player, Color>();
        }
        Iterator<Player> it = this.inGamePlayers.keySet().iterator();
        while (it.hasNext()) {
            Player player = it.next();
            if (playerInGame.contains(player)) continue;
            it.remove();
        }
        for (Player player : playerInGame) {
            if (this.inGamePlayers.containsKey(player)) continue;
            this.inGamePlayers.put(player, Color.BLUE);
        }
        this.repaint();
    }

    public void setPlayers(Map<Player, Color> playerColors) {
        this.inGamePlayers = playerColors;
        this.repaint();
    }

    public void setCurrentPlayer(String a) {
        this.currentPlayer = a;
        this.lobbyPlayers.repaint();
    }

    public static ImageIcon getPlayerIcon(Player pl) {
        switch (pl.getType()) {
            case 5: {
                return ICON_RED;
            }
            case 4: {
                return ICON_MAGENTA;
            }
            case 3: {
                return ICON_BLUE;
            }
            case 2: {
                return ICON_GREEN;
            }
            case 1: {
                return ICON_YELLOW;
            }
        }
        return ICON_GRAY;
    }

    class PlayerListCellRenderer
    extends DefaultListCellRenderer {
        private static final int gap = 15;
        private boolean drawArraw;
        private Color defaultForeground;

        public PlayerListCellRenderer() {
            this.setOpaque(false);
            this.defaultForeground = this.getForeground();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component retValue = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Player player = (Player)value;
            this.setIcon(PlayerList.getPlayerIcon(player));
            this.drawArraw = player.toString().equals(PlayerList.this.currentPlayer);
            super.setForeground(PlayerList.this.inGamePlayers != null && PlayerList.this.inGamePlayers.containsKey(player) ? (Color)PlayerList.this.inGamePlayers.get(player) : this.defaultForeground);
            return retValue;
        }

        public void paintComponent(Graphics g) {
            g.translate(15, 0);
            super.paintComponent(g);
            g.translate(-15, 0);
            if (this.drawArraw) {
                g.drawImage(ICON_ARROW.getImage(), 4, (this.getHeight() - ICON_ARROW.getIconHeight()) / 2, this);
            }
        }

        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.setSize((PlayerList.this.currentPlayer == null ? 0 : 15) + size.width, size.height);
            return size;
        }

        public void setForeground(Color fg) {
            this.defaultForeground = fg;
        }
    }
}

