/*
 * Decompiled with CFR 0.152.
 */
package net.yura.lobby.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ResBundle
extends PropertyResourceBundle {
    private Locale locale;

    public ResBundle(InputStream stream, Locale l) throws IOException {
        super(stream);
        this.locale = l;
    }

    public void setParent(ResourceBundle parent) {
        super.setParent(parent);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public static ResBundle getBundle(Class theclass, String name, Locale locale) {
        ResBundle resbun;
        String loadedlocal = locale.toString();
        int p = loadedlocal.lastIndexOf(95);
        String parent = p != -1 ? loadedlocal.substring(0, p) : "";
        try {
            String path = theclass.getPackage().getName().replace('.', '/') + "/" + name + ("".equals(loadedlocal) ? "" : "_" + loadedlocal) + ".properties";
            URL url = ResBundle.findResource((URLClassLoader)theclass.getClassLoader(), path);
            if (url == null) {
                throw new Exception("url null");
            }
            resbun = new ResBundle(url.openStream(), locale);
            if (!"".equals(loadedlocal)) {
                ResBundle parentbun = ResBundle.getBundle(theclass, name, ResBundle.getLocale(parent));
                resbun.setParent(parentbun);
            }
        }
        catch (Exception ioe) {
            System.out.println("cant find locale: " + loadedlocal + " " + ioe.toString());
            resbun = ResBundle.getBundle(theclass, name, ResBundle.getLocale(parent));
        }
        return resbun;
    }

    public static Locale getLocale(String localeString) {
        Locale locale;
        if ("".equals(localeString)) {
            return new Locale("");
        }
        String[] splitname = localeString.split("\\_");
        switch (splitname.length) {
            case 1: {
                locale = new Locale(splitname[0]);
                break;
            }
            case 2: {
                locale = new Locale(splitname[0], splitname[1]);
                break;
            }
            case 3: {
                locale = new Locale(splitname[0], splitname[1], splitname[2]);
                break;
            }
            default: {
                throw new IllegalArgumentException("bad local name: " + localeString);
            }
        }
        return locale;
    }

    public static URL findResource(URLClassLoader cl, String name) {
        try {
            URL[] urls = cl.getURLs();
            for (int c = 0; c < urls.length; ++c) {
                JarURLConnection conn = (JarURLConnection)urls[c].openConnection();
                JarFile jarfile = conn.getJarFile();
                JarEntry entry = jarfile.getJarEntry(name);
                if (entry == null) continue;
                return new URL(urls[c], name);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

