/*
 * Decompiled with CFR 0.152.
 */
package net.yura.lobby.client;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import net.yura.lobby.client.ChatBox;
import net.yura.lobby.client.LobbyGame;
import net.yura.lobby.client.LobbyGameChatListener;
import net.yura.lobby.client.PlayerList;
import net.yura.lobby.model.Game;

public abstract class TurnBasedAdapter
implements LobbyGame {
    private int seconds;
    private Thread timerThread;
    protected ChatBox chatbox;
    protected PlayerList playerlist;
    protected JPanel chatBoxArea;
    protected JPanel playerListArea;
    protected LobbyGameChatListener lgml;
    protected JButton startButton;
    protected boolean needinput;
    protected boolean paused;
    protected JProgressBar timer;

    public abstract void startNewGame(Game var1);

    public abstract void gameObject(Object var1);

    public abstract void gameString(String var1);

    public abstract void blockInput();

    public abstract void closegame();

    public void sendGameMessage(String message) {
        this.needinput = false;
        this.lgml.sendGameMessage(message);
    }

    public void leaveGame() {
        this.needinput = false;
        this.paused = true;
        this.lgml.closeGame();
    }

    public void openGame(Game game, ChatBox cb, PlayerList pl) {
        this.chatbox = cb;
        this.playerlist = pl;
        this.needinput = false;
        this.paused = true;
        if (this.startButton == null) {
            this.startButton = new JButton();
            this.startButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    String ac = ae.getActionCommand();
                    if (ac.equals("close")) {
                        TurnBasedAdapter.this.closegame();
                    } else if (ac.equals("resign")) {
                        TurnBasedAdapter.this.needinput = false;
                        TurnBasedAdapter.this.blockInput();
                        TurnBasedAdapter.this.lgml.leave();
                    } else if (ac.equals("join")) {
                        TurnBasedAdapter.this.lgml.join();
                    } else {
                        System.err.println("TurnBasedAdapter unknown command " + ac);
                    }
                }
            });
            this.chatBoxArea = new JPanel();
            this.playerListArea = new JPanel();
            this.chatBoxArea.setLayout(new BorderLayout());
            this.playerListArea.setLayout(new BorderLayout());
            this.timer = new JProgressBar();
            this.timer.setStringPainted(true);
            this.timer.setString("");
            this.timerThread = new Thread("Timer-Thread"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (true) {
                        if (TurnBasedAdapter.this.paused) {
                            TurnBasedAdapter.this.timer.setValue(0);
                            TurnBasedAdapter.this.timer.setString("");
                            2 var1_1 = this;
                            synchronized (var1_1) {
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                        }
                        TurnBasedAdapter.this.seconds = TurnBasedAdapter.this.timer.getMaximum();
                        while (TurnBasedAdapter.this.seconds > 0 && !TurnBasedAdapter.this.paused) {
                            TurnBasedAdapter.this.timer.setValue(TurnBasedAdapter.this.seconds);
                            TurnBasedAdapter.this.timer.setString(String.valueOf(TurnBasedAdapter.this.seconds));
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            TurnBasedAdapter.this.seconds--;
                        }
                        if (TurnBasedAdapter.this.paused || !TurnBasedAdapter.this.needinput) continue;
                    }
                }
            };
            this.timerThread.start();
        }
        this.timer.setMinimum(0);
        this.timer.setMaximum(game.getTimeout());
        this.chatBoxArea.removeAll();
        this.playerListArea.removeAll();
        this.chatBoxArea.add(this.chatbox);
        this.playerListArea.add(this.playerlist);
        this.startNewGame(game);
        this.gameUpdate(game);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gameMessage(Object obj) {
        if (obj instanceof String) {
            String message = (String)obj;
            if (message.equals("LOBBY_GAMEOVER")) {
                this.paused = true;
            } else {
                this.seconds = this.timer.getMaximum() + 1;
                if (this.paused) {
                    this.paused = false;
                    Thread thread = this.timerThread;
                    synchronized (thread) {
                        this.timerThread.notify();
                    }
                }
                this.gameString(message);
            }
        } else {
            if (obj instanceof byte[]) {
                if (this.paused) {
                    this.paused = false;
                    Thread message = this.timerThread;
                    synchronized (message) {
                        this.timerThread.notify();
                    }
                }
                try {
                    ByteArrayInputStream in = new ByteArrayInputStream((byte[])obj);
                    ObjectInputStream oin = new ObjectInputStream(in){

                        protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                            return Class.forName(desc.getName(), true, TurnBasedAdapter.this.getClass().getClassLoader());
                        }
                    };
                    Object object = oin.readObject();
                    this.gameObject(object);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            throw new IllegalArgumentException("unknown object " + obj);
        }
    }

    public void gameUpdate(Game game) {
        this.playerlist.setPlayers(game.getPlayers());
        this.playerlist.setCurrentPlayer(game.getWhosTurn());
        this.needinput = this.lgml.whoAmI().equals(game.getWhosTurn());
    }

    public void updateButton(boolean amPlayer, boolean space) {
        String text;
        String action;
        if (amPlayer) {
            action = "resign";
            text = "Resign";
        } else if (space) {
            action = "join";
            text = "Join";
        } else {
            action = "close";
            text = "Close";
        }
        this.startButton.setActionCommand(action);
        this.startButton.setText(text);
    }

    public PlayerList getPlayerList() {
        return this.playerlist;
    }

    public ChatBox getChatBox() {
        return this.chatbox;
    }

    public void addLobbyGameMoveListener(LobbyGameChatListener lgl) {
        this.lgml = lgl;
    }

    public void removeLobbyGameMoveListener(LobbyGameChatListener lgl) {
        if (this.lgml == lgl) {
            this.lgml = null;
        }
    }

    public LobbyGameChatListener getLobbyGameMoveListener() {
        return this.lgml;
    }
}

