/*
 * Decompiled with CFR 0.152.
 */
package net.yura.grasshopper;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Writer;
import java.net.URI;
import java.net.URLEncoder;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.yura.grasshopper.BugManager;
import net.yura.grasshopper.info.BugSystemInfo;
import net.yura.grasshopper.submitter.BugSubmitter;

public class PopupBug
extends Writer {
    static PopupBug instance;
    private static final int MAX_SUBMIT = 5;
    private JDialog errFrame;
    private JTextArea debugText = new JTextArea();
    private BugManager simplePrintStream;
    private String email;
    private String cause;

    private PopupBug() {
        this.debugText.getFontMetrics(this.debugText.getFont());
        this.appendString("testing 123\n");
        this.debugText.setText("");
        this.debugText.setEditable(false);
        this.simplePrintStream = new BugManager(){

            protected void action(String thecause, int actionCount) {
                PopupBug.this.cause = thecause;
                if (actionCount == 0) {
                    PopupBug.this.openPopup();
                } else if (PopupBug.this.errFrame == null && actionCount < 5) {
                    PopupBug.this.doSubmit(PopupBug.this.email, false);
                }
            }
        };
        BugManager.interceptAndAlert(this, this.simplePrintStream);
    }

    public static void initSimple(String appname, String version, String locale) {
        if (instance == null) {
            instance = new PopupBug();
        }
        BugSystemInfo.appName = appname;
        BugSystemInfo.version = version;
        BugSystemInfo.locale = locale;
    }

    private void openPopup() {
        if (this.errFrame == null) {
            this.errFrame = new JDialog((Frame)null, "an error has occurred!!!", true);
            this.errFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent winEvt) {
                    PopupBug.this.closePopup();
                    PopupBug.this.doSubmit("closed", false);
                }
            });
            JScrollPane errScroll = new JScrollPane(this.debugText);
            Dimension size = new Dimension(400, 400);
            errScroll.setMaximumSize(size);
            errScroll.setPreferredSize(size);
            errScroll.setMinimumSize(size);
            JLabel label = new JLabel("an error happened, please click on the button at the bottom to send it");
            label.setBorder(BorderFactory.createMatteBorder(10, 10, 10, 10, Color.RED));
            JButton saveErr = new JButton("click here to send");
            saveErr.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent a) {
                    String email = JOptionPane.showInputDialog(PopupBug.this.errFrame, (Object)"Please tell me your e-mail, in case I have questons about this bug");
                    if (email == null) {
                        email = "not-given";
                    }
                    PopupBug.this.closePopup();
                    PopupBug.this.doSubmit(email, true);
                }
            });
            this.errFrame.getContentPane().add((Component)label, "North");
            this.errFrame.getContentPane().add((Component)errScroll, "Center");
            this.errFrame.getContentPane().add((Component)saveErr, "South");
            this.errFrame.pack();
        }
        this.errFrame.setVisible(true);
    }

    private void closePopup() {
        this.errFrame.setVisible(false);
        this.errFrame.dispose();
        this.errFrame = null;
    }

    private void doSubmit(String email, boolean interactive) {
        this.email = email;
        String log = this.debugText.getText();
        boolean success = BugSubmitter.submitBug(log, this.email, this.cause);
        if (interactive) {
            if (success) {
                JOptionPane.showMessageDialog(null, "SENT!");
            } else {
                try {
                    PopupBug.sendEmailWithNativeClient(BugSubmitter.RECIPIENT, BugSubmitter.generateSubject(this.cause), log);
                }
                catch (Throwable ex) {
                    JOptionPane.showMessageDialog(null, "ERROR: failed to send, please copy and paste this log into an email to " + BugSubmitter.RECIPIENT);
                }
            }
        }
    }

    private static void sendEmailWithNativeClient(String recipient, String subject, String body) throws Exception {
        String regexForPlus = "\\Q+\\E";
        String subjectEncoded = URLEncoder.encode(subject, "UTF-8").replaceAll(regexForPlus, "%20");
        String bodyEncoded = URLEncoder.encode(body, "UTF-8").replaceAll(regexForPlus, "%20");
        URI mailto = new URI("mailto:" + recipient + "?subject=" + subjectEncoded + "&body=" + bodyEncoded);
        Desktop.getDesktop().mail(mailto);
    }

    public static void log(String text) {
        instance.appendString(text);
    }

    public static void clearLog() {
        if (!PopupBug.instance.simplePrintStream.hasHappened()) {
            PopupBug.instance.debugText.setText("");
        }
    }

    public void write(int c) {
        this.appendString(String.valueOf((char)c));
    }

    public void write(String str, int off, int len) {
        this.appendString(str.substring(off, off + len));
    }

    public void write(char[] cbuf, int off, int len) {
        this.appendString(String.valueOf(cbuf, off, len));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendString(String text) {
        boolean interrupted = Thread.interrupted();
        try {
            this.debugText.append(text);
        }
        catch (OutOfMemoryError oom) {
            this.debugText.setText("LOG CLEARED BECAUSE OF " + oom);
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void flush() {
    }

    public void close() {
    }
}

