/*
 * Decompiled with CFR 0.152.
 */
package net.yura.grasshopper.submitter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Map;
import net.yura.grasshopper.BugUIInfo;
import net.yura.grasshopper.info.LogText;
import net.yura.grasshopper.info.ScreenShot;
import net.yura.grasshopper.submitter.BugSubmitter;
import net.yura.grasshopper.util.TruncatedContentBody;
import org.apache.http.Header;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.AbstractContentBody;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.StringBody;

public class BugSubmitterMultipart {
    private static final int MAX_PAYLOAD_SIZE = 4999800;

    static void send(String url, Map map) throws IOException {
        MultipartEntity requestContent = new MultipartEntity();
        ScreenShot[] images = BugUIInfo.getFrames();
        for (int c = 0; c < images.length; ++c) {
            String error;
            ScreenShot ss = images[c];
            byte[] data = ss.getEncodedData();
            if (data != null) {
                requestContent.addPart("img" + c, new ByteArrayBody(data, "frame_" + c + "." + ss.getFileType()));
            }
            if ((error = ss.getError()) == null) continue;
            requestContent.addPart("img" + c + "Error", new StringBody(error));
        }
        Iterator it = BugSubmitter.getKeysLogTextLast(map).iterator();
        while (it.hasNext()) {
            AbstractContentBody contentBody;
            Object key = it.next();
            Object value = map.get(key);
            if (value instanceof LogText) {
                final LogText logtext = (LogText)value;
                contentBody = new AbstractContentBody("text/plain"){

                    public long getContentLength() {
                        return logtext.getContentLength();
                    }

                    public void writeTo(OutputStream out) throws IOException {
                        logtext.writeTo(out);
                    }

                    public String getFilename() {
                        return null;
                    }

                    public String getCharset() {
                        return "US-ASCII";
                    }

                    public String getTransferEncoding() {
                        return "8bit";
                    }
                };
            } else {
                contentBody = new StringBody(String.valueOf(value));
            }
            long sizeSoFar = requestContent.getContentLength();
            if (sizeSoFar + contentBody.getContentLength() > 4999800L) {
                long spaceAvailable = 4999800L - sizeSoFar;
                if (spaceAvailable <= 0L) continue;
                requestContent.addPart(String.valueOf(key), new TruncatedContentBody(contentBody, contentBody.getContentLength() - spaceAvailable));
                continue;
            }
            requestContent.addPart(String.valueOf(key), contentBody);
        }
        BugSubmitterMultipart.doPost(url, requestContent);
    }

    public static void doPost(String url, MultipartEntity requestContent) throws IOException {
        String line;
        URLConnection conn = new URL(url).openConnection();
        conn.setDoOutput(true);
        Header contentType = requestContent.getContentType();
        conn.setRequestProperty(contentType.getName(), contentType.getValue());
        conn.setRequestProperty("Content-Length", String.valueOf(requestContent.getContentLength()));
        OutputStream out = conn.getOutputStream();
        requestContent.writeTo(out);
        out.close();
        int code = 200;
        if (conn instanceof HttpURLConnection) {
            code = ((HttpURLConnection)conn).getResponseCode();
        }
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((line = rd.readLine()) != null) {
        }
        rd.close();
        if (code / 100 != 2) {
            throw new IOException("http error " + code);
        }
    }
}

